/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.dpm.task.jms;

import com.thetransactioncompany.jsonrpc2.JSONRPC2Error;
import com.thetransactioncompany.jsonrpc2.JSONRPC2Response;
import fr.proline.studio.dpm.AccessJMSManagerThread;
import fr.proline.studio.dpm.data.JMSNotificationMessage;
import fr.proline.studio.dpm.task.jms.AbstractJMSCallback;
import fr.proline.studio.dpm.task.util.JMSConnectionManager;
import fr.proline.studio.dpm.task.util.JMSMessageUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.swing.SwingUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PurgeConsumer {
    protected static final Logger m_logger = LoggerFactory.getLogger((String)"ProlineStudio.ResultExplorer");
    private List<AbstractJMSCallback> m_callbacks = new ArrayList<AbstractJMSCallback>();
    private List<JMSNotificationMessage[]> m_replyVals = new ArrayList<JMSNotificationMessage[]>();
    private static PurgeConsumer m_singleton;

    public static PurgeConsumer getPurgeConsumer() {
        if (m_singleton == null) {
            m_singleton = new PurgeConsumer();
        }
        return m_singleton;
    }

    private PurgeConsumer() {
    }

    public void addCallback(AbstractJMSCallback callback, JMSNotificationMessage[] replyVal) {
        if (callback == null || replyVal == null || replyVal.length != 1) {
            throw new RuntimeException("Must specify callback and reply value pair to register for PurgeConsumer ");
        }
        this.m_callbacks.add(callback);
        this.m_replyVals.add(replyVal);
    }

    public void removeCallback(AbstractJMSCallback callback) {
        int index = this.m_callbacks.indexOf(callback);
        if (index < 0) {
            return;
        }
        this.m_callbacks.remove(index);
        this.m_replyVals.remove(index);
    }

    public void clearMessage(String msgIdToRemove) {
        final String selectorString = "JMSMessageID = '" + msgIdToRemove + "'";
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Loose catch block
             */
            @Override
            public void run() {
                block32: {
                    JMSNotificationMessage resultMsg;
                    MessageProducer replyProducer;
                    MessageConsumer consumer;
                    String errorMsg;
                    block30: {
                        m_logger.debug("Purge Consumer selector [" + selectorString + ']');
                        Session session = AccessJMSManagerThread.getAccessJMSManagerThread().getSession();
                        errorMsg = null;
                        consumer = null;
                        replyProducer = null;
                        resultMsg = null;
                        consumer = session.createConsumer((Destination)JMSConnectionManager.getJMSConnectionManager().getServiceQueue(), selectorString);
                        replyProducer = session.createProducer(null);
                        Message message = consumer.receive(TimeUnit.SECONDS.toMillis(5L));
                        if (message == null) {
                            errorMsg = "No message to consume. ";
                        } else {
                            String messageId = message.getJMSMessageID();
                            m_logger.debug("Purging JMS Message with ID " + messageId);
                            Destination replyDestination = message.getJMSReplyTo();
                            if (replyDestination == null) {
                                m_logger.warn("Message has no JMSReplyTo Destination : Cannot send JSON Response to Client");
                            } else {
                                JSONRPC2Error jsonError = new JSONRPC2Error(-32004, "JMS message was cancelled ");
                                JSONRPC2Response jsonResponse = new JSONRPC2Response(jsonError, null);
                                TextMessage jmsResponseMessage = session.createTextMessage();
                                jmsResponseMessage.setJMSCorrelationID(messageId);
                                jmsResponseMessage.setText(jsonResponse.toJSONString());
                                m_logger.debug("Sending JMS Response to Message [" + messageId + "] on Destination [" + replyDestination + ']');
                                replyProducer.send(replyDestination, (Message)jmsResponseMessage);
                            }
                            resultMsg = JMSMessageUtil.buildJMSNotificationMessage(message, JMSNotificationMessage.MessageStatus.ABORTED);
                        }
                        if (consumer == null) break block30;
                        try {
                            consumer.close();
                        }
                        catch (Exception exClose) {
                            m_logger.error("Error closing Purge consumer ", (Throwable)exClose);
                        }
                    }
                    if (replyProducer != null) {
                        try {
                            replyProducer.close();
                        }
                        catch (Exception exClose) {
                            m_logger.error("Error closing replyProducer in Purge Consumer", (Throwable)exClose);
                        }
                    }
                    boolean success = errorMsg != null;
                    for (int index = 0; index < PurgeConsumer.this.m_callbacks.size(); ++index) {
                        AbstractJMSCallback callback = (AbstractJMSCallback)PurgeConsumer.this.m_callbacks.get(index);
                        JMSNotificationMessage[] replyVal = (JMSNotificationMessage[])PurgeConsumer.this.m_replyVals.get(index);
                        replyVal[0] = resultMsg;
                        if (callback.mustBeCalledInAWT()) {
                            SwingUtilities.invokeLater(new Runnable(callback, success){
                                final /* synthetic */ AbstractJMSCallback val$callback;
                                final /* synthetic */ boolean val$success;
                                {
                                    this.val$callback = abstractJMSCallback;
                                    this.val$success = bl;
                                }

                                @Override
                                public void run() {
                                    this.val$callback.run(this.val$success);
                                }
                            });
                            continue;
                        }
                        callback.run(success);
                    }
                    break block32;
                    catch (Exception ex) {
                        block31: {
                            errorMsg = "Error purging JMS Message";
                            m_logger.error("Unable to create Consumer message ! ");
                            if (consumer == null) break block31;
                            try {
                                consumer.close();
                            }
                            catch (Exception exClose) {
                                m_logger.error("Error closing Purge consumer ", (Throwable)exClose);
                            }
                        }
                        if (replyProducer != null) {
                            try {
                                replyProducer.close();
                            }
                            catch (Exception exClose) {
                                m_logger.error("Error closing replyProducer in Purge Consumer", (Throwable)exClose);
                            }
                        }
                        success = errorMsg != null;
                        for (int index = 0; index < PurgeConsumer.this.m_callbacks.size(); ++index) {
                            AbstractJMSCallback callback = (AbstractJMSCallback)PurgeConsumer.this.m_callbacks.get(index);
                            JMSNotificationMessage[] replyVal = (JMSNotificationMessage[])PurgeConsumer.this.m_replyVals.get(index);
                            replyVal[0] = resultMsg;
                            if (callback.mustBeCalledInAWT()) {
                                SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                                continue;
                            }
                            callback.run(success);
                        }
                        catch (Throwable throwable) {
                            if (consumer != null) {
                                try {
                                    consumer.close();
                                }
                                catch (Exception exClose) {
                                    m_logger.error("Error closing Purge consumer ", (Throwable)exClose);
                                }
                            }
                            if (replyProducer != null) {
                                try {
                                    replyProducer.close();
                                }
                                catch (Exception exClose) {
                                    m_logger.error("Error closing replyProducer in Purge Consumer", (Throwable)exClose);
                                }
                            }
                            boolean success2 = errorMsg != null;
                            for (int index = 0; index < PurgeConsumer.this.m_callbacks.size(); ++index) {
                                AbstractJMSCallback callback = (AbstractJMSCallback)PurgeConsumer.this.m_callbacks.get(index);
                                JMSNotificationMessage[] replyVal = (JMSNotificationMessage[])PurgeConsumer.this.m_replyVals.get(index);
                                replyVal[0] = resultMsg;
                                if (callback.mustBeCalledInAWT()) {
                                    SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                                    continue;
                                }
                                callback.run(success2);
                            }
                            throw throwable;
                        }
                    }
                }
            }
        }.start();
    }
}

