/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.dpm.task.jms;

import com.thetransactioncompany.jsonrpc2.JSONRPC2Error;
import com.thetransactioncompany.jsonrpc2.JSONRPC2Message;
import com.thetransactioncompany.jsonrpc2.JSONRPC2Notification;
import com.thetransactioncompany.jsonrpc2.JSONRPC2Request;
import com.thetransactioncompany.jsonrpc2.JSONRPC2Response;
import fr.proline.core.orm.uds.dto.DDataset;
import fr.proline.studio.dam.taskinfo.TaskInfo;
import fr.proline.studio.dpm.AccessJMSManagerThread;
import fr.proline.studio.dpm.task.jms.AbstractJMSCallback;
import fr.proline.studio.dpm.task.jms.AbstractJMSTask;
import fr.proline.studio.dpm.task.jms.FilterProteinSetsTask;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.TextMessage;

public class ValidationTask
extends AbstractJMSTask {
    private final DDataset m_dataset;
    private final String m_description;
    private final HashMap<String, String> m_argumentsMap;
    private final String m_scoringType;
    private final Integer[] m_resultSummaryId;
    private Map<Long, Long> m_rsmIdsPerRsIds = null;
    private String m_version = "3.0";

    public ValidationTask(AbstractJMSCallback callback, DDataset dataset, String description, HashMap<String, String> argumentsMap, Integer[] resultSummaryId, String scoringType) {
        super(callback, new TaskInfo("JMS Validation of Search Result " + dataset.getName(), true, "Services JMS", TaskInfo.INFO_IMPORTANCE_HIGH));
        this.m_dataset = dataset;
        this.m_description = description;
        this.m_argumentsMap = argumentsMap;
        this.m_resultSummaryId = resultSummaryId;
        this.m_scoringType = scoringType;
    }

    public ValidationTask(AbstractJMSCallback callback, DDataset dataset, String description, HashMap<String, String> argumentsMap, Integer[] resultSummaryId, HashMap<Long, Long> rsmIdsPerRsIds, String scoringType) {
        super(callback, new TaskInfo("JMS Validation of Search Result " + dataset.getName(), true, "Services JMS", TaskInfo.INFO_IMPORTANCE_HIGH));
        this.m_dataset = dataset;
        this.m_description = description;
        this.m_argumentsMap = argumentsMap;
        this.m_rsmIdsPerRsIds = rsmIdsPerRsIds;
        this.m_resultSummaryId = resultSummaryId;
        this.m_scoringType = scoringType;
    }

    @Override
    public void taskRun() throws JMSException {
        JSONRPC2Request jsonRequest = new JSONRPC2Request("process", (Object)this.m_taskInfo.getId());
        jsonRequest.setNamedParams(this.createParams());
        TextMessage message = AccessJMSManagerThread.getAccessJMSManagerThread().getSession().createTextMessage(jsonRequest.toJSONString());
        message.setJMSReplyTo((Destination)this.m_replyQueue);
        message.setStringProperty("Proline_ServiceName", "proline/dps/msi/ValidateResultSet");
        if (this.m_version != null) {
            message.setStringProperty("Proline_ServiceVersion", this.m_version);
        }
        this.addSourceToMessage((Message)message);
        this.addDescriptionToMessage((Message)message);
        this.setTaskInfoRequest(message.getText());
        this.m_producer.send((Message)message);
        m_loggerProline.info("ValidationTask Message [{}] sent", (Object)message.getJMSMessageID());
        this.m_taskInfo.setJmsMessageID(message.getJMSMessageID());
    }

    @Override
    public void taskDone(Message jmsMessage) throws Exception {
        TextMessage textMessage = (TextMessage)jmsMessage;
        String jsonString = textMessage.getText();
        JSONRPC2Message jsonMessage = JSONRPC2Message.parse((String)jsonString);
        if (jsonMessage instanceof JSONRPC2Notification) {
            m_loggerProline.warn("JSON Notification method: " + ((JSONRPC2Notification)jsonMessage).getMethod() + " instead of JSON Response");
            throw new Exception("Invalid JSONRPC2Message type");
        }
        if (jsonMessage instanceof JSONRPC2Response) {
            JSONRPC2Response jsonResponse = (JSONRPC2Response)jsonMessage;
            m_loggerProline.debug("JSON Response Id: " + jsonResponse.getID());
            JSONRPC2Error jsonError = jsonResponse.getError();
            if (jsonError != null) {
                m_loggerProline.error("JSON Error code {}, message : \"{}\"", (Object)jsonError.getCode(), (Object)jsonError.getMessage());
                m_loggerProline.error("JSON Throwable", (Throwable)jsonError);
                throw jsonError;
            }
            Object result = jsonResponse.getResult();
            if (result == null || !Map.class.isInstance(result)) {
                m_loggerProline.debug("Invalid or no result");
                throw new Exception("null or invalid result " + result);
            }
            m_loggerProline.debug("Result :\n" + result);
            Long rsmId = (Long)((Map)result).get(this.m_dataset.getResultSetId().toString());
            this.m_resultSummaryId[0] = rsmId.intValue();
            if (this.m_rsmIdsPerRsIds != null) {
                ((Map)result).forEach((key, value) -> this.m_rsmIdsPerRsIds.put(Long.parseLong(key), (Long)value));
            }
        }
        this.m_currentState = AbstractJMSTask.JMSState.STATE_DONE;
    }

    private HashMap<String, Object> createParams() {
        HashMap<String, Object> filterCfg;
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("project_id", this.m_dataset.getProject().getId());
        params.put("result_set_id", this.m_dataset.getResultSetId());
        params.put("description", this.m_description);
        ArrayList psmFilters = new ArrayList();
        if (this.m_argumentsMap.containsKey("PSM_" + PSMFilter.RANK.key)) {
            filterCfg = new HashMap<String, Object>();
            filterCfg.put("parameter", PSMFilter.RANK.key);
            filterCfg.put("threshold", Integer.valueOf(this.m_argumentsMap.get("PSM_" + PSMFilter.RANK.key)));
            psmFilters.add(filterCfg);
        }
        if (this.m_argumentsMap.containsKey("PSM_" + PSMFilter.SCORE.key)) {
            filterCfg = new HashMap();
            filterCfg.put("parameter", PSMFilter.SCORE.key);
            filterCfg.put("threshold", Float.valueOf(this.m_argumentsMap.get("PSM_" + PSMFilter.SCORE.key)));
            psmFilters.add(filterCfg);
        }
        if (this.m_argumentsMap.containsKey("PSM_" + PSMFilter.MASCOT_EVAL.key)) {
            filterCfg = new HashMap();
            filterCfg.put("parameter", PSMFilter.MASCOT_EVAL.key);
            filterCfg.put("threshold", Float.valueOf(this.m_argumentsMap.get("PSM_" + PSMFilter.MASCOT_EVAL.key)));
            psmFilters.add(filterCfg);
        }
        if (this.m_argumentsMap.containsKey("PSM_" + PSMFilter.MASCOT_ADJUSTED_EVALUE.key)) {
            filterCfg = new HashMap();
            filterCfg.put("parameter", PSMFilter.MASCOT_ADJUSTED_EVALUE.key);
            filterCfg.put("threshold", Float.valueOf(this.m_argumentsMap.get("PSM_" + PSMFilter.MASCOT_ADJUSTED_EVALUE.key)));
            psmFilters.add(filterCfg);
        }
        if (this.m_argumentsMap.containsKey("PSM_" + PSMFilter.PEP_LENGTH.key)) {
            filterCfg = new HashMap();
            filterCfg.put("parameter", PSMFilter.PEP_LENGTH.key);
            filterCfg.put("threshold", Integer.valueOf(this.m_argumentsMap.get("PSM_" + PSMFilter.PEP_LENGTH.key)));
            psmFilters.add(filterCfg);
        }
        if (this.m_argumentsMap.containsKey("PSM_" + PSMFilter.MASCOT_IT_SCORE.key)) {
            filterCfg = new HashMap();
            filterCfg.put("parameter", PSMFilter.MASCOT_IT_SCORE.key);
            filterCfg.put("threshold", Float.valueOf(this.m_argumentsMap.get("PSM_" + PSMFilter.MASCOT_IT_SCORE.key)));
            psmFilters.add(filterCfg);
        }
        if (this.m_argumentsMap.containsKey("PSM_" + PSMFilter.MASCOT_HT_SCORE.key)) {
            filterCfg = new HashMap();
            filterCfg.put("parameter", PSMFilter.MASCOT_HT_SCORE.key);
            filterCfg.put("threshold", Float.valueOf(this.m_argumentsMap.get("PSM_" + PSMFilter.MASCOT_HT_SCORE.key)));
            psmFilters.add(filterCfg);
        }
        if (this.m_argumentsMap.containsKey("PSM_" + PSMFilter.SINGLE_PSM_QUERY.key)) {
            filterCfg = new HashMap();
            filterCfg.put("parameter", PSMFilter.SINGLE_PSM_QUERY.key);
            filterCfg.put("threshold", 1);
            filterCfg.put("post_validation", Boolean.valueOf(this.m_argumentsMap.get("PSM_" + PSMFilter.SINGLE_PSM_QUERY.key)));
            psmFilters.add(filterCfg);
        }
        if (this.m_argumentsMap.containsKey("PSM_" + PSMFilter.SINGLE_PSM_RANK.key)) {
            filterCfg = new HashMap();
            filterCfg.put("parameter", PSMFilter.SINGLE_PSM_RANK.key);
            filterCfg.put("threshold", 1);
            filterCfg.put("post_validation", Boolean.valueOf(this.m_argumentsMap.get("PSM_" + PSMFilter.SINGLE_PSM_RANK.key)));
            psmFilters.add(filterCfg);
        }
        if (this.m_argumentsMap.containsKey("PSM_" + PSMFilter.ISOTOPE_OFFSET.key)) {
            filterCfg = new HashMap();
            filterCfg.put("parameter", PSMFilter.ISOTOPE_OFFSET.key);
            filterCfg.put("threshold", Integer.valueOf(this.m_argumentsMap.get("PSM_" + PSMFilter.ISOTOPE_OFFSET.key)));
            psmFilters.add(filterCfg);
        }
        params.put("pep_match_filters", psmFilters);
        if (this.m_argumentsMap.containsKey(ValidationParameters.EXPECTED_FDR.key)) {
            HashMap<String, String> pepMatchValidator = new HashMap<String, String>();
            pepMatchValidator.put("parameter", this.m_argumentsMap.get(ValidationParameters.EXPECTED_FDR_PARAM.key));
            pepMatchValidator.put("expected_fdr", this.m_argumentsMap.get(ValidationParameters.EXPECTED_FDR.key));
            params.put("pep_match_validator_config", pepMatchValidator);
        }
        HashMap<String, Object> fdrConfig = new HashMap<String, Object>();
        if (this.m_argumentsMap.containsKey(ValidationParameters.EXPECTED_FDR.key) || this.m_argumentsMap.containsKey(ValidationParameters.PEPTIDE_EXPECTED_FDR.key) || this.m_argumentsMap.containsKey(ValidationParameters.PROTEIN_EXPECTED_FDR.key)) {
            if (this.m_argumentsMap.containsKey(ValidationParameters.FDR_METHOD.key)) {
                fdrConfig.put("method_name", this.m_argumentsMap.get(ValidationParameters.FDR_METHOD.key));
                if (this.m_argumentsMap.get(ValidationParameters.FDR_METHOD.key).equals("TARGET_DECOY")) {
                    HashMap<String, String> tdAnalyzerConfig = new HashMap<String, String>();
                    tdAnalyzerConfig.put("method_name", "BASIC");
                    fdrConfig.put("td_analyzer_config", tdAnalyzerConfig);
                }
            }
            params.put("fdr_analyzer_config", fdrConfig);
        }
        if (this.m_argumentsMap.containsKey(ValidationParameters.PEPTIDE_EXPECTED_FDR.key)) {
            HashMap<String, String> peptideValidatorConfig = new HashMap<String, String>();
            peptideValidatorConfig.put("parameter", "BH");
            peptideValidatorConfig.put("expected_fdr", this.m_argumentsMap.get(ValidationParameters.PEPTIDE_EXPECTED_FDR.key));
            params.put("pep_validator_config", peptideValidatorConfig);
        }
        params.put("pep_set_score_type", this.m_scoringType);
        ArrayList proteinFilters = new ArrayList();
        for (FilterProteinSetsTask.Filter filter : FilterProteinSetsTask.Filter.values()) {
            String filterKeyOfInMap = "PROT_" + filter.key;
            if (!this.m_argumentsMap.containsKey(filterKeyOfInMap)) continue;
            HashMap<String, Object> filterCfg2 = new HashMap<String, Object>();
            filterCfg2.put("parameter", filter.key);
            if (filter == FilterProteinSetsTask.Filter.SCORE) {
                filterCfg2.put("threshold", Double.valueOf(this.m_argumentsMap.get(filterKeyOfInMap)));
            } else {
                filterCfg2.put("threshold", Integer.valueOf(this.m_argumentsMap.get(filterKeyOfInMap)));
            }
            proteinFilters.add(filterCfg2);
        }
        params.put("prot_set_filters", proteinFilters);
        if (this.m_argumentsMap.containsKey(ValidationParameters.PROTEIN_EXPECTED_FDR.key)) {
            HashMap<String, String> protSetValidator = new HashMap<String, String>();
            protSetValidator.put("parameter", "SCORE");
            protSetValidator.put("expected_fdr", this.m_argumentsMap.get(ValidationParameters.PROTEIN_EXPECTED_FDR.key));
            protSetValidator.put("validation_method", "PROTEIN_SET_RULES");
            params.put("prot_set_validator_config", protSetValidator);
            if (!fdrConfig.containsKey("td_analyzer_config")) {
                HashMap<String, String> tdAnalyzerConfig = new HashMap<String, String>();
                tdAnalyzerConfig.put("method_name", "BASIC");
                fdrConfig.put("td_analyzer_config", tdAnalyzerConfig);
            }
        }
        if (this.m_argumentsMap.containsKey("propagate_prot_set_filters")) {
            params.put("propagate_prot_set_filters", Boolean.parseBoolean(this.m_argumentsMap.get("propagate_prot_set_filters")));
        }
        if (this.m_argumentsMap.containsKey("propagate_pep_match_filters")) {
            params.put("propagate_pep_match_filters", Boolean.parseBoolean(this.m_argumentsMap.get("propagate_pep_match_filters")));
        }
        return params;
    }

    public static enum ValidationParameters {
        FDR_METHOD("fdr_method", "FDR control method"),
        EXPECTED_FDR("expected_fdr", "FDR"),
        EXPECTED_FDR_PARAM("expected_fdr_parameter", "FDR Variable"),
        PROTEIN_EXPECTED_FDR("protein_expected_fdr", "Protein FDR"),
        PEPTIDE_EXPECTED_FDR("peptide_expected_fdr", "Peptide FDR"),
        TD_ANALYZER("td_analyzer", "Target/Decoy method");

        public final String key;
        public final String name;

        private ValidationParameters(String key, String name) {
            this.key = key;
            this.name = name;
        }
    }

    public static enum PSMFilter {
        RANK("PRETTY_RANK", "Pretty Rank"),
        SCORE("SCORE", "Score"),
        PEP_LENGTH("PEP_SEQ_LENGTH", "Length"),
        MASCOT_EVAL("MASCOT_EVALUE", "e-Value"),
        MASCOT_ADJUSTED_EVALUE("MASCOT_ADJUSTED_EVALUE", "Adjusted e-Value"),
        MASCOT_IT_SCORE("SCORE_IT_P-VALUE", "Identity p-Value"),
        MASCOT_HT_SCORE("SCORE_HT_P-VALUE", "Homology p-Value"),
        SINGLE_PSM_QUERY("SINGLE_PSM_PER_QUERY", "Single PSM per MS Query"),
        SINGLE_PSM_RANK("SINGLE_PSM_PER_RANK", "Single PSM per Rank"),
        ISOTOPE_OFFSET("ISOTOPE_OFFSET", "Isotope Offset");

        public final String key;
        public final String name;

        private PSMFilter(String key, String name) {
            this.key = key;
            this.name = name;
        }
    }
}

