/*
 * Decompiled with CFR 0.152.
 */
package org.forester.application;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.forester.io.parsers.phyloxml.PhyloXmlParser;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyMethods;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.factories.ParserBasedPhylogenyFactory;
import org.forester.phylogeny.factories.PhylogenyFactory;
import org.forester.phylogeny.iterators.PhylogenyNodeIterator;
import org.forester.util.CommandLineArguments;
import org.forester.util.ForesterUtil;

public class dom_dup {
    private static final String HELP_OPTION_1 = "help";
    private static final String HELP_OPTION_2 = "h";
    private static final String PRG_NAME = "dom_dup";
    private static final String PRG_DESC = "";
    private static final String PRG_VERSION = "0.90";
    private static final String PRG_DATE = "2013.03.12";
    private static final String E_MAIL = "phylosoft@gmail.com";
    private static final String WWW = "sites.google.com/site/cmzmasek/home/software/forester";

    public static void main(String[] args) {
        try {
            CommandLineArguments cla = new CommandLineArguments(args);
            if (cla.isOptionSet(HELP_OPTION_1) || cla.isOptionSet(HELP_OPTION_2) || cla.getNumberOfNames() != 3) {
                dom_dup.printHelp();
                System.exit(0);
            }
            String pattern_str = cla.getName(0);
            File intree_file = cla.getFile(2);
            File species_groups_file = cla.getFile(1);
            PhylogenyFactory factory = ParserBasedPhylogenyFactory.getInstance();
            Phylogeny phy = factory.create(intree_file, PhyloXmlParser.createPhyloXmlParserXsdValidating())[0];
            ForesterUtil.programMessage(PRG_NAME, "Pattern string: " + pattern_str);
            Pattern pattern = Pattern.compile(pattern_str);
            ForesterUtil.programMessage(PRG_NAME, "Pattern is: " + pattern);
            TreeSet<String> set_a = new TreeSet<String>();
            TreeSet<String> set_b = new TreeSet<String>();
            dom_dup.read(species_groups_file, set_a, set_b);
            dom_dup.print_set(set_a, "Set a:");
            dom_dup.print_set(set_b, "Set b:");
            SortedSet<String> matching_names = dom_dup.obtainMatchingNames(phy, pattern);
            ForesterUtil.programMessage(PRG_NAME, "Found names: ");
            SortedMap<String, List<String>> pairs = dom_dup.obtainPairs(matching_names);
            int lca_counter = 0;
            int non_lca_counter = 0;
            int missing_counter = 0;
            int total_counter = 0;
            for (Map.Entry<String, List<String>> x : pairs.entrySet()) {
                ++total_counter;
                if (x.getValue().size() == 2) {
                    String a = x.getValue().get(0);
                    String b = x.getValue().get(1);
                    System.out.print(a + " - " + b);
                    PhylogenyNode lca = PhylogenyMethods.calculateLCA(phy.getNode(a), phy.getNode(b));
                    List<PhylogenyNode> external_descs = lca.getAllExternalDescendants();
                    boolean in_a = false;
                    boolean in_b = false;
                    for (PhylogenyNode external_desc : external_descs) {
                        String tc = external_desc.getNodeData().getTaxonomy().getTaxonomyCode();
                        if (set_a.contains(tc)) {
                            in_a = true;
                        }
                        if (!set_b.contains(tc)) continue;
                        in_b = true;
                    }
                    if (in_a && in_b) {
                        System.out.print(" => LCA ");
                        ++lca_counter;
                    } else {
                        ++non_lca_counter;
                    }
                    System.out.println();
                    continue;
                }
                if (x.getValue().size() == 1) {
                    System.out.println(x.getValue().get(0) + " => no partner in current tree!");
                    ++missing_counter;
                    continue;
                }
                System.out.println("error");
                System.exit(-1);
            }
            System.out.println("Total       : " + total_counter);
            System.out.println("LCA         : " + lca_counter);
            System.out.println("Non-LCA     : " + non_lca_counter);
            System.out.println("With missing: " + missing_counter);
        }
        catch (Exception e) {
            e.printStackTrace();
            ForesterUtil.fatalError(PRG_NAME, e.getMessage());
        }
    }

    private static SortedMap<String, List<String>> obtainPairs(SortedSet<String> matching_names) {
        TreeMap<String, List<String>> pairs = new TreeMap<String, List<String>>();
        for (String m : matching_names) {
            String short_m = m.substring(0, m.indexOf(126));
            if (!pairs.containsKey(short_m)) {
                ArrayList<String> p = new ArrayList<String>();
                p.add(m);
                pairs.put(short_m, p);
                continue;
            }
            ((List)pairs.get(short_m)).add(m);
        }
        return pairs;
    }

    private static SortedSet<String> obtainMatchingNames(Phylogeny phy, Pattern pattern) {
        TreeSet<String> matching_names = new TreeSet<String>();
        PhylogenyNodeIterator it = phy.iteratorExternalForward();
        while (it.hasNext()) {
            PhylogenyNode n = it.next();
            Matcher m = pattern.matcher(n.getName());
            if (!m.find()) continue;
            matching_names.add(n.getName());
        }
        return matching_names;
    }

    private static void print_set(Set<String> set_a, String l) {
        ForesterUtil.programMessage(PRG_NAME, l);
        for (String s : set_a) {
            System.out.print(s + " ");
        }
        System.out.println();
    }

    private static void read(File species_groups_file, Set<String> set_a, Set<String> set_b) throws IOException {
        String line;
        BufferedReader reader = ForesterUtil.obtainReader(species_groups_file);
        boolean first_line = true;
        while ((line = reader.readLine()) != null) {
            String[] s;
            if (ForesterUtil.isEmpty(line = line.trim())) continue;
            for (String name : s = line.split(" ")) {
                if (first_line) {
                    set_a.add(name);
                    continue;
                }
                set_b.add(name);
            }
            if (!first_line) continue;
            first_line = false;
        }
    }

    private static void printHelp() {
        ForesterUtil.printProgramInformation(PRG_NAME, PRG_DESC, PRG_VERSION, PRG_DATE, E_MAIL, WWW, ForesterUtil.getForesterLibraryInformation());
        System.out.println("Usage:");
        System.out.println();
        System.out.println(PRG_NAME);
        System.out.println();
        System.out.println(" example: ");
        System.out.println();
        System.out.println("dom_dup \"HUMAN~[12]-2\" groups.txt RRMa_ALL_plus_RRMa_ee3_50_hmmalign_05_40_fme_gsdi.phylo.xml");
        System.out.println();
        System.out.println();
    }
}

