/*
 * Decompiled with CFR 0.152.
 */
package org.forester.application;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import org.forester.evoinference.distance.NeighborJoining;
import org.forester.evoinference.matrix.distance.BasicSymmetricalDistanceMatrix;
import org.forester.evoinference.matrix.distance.DistanceMatrix;
import org.forester.io.parsers.SymmetricalDistanceMatrixParser;
import org.forester.io.writers.PhylogenyWriter;
import org.forester.phylogeny.Phylogeny;
import org.forester.util.CommandLineArguments;
import org.forester.util.ForesterUtil;

public class nj {
    private static final String HELP_OPTION_1 = "help";
    private static final String HELP_OPTION_2 = "h";
    private static final String VERBOSE_OPTION = "v";
    private static final String UPPER_TRIANGLE_OPTION = "u";
    private static final String PRG_NAME = "nj";
    private static final String PRG_VERSION = "0.0.1";
    private static final String PRG_DATE = "2008.03.04";
    private static final String E_MAIL = "czmasek@burnham.org";
    private static final String WWW = "www.phylosoft.org/forester/";

    public static void main(String[] args) {
        String error2;
        ForesterUtil.printProgramInformation(PRG_NAME, PRG_VERSION, PRG_DATE, E_MAIL, WWW);
        ArrayList<String> allowed_options = new ArrayList<String>();
        allowed_options.add(HELP_OPTION_1);
        allowed_options.add(HELP_OPTION_2);
        allowed_options.add(VERBOSE_OPTION);
        allowed_options.add(UPPER_TRIANGLE_OPTION);
        if (args.length < 2) {
            nj.printHelp();
            System.exit(-1);
        }
        CommandLineArguments cla = null;
        try {
            cla = new CommandLineArguments(args);
        }
        catch (Exception e) {
            ForesterUtil.fatalError(PRG_NAME, e.getMessage());
        }
        if (cla.isOptionSet(HELP_OPTION_1) || cla.isOptionSet(HELP_OPTION_2)) {
            nj.printHelp();
            System.exit(0);
        }
        if (cla.getNumberOfNames() != 2) {
            nj.printHelp();
            System.exit(-1);
        }
        boolean verbose = false;
        boolean upper_triangle = false;
        if (cla.isOptionSet(VERBOSE_OPTION)) {
            verbose = true;
        }
        if (cla.isOptionSet(UPPER_TRIANGLE_OPTION)) {
            upper_triangle = true;
        }
        File infile = cla.getFile(0);
        File outfile = cla.getFile(1);
        String error1 = ForesterUtil.isReadableFile(infile);
        if (!ForesterUtil.isEmpty(error1)) {
            ForesterUtil.fatalError(PRG_NAME, "cannot read from infile [" + infile + "]: " + error1);
        }
        if (outfile.exists()) {
            ForesterUtil.fatalError(PRG_NAME, "outfile [" + outfile + "] already exists");
        }
        if (!ForesterUtil.isEmpty(error2 = ForesterUtil.isWritableFile(outfile))) {
            ForesterUtil.fatalError(PRG_NAME, "cannot write to outfile [" + outfile + "]: " + error2);
        }
        SymmetricalDistanceMatrixParser parser = SymmetricalDistanceMatrixParser.createInstance();
        if (upper_triangle) {
            parser.setInputMatrixType(SymmetricalDistanceMatrixParser.InputMatrixType.UPPER_TRIANGLE);
        } else {
            parser.setInputMatrixType(SymmetricalDistanceMatrixParser.InputMatrixType.LOWER_TRIANGLE);
        }
        DistanceMatrix[] matrices = null;
        try {
            matrices = parser.parse(infile);
        }
        catch (IOException e) {
            ForesterUtil.fatalError(PRG_NAME, "failed to read from infile [" + infile + "]: " + e.getMessage());
        }
        if (verbose) {
            System.out.println("nj > read " + matrices.length + " pairwise distance matrice(s) of size " + matrices[0].getSize());
        }
        ArrayList<Phylogeny> ps = new ArrayList<Phylogeny>();
        NeighborJoining nj2 = NeighborJoining.createInstance(verbose, 6);
        long start_time = new Date().getTime();
        for (DistanceMatrix matrix : matrices) {
            ps.add(nj2.execute((BasicSymmetricalDistanceMatrix)matrix));
        }
        long end_time = new Date().getTime();
        PhylogenyWriter w = new PhylogenyWriter();
        try {
            w.toPhyloXML(outfile, ps, 1, ForesterUtil.LINE_SEPARATOR);
        }
        catch (IOException e) {
            ForesterUtil.fatalError(PRG_NAME, "failed to write to outfile [" + outfile + "]: " + e.getMessage());
        }
        System.out.println();
        System.out.println("nj > OK [" + (end_time - start_time) + "ms]");
        System.out.println();
    }

    private static void printHelp() {
        System.out.println();
        System.out.println("Usage:");
        System.out.println();
        System.out.println("% java -cp forester.jar org.forester.applications.nj [options] <pairwise distances infile> <out file>");
        System.out.println();
        System.out.println(" Options: ");
        System.out.println("v: verbose on");
        System.out.println("u: upper triangle option on (lower triangle is default)");
        System.out.println();
    }
}

