/*
 * Decompiled with CFR 0.152.
 */
package org.forester.applications;

import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import org.forester.archaeopteryx.AptxUtil;
import org.forester.archaeopteryx.Configuration;
import org.forester.archaeopteryx.Options;
import org.forester.io.parsers.PhylogenyParser;
import org.forester.io.parsers.util.ParserUtils;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyMethods;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.data.BranchColor;
import org.forester.phylogeny.data.BranchWidth;
import org.forester.phylogeny.iterators.PhylogenyNodeIterator;

public class phylo2coloredgraphics {
    public static void main(String[] args) {
        try {
            File treefile = new File("/home/czmasek/tol_117_TEST.xml");
            PhylogenyParser parser = ParserUtils.createParserDependingOnFileType(treefile, true);
            Phylogeny phy = PhylogenyMethods.readPhylogenies(parser, treefile)[0];
            HashMap<String, Color> colors = new HashMap<String, Color>();
            colors.put("Primates", new Color(255, 255, 0));
            colors.put("PANTR", new Color(255, 0, 255));
            colors.put("HUMAN", new Color(255, 0, 0));
            colors.put("RAT", new Color(155, 0, 0));
            colors.put("MOUSE", new Color(55, 155, 0));
            colors.put("CAVPO", new Color(155, 155, 0));
            colors.put("LOTGI", new Color(155, 155, 255));
            PhylogenyNodeIterator it = phy.iteratorPostorder();
            while (it.hasNext()) {
                PhylogenyNode n = it.next();
                if (!colors.containsKey(n.getName())) continue;
                n.getBranchData().setBranchColor(new BranchColor((Color)colors.get(n.getName())));
                n.getBranchData().setBranchWidth(new BranchWidth(4.0));
            }
            Configuration config = new Configuration();
            config.putDisplayColors("Background", new Color(255, 255, 255));
            config.putDisplayColors("Branch", new Color(0, 0, 0));
            config.putDisplayColors("Taxonomy", new Color(0, 0, 0));
            config.setPhylogenyGraphicsType(Options.PHYLOGENY_GRAPHICS_TYPE.RECTANGULAR);
            config.setColorizeBranches(true);
            config.setDisplayTaxonomyCode(false);
            AptxUtil.writePhylogenyToGraphicsFile(phy, new File("/home/czmasek/000.png"), 1300, 1300, AptxUtil.GraphicsExportType.PNG, config);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

