/*
 * Decompiled with CFR 0.152.
 */
package org.forester.archaeopteryx;

import java.awt.Font;
import java.awt.FontMetrics;
import org.forester.archaeopteryx.MainPanel;

public final class TreeFontSet {
    static final int BOLD_AND_ITALIC = 3;
    static final float FONT_SIZE_CHANGE_STEP = 1.0f;
    static final float SMALL_FONTS_BASE = 8.0f;
    private static final String DEFAULT_FONT = "Verdana";
    private Font _base_font;
    private boolean _decreased_size_by_system = false;
    private FontMetrics _fm_large;
    private FontMetrics _fm_small;
    private Font _large_font;
    private Font _large_font_memory;
    private Font _large_font_system;
    private final int _max;
    private final int _min;
    private final MainPanel _owner;
    private Font _small_font;
    private Font _small_font_memory;
    private Font _small_font_system;
    private int _small_max_ascent = 0;
    private int _small_max_descent = 0;

    TreeFontSet(MainPanel owner) {
        this._owner = owner;
        this._min = this._owner.getConfiguration().getMinBaseFontSize();
        this._max = this._owner.getConfiguration().getMinBaseFontSize();
        this.setBaseFont(new Font(DEFAULT_FONT, 0, 10));
    }

    public FontMetrics getFontMetricsLarge() {
        return this._fm_large;
    }

    public FontMetrics getFontMetricsSmall() {
        return this._fm_small;
    }

    public Font getSmallFont() {
        return this._small_font;
    }

    public int getSmallMaxAscent() {
        return this._small_max_ascent;
    }

    public int getSmallMaxDescent() {
        return this._small_max_descent;
    }

    private Font getLargeFontSystem() {
        return this._large_font_system;
    }

    private void intializeFonts() {
        int small_size = this.getBaseFont().getSize() - 2;
        int italic = 2;
        if (this.getBaseFont().getStyle() == 1) {
            ++italic;
        }
        this._small_font = new Font(this.getBaseFont().getFontName(), this.getBaseFont().getStyle(), small_size);
        this._large_font = new Font(this.getBaseFont().getFontName(), this.getBaseFont().getStyle(), this.getBaseFont().getSize());
        this._small_font_system = new Font(this.getBaseFont().getFontName(), this.getBaseFont().getStyle(), small_size);
        this._large_font_system = new Font(this.getBaseFont().getFontName(), this.getBaseFont().getStyle(), this.getBaseFont().getSize());
        this._small_font_memory = this._small_font;
        this._large_font_memory = this._large_font;
        this.setupFontMetrics();
    }

    private void setDecreasedSizeBySystem(boolean decreased_size_by_system) {
        this._decreased_size_by_system = decreased_size_by_system;
    }

    private void setupFontMetrics() {
        this._fm_small = this._owner.getFontMetrics(this._small_font);
        this._fm_large = this._owner.getFontMetrics(this._large_font);
        this._small_max_descent = this._fm_small.getMaxDescent();
        this._small_max_ascent = this._fm_small.getMaxAscent() + 1;
    }

    void decreaseFontSize(int min, boolean decreased_size_by_system) {
        if (decreased_size_by_system && !this.isDecreasedSizeBySystem()) {
            this._small_font_memory = this._small_font;
            this._large_font_memory = this._large_font;
        }
        this.setDecreasedSizeBySystem(decreased_size_by_system);
        if (this._large_font.getSize() >= min) {
            this._small_font = this._small_font.deriveFont((float)this._small_font.getSize() - 1.0f);
            this._large_font = this._large_font.deriveFont((float)this._large_font.getSize() - 1.0f);
            this.setupFontMetrics();
        }
    }

    Font getBaseFont() {
        return this._base_font;
    }

    Font getLargeFont() {
        return this._large_font;
    }

    Font getLargeFontMemory() {
        return this._large_font_memory;
    }

    Font getSmallFontSystem() {
        return this._small_font_system;
    }

    void increaseFontSize() {
        this._small_font = this._small_font.deriveFont((float)this._small_font.getSize() + 1.0f);
        this._large_font = this._large_font.deriveFont((float)this._large_font.getSize() + 1.0f);
        this.setupFontMetrics();
    }

    boolean isDecreasedSizeBySystem() {
        return this._decreased_size_by_system;
    }

    void largeFonts() {
        this.setDecreasedSizeBySystem(false);
        this._small_font = this._small_font.deriveFont(12.0f);
        this._large_font = this._large_font.deriveFont(14.0f);
        this.setupFontMetrics();
    }

    void mediumFonts() {
        this.setDecreasedSizeBySystem(false);
        this._small_font = this._small_font.deriveFont(8.0f);
        this._large_font = this._large_font.deriveFont(10.0f);
        this.setupFontMetrics();
    }

    void reset() {
        this._large_font_system = this._large_font;
    }

    void setBaseFont(Font base_font) {
        this._base_font = base_font;
        this.intializeFonts();
    }

    void smallFonts() {
        this.setDecreasedSizeBySystem(false);
        this._small_font = this._small_font.deriveFont(6.0f);
        this._large_font = this._large_font.deriveFont(8.0f);
        this.setupFontMetrics();
    }

    void superTinyFonts() {
        this.setDecreasedSizeBySystem(false);
        this._small_font = this._small_font.deriveFont(2.0f);
        this._large_font = this._large_font.deriveFont(4.0f);
        this.setupFontMetrics();
    }

    void tinyFonts() {
        this.setDecreasedSizeBySystem(false);
        this._small_font = this._small_font.deriveFont(4.0f);
        this._large_font = this._large_font.deriveFont(6.0f);
        this.setupFontMetrics();
    }
}

