/*
 * Decompiled with CFR 0.152.
 */
package org.forester.archaeopteryx;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JOptionPane;
import org.forester.archaeopteryx.AptxUtil;
import org.forester.archaeopteryx.MainFrame;
import org.forester.archaeopteryx.webservices.PhylogeniesWebserviceClient;
import org.forester.archaeopteryx.webservices.WebserviceUtil;
import org.forester.archaeopteryx.webservices.WebservicesManager;
import org.forester.io.parsers.PhylogenyParser;
import org.forester.io.parsers.nexus.NexusPhylogeniesParser;
import org.forester.io.parsers.nhx.NHXParser;
import org.forester.io.parsers.phyloxml.PhyloXmlDataFormatException;
import org.forester.io.parsers.phyloxml.PhyloXmlParser;
import org.forester.io.parsers.tol.TolParser;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyMethods;
import org.forester.phylogeny.data.Identifier;
import org.forester.phylogeny.factories.ParserBasedPhylogenyFactory;
import org.forester.phylogeny.factories.PhylogenyFactory;
import org.forester.util.ForesterUtil;

public class UrlTreeReader
implements Runnable {
    private final MainFrame _main_frame;
    private final int _webservice_client_index;

    UrlTreeReader(MainFrame mf, int webservice_client_index) {
        this._main_frame = mf;
        this._webservice_client_index = webservice_client_index;
    }

    @Override
    public void run() {
        this.readPhylogeniesFromWebservice();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void readPhylogeniesFromWebservice() {
        URL url = null;
        Phylogeny[] trees = null;
        WebservicesManager webservices_manager = WebservicesManager.getInstance();
        PhylogeniesWebserviceClient client = webservices_manager.getAvailablePhylogeniesWebserviceClient(this._webservice_client_index);
        String identifier = JOptionPane.showInputDialog(this._main_frame, client.getInstructions() + "\n(Reference: " + client.getReference() + ")", client.getDescription(), 3);
        if (identifier != null && identifier.trim().length() > 0) {
            identifier = identifier.trim();
            if (client.isQueryInteger()) {
                identifier = identifier.replaceAll("^\\D+", "");
                int id = -1;
                try {
                    id = Integer.parseInt(identifier);
                }
                catch (NumberFormatException e) {
                    id = -1;
                }
                if (id < 1) {
                    JOptionPane.showMessageDialog(this._main_frame, "Identifier is expected to be a number", "Can not open URL", 0);
                    return;
                }
                identifier = id + "";
            }
            boolean exception = false;
            try {
                String url_str = client.getUrl();
                url_str = url_str.replaceFirst("__query__", identifier);
                url = new URL(url_str);
                PhylogenyParser parser = null;
                switch (client.getReturnFormat()) {
                    case TOL_XML_RESPONSE: {
                        parser = new TolParser();
                        break;
                    }
                    case NEXUS: {
                        parser = new NexusPhylogeniesParser();
                        ((NexusPhylogeniesParser)parser).setReplaceUnderscores(true);
                        break;
                    }
                    case TREEBASE_TREE: {
                        parser = new NexusPhylogeniesParser();
                        ((NexusPhylogeniesParser)parser).setReplaceUnderscores(true);
                        ((NexusPhylogeniesParser)parser).setTaxonomyExtraction(NHXParser.TAXONOMY_EXTRACTION.NO);
                        break;
                    }
                    case TREEBASE_STUDY: {
                        parser = new NexusPhylogeniesParser();
                        ((NexusPhylogeniesParser)parser).setReplaceUnderscores(true);
                        ((NexusPhylogeniesParser)parser).setTaxonomyExtraction(NHXParser.TAXONOMY_EXTRACTION.NO);
                        break;
                    }
                    case NH: {
                        parser = new NHXParser();
                        ((NHXParser)parser).setTaxonomyExtraction(NHXParser.TAXONOMY_EXTRACTION.NO);
                        ((NHXParser)parser).setReplaceUnderscores(true);
                        ((NHXParser)parser).setGuessRootedness(true);
                        break;
                    }
                    case NH_EXTRACT_TAXONOMY: {
                        parser = new NHXParser();
                        ((NHXParser)parser).setTaxonomyExtraction(NHXParser.TAXONOMY_EXTRACTION.AGGRESSIVE);
                        ((NHXParser)parser).setReplaceUnderscores(false);
                        ((NHXParser)parser).setGuessRootedness(true);
                        break;
                    }
                    case PFAM: {
                        parser = new NHXParser();
                        ((NHXParser)parser).setTaxonomyExtraction(NHXParser.TAXONOMY_EXTRACTION.PFAM_STYLE_STRICT);
                        ((NHXParser)parser).setReplaceUnderscores(false);
                        ((NHXParser)parser).setGuessRootedness(true);
                        break;
                    }
                    case NHX: {
                        parser = new NHXParser();
                        ((NHXParser)parser).setTaxonomyExtraction(NHXParser.TAXONOMY_EXTRACTION.NO);
                        ((NHXParser)parser).setReplaceUnderscores(false);
                        ((NHXParser)parser).setGuessRootedness(true);
                        break;
                    }
                    case PHYLOXML: {
                        parser = PhyloXmlParser.createPhyloXmlParserXsdValidating();
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("unknown format: " + (Object)((Object)client.getReturnFormat()));
                    }
                }
                if (this._main_frame.getMainPanel().getCurrentTreePanel() != null) {
                    this._main_frame.getMainPanel().getCurrentTreePanel().setWaitCursor();
                } else {
                    this._main_frame.getMainPanel().setWaitCursor();
                }
                PhylogenyFactory factory = ParserBasedPhylogenyFactory.getInstance();
                trees = factory.create(url.openStream(), parser);
            }
            catch (MalformedURLException e) {
                exception = true;
                JOptionPane.showMessageDialog(this._main_frame, "Malformed URL: " + url + "\n" + e.getLocalizedMessage(), "Malformed URL", 0);
            }
            catch (IOException e) {
                exception = true;
                JOptionPane.showMessageDialog(this._main_frame, "Could not read from " + url + "\n" + e.getLocalizedMessage(), "Failed to read tree from " + client.getName() + " for " + identifier, 0);
            }
            catch (NumberFormatException e) {
                exception = true;
                JOptionPane.showMessageDialog(this._main_frame, "Could not read from " + url + "\n" + e.getLocalizedMessage(), "Failed to read tree from " + client.getName() + " for " + identifier, 0);
            }
            catch (Exception e) {
                exception = true;
                e.printStackTrace();
                JOptionPane.showMessageDialog(this._main_frame, e.getLocalizedMessage(), "Unexpected Exception", 0);
            }
            finally {
                if (this._main_frame.getCurrentTreePanel() != null) {
                    this._main_frame.getCurrentTreePanel().setArrowCursor();
                } else {
                    this._main_frame.getMainPanel().setArrowCursor();
                }
            }
            if (trees != null && trees.length > 0) {
                for (Phylogeny phylogeny : trees) {
                    if (phylogeny.isEmpty()) continue;
                    if (client.getName().equals("TreeFam")) {
                        phylogeny.setRerootable(false);
                        phylogeny.setRooted(true);
                    }
                    if (client.getProcessingInstructions() != null) {
                        try {
                            WebserviceUtil.processInstructions(client, phylogeny);
                        }
                        catch (PhyloXmlDataFormatException e) {
                            JOptionPane.showMessageDialog(this._main_frame, "Error:\n" + e.getLocalizedMessage(), "Error", 0);
                        }
                    }
                    if (client.getNodeField() != null) {
                        try {
                            PhylogenyMethods.transferNodeNameToField(phylogeny, client.getNodeField(), false);
                        }
                        catch (PhyloXmlDataFormatException e) {
                            JOptionPane.showMessageDialog(this._main_frame, "Error:\n" + e.getLocalizedMessage(), "Error", 0);
                        }
                    }
                    phylogeny.setIdentifier(new Identifier(identifier, client.getName()));
                    this._main_frame.getJMenuBar().remove(this._main_frame.getHelpMenu());
                    this._main_frame.getMenuBarOfMainFrame().add(this._main_frame.getHelpMenu());
                    this._main_frame.getMainPanel().addPhylogenyInNewTab(phylogeny, this._main_frame.getConfiguration(), new File(url.getFile()).getName(), url.toString());
                    String my_name_for_file = "";
                    if (!ForesterUtil.isEmpty(phylogeny.getName())) {
                        my_name_for_file = new String(phylogeny.getName()).replaceAll(" ", "_");
                    } else if (phylogeny.getIdentifier() != null) {
                        StringBuffer sb = new StringBuffer();
                        if (!ForesterUtil.isEmpty(phylogeny.getIdentifier().getProvider())) {
                            sb.append(phylogeny.getIdentifier().getProvider());
                            sb.append("_");
                        }
                        sb.append(phylogeny.getIdentifier().getValue());
                        my_name_for_file = new String(sb.toString().replaceAll(" ", "_"));
                    }
                    this._main_frame.getMainPanel().getCurrentTreePanel().setTreeFile(new File(my_name_for_file));
                    AptxUtil.lookAtSomeTreePropertiesForAptxControlSettings(phylogeny, this._main_frame.getMainPanel().getControlPanel(), this._main_frame.getConfiguration());
                    this._main_frame.getMainPanel().getControlPanel().showWhole();
                }
            } else if (!exception) {
                JOptionPane.showMessageDialog(null, ForesterUtil.wordWrap("Failed to read in tree(s) from [" + url + "]", 80), "Error", 0);
            }
            this._main_frame.getContentPane().repaint();
            if (trees != null && trees.length > 0) {
                try {
                    JOptionPane.showMessageDialog(null, ForesterUtil.wordWrap("Successfully read in " + trees.length + " tree(s) from [" + url + "]", 80), "Success", 1);
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                this._main_frame.getContentPane().repaint();
            }
        }
        this._main_frame.activateSaveAllIfNeeded();
        System.gc();
    }
}

