/*
 * Decompiled with CFR 0.152.
 */
package org.forester.archaeopteryx.tools;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;
import org.forester.archaeopteryx.MainFrameApplication;
import org.forester.archaeopteryx.tools.PhylogeneticInferenceOptions;
import org.forester.archaeopteryx.tools.RunnableProcess;
import org.forester.evoinference.distance.NeighborJoiningF;
import org.forester.evoinference.distance.PairwiseDistanceCalculator;
import org.forester.evoinference.matrix.distance.BasicSymmetricalDistanceMatrix;
import org.forester.evoinference.tools.BootstrapResampler;
import org.forester.msa.BasicMsa;
import org.forester.msa.Mafft;
import org.forester.msa.Msa;
import org.forester.msa.MsaInferrer;
import org.forester.msa.MsaMethods;
import org.forester.msa.ResampleableMsa;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyMethods;
import org.forester.sequence.MolecularSequence;
import org.forester.tools.ConfidenceAssessor;
import org.forester.util.ForesterUtil;

public class PhylogeneticInferrer
extends RunnableProcess {
    private Msa _msa;
    private final MainFrameApplication _mf;
    private final PhylogeneticInferenceOptions _options;
    private final List<MolecularSequence> _seqs;
    private final boolean DEBUG = true;
    public static final String MSA_FILE_SUFFIX = ".aln";
    public static final String PWD_FILE_SUFFIX = ".pwd";

    public PhylogeneticInferrer(List<MolecularSequence> seqs, PhylogeneticInferenceOptions options, MainFrameApplication mf) {
        this._msa = null;
        this._seqs = seqs;
        this._mf = mf;
        this._options = options;
    }

    public PhylogeneticInferrer(Msa msa, PhylogeneticInferenceOptions options, MainFrameApplication mf) {
        this._msa = msa;
        this._seqs = null;
        this._mf = mf;
        this._options = options;
    }

    private Msa inferMsa(MSA_PRG msa_prg) throws IOException, InterruptedException {
        switch (msa_prg) {
            case MAFFT: {
                return this.runMAFFT(this._seqs, this.processMafftOptions());
            }
        }
        return null;
    }

    private List<String> processMafftOptions() {
        String opts_str = this._options.getMsaPrgParameters().trim().toLowerCase();
        String[] opts_ary = opts_str.split(" ");
        ArrayList<String> opts = new ArrayList<String>();
        boolean saw_quiet = false;
        for (String opt : opts_ary) {
            opts.add(opt);
            if (!opt.equals("--quiet")) continue;
            saw_quiet = true;
        }
        if (!saw_quiet) {
            opts.add("--quiet");
        }
        return opts;
    }

    private Phylogeny inferPhylogeny(Msa msa) {
        BasicSymmetricalDistanceMatrix m = null;
        switch (this._options.getPwdDistanceMethod()) {
            case KIMURA_DISTANCE: {
                m = PairwiseDistanceCalculator.calcKimuraDistances(msa);
                break;
            }
            case POISSON_DISTANCE: {
                m = PairwiseDistanceCalculator.calcPoissonDistances(msa);
                break;
            }
            case FRACTIONAL_DISSIMILARITY: {
                m = PairwiseDistanceCalculator.calcFractionalDissimilarities(msa);
                break;
            }
            default: {
                throw new RuntimeException("invalid pwd method");
            }
        }
        if (!ForesterUtil.isEmpty(this._options.getIntermediateFilesBase())) {
            try {
                BufferedWriter pwd_writer = new BufferedWriter(new FileWriter(this._options.getIntermediateFilesBase() + PWD_FILE_SUFFIX));
                m.write(pwd_writer);
                pwd_writer.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        NeighborJoiningF nj2 = NeighborJoiningF.createInstance(false, 5);
        Phylogeny phy = nj2.execute(m);
        PhylogenyMethods.addMolecularSeqsToTree(phy, msa);
        PhylogenyMethods.extractFastaInformation(phy);
        return phy;
    }

    private void infer() throws InterruptedException {
        if (this._msa == null && this._seqs == null) {
            throw new IllegalArgumentException("cannot run phylogenetic analysis with null msa and seq array");
        }
        this.start(this._mf, "phylogenetic inference");
        if (this._msa == null) {
            Msa msa = null;
            try {
                msa = this.inferMsa(MSA_PRG.MAFFT);
            }
            catch (IOException e) {
                this.end(this._mf);
                JOptionPane.showMessageDialog(this._mf, "Could not create multiple sequence alignment with \"" + this._options.getMsaPrg() + "\" and the following parameters:\n\"" + this._options.getMsaPrgParameters() + "\"\nError: " + e.getLocalizedMessage(), "Failed to Calculate MSA", 0);
                e.printStackTrace();
                return;
            }
            catch (Exception e) {
                this.end(this._mf);
                JOptionPane.showMessageDialog(this._mf, "Could not create multiple sequence alignment with \"" + this._options.getMsaPrg() + "\" and the following parameters:\n\"" + this._options.getMsaPrgParameters() + "\"\nError: " + e.getLocalizedMessage(), "Unexpected Exception During MSA Calculation", 0);
                e.printStackTrace();
                return;
            }
            if (msa == null) {
                this.end(this._mf);
                JOptionPane.showMessageDialog(this._mf, "Could not create multiple sequence alignment with " + this._options.getMsaPrg() + "\nand the following parameters:\n\"" + this._options.getMsaPrgParameters() + "\"", "Failed to Calculate MSA", 0);
                return;
            }
            System.out.println(msa.toString());
            System.out.println(MsaMethods.calcGapRatio(msa));
            MsaMethods msa_tools = MsaMethods.createInstance();
            if (this._options.isExecuteMsaProcessing() && (msa = msa_tools.deleteGapColumns(this._options.getMsaProcessingMaxAllowedGapRatio(), this._options.getMsaProcessingMinAllowedLength(), msa)) == null) {
                this.end(this._mf);
                JOptionPane.showMessageDialog(this._mf, "Less than two sequences longer than " + this._options.getMsaProcessingMinAllowedLength() + " residues left after MSA processing", "MSA Processing Settings Too Stringent", 0);
                return;
            }
            System.out.println(msa_tools.getIgnoredSequenceIds());
            System.out.println(msa.toString());
            System.out.println(MsaMethods.calcGapRatio(msa));
            this._msa = msa;
        }
        int n = this._options.getBootstrapSamples();
        long seed = this._options.getRandomNumberGeneratorSeed();
        Phylogeny master_phy = this.inferPhylogeny(this._msa);
        if (this._options.isPerformBootstrapResampling() && n > 0) {
            ResampleableMsa resampleable_msa = new ResampleableMsa((BasicMsa)this._msa);
            int[][] resampled_column_positions = BootstrapResampler.createResampledColumnPositions(this._msa.getLength(), n, seed);
            Phylogeny[] eval_phys = new Phylogeny[n];
            for (int i = 0; i < n; ++i) {
                resampleable_msa.resample(resampled_column_positions[i]);
                eval_phys[i] = this.inferPhylogeny(resampleable_msa);
            }
            ConfidenceAssessor.evaluate("bootstrap", eval_phys, master_phy, true, 1.0);
        }
        this._mf.getMainPanel().addPhylogenyInNewTab(master_phy, this._mf.getConfiguration(), "nj", "njpath");
        this.end(this._mf);
        JOptionPane.showMessageDialog(this._mf, "Inference successfully completed", "Inference Completed", 1);
    }

    @Override
    public void run() {
        try {
            this.infer();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private Msa runMAFFT(List<MolecularSequence> seqs, List<String> opts) throws IOException, InterruptedException {
        Msa msa = null;
        MsaInferrer mafft = Mafft.createInstance(this._mf.getInferenceManager().getPathToLocalMafft().getCanonicalPath());
        try {
            msa = mafft.infer(seqs, opts);
        }
        catch (IOException e) {
            System.out.println(mafft.getErrorDescription());
        }
        return msa;
    }

    private void writeToFiles(BasicSymmetricalDistanceMatrix m) {
        if (!ForesterUtil.isEmpty(this._options.getIntermediateFilesBase())) {
            try {
                BufferedWriter msa_writer = new BufferedWriter(new FileWriter(this._options.getIntermediateFilesBase() + MSA_FILE_SUFFIX));
                this._msa.write(msa_writer, Msa.MSA_FORMAT.PHYLIP);
                msa_writer.close();
                BufferedWriter pwd_writer = new BufferedWriter(new FileWriter(this._options.getIntermediateFilesBase() + PWD_FILE_SUFFIX));
                m.write(pwd_writer);
                pwd_writer.close();
            }
            catch (Exception e) {
                System.out.println("Error: " + e.getMessage());
            }
        }
    }

    public static enum MSA_PRG {
        MAFFT;

    }
}

