/*
 * Decompiled with CFR 0.152.
 */
package org.forester.go.etc;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Writer;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.forester.go.GoId;
import org.forester.go.GoNameSpace;
import org.forester.go.GoTerm;
import org.forester.go.GoUtils;
import org.forester.go.OBOparser;
import org.forester.go.PfamToGoMapping;
import org.forester.go.etc.OntologizerResult;
import org.forester.species.BasicSpecies;
import org.forester.species.Species;
import org.forester.surfacing.SurfacingUtil;
import org.forester.util.ForesterUtil;

public class MetaOntologizer {
    private static final NumberFormat FORMATER = new DecimalFormat("0.00E0");
    private static final Color MIN_COLOR = new Color(0, 200, 50);
    private static final Color MAX_COLOR = new Color(0, 0, 0);
    private static final String PRG_NAME = "meta_ontologizer";
    private static final boolean VERBOSE = true;
    private static final Pattern PATTERN_ONTOLOGIZER_TABLE_OUTPUT = Pattern.compile(".*table-(.+)\\.txt", 2);

    private static boolean hasResultsForSpecies(Map<GoId, GoTerm> go_id_to_terms, SortedMap<String, SortedSet<OntologizerResult>> species_to_results_map, String species, GoNameSpace.GoNamespaceType namespace) {
        for (OntologizerResult ontologizer_result : (SortedSet)species_to_results_map.get(species)) {
            if (go_id_to_terms.get(ontologizer_result.getGoId()).getGoNameSpace().getType() != namespace) continue;
            return true;
        }
        return false;
    }

    private static StringBuilder obtainDomainsForGoId(List<PfamToGoMapping> pfam_to_go, SortedSet<String> domains_per_species, Map<GoId, GoTerm> all_go_terms, GoId query_go_id, Set<String> found_domain_ids) {
        StringBuilder sb = new StringBuilder();
        block0: for (String domain_id : domains_per_species) {
            for (PfamToGoMapping ptg : pfam_to_go) {
                if (!ptg.getKey().equals(domain_id)) continue;
                GoId go_id = ptg.getValue();
                HashSet<GoId> super_ids = new HashSet<GoId>();
                for (GoTerm term : GoUtils.getAllSuperGoTerms(go_id, all_go_terms)) {
                    super_ids.add(term.getGoId());
                }
                super_ids.add(go_id);
                if (!super_ids.contains(query_go_id)) continue;
                sb.append("[<a href=\"http://pfam.xfam.org/family/" + domain_id + "\">" + domain_id + "</a>] ");
                found_domain_ids.add(domain_id);
                continue block0;
            }
        }
        return sb;
    }

    private static String obtainSpecies(File ontologizer_outfile) {
        Matcher matcher = PATTERN_ONTOLOGIZER_TABLE_OUTPUT.matcher(ontologizer_outfile.getName());
        String species = null;
        if (!matcher.matches()) {
            throw new RuntimeException("pattern [" + PATTERN_ONTOLOGIZER_TABLE_OUTPUT + "] did not match [" + ontologizer_outfile.getName() + "]");
        }
        species = matcher.group(1);
        ForesterUtil.programMessage(PRG_NAME, "species for [" + ontologizer_outfile + "] is [" + species + "]");
        return species;
    }

    private static SortedMap<Species, SortedSet<String>> parseDomainGainLossFile(File input) throws IOException {
        String error = ForesterUtil.isReadableFile(input);
        if (!ForesterUtil.isEmpty(error)) {
            throw new IOException(error);
        }
        TreeMap<Species, SortedSet<String>> speciesto_to_domain_id = new TreeMap<Species, SortedSet<String>>();
        BufferedReader br = new BufferedReader(new FileReader(input));
        int line_number = 0;
        BasicSpecies current_species = null;
        try {
            String line;
            while ((line = br.readLine()) != null) {
                ++line_number;
                if (ForesterUtil.isEmpty(line = line.trim()) || line.startsWith("##")) continue;
                if (line.startsWith("#")) {
                    current_species = new BasicSpecies(line.substring(1));
                    speciesto_to_domain_id.put(current_species, new TreeSet());
                    ForesterUtil.programMessage(PRG_NAME, "saw " + current_species);
                    continue;
                }
                if (current_species == null) {
                    throw new IOException("parsing problem [at line " + line_number + "] in [" + input + "]");
                }
                ((SortedSet)speciesto_to_domain_id.get(current_species)).add(new String(line));
            }
        }
        catch (Exception e) {
            throw new IOException("parsing problem [at line " + line_number + "] in [" + input + "]: " + e.getMessage());
        }
        return speciesto_to_domain_id;
    }

    private static void processOneSpecies(Map<GoId, GoTerm> go_id_to_terms, Writer b_html_writer, Writer b_tab_writer, Writer c_html_writer, Writer c_tab_writer, Writer m_html_writer, Writer m_tab_writer, SortedMap<String, SortedSet<OntologizerResult>> species_to_results_map, String species, double p_adjusted_upper_limit, SortedSet<String> domains_per_species, List<PfamToGoMapping> pfam_to_go, Set<String> domain_ids_with_go_annot) throws IOException {
        SortedSet ontologizer_results = (SortedSet)species_to_results_map.get(species);
        for (OntologizerResult ontologizer_result : ontologizer_results) {
            GoTerm go_term = go_id_to_terms.get(ontologizer_result.getGoId());
            Writer current_html_writer = b_html_writer;
            Writer current_tab_writer = b_tab_writer;
            switch (go_term.getGoNameSpace().getType()) {
                case CELLULAR_COMPONENT: {
                    current_html_writer = c_html_writer;
                    current_tab_writer = c_tab_writer;
                    break;
                }
                case MOLECULAR_FUNCTION: {
                    current_html_writer = m_html_writer;
                    current_tab_writer = m_tab_writer;
                }
            }
            MetaOntologizer.writeValuesToTabWriter(species, ontologizer_result, go_term, current_tab_writer);
            MetaOntologizer.writeValuesToHtmlWriter(ontologizer_result, go_term, current_html_writer, p_adjusted_upper_limit, species, go_id_to_terms, domains_per_species, pfam_to_go, domain_ids_with_go_annot);
        }
    }

    public static void reformat(File ontologizer_outdir, String result_file_prefix, File domain_gain_loss_file, String outfile_base, File obo_file, double p_adjusted_upper_limit, String comment, List<PfamToGoMapping> pfam_to_go) throws IOException {
        if (!ontologizer_outdir.exists()) {
            throw new IllegalArgumentException("[" + ontologizer_outdir + "] does not exist");
        }
        if (!ontologizer_outdir.isDirectory()) {
            throw new IllegalArgumentException("[" + ontologizer_outdir + "] is not a directory");
        }
        if (!obo_file.exists()) {
            throw new IllegalArgumentException("[" + obo_file + "] does not exist");
        }
        if (p_adjusted_upper_limit < 0.0 || p_adjusted_upper_limit > 1.0) {
            throw new IllegalArgumentException("adjusted P values limit [" + p_adjusted_upper_limit + "] is out of range");
        }
        SortedMap<Species, SortedSet<String>> speciesto_to_domain_id = null;
        if (domain_gain_loss_file != null) {
            if (!domain_gain_loss_file.exists()) {
                throw new IllegalArgumentException("[" + domain_gain_loss_file + "] does not exist");
            }
            speciesto_to_domain_id = MetaOntologizer.parseDomainGainLossFile(domain_gain_loss_file);
            ForesterUtil.programMessage(PRG_NAME, "parsed gain/loss domains for " + speciesto_to_domain_id.size() + " species from [" + domain_gain_loss_file + "]");
        }
        String[] children = ontologizer_outdir.list();
        ArrayList<File> ontologizer_outfiles = new ArrayList<File>();
        if (children == null) {
            throw new IllegalArgumentException("problem with [" + ontologizer_outdir + "]");
        }
        for (String filename : children) {
            if (!filename.startsWith(result_file_prefix)) continue;
            ontologizer_outfiles.add(new File(filename));
        }
        ForesterUtil.programMessage(PRG_NAME, "need to analyze " + ontologizer_outfiles.size() + " Ontologizer outfiles from [" + ontologizer_outdir + "]");
        OBOparser parser = new OBOparser(obo_file, OBOparser.ReturnType.BASIC_GO_TERM);
        List<GoTerm> go_terms = parser.parse();
        ForesterUtil.programMessage(PRG_NAME, "parsed " + go_terms.size() + " GO terms from [" + obo_file + "]");
        Map<GoId, GoTerm> go_id_to_terms = GoUtils.createGoIdToGoTermMap(go_terms);
        String b_file_html = outfile_base + "_B.html";
        String b_file_txt = outfile_base + "_B.txt";
        String m_file_html = outfile_base + "_C.html";
        String m_file_txt = outfile_base + "_C.txt";
        String c_file_html = outfile_base + "_M.html";
        String c_file_txt = outfile_base + "_M.txt";
        BufferedWriter b_html_writer = ForesterUtil.createBufferedWriter(b_file_html);
        BufferedWriter b_tab_writer = ForesterUtil.createBufferedWriter(b_file_txt);
        BufferedWriter c_html_writer = ForesterUtil.createBufferedWriter(m_file_html);
        BufferedWriter c_tab_writer = ForesterUtil.createBufferedWriter(m_file_txt);
        BufferedWriter m_html_writer = ForesterUtil.createBufferedWriter(c_file_html);
        BufferedWriter m_tab_writer = ForesterUtil.createBufferedWriter(c_file_txt);
        TreeMap<String, SortedSet<OntologizerResult>> species_to_results_map = new TreeMap<String, SortedSet<OntologizerResult>>();
        for (File ontologizer_outfile : ontologizer_outfiles) {
            String species = MetaOntologizer.obtainSpecies(ontologizer_outfile);
            List<OntologizerResult> ontologizer_results = OntologizerResult.parse(new File(ontologizer_outdir + ForesterUtil.FILE_SEPARATOR + ontologizer_outfile));
            TreeSet<OntologizerResult> filtered_ontologizer_results = new TreeSet<OntologizerResult>();
            for (OntologizerResult ontologizer_result : ontologizer_results) {
                if (!(ontologizer_result.getPAdjusted() <= p_adjusted_upper_limit)) continue;
                filtered_ontologizer_results.add(ontologizer_result);
            }
            species_to_results_map.put(species, filtered_ontologizer_results);
        }
        MetaOntologizer.writeLabelsToTabWriter(b_tab_writer);
        MetaOntologizer.writeLabelsToTabWriter(c_tab_writer);
        MetaOntologizer.writeLabelsToTabWriter(m_tab_writer);
        String domain_gain_loss_file_full_path_str = null;
        if (domain_gain_loss_file != null) {
            domain_gain_loss_file_full_path_str = domain_gain_loss_file.getAbsolutePath();
        }
        MetaOntologizer.writeHtmlHeader(b_html_writer, GoNameSpace.GoNamespaceType.BIOLOGICAL_PROCESS.toString() + " | Pmax = " + p_adjusted_upper_limit + " | " + comment, ontologizer_outdir.getAbsolutePath(), domain_gain_loss_file_full_path_str);
        MetaOntologizer.writeHtmlHeader(c_html_writer, GoNameSpace.GoNamespaceType.CELLULAR_COMPONENT.toString() + " | Pmax = " + p_adjusted_upper_limit + " | " + comment, ontologizer_outdir.getAbsolutePath(), domain_gain_loss_file_full_path_str);
        MetaOntologizer.writeHtmlHeader(m_html_writer, GoNameSpace.GoNamespaceType.MOLECULAR_FUNCTION.toString() + " | Pmax = " + p_adjusted_upper_limit + " | " + comment, ontologizer_outdir.getAbsolutePath(), domain_gain_loss_file_full_path_str);
        for (String species : species_to_results_map.keySet()) {
            if (MetaOntologizer.hasResultsForSpecies(go_id_to_terms, species_to_results_map, species, GoNameSpace.GoNamespaceType.BIOLOGICAL_PROCESS)) {
                MetaOntologizer.writeHtmlSpecies(b_html_writer, species);
            }
            if (MetaOntologizer.hasResultsForSpecies(go_id_to_terms, species_to_results_map, species, GoNameSpace.GoNamespaceType.CELLULAR_COMPONENT)) {
                MetaOntologizer.writeHtmlSpecies(c_html_writer, species);
            }
            if (MetaOntologizer.hasResultsForSpecies(go_id_to_terms, species_to_results_map, species, GoNameSpace.GoNamespaceType.MOLECULAR_FUNCTION)) {
                MetaOntologizer.writeHtmlSpecies(m_html_writer, species);
            }
            SortedSet domains_per_species = null;
            if (speciesto_to_domain_id != null && speciesto_to_domain_id.size() > 0) {
                domains_per_species = (SortedSet)speciesto_to_domain_id.get(new BasicSpecies(species));
            }
            HashSet<String> domain_ids_with_go_annot = new HashSet<String>();
            MetaOntologizer.processOneSpecies(go_id_to_terms, b_html_writer, b_tab_writer, c_html_writer, c_tab_writer, m_html_writer, m_tab_writer, species_to_results_map, species, p_adjusted_upper_limit, domains_per_species, pfam_to_go, domain_ids_with_go_annot);
            if (speciesto_to_domain_id == null || speciesto_to_domain_id.size() <= 0) continue;
            if (MetaOntologizer.hasResultsForSpecies(go_id_to_terms, species_to_results_map, species, GoNameSpace.GoNamespaceType.BIOLOGICAL_PROCESS)) {
                MetaOntologizer.writeHtmlDomains(b_html_writer, domains_per_species, domain_ids_with_go_annot);
            }
            if (MetaOntologizer.hasResultsForSpecies(go_id_to_terms, species_to_results_map, species, GoNameSpace.GoNamespaceType.CELLULAR_COMPONENT)) {
                MetaOntologizer.writeHtmlDomains(c_html_writer, domains_per_species, domain_ids_with_go_annot);
            }
            if (!MetaOntologizer.hasResultsForSpecies(go_id_to_terms, species_to_results_map, species, GoNameSpace.GoNamespaceType.MOLECULAR_FUNCTION)) continue;
            MetaOntologizer.writeHtmlDomains(m_html_writer, domains_per_species, domain_ids_with_go_annot);
        }
        MetaOntologizer.writeHtmlEnd(b_html_writer);
        MetaOntologizer.writeHtmlEnd(c_html_writer);
        MetaOntologizer.writeHtmlEnd(m_html_writer);
        ((Writer)b_html_writer).close();
        ((Writer)b_tab_writer).close();
        ((Writer)c_html_writer).close();
        ((Writer)c_tab_writer).close();
        ((Writer)m_html_writer).close();
        ((Writer)m_tab_writer).close();
        ForesterUtil.programMessage(PRG_NAME, "successfully wrote biological process summary to [" + b_file_html + "]");
        ForesterUtil.programMessage(PRG_NAME, "successfully wrote biological process summary to [" + b_file_txt + "]");
        ForesterUtil.programMessage(PRG_NAME, "successfully wrote molecular function summary to [" + m_file_html + "]");
        ForesterUtil.programMessage(PRG_NAME, "successfully wrote molecular function summary to [" + m_file_txt + "]");
        ForesterUtil.programMessage(PRG_NAME, "successfully wrote cellular component summary to [" + c_file_html + "]");
        ForesterUtil.programMessage(PRG_NAME, "successfully wrote cellular component summary to [" + c_file_txt + "]");
    }

    private static void writeHtmlDomains(Writer writer, SortedSet<String> domains, Set<String> domain_ids_with_go_annot) throws IOException {
        writer.write("<tr>");
        writer.write("<td colspan=\"10\">");
        if (domains != null) {
            for (String domain : domains) {
                if (domain_ids_with_go_annot.contains(domain)) continue;
                writer.write("[<a class=\"new_type\" href=\"http://pfam.xfam.org/family/" + domain + "\">" + domain + "</a>] ");
            }
        }
        writer.write("</td>");
        writer.write("</tr>");
        writer.write(ForesterUtil.LINE_SEPARATOR);
    }

    private static void writeHtmlEnd(Writer writer) throws IOException {
        writer.write("</table>");
        writer.write("</body>");
        writer.write("</html>");
    }

    private static void writeHtmlHeader(Writer w, String desc, String ontologizer_outdir, String domain_gain_loss_file) throws IOException {
        w.write("<head>");
        w.write("<title>");
        w.write(desc);
        w.write("</title>");
        w.write(ForesterUtil.LINE_SEPARATOR);
        w.write("<style>");
        w.write(ForesterUtil.LINE_SEPARATOR);
        w.write("a:visited { color : #F87217; text-decoration : none; }");
        w.write(ForesterUtil.LINE_SEPARATOR);
        w.write("a:link { color : #F87217; text-decoration : none; }");
        w.write(ForesterUtil.LINE_SEPARATOR);
        w.write("a:hover { color : #FFFFFF; background-color : #00FF00; text-decoration : none; }");
        w.write(ForesterUtil.LINE_SEPARATOR);
        w.write("a:hover { color : #FFFFFF; background-color : #00FF00; text-decoration : none; }");
        w.write(ForesterUtil.LINE_SEPARATOR);
        w.write("a.new_type:visited { font-size: 7pt; color : #808080; text-decoration : none; }");
        w.write(ForesterUtil.LINE_SEPARATOR);
        w.write("a.new_type:link { font-size: 7pt; color : #505050; text-decoration : none; }");
        w.write(ForesterUtil.LINE_SEPARATOR);
        w.write("a.new_type:hover { font-size: 7pt; color : #000000; background-color : #FFFF00; text-decoration : none; }");
        w.write(ForesterUtil.LINE_SEPARATOR);
        w.write("a.new_type:hover { font-size: 7pt; color : #000000; background-color : #FFFF00; text-decoration : none; }");
        w.write(ForesterUtil.LINE_SEPARATOR);
        w.write("td { text-align: left; vertical-align: top; font-family: Verdana, Arial, Helvetica; font-size: 8pt}");
        w.write(ForesterUtil.LINE_SEPARATOR);
        w.write("th { text-align: left; vertical-align: top; font-family: Verdana, Arial, Helvetica; font-size: 10pt; font-weight: bold }");
        w.write(ForesterUtil.LINE_SEPARATOR);
        w.write("h1 { color : #000000; font-family: Verdana, Arial, Helvetica; font-size: 18pt; font-weight: bold }");
        w.write(ForesterUtil.LINE_SEPARATOR);
        w.write("h2 { color : #000000; font-family: Verdana, Arial, Helvetica; font-size: 16pt; font-weight: bold }");
        w.write("h3 { margin-top: 12px;  margin-bottom: 0px; color : #000000; font-family: Verdana, Arial, Helvetica; font-size: 12pt; font-weight: bold }");
        w.write(ForesterUtil.LINE_SEPARATOR);
        w.write("</style>");
        w.write(ForesterUtil.LINE_SEPARATOR);
        w.write("</head>");
        w.write(ForesterUtil.LINE_SEPARATOR);
        w.write("<body>");
        w.write(ForesterUtil.LINE_SEPARATOR);
        w.write("<h2>");
        w.write("meta ontologizer");
        w.write("</h2>");
        w.write(ForesterUtil.LINE_SEPARATOR);
        w.write("<h2>");
        w.write(desc);
        w.write("</h2>");
        w.write(ForesterUtil.LINE_SEPARATOR);
        w.write("<table>");
        w.write(ForesterUtil.LINE_SEPARATOR);
        w.write("<tr><th>");
        w.write("ontolgizer output directory analysed:");
        w.write("</th><td>");
        w.write(ontologizer_outdir);
        w.write("</td></tr>");
        if (!ForesterUtil.isEmpty(domain_gain_loss_file)) {
            w.write(ForesterUtil.LINE_SEPARATOR);
            w.write("<tr><th>");
            w.write("domain gain or loss file:");
            w.write("</th><td>");
            w.write(domain_gain_loss_file);
            w.write("</td></tr>");
        }
        w.write("</table>");
        w.write(ForesterUtil.LINE_SEPARATOR);
        w.write("<table>");
        w.write(ForesterUtil.LINE_SEPARATOR);
        w.write("<tr>");
        w.write("<th>");
        w.write("GO term name");
        w.write("</th><th>");
        w.write("GO id");
        w.write("</th><th>");
        w.write("P adjusted");
        w.write("</th><th>");
        w.write("P");
        w.write("</th><th>");
        w.write("Pop total");
        w.write("</th><th>");
        w.write("Pop term");
        w.write("</th><th>");
        w.write("Study total");
        w.write("</th><th>");
        w.write("Study term");
        w.write("</th><th>");
        w.write("Domains");
        w.write("</th><th>");
        w.write("trivial?");
        w.write("</th>");
        w.write("</tr>");
        w.write(ForesterUtil.LINE_SEPARATOR);
    }

    private static void writeHtmlSpecies(Writer writer, String species) throws IOException {
        writer.write("<tr>");
        writer.write("<td><h3>");
        writer.write(species);
        SurfacingUtil.writeTaxonomyLinks(writer, species, null);
        writer.write("</h3></td>");
        writer.write("</tr>");
        writer.write(ForesterUtil.LINE_SEPARATOR);
    }

    private static void writeLabelsToTabWriter(Writer writer) throws IOException {
        writer.write("#species");
        writer.write("\t");
        writer.write("GO name");
        writer.write("\t");
        writer.write("GO id");
        writer.write("\t");
        writer.write("P adjusted");
        writer.write("\t");
        writer.write("P");
        writer.write("\t");
        writer.write("Pop total");
        writer.write("\t");
        writer.write("Pop term");
        writer.write("\t");
        writer.write("Study total");
        writer.write("\t");
        writer.write("Study term");
        writer.write("\t");
        writer.write("is trivial");
        writer.write(ForesterUtil.LINE_SEPARATOR);
    }

    private static void writeValuesToHtmlWriter(OntologizerResult ontologizer_result, GoTerm go_term, Writer writer, double p_adjusted_upper_limit, String species, Map<GoId, GoTerm> go_id_to_terms, SortedSet<String> domains_per_species, List<PfamToGoMapping> pfam_to_go, Set<String> domain_ids_with_go_annot) throws IOException {
        Color p_adj_color = ForesterUtil.calcColor(ontologizer_result.getPAdjusted(), 0.0, p_adjusted_upper_limit, MIN_COLOR, MAX_COLOR);
        Color p_color = ForesterUtil.calcColor(ontologizer_result.getP(), 0.0, p_adjusted_upper_limit, MIN_COLOR, MAX_COLOR);
        writer.write("<tr>");
        writer.write("<td>");
        writer.write("<font color=\"#" + ForesterUtil.colorToHex(p_adj_color) + "\">");
        writer.write(go_term.getName());
        writer.write("</font>");
        writer.write("</td><td>");
        writer.write("<a href=\"http://amigo.geneontology.org/cgi-bin/amigo/go.cgi?view=details&search_constraint=terms&query=" + ontologizer_result.getGoId().getId() + "\" target=\"amigo_window\">" + ontologizer_result.getGoId().getId() + "</a>");
        writer.write("</td><td>");
        writer.write("<font color=\"#" + ForesterUtil.colorToHex(p_adj_color) + "\">");
        writer.write(FORMATER.format(ontologizer_result.getPAdjusted()));
        writer.write("</font>");
        writer.write("</td><td>");
        writer.write("<font color=\"#" + ForesterUtil.colorToHex(p_color) + "\">");
        writer.write(FORMATER.format(ontologizer_result.getP()));
        writer.write("</font>");
        writer.write("</td><td>");
        writer.write(String.valueOf(ontologizer_result.getPopTotal()));
        writer.write("</td><td>");
        writer.write(String.valueOf(ontologizer_result.getPopTerm()));
        writer.write("</td><td>");
        writer.write(String.valueOf(ontologizer_result.getStudyTotal()));
        writer.write("</td><td>");
        writer.write(String.valueOf(ontologizer_result.getStudyTerm()));
        writer.write("</td><td>");
        if (domains_per_species != null) {
            StringBuilder sb = MetaOntologizer.obtainDomainsForGoId(pfam_to_go, domains_per_species, go_id_to_terms, go_term.getGoId(), domain_ids_with_go_annot);
            writer.write(sb.toString());
        } else {
            writer.write(" ");
        }
        writer.write("</td><td>");
        if (ontologizer_result.isTrivial()) {
            writer.write("trivial");
        } else {
            writer.write(" ");
        }
        writer.write("</td>");
        writer.write("</tr>");
        writer.write(ForesterUtil.LINE_SEPARATOR);
    }

    private static void writeValuesToTabWriter(String species, OntologizerResult ontologizer_result, GoTerm got_term, Writer writer) throws IOException {
        writer.write(species);
        writer.write("\t");
        writer.write(got_term.getName());
        writer.write("\t");
        writer.write(ontologizer_result.getGoId().getId());
        writer.write("\t");
        writer.write(String.valueOf(ontologizer_result.getPAdjusted()));
        writer.write("\t");
        writer.write(String.valueOf(ontologizer_result.getP()));
        writer.write("\t");
        writer.write(String.valueOf(ontologizer_result.getPopTotal()));
        writer.write("\t");
        writer.write(String.valueOf(ontologizer_result.getPopTerm()));
        writer.write("\t");
        writer.write(String.valueOf(ontologizer_result.getStudyTotal()));
        writer.write("\t");
        writer.write(String.valueOf(ontologizer_result.getStudyTerm()));
        writer.write("\t");
        writer.write(String.valueOf(ontologizer_result.isTrivial()));
        writer.write(ForesterUtil.LINE_SEPARATOR);
    }
}

