/*
 * Decompiled with CFR 0.152.
 */
package org.forester.io.parsers.nexus;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.forester.io.parsers.IteratingPhylogenyParser;
import org.forester.io.parsers.PhylogenyParser;
import org.forester.io.parsers.nhx.NHXFormatException;
import org.forester.io.parsers.nhx.NHXParser;
import org.forester.io.parsers.util.ParserUtils;
import org.forester.io.parsers.util.PhylogenyParserException;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.data.Sequence;
import org.forester.phylogeny.iterators.PhylogenyNodeIterator;
import org.forester.sequence.BasicSequence;
import org.forester.sequence.MolecularSequence;
import org.forester.util.ForesterUtil;

public final class NexusPhylogeniesParser
implements IteratingPhylogenyParser,
PhylogenyParser {
    private static final String begin_trees = "Begin Trees;".toLowerCase();
    private static final String end = "End;".toLowerCase();
    private static final String endblock = "endblock";
    private static final Pattern ROOTEDNESS_PATTERN = Pattern.compile(".+=\\s*\\[&([R|U])\\].*");
    private static final String taxlabels = "TaxLabels".toLowerCase();
    private static final Pattern TITLE_PATTERN = Pattern.compile("TITLE.?\\s+([^;]+)", 2);
    private static final String translate = "Translate".toLowerCase();
    private static final String data = "Begin Characters;".toLowerCase();
    private static final String characters = "Begin Data;".toLowerCase();
    private static final String tree = "Tree".toLowerCase();
    private static final Pattern TREE_NAME_PATTERN = Pattern.compile("\\s*.?Tree\\s+(.+?)\\s*=.+", 2);
    private static final Pattern TRANSLATE_PATTERN = Pattern.compile("([0-9A-Za-z]+)\\s+(.+)");
    private static final Pattern ALN_PATTERN = Pattern.compile("(.+)\\s+([A-Za-z-_\\*\\?]+)");
    private static final Pattern DATATYPE_PATTERN = Pattern.compile("datatype\\s?.\\s?([a-z]+)");
    private static final Pattern LINK_TAXA_PATTERN = Pattern.compile("link\\s+taxa\\s?.\\s?([^;]+)", 2);
    private static final String utree = "UTREE".toLowerCase();
    private BufferedReader _br;
    private boolean _ignore_quotes_in_nh_data = false;
    private boolean _in_taxalabels;
    private boolean _in_translate;
    private boolean _in_tree;
    private boolean _in_trees_block;
    private boolean _in_data_block;
    private boolean _is_rooted;
    private String _datatype;
    private String _name;
    private Phylogeny _next;
    private Object _nexus_source;
    private StringBuilder _nh;
    private boolean _replace_underscores = false;
    private boolean _rooted_info_present;
    private List<String> _taxlabels;
    private NHXParser.TAXONOMY_EXTRACTION _taxonomy_extraction = NHXParser.TAXONOMY_EXTRACTION.NO;
    private String _title;
    private Map<String, String> _translate_map;
    private StringBuilder _translate_sb;
    private Map<String, MolecularSequence> _seqs;
    private final boolean _add_sequences = true;

    @Override
    public String getName() {
        return "Nexus Phylogenies Parser";
    }

    @Override
    public final boolean hasNext() {
        return this._next != null;
    }

    @Override
    public final Phylogeny next() throws NHXFormatException, IOException {
        Phylogeny phy = this._next;
        this.getNext();
        return phy;
    }

    @Override
    public final Phylogeny[] parse() throws IOException {
        ArrayList<Phylogeny> l = new ArrayList<Phylogeny>();
        while (this.hasNext()) {
            l.add(this.next());
        }
        Phylogeny[] p = new Phylogeny[l.size()];
        for (int i = 0; i < l.size(); ++i) {
            p[i] = (Phylogeny)l.get(i);
        }
        this.reset();
        return p;
    }

    @Override
    public final void reset() throws FileNotFoundException, IOException {
        this._taxlabels = new ArrayList<String>();
        this._translate_map = new HashMap<String, String>();
        this._nh = new StringBuilder();
        this._name = "";
        this._title = "";
        this._translate_sb = null;
        this._next = null;
        this._in_trees_block = false;
        this._in_taxalabels = false;
        this._in_translate = false;
        this._in_tree = false;
        this._rooted_info_present = false;
        this._is_rooted = false;
        this._seqs = new HashMap<String, MolecularSequence>();
        this._br = ParserUtils.createReader(this._nexus_source);
        this.getNext();
    }

    public final void setIgnoreQuotes(boolean ignore_quotes_in_nh_data) {
        this._ignore_quotes_in_nh_data = ignore_quotes_in_nh_data;
    }

    public final void setReplaceUnderscores(boolean replace_underscores) {
        this._replace_underscores = replace_underscores;
    }

    @Override
    public final void setSource(Object nexus_source) throws PhylogenyParserException, IOException {
        if (nexus_source == null) {
            throw new PhylogenyParserException("attempt to parse null object");
        }
        this._nexus_source = nexus_source;
        this.reset();
    }

    public final void setTaxonomyExtraction(NHXParser.TAXONOMY_EXTRACTION taxonomy_extraction) {
        this._taxonomy_extraction = taxonomy_extraction;
    }

    private final void createPhylogeny(String title, String name, StringBuilder nhx, boolean rooted_info_present, boolean is_rooted) throws IOException {
        this._next = null;
        NHXParser pars = new NHXParser();
        pars.setTaxonomyExtraction(this._taxonomy_extraction);
        pars.setReplaceUnderscores(this._replace_underscores);
        pars.setIgnoreQuotes(this._ignore_quotes_in_nh_data);
        if (rooted_info_present) {
            pars.setGuessRootedness(false);
        }
        pars.setSource(nhx);
        Phylogeny p = pars.next();
        if (p == null) {
            throw new PhylogenyParserException("failed to create phylogeny");
        }
        String myname = null;
        if (!ForesterUtil.isEmpty(title) && !ForesterUtil.isEmpty(name)) {
            myname = title.replace('_', ' ').trim() + " (" + name.trim() + ")";
        } else if (!ForesterUtil.isEmpty(title)) {
            myname = title.replace('_', ' ').trim();
        } else if (!ForesterUtil.isEmpty(name)) {
            myname = name.trim();
        }
        if (!ForesterUtil.isEmpty(myname)) {
            p.setName(myname);
        }
        if (rooted_info_present) {
            p.setRooted(is_rooted);
        }
        if (this._taxlabels.size() > 0 || this._translate_map.size() > 0) {
            PhylogenyNodeIterator it = p.iteratorExternalForward();
            while (it.hasNext()) {
                PhylogenyNode node = it.next();
                if (this._translate_map.size() > 0 && this._translate_map.containsKey(node.getName())) {
                    node.setName(this._translate_map.get(node.getName()).replaceAll("['\"]+", ""));
                } else if (this._taxlabels.size() > 0) {
                    int i = -1;
                    try {
                        i = Integer.parseInt(node.getName());
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    if (i > 0) {
                        node.setName(this._taxlabels.get(i - 1).replaceAll("['\"]+", ""));
                    }
                }
                if (!this._replace_underscores && this._taxonomy_extraction != NHXParser.TAXONOMY_EXTRACTION.NO) {
                    ParserUtils.extractTaxonomyDataFromNodeName(node, this._taxonomy_extraction);
                } else if (this._replace_underscores && !ForesterUtil.isEmpty(node.getName())) {
                    node.setName(node.getName().replace('_', ' ').trim());
                }
                if (!this._seqs.containsKey(node.getName())) continue;
                MolecularSequence s = this._seqs.get(node.getName());
                Sequence ns = new Sequence(s);
                ns.setMolecularSequenceAligned(true);
                node.getNodeData().addSequence(ns);
            }
        }
        this._next = p;
    }

    private final void getNext() throws IOException, NHXFormatException {
        String line;
        this._next = null;
        while ((line = this._br.readLine()) != null) {
            Matcher aln_matcher;
            Object name_matcher;
            if ((line = line.trim()).length() <= 0 || line.startsWith("#") || line.startsWith(">")) continue;
            line = ForesterUtil.collapseWhiteSpace(line);
            String line_lc = (line = NexusPhylogeniesParser.removeWhiteSpaceBeforeSemicolon(line)).toLowerCase();
            if (line_lc.startsWith(begin_trees)) {
                this._in_trees_block = true;
                this._in_taxalabels = false;
                this._in_translate = false;
                this._in_data_block = false;
                this._datatype = null;
                this._title = "";
            } else if (line_lc.startsWith(taxlabels)) {
                this._in_trees_block = false;
                this._in_taxalabels = true;
                this._in_translate = false;
                this._in_data_block = false;
                this._datatype = null;
            } else if (line_lc.startsWith(translate)) {
                this._translate_sb = new StringBuilder();
                this._in_taxalabels = false;
                this._in_translate = true;
                this._in_data_block = false;
                this._datatype = null;
            } else if (line_lc.startsWith(characters) || line_lc.startsWith(data)) {
                this._in_taxalabels = false;
                this._in_trees_block = false;
                this._in_translate = false;
                this._in_data_block = true;
                this._datatype = null;
            } else if (this._in_trees_block) {
                if (line_lc.startsWith("title")) {
                    Matcher title_m = TITLE_PATTERN.matcher(line);
                    if (title_m.lookingAt()) {
                        this._title = title_m.group(1);
                    }
                } else if (line_lc.startsWith("link")) {
                    Matcher link_m = LINK_TAXA_PATTERN.matcher(line);
                    if (link_m.lookingAt()) {
                        String string = link_m.group(1);
                    }
                } else if (line_lc.startsWith(end) || line_lc.startsWith(endblock)) {
                    this._in_trees_block = false;
                    this._in_tree = false;
                    this._in_translate = false;
                    if (this._nh.length() > 0) {
                        this.createPhylogeny(this._title, this._name, this._nh, this._rooted_info_present, this._is_rooted);
                        this._nh = new StringBuilder();
                        this._name = "";
                        this._rooted_info_present = false;
                        this._is_rooted = false;
                        if (this._next != null) {
                            return;
                        }
                    }
                } else if (line_lc.startsWith(tree) || line_lc.startsWith(utree)) {
                    Matcher rootedness_matcher;
                    boolean might = false;
                    if (this._nh.length() > 0) {
                        might = true;
                        this.createPhylogeny(this._title, this._name, this._nh, this._rooted_info_present, this._is_rooted);
                        this._nh = new StringBuilder();
                        this._name = "";
                        this._rooted_info_present = false;
                        this._is_rooted = false;
                    }
                    this._in_tree = true;
                    this._nh.append(line.substring(line.indexOf(61)));
                    name_matcher = TREE_NAME_PATTERN.matcher(line);
                    if (((Matcher)name_matcher).matches()) {
                        this._name = ((Matcher)name_matcher).group(1);
                        this._name = this._name.replaceAll("['\"]+", "");
                    }
                    if ((rootedness_matcher = ROOTEDNESS_PATTERN.matcher(line)).matches()) {
                        String s = rootedness_matcher.group(1);
                        line = line.replaceAll("\\[\\&.\\]", "");
                        this._rooted_info_present = true;
                        if (s.toUpperCase().equals("R")) {
                            this._is_rooted = true;
                        }
                    }
                    if (might && this._next != null) {
                        return;
                    }
                } else if (this._in_tree && !this._in_translate) {
                    this._nh.append(line);
                }
                if (!(line_lc.startsWith("title") || line_lc.startsWith("link") || this._in_translate || line_lc.startsWith(end) || line_lc.startsWith(endblock) || !line_lc.endsWith(";"))) {
                    this._in_tree = false;
                    this._in_translate = false;
                    this.createPhylogeny(this._title, this._name, this._nh, this._rooted_info_present, this._is_rooted);
                    this._nh = new StringBuilder();
                    this._name = "";
                    this._rooted_info_present = false;
                    this._is_rooted = false;
                    if (this._next != null) {
                        return;
                    }
                }
            }
            if (this._in_taxalabels) {
                if (line_lc.startsWith(end) || line_lc.startsWith(endblock)) {
                    this._in_taxalabels = false;
                } else {
                    String[] labels = line.split("\\s+");
                    for (String label : labels) {
                        if (label.toLowerCase().equals(taxlabels)) continue;
                        if (label.endsWith(";")) {
                            this._in_taxalabels = false;
                            label = label.substring(0, label.length() - 1);
                        }
                        if (label.length() <= 0) continue;
                        this._taxlabels.add(label);
                    }
                }
            }
            if (this._in_translate) {
                if (line_lc.startsWith(end) || line_lc.startsWith(endblock)) {
                    this._in_translate = false;
                } else {
                    this._translate_sb.append(" ");
                    this._translate_sb.append(line.trim());
                    if (line.endsWith(";")) {
                        this._in_translate = false;
                        this.setTranslateKeyValuePairs(this._translate_sb);
                    }
                }
            }
            if (!this._in_data_block) continue;
            if (line_lc.startsWith(end) || line_lc.startsWith(endblock)) {
                this._in_data_block = false;
                this._datatype = null;
                continue;
            }
            if (line_lc.startsWith("link")) {
                Matcher link_m = LINK_TAXA_PATTERN.matcher(line);
                if (!link_m.lookingAt()) continue;
                name_matcher = link_m.group(1);
                continue;
            }
            Matcher datatype_matcher = DATATYPE_PATTERN.matcher(line_lc);
            if (datatype_matcher.find()) {
                this._datatype = datatype_matcher.group(1);
                continue;
            }
            if (this._datatype == null || !this._datatype.equals("protein") && !this._datatype.equals("dna") && !this._datatype.equals("rna")) continue;
            if (line.endsWith(";")) {
                this._in_data_block = false;
                line = line.substring(0, line.length() - 1);
            }
            if (!(aln_matcher = ALN_PATTERN.matcher(line)).matches()) continue;
            String id = aln_matcher.group(1);
            String seq = aln_matcher.group(2);
            MolecularSequence s = null;
            s = this._datatype.equals("protein") ? BasicSequence.createAaSequence(id, seq) : (this._datatype.equals("dna") ? BasicSequence.createDnaSequence(id, seq) : BasicSequence.createRnaSequence(id, seq));
            this._seqs.put(id, s);
        }
        if (this._nh.length() > 0) {
            this.createPhylogeny(this._title, this._name, this._nh, this._rooted_info_present, this._is_rooted);
            if (this._next != null) {
                return;
            }
        }
    }

    private final void setTranslateKeyValuePairs(StringBuilder translate_sb) throws IOException {
        String s = translate_sb.toString().trim();
        if (s.endsWith(";")) {
            s = s.substring(0, s.length() - 1).trim();
        }
        for (String pair : s.split(",")) {
            Matcher m;
            String key = "";
            String value = "";
            int ti = pair.toLowerCase().indexOf("translate");
            if (ti > -1) {
                pair = pair.substring(ti + 9);
            }
            if (!(m = TRANSLATE_PATTERN.matcher(pair)).find()) {
                throw new IOException("ill-formatted translate values: " + pair);
            }
            key = m.group(1);
            value = m.group(2).replaceAll("'", "").replaceAll("\"", "").trim();
            if (value.endsWith(";")) {
                value = value.substring(0, value.length() - 1);
            }
            this._translate_map.put(key, value);
        }
    }

    private static final String removeWhiteSpaceBeforeSemicolon(String s) {
        return s.replaceAll("\\s+;", ";");
    }
}

