/*
 * Decompiled with CFR 0.152.
 */
package org.forester.io.parsers.phyloxml.data;

import org.forester.io.parsers.phyloxml.PhyloXmlDataFormatException;
import org.forester.io.parsers.phyloxml.XmlElement;
import org.forester.io.parsers.phyloxml.data.PhylogenyDataPhyloXmlParser;
import org.forester.phylogeny.data.PhylogenyData;
import org.forester.phylogeny.data.Reference;
import org.forester.util.ForesterUtil;

public class ReferenceParser
implements PhylogenyDataPhyloXmlParser {
    private static final PhylogenyDataPhyloXmlParser _instance;

    private ReferenceParser() {
    }

    @Override
    public PhylogenyData parse(XmlElement element) throws PhyloXmlDataFormatException {
        String desc = "";
        String doi = "";
        if (element.isHasAttribute("doi")) {
            doi = element.getAttribute("doi");
        }
        for (int i = 0; i < element.getNumberOfChildElements(); ++i) {
            XmlElement child_element = element.getChildElement(i);
            if (!child_element.getQualifiedName().equals("desc")) continue;
            desc = child_element.getValueAsString();
            break;
        }
        if (!ForesterUtil.isEmpty(doi)) {
            return new Reference(desc, doi);
        }
        return new Reference(desc);
    }

    public static PhylogenyDataPhyloXmlParser getInstance() {
        return _instance;
    }

    static {
        try {
            _instance = new ReferenceParser();
        }
        catch (Throwable e) {
            throw new RuntimeException(e.getMessage());
        }
    }
}

