/*
 * Decompiled with CFR 0.152.
 */
package org.forester.io.parsers.phyloxml.data;

import org.forester.io.parsers.phyloxml.PhyloXmlDataFormatException;
import org.forester.io.parsers.phyloxml.XmlElement;
import org.forester.io.parsers.phyloxml.data.IdentifierParser;
import org.forester.io.parsers.phyloxml.data.PhylogenyDataPhyloXmlParser;
import org.forester.io.parsers.phyloxml.data.UriParser;
import org.forester.phylogeny.data.Identifier;
import org.forester.phylogeny.data.Taxonomy;
import org.forester.phylogeny.data.Uri;

public class TaxonomyParser
implements PhylogenyDataPhyloXmlParser {
    private static final PhylogenyDataPhyloXmlParser _instance;

    private TaxonomyParser() {
    }

    @Override
    public Taxonomy parse(XmlElement element) throws PhyloXmlDataFormatException {
        Taxonomy taxonomy = new Taxonomy();
        for (int i = 0; i < element.getNumberOfChildElements(); ++i) {
            XmlElement child_element = element.getChildElement(i);
            if (!child_element.isHasValue()) continue;
            if (child_element.getQualifiedName().equals("code")) {
                taxonomy.setTaxonomyCode(child_element.getValueAsString());
                continue;
            }
            if (child_element.getQualifiedName().equals("common_name")) {
                taxonomy.setCommonName(child_element.getValueAsString());
                continue;
            }
            if (child_element.getQualifiedName().equals("authority")) {
                taxonomy.setAuthority(child_element.getValueAsString());
                continue;
            }
            if (child_element.getQualifiedName().equals("synonym")) {
                taxonomy.getSynonyms().add(child_element.getValueAsString());
                continue;
            }
            if (child_element.getQualifiedName().equals("id")) {
                taxonomy.setIdentifier((Identifier)IdentifierParser.getInstance().parse(child_element));
                continue;
            }
            if (child_element.getQualifiedName().equals("rank")) {
                taxonomy.setRank(child_element.getValueAsString());
                continue;
            }
            if (child_element.getQualifiedName().equals("scientific_name")) {
                taxonomy.setScientificName(child_element.getValueAsString());
                continue;
            }
            if (!child_element.getQualifiedName().equals("uri")) continue;
            taxonomy.addUri((Uri)UriParser.getInstance().parse(child_element));
        }
        return taxonomy;
    }

    public static PhylogenyDataPhyloXmlParser getInstance() {
        return _instance;
    }

    static {
        try {
            _instance = new TaxonomyParser();
        }
        catch (Throwable e) {
            throw new RuntimeException(e.getMessage());
        }
    }
}

