/*
 * Decompiled with CFR 0.152.
 */
package org.forester.msa;

import org.forester.msa.BasicMsa;
import org.forester.sequence.BasicSequence;
import org.forester.sequence.MolecularSequence;

public final class ResampleableMsa
extends BasicMsa {
    private int[] _resampled_column_positions = null;

    public ResampleableMsa(BasicMsa msa) {
        super(msa);
    }

    @Override
    public final char getResidueAt(int row, int col) {
        if (this._resampled_column_positions != null) {
            return super.getResidueAt(row, this._resampled_column_positions[col]);
        }
        return super.getResidueAt(row, col);
    }

    public final void resample(int[] resampled_column_positions) {
        if (resampled_column_positions.length != this.getLength()) {
            throw new IllegalArgumentException("illegal attempt to use " + resampled_column_positions.length + " resampled column positions on msa of length " + this.getLength());
        }
        this._resampled_column_positions = resampled_column_positions;
    }

    @Override
    public final void setResidueAt(int row, int col, char residue) {
        throw new NoSuchMethodError("illegal attempt to set residue in resampleable msa");
    }

    @Override
    public MolecularSequence getSequence(int row) {
        return new BasicSequence(this.getIdentifier(row), this.getSequenceAsString(row).toString(), this.getType());
    }
}

