/*
 * Decompiled with CFR 0.152.
 */
package org.forester.pccx;

import java.awt.Color;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import org.forester.pccx.BranchCountingBasedScoringMethod;
import org.forester.pccx.Coverage;
import org.forester.pccx.CoverageCalculationMethod;
import org.forester.pccx.CoverageCalculationOptions;
import org.forester.pccx.ExternalNodeBasedCoverage;
import org.forester.pccx.ExternalNodeBasedCoverageMethodOptions;
import org.forester.pccx.ModelingUtils;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyMethods;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.util.BasicDescriptiveStatistics;
import org.forester.util.ForesterUtil;

public class ExternalNodeBasedCoverageMethod
implements CoverageCalculationMethod {
    private static final Color MEAN_COVERAGE_COLOR = new Color(0, 0, 0);
    private static final Color MAXIMAL_COV_COLOR = new Color(0, 255, 0);
    private static final Color MINIMAL_COV_COLOR = new Color(255, 0, 0);

    @Override
    public Coverage calculateCoverage(List<Phylogeny> phylogenies, List<String> names, CoverageCalculationOptions options, boolean annotate_phylogenies) {
        BranchCountingBasedScoringMethod scoring_method;
        BasicDescriptiveStatistics normalized_score_stats = new BasicDescriptiveStatistics();
        BasicDescriptiveStatistics raw_score_stats = new BasicDescriptiveStatistics();
        ExternalNodeBasedCoverageMethodOptions my_options = (ExternalNodeBasedCoverageMethodOptions)options;
        if (my_options == null || ForesterUtil.isEmpty(my_options.getScoringMethod())) {
            throw new IllegalArgumentException("options for external node based coverage method appear to not have been set");
        }
        try {
            scoring_method = (BranchCountingBasedScoringMethod)Class.forName(my_options.getScoringMethod()).newInstance();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("could not create scoring method class \"" + my_options.getScoringMethod() + "\"");
        }
        double normalization_factor = scoring_method.getNormalizationFactor(phylogenies.get(0));
        for (Phylogeny element : phylogenies) {
            double raw_score = this.calculateCoverage(element, names, options, scoring_method, annotate_phylogenies, normalization_factor);
            normalized_score_stats.addValue(raw_score * normalization_factor);
            raw_score_stats.addValue(raw_score);
        }
        return new ExternalNodeBasedCoverage(normalized_score_stats, raw_score_stats.arithmeticMean(), options);
    }

    private double calculateCoverage(Phylogeny phylogeny, List<String> names, CoverageCalculationOptions options, BranchCountingBasedScoringMethod scoring_method, boolean annotate_phylogeny, double normalization_factor) {
        SortedMap<PhylogenyNode, Double> external_node_scores = ModelingUtils.setUpExternalCoverageHashMap(phylogeny);
        for (String element : names) {
            scoring_method.calculateScoreForExternalNode(external_node_scores, phylogeny, phylogeny.getNode(element), options);
        }
        if (annotate_phylogeny) {
            this.colorizePhylogenyAccordingToCoverage(external_node_scores, phylogeny, normalization_factor);
        }
        double score = 0.0;
        for (Double element : external_node_scores.values()) {
            score += element.doubleValue();
        }
        return score;
    }

    private void colorizePhylogenyAccordingToCoverage(SortedMap<PhylogenyNode, Double> external_node_scores, Phylogeny phylogeny, double normalization_factor) {
        BasicDescriptiveStatistics ds = new BasicDescriptiveStatistics();
        for (Map.Entry<PhylogenyNode, Double> element : external_node_scores.entrySet()) {
            ds.addValue(element.getValue() * normalization_factor);
        }
        double min = ds.getMin();
        double max = ds.getMax();
        double median = ds.median();
        Iterator<Map.Entry<PhylogenyNode, Double>> iterator = external_node_scores.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<PhylogenyNode, Double> element2;
            Map.Entry<PhylogenyNode, Double> element = element2 = iterator.next();
            PhylogenyNode node = element.getKey();
            double normalized_value = element.getValue() * normalization_factor;
            PhylogenyMethods.setBranchColorValue(node, ForesterUtil.calcColor(normalized_value, min, max, median, MINIMAL_COV_COLOR, MAXIMAL_COV_COLOR, MEAN_COVERAGE_COLOR));
        }
        PhylogenyMethods.postorderBranchColorAveragingExternalNodeBased(phylogeny);
    }
}

