/*
 * Decompiled with CFR 0.152.
 */
package org.forester.phylogeny.data;

import java.io.IOException;
import java.io.Writer;
import java.util.StringTokenizer;
import org.forester.io.parsers.nhx.NHXFormatException;
import org.forester.phylogeny.data.Confidence;
import org.forester.phylogeny.data.PhylogenyData;
import org.forester.phylogeny.data.PhylogenyDataUtil;
import org.forester.util.ForesterUtil;

public class Event
implements PhylogenyData {
    public static final int DEFAULT_VALUE = -1;
    private static final String NHX_SEPARATOR = ">";
    private int _duplications;
    private int _speciations;
    private int _gene_losses;
    private EventType _event_type;
    private Confidence _confidence;

    public Event() {
        this._duplications = -1;
        this._speciations = -1;
        this._gene_losses = -1;
        this._event_type = EventType.unassigned;
    }

    public Event(EventType type) {
        this._duplications = -1;
        this._speciations = -1;
        this._gene_losses = -1;
        this._event_type = type;
    }

    public Event(int duplications, int speciations, int gene_losses) {
        this._duplications = duplications;
        this._speciations = speciations;
        this._gene_losses = gene_losses;
        this._event_type = EventType.mixed;
    }

    public Event(int duplications, int speciations, int gene_losses, String type) {
        this._duplications = duplications;
        this._speciations = speciations;
        this._gene_losses = gene_losses;
        this._event_type = EventType.valueOf(type);
    }

    public Event(String nhx) throws NHXFormatException {
        if (ForesterUtil.isEmpty(nhx)) {
            this._duplications = -1;
            this._speciations = -1;
            this._gene_losses = -1;
            this._event_type = EventType.unassigned;
        } else {
            StringTokenizer st = new StringTokenizer(nhx, NHX_SEPARATOR);
            if (st.countTokens() != 4) {
                throw new NHXFormatException("malformed NHX format for event [" + nhx + "]");
            }
            String duplications = (String)st.nextElement();
            String speciations = (String)st.nextElement();
            String losses = (String)st.nextElement();
            String event_type = (String)st.nextElement();
            int d = 0;
            int s = 0;
            int l = 0;
            try {
                d = Integer.parseInt(duplications);
                s = Integer.parseInt(speciations);
                l = Integer.parseInt(losses);
                this._duplications = d;
                this._speciations = s;
                this._gene_losses = l;
                this._event_type = EventType.valueOf(event_type);
            }
            catch (Exception e) {
                throw new NHXFormatException("malformed NHX format for event [" + nhx + "]:" + e.getMessage());
            }
        }
    }

    @Override
    public StringBuffer asSimpleText() {
        StringBuffer sb = new StringBuffer();
        if (!this.isUnassigned()) {
            if (this.isSpeciationOrDuplication()) {
                sb.append("?");
            } else if (this.isOther() || this.isRoot() || this.isTransfer() || this.isFusion()) {
                sb.append(this.getEventType().toString());
            } else {
                if (this.getNumberOfDuplications() > 0) {
                    if (this.getNumberOfDuplications() > 1) {
                        sb.append(this.getNumberOfDuplications());
                    }
                    sb.append("D");
                }
                if (this.getNumberOfSpeciations() > 0) {
                    if (this.getNumberOfSpeciations() > 1) {
                        sb.append(this.getNumberOfSpeciations());
                    }
                    sb.append("S");
                }
                if (this.getNumberOfGeneLosses() > 0) {
                    if (this.getNumberOfGeneLosses() > 1) {
                        sb.append(this.getNumberOfGeneLosses());
                    }
                    sb.append("L");
                }
            }
        }
        return sb;
    }

    @Override
    public StringBuffer asText() {
        StringBuffer sb = new StringBuffer();
        if (this.isUnassigned() || this.isSpeciationOrDuplication() || this.isOther() || this.isRoot() || this.isTransfer() || this.isFusion()) {
            sb.append(this.getEventType().toString());
        } else if (this.isDuplication()) {
            if (this.getNumberOfDuplications() == 1) {
                sb.append("duplication");
            } else {
                sb.append("duplications [" + this.getNumberOfDuplications() + "]");
            }
        } else if (this.isSpeciation()) {
            if (this.getNumberOfSpeciations() == 1) {
                sb.append("speciation");
            } else {
                sb.append("speciations [" + this.getNumberOfSpeciations() + "]");
            }
        } else if (this.isGeneLoss()) {
            if (this.getNumberOfGeneLosses() == 1) {
                sb.append("gene-loss");
            } else {
                sb.append("gene-losses [" + this.getNumberOfGeneLosses() + "]");
            }
        } else {
            sb.append("duplications [" + this.getNumberOfDuplications() + "] ");
            sb.append("speciations [" + this.getNumberOfSpeciations() + "] ");
            sb.append("gene-losses [" + this.getNumberOfGeneLosses() + "]");
        }
        return sb;
    }

    @Override
    public PhylogenyData copy() {
        if (this.isUnassigned()) {
            return new Event();
        }
        if (this._event_type != EventType.mixed) {
            return new Event(this._event_type);
        }
        return new Event(this._duplications, this._speciations, this._gene_losses);
    }

    public Confidence getConfidence() {
        return this._confidence;
    }

    public EventType getEventType() {
        return this._event_type;
    }

    public int getNumberOfDuplications() {
        return this._duplications;
    }

    public int getNumberOfGeneLosses() {
        return this._gene_losses;
    }

    public int getNumberOfSpeciations() {
        return this._speciations;
    }

    public boolean isDuplication() {
        return this._duplications > 0 && this._gene_losses < 1 && this._speciations < 1;
    }

    @Override
    public boolean isEqual(PhylogenyData event) {
        if (event == null || !(event instanceof Event)) {
            return false;
        }
        Event e = (Event)event;
        if (this.getEventType().compareTo(e.getEventType()) != 0) {
            return false;
        }
        if (this.getNumberOfDuplications() != e.getNumberOfDuplications()) {
            return false;
        }
        if (this.getNumberOfSpeciations() != e.getNumberOfSpeciations()) {
            return false;
        }
        return this.getNumberOfGeneLosses() == e.getNumberOfGeneLosses();
    }

    public boolean isFusion() {
        return this._event_type == EventType.fusion;
    }

    public boolean isGeneLoss() {
        return this._duplications < 1 && this._gene_losses > 0 && this._speciations < 1;
    }

    public boolean isOther() {
        return this._event_type == EventType.other;
    }

    public boolean isRoot() {
        return this._event_type == EventType.root;
    }

    public boolean isSpeciation() {
        return this._duplications < 1 && this._gene_losses < 1 && this._speciations > 0;
    }

    public boolean isSpeciationOrDuplication() {
        return this._event_type == EventType.speciation_or_duplication;
    }

    public boolean isTransfer() {
        return this._event_type == EventType.transfer;
    }

    public boolean isUnassigned() {
        return this._duplications == -1 && this._event_type == EventType.unassigned;
    }

    public void setConfidence(Confidence confidence) {
        this._confidence = confidence;
    }

    public void setDuplications(int duplications) {
        this._duplications = duplications;
        this._event_type = EventType.mixed;
    }

    public void setGeneLosses(int gene_losses) {
        this._gene_losses = gene_losses;
        this._event_type = EventType.mixed;
    }

    public void setSpeciations(int speciations) {
        this._speciations = speciations;
        this._event_type = EventType.mixed;
    }

    @Override
    public StringBuffer toNHX() {
        StringBuffer sb = new StringBuffer();
        if (!this.isUnassigned() && (this.isSpeciationOrDuplication() || this.isDuplication() || this.isSpeciation())) {
            sb.append(":");
            sb.append("D=");
            if (this.isSpeciationOrDuplication()) {
                sb.append("?");
            } else if (this.isDuplication()) {
                sb.append("Y");
            } else if (this.isSpeciation()) {
                sb.append("N");
            }
        }
        return sb;
    }

    @Override
    public void toPhyloXML(Writer writer, int level, String indentation) throws IOException {
        writer.write(ForesterUtil.LINE_SEPARATOR);
        writer.write(indentation);
        PhylogenyDataUtil.appendOpen(writer, "events");
        if (this.getEventType() != EventType.unassigned && this.getEventType() != EventType.mixed) {
            PhylogenyDataUtil.appendElement(writer, "type", this.getEventType().toString(), indentation);
        }
        if (this.getNumberOfDuplications() > 0) {
            PhylogenyDataUtil.appendElement(writer, "duplications", this.getNumberOfDuplications() + "", indentation);
        }
        if (this.getNumberOfSpeciations() > 0) {
            PhylogenyDataUtil.appendElement(writer, "speciations", this.getNumberOfSpeciations() + "", indentation);
        }
        if (this.getNumberOfGeneLosses() > 0) {
            PhylogenyDataUtil.appendElement(writer, "losses", this.getNumberOfGeneLosses() + "", indentation);
        }
        if (this.getConfidence() != null) {
            this.getConfidence().toPhyloXML(writer, level, indentation + "  ");
        }
        writer.write(ForesterUtil.LINE_SEPARATOR);
        writer.write(indentation);
        PhylogenyDataUtil.appendClose(writer, "events");
    }

    public String toString() {
        return this.asText().toString();
    }

    public static Event createSingleDuplicationEvent() {
        return new Event(1, 0, 0);
    }

    public static Event createSingleSpeciationEvent() {
        return new Event(0, 1, 0);
    }

    public static Event createSingleSpeciationOrDuplicationEvent() {
        return new Event(EventType.speciation_or_duplication);
    }

    public static enum EventType {
        transfer,
        fusion,
        root,
        speciation_or_duplication,
        other,
        mixed,
        unassigned;

    }
}

