/*
 * Decompiled with CFR 0.152.
 */
package org.forester.phylogeny.data;

import java.io.IOException;
import java.io.Writer;
import org.forester.phylogeny.data.PhylogenyData;
import org.forester.phylogeny.data.PhylogenyDataUtil;
import org.forester.util.ForesterUtil;

public class ProteinDomain
implements PhylogenyData {
    public static final double CONFIDENCE_DEFAULT = -1.0;
    public static final String IDENTIFIER_DEFAULT = "";
    private final String _name;
    private final int _from;
    private final int _to;
    private final String _id;
    private final double _confidence;

    public ProteinDomain(String name, int from, int to) {
        this(name, from, to, IDENTIFIER_DEFAULT, -1.0);
    }

    public ProteinDomain(String name, int from, int to, double confidence) {
        this(name, from, to, IDENTIFIER_DEFAULT, confidence);
    }

    public ProteinDomain(String name, int from, int to, String id) {
        this(name, from, to, id, -1.0);
    }

    public ProteinDomain(String name, int from, int to, String id, double confidence) {
        if (from >= to || to < 0) {
            throw new IllegalArgumentException("attempt to create protein domain from " + from + " to " + to);
        }
        this._name = name;
        this._from = from;
        this._to = to;
        this._id = id;
        this._confidence = confidence;
    }

    @Override
    public StringBuffer asSimpleText() {
        return new StringBuffer(this.getName());
    }

    @Override
    public StringBuffer asText() {
        StringBuffer sb = new StringBuffer(this.getName());
        sb.append(" [");
        sb.append(this.getLength());
        if (!ForesterUtil.isEmpty(this.getId())) {
            sb.append(" ");
            sb.append(this.getId());
        }
        if (this.getConfidence() >= 0.0) {
            sb.append(" ");
            sb.append(this.getConfidence());
        }
        sb.append("]");
        return sb;
    }

    @Override
    public PhylogenyData copy() {
        if (this.getId() == null) {
            return new ProteinDomain(this.getName(), this.getFrom(), this.getTo(), this.getConfidence());
        }
        return new ProteinDomain(this.getName(), this.getFrom(), this.getTo(), this.getId(), this.getConfidence());
    }

    public double getConfidence() {
        return this._confidence;
    }

    public int getFrom() {
        return this._from;
    }

    public String getId() {
        return this._id;
    }

    public int getLength() {
        return this.getTo() - this.getFrom() + 1;
    }

    public String getName() {
        return this._name;
    }

    public int getTo() {
        return this._to;
    }

    @Override
    public boolean isEqual(PhylogenyData protein_domain) {
        if (protein_domain == null) {
            return false;
        }
        if (!(protein_domain instanceof ProteinDomain)) {
            return false;
        }
        if (((ProteinDomain)protein_domain).getLength() != this.getLength()) {
            return false;
        }
        return ((ProteinDomain)protein_domain).getName().equals(this.getName());
    }

    @Override
    public StringBuffer toNHX() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void toPhyloXML(Writer writer, int level, String indentation) throws IOException {
        writer.write(ForesterUtil.LINE_SEPARATOR);
        writer.write(indentation);
        if (this.getId() != null) {
            PhylogenyDataUtil.appendOpen(writer, "domain", "from", this.getFrom() + IDENTIFIER_DEFAULT, "to", this.getTo() + IDENTIFIER_DEFAULT, "confidence", this.getConfidence() + IDENTIFIER_DEFAULT, "id", this.getId());
        } else {
            PhylogenyDataUtil.appendOpen(writer, "domain", "from", this.getFrom() + IDENTIFIER_DEFAULT, "to", this.getTo() + IDENTIFIER_DEFAULT, "confidence", this.getConfidence() + IDENTIFIER_DEFAULT);
        }
        writer.write(this.getName());
        PhylogenyDataUtil.appendClose(writer, "domain");
    }

    public String toString() {
        return this.asText().toString();
    }
}

