/*
 * Decompiled with CFR 0.152.
 */
package org.forester.surfacing;

import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.forester.surfacing.DomainSimilarityCalculator;
import org.forester.surfacing.SpeciesSpecificDcData;
import org.forester.util.ForesterUtil;
import org.forester.util.SequenceAccessionTools;

class PrintableSpeciesSpecificDcData
implements SpeciesSpecificDcData {
    final SortedMap<String, Integer> _combinable_domain_id_to_count_map;
    final SortedSet<String> _key_domain_proteins = new TreeSet<String>();
    private final int _combinable_domains_count;
    private final int _key_domain_domains_count;

    public PrintableSpeciesSpecificDcData(int key_domain_domains_count, int combinable_domains) {
        this._key_domain_domains_count = key_domain_domains_count;
        this._combinable_domains_count = combinable_domains;
        this._combinable_domain_id_to_count_map = new TreeMap<String, Integer>();
    }

    @Override
    public void addKeyDomainProtein(String protein) {
        if (ForesterUtil.isEmpty(protein)) {
            throw new IllegalArgumentException("attempt to add null or empty protein");
        }
        if (this.getKeyDomainProteins().contains(protein)) {
            throw new IllegalArgumentException("protein \"" + protein + "\" is not unique");
        }
        this.getKeyDomainProteins().add(protein);
    }

    @Override
    public void addProteinsExhibitingCombinationCount(String domain_id, int count) {
        if (this.getCombinableDomainIdToCountsMap().containsKey(domain_id)) {
            throw new IllegalArgumentException("Domain with id " + domain_id + " already exists");
        }
        this.getCombinableDomainIdToCountsMap().put(domain_id, count);
    }

    @Override
    public SortedMap<String, Integer> getCombinableDomainIdToCountsMap() {
        return this._combinable_domain_id_to_count_map;
    }

    @Override
    public SortedSet<String> getKeyDomainProteins() {
        return this._key_domain_proteins;
    }

    @Override
    public int getNumberOfProteinsExhibitingCombinationWith(String domain_id) {
        if (!this.getCombinableDomainIdToCountsMap().containsKey(domain_id)) {
            throw new IllegalArgumentException("Domain with id " + domain_id + " not found");
        }
        return (Integer)this.getCombinableDomainIdToCountsMap().get(domain_id);
    }

    public String toString() {
        return this.toStringBuffer(DomainSimilarityCalculator.Detailedness.LIST_COMBINING_DOMAIN_FOR_EACH_SPECIES, false).toString();
    }

    @Override
    public StringBuffer toStringBuffer(DomainSimilarityCalculator.Detailedness detailedness, boolean html) {
        StringBuffer sb = new StringBuffer();
        if (detailedness == DomainSimilarityCalculator.Detailedness.PUNCTILIOUS) {
            if (html) {
                sb.append("<td>");
            }
            sb.append(this.getKeyDomainDomainsCount());
            if (html) {
                sb.append("</td><td>");
            } else {
                sb.append("\t");
            }
            sb.append(this.getKeyDomainProteinsCount());
            if (html) {
                sb.append("</td><td>");
            } else {
                sb.append("\t");
            }
            sb.append(this.getCombinableDomainsCount());
            if (html) {
                sb.append("</td><td>");
            }
        }
        if (html) {
            Set<String> ids = this.getCombinableDomainIdToCountsMap().keySet();
            for (String domain_id : ids) {
                sb.append(" ");
                if (html) {
                    sb.append("<a href=\"http://pfam.xfam.org/family/" + domain_id + "\">" + domain_id + "</a>");
                } else {
                    sb.append(domain_id);
                }
                if (detailedness != DomainSimilarityCalculator.Detailedness.PUNCTILIOUS) continue;
                sb.append(":");
                sb.append(this.getCombinableDomainIdToCountsMap().get(domain_id));
            }
            sb.append(" [");
            boolean first = true;
            for (String p : this.getKeyDomainProteins()) {
                String link = PrintableSpeciesSpecificDcData.obtainSeqLink(p);
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                sb.append(link);
            }
            sb.append("]");
            sb.append("</td>");
        }
        return sb;
    }

    private int getCombinableDomainsCount() {
        return this._combinable_domains_count;
    }

    private int getKeyDomainDomainsCount() {
        return this._key_domain_domains_count;
    }

    private int getKeyDomainProteinsCount() {
        return this._key_domain_proteins.size();
    }

    private static String obtainSeqLink(String p) {
        String gi;
        String gb_id;
        String up_id = SequenceAccessionTools.parseUniProtAccessorFromString(p);
        String link = !ForesterUtil.isEmpty(up_id) ? "<a class=\"pl\" href=\"http://www.uniprot.org/uniprot/" + up_id + "\" target=\"_up_window\">" + up_id + "</a>" : (!ForesterUtil.isEmpty(gb_id = SequenceAccessionTools.parseGenbankProteinAccessorFromString(p)) ? "<a class=\"pl\" href=\"http://www.ncbi.nlm.nih.gov/protein/" + gb_id + "\" target=\"_up_window\">" + gb_id + "</a>" : (!ForesterUtil.isEmpty(gi = SequenceAccessionTools.parseGInumberFromString(p)) ? "<a class=\"pl\" href=\"http://www.ncbi.nlm.nih.gov/protein/gi:" + gi + "\" target=\"_up_window\">gi|" + gi + "</a>" : "<a class=\"ps\" href=\"http://www.google.com/search?q=" + p + "\" target=\"_g_window\">" + p + "</a>"));
        return link;
    }
}

