/*
 * Decompiled with CFR 0.152.
 */
package org.forester.surfacing;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.forester.evoinference.matrix.character.BasicCharacterStateMatrix;
import org.forester.evoinference.matrix.character.CharacterStateMatrix;
import org.forester.io.parsers.HmmPfamOutputParser;
import org.forester.io.parsers.nexus.PaupLogParser;
import org.forester.io.parsers.nhx.NHXParser;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.factories.ParserBasedPhylogenyFactory;
import org.forester.phylogeny.factories.PhylogenyFactory;
import org.forester.protein.BasicDomain;
import org.forester.protein.BasicProtein;
import org.forester.protein.BinaryDomainCombination;
import org.forester.protein.Domain;
import org.forester.protein.Protein;
import org.forester.protein.ProteinId;
import org.forester.species.BasicSpecies;
import org.forester.surfacing.AdjactantDirectedBinaryDomainCombination;
import org.forester.surfacing.BasicBinaryDomainCombination;
import org.forester.surfacing.BasicCombinableDomains;
import org.forester.surfacing.BasicDomainSimilarityCalculator;
import org.forester.surfacing.BasicGenomeWideCombinableDomains;
import org.forester.surfacing.CombinableDomains;
import org.forester.surfacing.CombinationsBasedPairwiseDomainSimilarity;
import org.forester.surfacing.CombinationsBasedPairwiseDomainSimilarityCalculator;
import org.forester.surfacing.DirectedBinaryDomainCombination;
import org.forester.surfacing.DirectedCombinableDomains;
import org.forester.surfacing.DomainArchitectureBasedGenomeSimilarityCalculator;
import org.forester.surfacing.DomainCountsBasedPairwiseSimilarityCalculator;
import org.forester.surfacing.DomainParsimonyCalculator;
import org.forester.surfacing.DomainSimilarity;
import org.forester.surfacing.GenomeWideCombinableDomains;
import org.forester.surfacing.PairwiseDomainSimilarity;
import org.forester.surfacing.ProteinCountsBasedPairwiseDomainSimilarityCalculator;
import org.forester.surfacing.SimpleDomain;
import org.forester.surfacing.SpeciesSpecificDcData;
import org.forester.surfacing.SurfacingUtil;
import org.forester.util.ForesterUtil;

public class TestSurfacing {
    private static final double ZERO_DIFF = 1.0E-9;

    public static boolean isEqual(double a, double b) {
        return Math.abs(a - b) < 1.0E-9;
    }

    public static boolean test(File test_dir) {
        System.out.print("  Combinable domains: ");
        if (!TestSurfacing.testCombinableDomains()) {
            System.out.println("failed.");
            return false;
        }
        System.out.println("OK.");
        System.out.print("  Directed combinable domains: ");
        if (!TestSurfacing.testDirectedCombinableDomains()) {
            System.out.println("failed.");
            return false;
        }
        System.out.println("OK.");
        System.out.print("  Genome wide specific combinable domains: ");
        if (!TestSurfacing.testGenomeWideCombinableDomains()) {
            System.out.println("failed.");
            return false;
        }
        System.out.println("OK.");
        System.out.print("  Domain architecture based genome similarity calculator: ");
        if (!TestSurfacing.testDomainArchitectureBasedGenomeSimilarityCalculator()) {
            System.out.println("failed.");
            return false;
        }
        System.out.println("OK.");
        System.out.print("  Hmmpfam output parser: ");
        if (!TestSurfacing.testHmmPfamOutputParser(test_dir)) {
            System.out.println("failed.");
            return false;
        }
        System.out.println("OK.");
        System.out.print("  Hmmpfam output parser with filter: ");
        if (!TestSurfacing.testHmmPfamOutputParserWithFilter(test_dir)) {
            System.out.println("failed.");
            return false;
        }
        System.out.println("OK.");
        System.out.print("  Combinations based pairwise similarity calculator: ");
        if (!TestSurfacing.testCombinationsBasedPairwiseSimilarityCalculator()) {
            System.out.println("failed.");
            return false;
        }
        System.out.println("OK.");
        System.out.print("  Copy number based pairwise similarity calculator: ");
        if (!TestSurfacing.testCopyNumberBasedPairwiseSimilarityCalculator()) {
            return false;
        }
        System.out.println("OK.");
        System.out.print("  Domain combination counting: ");
        if (!TestSurfacing.testDomainCombinationCounting(test_dir)) {
            System.out.println("failed.");
            return false;
        }
        System.out.println("OK.");
        System.out.print("  Basic domain similarity calculator: ");
        if (!TestSurfacing.testBasicDomainSimilarityCalculator()) {
            System.out.println("failed.");
            return false;
        }
        System.out.println("OK.");
        System.out.print("  Basic domain similarity calculator not ignoring species specific domains: ");
        if (!TestSurfacing.testBasicDomainSimilarityCalculatorNotIgnoringSpeciesSpeficDomains()) {
            System.out.println("failed.");
            return false;
        }
        System.out.println("OK.");
        System.out.print("  Basic domain similarity calculator removal of singles: ");
        if (!TestSurfacing.testBasicDomainSimilarityCalculatorRemovalOfSingles()) {
            System.out.println("failed.");
            return false;
        }
        System.out.println("OK.");
        System.out.print("  Domain sorting: ");
        if (!TestSurfacing.testDomainSorting()) {
            System.out.println("failed.");
            return false;
        }
        System.out.println("OK.");
        System.out.print("  Binary domain combination: ");
        if (!TestSurfacing.testBinaryDomainCombination()) {
            System.out.println("failed.");
            return false;
        }
        System.out.println("OK.");
        System.out.print("  Parsimony: ");
        if (!TestSurfacing.testParsimony()) {
            System.out.println("failed.");
            return false;
        }
        System.out.println("OK.");
        System.out.print("  Directedness: ");
        if (!TestSurfacing.testDirectedness()) {
            System.out.println("failed.");
            return false;
        }
        System.out.println("OK.");
        System.out.print("  Directedness and adjacency: ");
        if (!TestSurfacing.testDirectednessAndAdjacency()) {
            System.out.println("failed.");
            return false;
        }
        System.out.println("OK.");
        System.out.print("  Dollo parsimony on secodary features: ");
        if (!TestSurfacing.testParsimonyOnSecondaryFeatures()) {
            System.out.println("failed.");
            return false;
        }
        System.out.println("OK.");
        System.out.print("  Paup log parser: ");
        if (!TestSurfacing.testPaupLogParser(test_dir)) {
            System.out.println("failed.");
            return false;
        }
        System.out.println("OK.");
        System.out.print("  Binary state matrix to gain loss matrix: ");
        if (!TestSurfacing.testBinaryStateMatrixToGainLossMatrix(test_dir)) {
            System.out.println("failed.");
            return false;
        }
        System.out.println("OK.");
        return true;
    }

    private static StringBuffer mapToStringBuffer(Map<PhylogenyNode, CharacterStateMatrix.BinaryStates> map) {
        StringBuffer sb = new StringBuffer();
        for (PhylogenyNode key : map.keySet()) {
            if (key.isExternal()) continue;
            sb.append(key.getName());
            sb.append(" : ");
            sb.append(map.get(key).toString());
            sb.append(ForesterUtil.getLineSeparator());
        }
        return sb;
    }

    private static boolean testBasicDomainSimilarityCalculator() {
        try {
            BasicDomain A = new BasicDomain("A", 1, 2, 1, 1, 0.15, -12.0);
            BasicDomain B = new BasicDomain("B", 1, 2, 1, 1, 0.2, -12.0);
            BasicDomain C = new BasicDomain("C", 1, 2, 1, 1, 0.3, -12.0);
            BasicDomain D = new BasicDomain("D", 1, 2, 1, 1, 0.5, -12.0);
            BasicDomain E = new BasicDomain("E", 1, 2, 1, 1, 0.5, -12.0);
            BasicDomain F = new BasicDomain("F", 1, 2, 1, 1, 0.01, -12.0);
            BasicDomain G = new BasicDomain("G", 1, 2, 1, 1, 0.001, -12.0);
            BasicDomain X = new BasicDomain("X", 1, 2, 1, 1, 1.0E-4, -12.0);
            BasicProtein mouse_1 = new BasicProtein("1", "mouse", 0);
            BasicProtein rabbit_1 = new BasicProtein("1", "rabbit", 0);
            BasicProtein ciona_1 = new BasicProtein("1", "ciona", 0);
            BasicProtein nemve_1 = new BasicProtein("1", "nemve", 0);
            mouse_1.addProteinDomain(A);
            mouse_1.addProteinDomain(B);
            mouse_1.addProteinDomain(C);
            mouse_1.addProteinDomain(D);
            mouse_1.addProteinDomain(E);
            rabbit_1.addProteinDomain(A);
            rabbit_1.addProteinDomain(C);
            rabbit_1.addProteinDomain(E);
            rabbit_1.addProteinDomain(F);
            rabbit_1.addProteinDomain(F);
            rabbit_1.addProteinDomain(F);
            rabbit_1.addProteinDomain(F);
            rabbit_1.addProteinDomain(F);
            rabbit_1.addProteinDomain(F);
            ciona_1.addProteinDomain(A);
            ciona_1.addProteinDomain(A);
            ciona_1.addProteinDomain(A);
            ciona_1.addProteinDomain(A);
            ciona_1.addProteinDomain(A);
            ciona_1.addProteinDomain(F);
            ciona_1.addProteinDomain(G);
            ciona_1.addProteinDomain(X);
            nemve_1.addProteinDomain(A);
            nemve_1.addProteinDomain(B);
            nemve_1.addProteinDomain(C);
            nemve_1.addProteinDomain(D);
            nemve_1.addProteinDomain(E);
            nemve_1.addProteinDomain(F);
            nemve_1.addProteinDomain(G);
            ArrayList<Protein> protein_list_mouse = new ArrayList<Protein>();
            ArrayList<Protein> protein_list_rabbit = new ArrayList<Protein>();
            ArrayList<Protein> protein_list_ciona = new ArrayList<Protein>();
            ArrayList<Protein> protein_list_nemve = new ArrayList<Protein>();
            protein_list_mouse.add(mouse_1);
            protein_list_rabbit.add(rabbit_1);
            protein_list_ciona.add(ciona_1);
            protein_list_nemve.add(nemve_1);
            ArrayList<GenomeWideCombinableDomains> cdc_list = new ArrayList<GenomeWideCombinableDomains>();
            cdc_list.add(BasicGenomeWideCombinableDomains.createInstance(protein_list_mouse, true, new BasicSpecies("mouse")));
            cdc_list.add(BasicGenomeWideCombinableDomains.createInstance(protein_list_rabbit, true, new BasicSpecies("rabbit")));
            cdc_list.add(BasicGenomeWideCombinableDomains.createInstance(protein_list_ciona, true, new BasicSpecies("ciona")));
            cdc_list.add(BasicGenomeWideCombinableDomains.createInstance(protein_list_nemve, true, new BasicSpecies("nemve")));
            BasicDomainSimilarityCalculator calc = new BasicDomainSimilarityCalculator(DomainSimilarity.DomainSimilaritySortField.DOMAIN_ID, false, false, true);
            SortedSet<DomainSimilarity> sims = calc.calculateSimilarities(new CombinationsBasedPairwiseDomainSimilarityCalculator(), cdc_list, true, true);
            Iterator sims_it = sims.iterator();
            DomainSimilarity sa = (DomainSimilarity)sims_it.next();
            if (!sa.getDomainId().equals("A")) {
                return false;
            }
            if (sa.getSpeciesData().size() != 4) {
                return false;
            }
            if (!sa.getSpecies().contains(new BasicSpecies("ciona"))) {
                return false;
            }
            if (!sa.getSpecies().contains(new BasicSpecies("mouse"))) {
                return false;
            }
            if (!sa.getSpecies().contains(new BasicSpecies("nemve"))) {
                return false;
            }
            if (!sa.getSpecies().contains(new BasicSpecies("rabbit"))) {
                return false;
            }
            if (!TestSurfacing.isEqual(sa.getMeanSimilarityScore(), 0.342063492063492)) {
                return false;
            }
            if (!TestSurfacing.isEqual(sa.getStandardDeviationOfSimilarityScore(), 0.23410788192183737)) {
                return false;
            }
            if (!TestSurfacing.isEqual(sa.getMaximalSimilarityScore(), 0.6666666666666666)) {
                return false;
            }
            if (!TestSurfacing.isEqual(sa.getMinimalSimilarityScore(), 0.0)) {
                return false;
            }
            if (sa.getN() != 6) {
                return false;
            }
            if (sa.getMaximalDifference() != 7) {
                return false;
            }
            if (sa.getMaximalDifferenceInCounts() != 3) {
                return false;
            }
            DomainSimilarity sb = (DomainSimilarity)sims_it.next();
            if (!sb.getDomainId().equals("B")) {
                return false;
            }
            if (sb.getSpeciesData().size() != 2) {
                return false;
            }
            if (!sb.getSpecies().contains(new BasicSpecies("mouse"))) {
                return false;
            }
            if (!sb.getSpecies().contains(new BasicSpecies("nemve"))) {
                return false;
            }
            if (!TestSurfacing.isEqual(sb.getMeanSimilarityScore(), 0.6666666666666666)) {
                return false;
            }
            if (!TestSurfacing.isEqual(sb.getStandardDeviationOfSimilarityScore(), 0.0)) {
                return false;
            }
            if (!TestSurfacing.isEqual(sb.getMaximalSimilarityScore(), 0.6666666666666666)) {
                return false;
            }
            if (!TestSurfacing.isEqual(sb.getMinimalSimilarityScore(), 0.6666666666666666)) {
                return false;
            }
            if (sb.getN() != 1) {
                return false;
            }
            if (sb.getMaximalDifference() != 2) {
                return false;
            }
            if (sb.getMaximalDifferenceInCounts() != 2) {
                return false;
            }
            DomainSimilarity sc = (DomainSimilarity)sims_it.next();
            if (!sc.getDomainId().equals("C")) {
                return false;
            }
            if (sc.getSpeciesData().size() != 3) {
                return false;
            }
            if (!sc.getSpecies().contains(new BasicSpecies("mouse"))) {
                return false;
            }
            if (!sc.getSpecies().contains(new BasicSpecies("rabbit"))) {
                return false;
            }
            if (!sc.getSpecies().contains(new BasicSpecies("nemve"))) {
                return false;
            }
            if (!TestSurfacing.isEqual(sc.getMeanSimilarityScore(), 0.5222222222222223)) {
                return false;
            }
            if (!TestSurfacing.isEqual(sc.getStandardDeviationOfSimilarityScore(), 0.13471506281091264)) {
                return false;
            }
            if (!TestSurfacing.isEqual(sc.getMaximalSimilarityScore(), 0.6666666666666666)) {
                return false;
            }
            if (!TestSurfacing.isEqual(sc.getMinimalSimilarityScore(), 0.4)) {
                return false;
            }
            if (sc.getN() != 3) {
                return false;
            }
            if (sc.getMaximalDifference() != 3) {
                return false;
            }
            if (sc.getMaximalDifferenceInCounts() != 3) {
                return false;
            }
            ArrayList<GenomeWideCombinableDomains> cdc_list2 = new ArrayList<GenomeWideCombinableDomains>();
            cdc_list2.add(BasicGenomeWideCombinableDomains.createInstance(protein_list_mouse, false, new BasicSpecies("mouse")));
            cdc_list2.add(BasicGenomeWideCombinableDomains.createInstance(protein_list_rabbit, false, new BasicSpecies("rabbit")));
            cdc_list2.add(BasicGenomeWideCombinableDomains.createInstance(protein_list_ciona, false, new BasicSpecies("ciona")));
            cdc_list2.add(BasicGenomeWideCombinableDomains.createInstance(protein_list_nemve, false, new BasicSpecies("nemve")));
            BasicDomainSimilarityCalculator calc2 = new BasicDomainSimilarityCalculator(DomainSimilarity.DomainSimilaritySortField.DOMAIN_ID, false, false, true);
            SortedSet<DomainSimilarity> sims2 = calc2.calculateSimilarities(new CombinationsBasedPairwiseDomainSimilarityCalculator(), cdc_list2, false, true);
            Iterator sims_it2 = sims2.iterator();
            DomainSimilarity sa2 = (DomainSimilarity)sims_it2.next();
            if (!sa2.getDomainId().equals("A")) {
                return false;
            }
            if (sa2.getSpeciesData().size() != 4) {
                return false;
            }
            if (!sa2.getSpecies().contains(new BasicSpecies("ciona"))) {
                return false;
            }
            if (!sa2.getSpecies().contains(new BasicSpecies("mouse"))) {
                return false;
            }
            if (!sa2.getSpecies().contains(new BasicSpecies("nemve"))) {
                return false;
            }
            if (!sa2.getSpeciesData().keySet().contains(new BasicSpecies("rabbit"))) {
                return false;
            }
            if (!TestSurfacing.isEqual(sa2.getMeanSimilarityScore(), 0.33055555555555555)) {
                return false;
            }
            if (!TestSurfacing.isEqual(sa2.getStandardDeviationOfSimilarityScore(), 0.2404663678647683)) {
                return false;
            }
            if (!TestSurfacing.isEqual(sa2.getMaximalSimilarityScore(), 0.6666666666666666)) {
                return false;
            }
            if (!TestSurfacing.isEqual(sa2.getMinimalSimilarityScore(), 0.0)) {
                return false;
            }
            if (sa2.getN() != 6) {
                return false;
            }
            if (sa2.getMaximalDifference() != 8) {
                return false;
            }
            if (sa2.getMaximalDifferenceInCounts() != 3) {
                return false;
            }
            BasicProtein ciona_2 = new BasicProtein("2", "ciona", 0);
            ciona_2.addProteinDomain(A);
            ciona_2.addProteinDomain(A);
            ciona_2.addProteinDomain(A);
            ciona_2.addProteinDomain(B);
            ciona_2.addProteinDomain(B);
            ciona_2.addProteinDomain(B);
            ciona_2.addProteinDomain(F);
            ciona_2.addProteinDomain(F);
            ciona_2.addProteinDomain(F);
            ciona_2.addProteinDomain(F);
            ciona_2.addProteinDomain(G);
            ciona_2.addProteinDomain(X);
            BasicProtein ciona_3 = new BasicProtein("3", "ciona", 0);
            ciona_3.addProteinDomain(A);
            ciona_3.addProteinDomain(A);
            ciona_3.addProteinDomain(A);
            ciona_3.addProteinDomain(A);
            ciona_3.addProteinDomain(B);
            ciona_3.addProteinDomain(B);
            ciona_3.addProteinDomain(X);
            ciona_3.addProteinDomain(X);
            protein_list_ciona.add(ciona_2);
            protein_list_ciona.add(ciona_3);
            ArrayList<GenomeWideCombinableDomains> cdc_list3 = new ArrayList<GenomeWideCombinableDomains>();
            cdc_list3.add(BasicGenomeWideCombinableDomains.createInstance(protein_list_mouse, true, new BasicSpecies("mouse")));
            cdc_list3.add(BasicGenomeWideCombinableDomains.createInstance(protein_list_rabbit, true, new BasicSpecies("rabbit")));
            cdc_list3.add(BasicGenomeWideCombinableDomains.createInstance(protein_list_ciona, true, new BasicSpecies("ciona")));
            cdc_list3.add(BasicGenomeWideCombinableDomains.createInstance(protein_list_nemve, true, new BasicSpecies("nemve")));
            BasicDomainSimilarityCalculator calc3 = new BasicDomainSimilarityCalculator(DomainSimilarity.DomainSimilaritySortField.DOMAIN_ID, false, false, true);
            SortedSet<DomainSimilarity> sims3 = calc3.calculateSimilarities(new CombinationsBasedPairwiseDomainSimilarityCalculator(), cdc_list3, false, true);
            Iterator sims_it3 = sims3.iterator();
            DomainSimilarity sa3 = (DomainSimilarity)sims_it3.next();
            if (!sa3.getDomainId().equals("A")) {
                return false;
            }
            SpeciesSpecificDcData ssdsd = (SpeciesSpecificDcData)sa3.getSpeciesData().get(new BasicSpecies("ciona"));
            if (ssdsd.getCombinableDomainIdToCountsMap().size() != 4) {
                return false;
            }
            if (ssdsd.getNumberOfProteinsExhibitingCombinationWith("B") != 2) {
                return false;
            }
            if (ssdsd.getNumberOfProteinsExhibitingCombinationWith("F") != 2) {
                return false;
            }
            if (ssdsd.getNumberOfProteinsExhibitingCombinationWith("G") != 2) {
                return false;
            }
            if (ssdsd.getNumberOfProteinsExhibitingCombinationWith("X") != 3) {
                return false;
            }
            ArrayList<GenomeWideCombinableDomains> cdc_list4 = new ArrayList<GenomeWideCombinableDomains>();
            cdc_list4.add(BasicGenomeWideCombinableDomains.createInstance(protein_list_mouse, false, new BasicSpecies("mouse")));
            cdc_list4.add(BasicGenomeWideCombinableDomains.createInstance(protein_list_rabbit, false, new BasicSpecies("rabbit")));
            cdc_list4.add(BasicGenomeWideCombinableDomains.createInstance(protein_list_ciona, false, new BasicSpecies("ciona")));
            cdc_list4.add(BasicGenomeWideCombinableDomains.createInstance(protein_list_nemve, false, new BasicSpecies("nemve")));
            BasicDomainSimilarityCalculator calc4 = new BasicDomainSimilarityCalculator(DomainSimilarity.DomainSimilaritySortField.DOMAIN_ID, true, false, true);
            SortedSet<DomainSimilarity> sims4 = calc4.calculateSimilarities(new CombinationsBasedPairwiseDomainSimilarityCalculator(), cdc_list4, false, true);
            Iterator sims_it4 = sims4.iterator();
            DomainSimilarity sa4 = (DomainSimilarity)sims_it4.next();
            if (!sa4.getDomainId().equals("A")) {
                return false;
            }
            SpeciesSpecificDcData ssdsd4 = (SpeciesSpecificDcData)sa4.getSpeciesData().get(new BasicSpecies("ciona"));
            if (ssdsd4.getCombinableDomainIdToCountsMap().size() != 5) {
                return false;
            }
            if (ssdsd4.getNumberOfProteinsExhibitingCombinationWith("A") != 3) {
                return false;
            }
            if (ssdsd4.getNumberOfProteinsExhibitingCombinationWith("B") != 2) {
                return false;
            }
            if (ssdsd4.getNumberOfProteinsExhibitingCombinationWith("F") != 2) {
                return false;
            }
            if (ssdsd4.getNumberOfProteinsExhibitingCombinationWith("G") != 2) {
                return false;
            }
            if (ssdsd4.getNumberOfProteinsExhibitingCombinationWith("X") != 3) {
                return false;
            }
            SortedSet<DomainSimilarity> sims4_d = calc4.calculateSimilarities(new DomainCountsBasedPairwiseSimilarityCalculator(), cdc_list4, false, true);
            Iterator sims_it4_d = sims4_d.iterator();
            DomainSimilarity sa4_d = (DomainSimilarity)sims_it4_d.next();
            if (!sa4_d.getDomainId().equals("A")) {
                return false;
            }
            if (sa4_d.getCombinableDomainIds(new BasicSpecies("ciona")).size() != 5) {
                return false;
            }
            if (!TestSurfacing.isEqual(sa4_d.getMeanSimilarityScore(), 0.5769230769230769)) {
                return false;
            }
            if (!TestSurfacing.isEqual(sa4_d.getMaximalSimilarityScore(), 1.0)) {
                return false;
            }
            if (!TestSurfacing.isEqual(sa4_d.getMinimalSimilarityScore(), 0.15384615384615385)) {
                return false;
            }
            if (sa4_d.getN() != 6) {
                return false;
            }
            SortedSet<DomainSimilarity> sims4_p = calc4.calculateSimilarities(new ProteinCountsBasedPairwiseDomainSimilarityCalculator(), cdc_list4, false, true);
            Iterator sims_it4_p = sims4_p.iterator();
            DomainSimilarity sa4_p = (DomainSimilarity)sims_it4_p.next();
            if (!sa4_p.getDomainId().equals("A")) {
                return false;
            }
            if (sa4_p.getCombinableDomainIds(new BasicSpecies("ciona")).size() != 5) {
                return false;
            }
            if (!sa4_p.getCombinableDomainIds(new BasicSpecies("ciona")).contains("A")) {
                return false;
            }
            if (!sa4_p.getCombinableDomainIds(new BasicSpecies("ciona")).contains("B")) {
                return false;
            }
            if (!sa4_p.getCombinableDomainIds(new BasicSpecies("ciona")).contains("F")) {
                return false;
            }
            if (!sa4_p.getCombinableDomainIds(new BasicSpecies("ciona")).contains("G")) {
                return false;
            }
            if (!sa4_p.getCombinableDomainIds(new BasicSpecies("ciona")).contains("X")) {
                return false;
            }
            if (!TestSurfacing.isEqual(sa4_p.getMeanSimilarityScore(), 0.75)) {
                return false;
            }
            if (!TestSurfacing.isEqual(sa4_p.getMaximalSimilarityScore(), 1.0)) {
                return false;
            }
            if (!TestSurfacing.isEqual(sa4_p.getMinimalSimilarityScore(), 0.5)) {
                return false;
            }
            if (sa4_p.getN() != 6) {
                return false;
            }
            ArrayList<GenomeWideCombinableDomains> cdc_list5 = new ArrayList<GenomeWideCombinableDomains>();
            cdc_list5.add(BasicGenomeWideCombinableDomains.createInstance(protein_list_mouse, true, new BasicSpecies("mouse")));
            cdc_list5.add(BasicGenomeWideCombinableDomains.createInstance(protein_list_rabbit, true, new BasicSpecies("rabbit")));
            cdc_list5.add(BasicGenomeWideCombinableDomains.createInstance(protein_list_ciona, true, new BasicSpecies("ciona")));
            cdc_list5.add(BasicGenomeWideCombinableDomains.createInstance(protein_list_nemve, true, new BasicSpecies("nemve")));
            SortedSet<DomainSimilarity> sims5_d = calc4.calculateSimilarities(new DomainCountsBasedPairwiseSimilarityCalculator(), cdc_list5, false, true);
            Iterator sims_it5_d = sims5_d.iterator();
            DomainSimilarity sa5_d = (DomainSimilarity)sims_it5_d.next();
            if (sa5_d.getSpecies().size() != 4) {
                return false;
            }
            if (!sa5_d.getSpecies().last().equals(new BasicSpecies("rabbit"))) {
                return false;
            }
            SpeciesSpecificDcData ssdsd5 = (SpeciesSpecificDcData)sa5_d.getSpeciesData().get(new BasicSpecies("ciona"));
            if (ssdsd5.getCombinableDomainIdToCountsMap().size() != 4) {
                return false;
            }
            if (ssdsd5.getNumberOfProteinsExhibitingCombinationWith("B") != 2) {
                return false;
            }
            if (ssdsd5.getNumberOfProteinsExhibitingCombinationWith("F") != 2) {
                return false;
            }
            if (ssdsd5.getNumberOfProteinsExhibitingCombinationWith("G") != 2) {
                return false;
            }
            if (ssdsd5.getNumberOfProteinsExhibitingCombinationWith("X") != 3) {
                return false;
            }
            if (!sa5_d.getDomainId().equals("A")) {
                return false;
            }
            BasicSpecies ciona = new BasicSpecies("ciona");
            if (sa5_d.getCombinableDomainIds(ciona).size() != 4) {
                return false;
            }
            if (sa5_d.getCombinableDomainIds(ciona).contains("A")) {
                return false;
            }
            if (!sa5_d.getCombinableDomainIds(ciona).contains("B")) {
                return false;
            }
            if (!sa5_d.getCombinableDomainIds(ciona).contains("F")) {
                return false;
            }
            if (!sa5_d.getCombinableDomainIds(ciona).contains("G")) {
                return false;
            }
            if (!sa5_d.getCombinableDomainIds(ciona).contains("X")) {
                return false;
            }
            if (!TestSurfacing.isEqual(sa5_d.getMeanSimilarityScore(), 0.5769230769230769)) {
                return false;
            }
            if (!TestSurfacing.isEqual(sa5_d.getMaximalSimilarityScore(), 1.0)) {
                return false;
            }
            if (!TestSurfacing.isEqual(sa5_d.getMinimalSimilarityScore(), 0.15384615384615385)) {
                return false;
            }
            if (sa5_d.getN() != 6) {
                return false;
            }
            if (sa5_d.getMaximalDifference() != sa5_d.getMaximalDifferenceInCounts()) {
                return false;
            }
            if (sa5_d.getMaximalDifference() != 11) {
                return false;
            }
            if (sa5_d.getMaximalDifferenceInCounts() != 11) {
                return false;
            }
            SortedSet<DomainSimilarity> sims5_p = calc4.calculateSimilarities(new ProteinCountsBasedPairwiseDomainSimilarityCalculator(), cdc_list5, false, true);
            Iterator sims_it5_p = sims5_p.iterator();
            DomainSimilarity sa5_p = (DomainSimilarity)sims_it5_p.next();
            if (!sa5_p.getDomainId().equals("A")) {
                return false;
            }
            if (sa5_p.getCombinableDomainIds(ciona).size() != 4) {
                return false;
            }
            if (sa5_p.getCombinableDomainIds(ciona).contains("A")) {
                return false;
            }
            if (!sa5_p.getCombinableDomainIds(ciona).contains("B")) {
                return false;
            }
            if (!sa5_p.getCombinableDomainIds(ciona).contains("F")) {
                return false;
            }
            if (!sa5_p.getCombinableDomainIds(ciona).contains("G")) {
                return false;
            }
            if (!sa5_p.getCombinableDomainIds(ciona).contains("X")) {
                return false;
            }
            if (!TestSurfacing.isEqual(sa5_p.getMeanSimilarityScore(), 0.75)) {
                return false;
            }
            if (!TestSurfacing.isEqual(sa5_p.getMaximalSimilarityScore(), 1.0)) {
                return false;
            }
            if (!TestSurfacing.isEqual(sa5_p.getMinimalSimilarityScore(), 0.5)) {
                return false;
            }
            if (sa5_p.getN() != 6) {
                return false;
            }
            if (sa5_p.getMaximalDifference() != sa5_p.getMaximalDifferenceInCounts()) {
                return false;
            }
            if (sa5_p.getMaximalDifference() != 2) {
                return false;
            }
            if (sa5_p.getMaximalDifferenceInCounts() != 2) {
                return false;
            }
            ArrayList<GenomeWideCombinableDomains> cdc_list6 = new ArrayList<GenomeWideCombinableDomains>();
            cdc_list6.add(BasicGenomeWideCombinableDomains.createInstance(protein_list_mouse, false, new BasicSpecies("mouse")));
            cdc_list6.add(BasicGenomeWideCombinableDomains.createInstance(protein_list_rabbit, false, new BasicSpecies("rabbit")));
            cdc_list6.add(BasicGenomeWideCombinableDomains.createInstance(protein_list_ciona, false, new BasicSpecies("ciona")));
            cdc_list6.add(BasicGenomeWideCombinableDomains.createInstance(protein_list_nemve, false, new BasicSpecies("nemve")));
            SortedSet<DomainSimilarity> sims6_d = calc4.calculateSimilarities(new DomainCountsBasedPairwiseSimilarityCalculator(), cdc_list6, false, true);
            Iterator sims_it6_d = sims6_d.iterator();
            DomainSimilarity sa6_d = (DomainSimilarity)sims_it6_d.next();
            if (sa6_d.getSpecies().size() != 4) {
                return false;
            }
            if (!sa6_d.getSpecies().last().equals(new BasicSpecies("rabbit"))) {
                return false;
            }
            SpeciesSpecificDcData ssdsd6 = (SpeciesSpecificDcData)sa6_d.getSpeciesData().get(new BasicSpecies("ciona"));
            if (ssdsd6.getCombinableDomainIdToCountsMap().size() != 5) {
                return false;
            }
            if (ssdsd6.getNumberOfProteinsExhibitingCombinationWith("B") != 2) {
                return false;
            }
            if (ssdsd6.getNumberOfProteinsExhibitingCombinationWith("F") != 2) {
                return false;
            }
            if (ssdsd6.getNumberOfProteinsExhibitingCombinationWith("G") != 2) {
                return false;
            }
            if (ssdsd6.getNumberOfProteinsExhibitingCombinationWith("X") != 3) {
                return false;
            }
            if (!sa5_d.getDomainId().equals("A")) {
                return false;
            }
            BasicSpecies ciona6 = new BasicSpecies("ciona");
            if (sa6_d.getCombinableDomainIds(ciona6).size() != 5) {
                return false;
            }
            if (!sa6_d.getCombinableDomainIds(ciona6).contains("A")) {
                return false;
            }
            if (!sa6_d.getCombinableDomainIds(ciona6).contains("B")) {
                return false;
            }
            if (!sa6_d.getCombinableDomainIds(ciona6).contains("F")) {
                return false;
            }
            if (!sa6_d.getCombinableDomainIds(ciona6).contains("G")) {
                return false;
            }
            if (!sa6_d.getCombinableDomainIds(ciona6).contains("X")) {
                return false;
            }
            if (!TestSurfacing.isEqual(sa6_d.getMeanSimilarityScore(), 0.5769230769230769)) {
                return false;
            }
            if (!TestSurfacing.isEqual(sa6_d.getMaximalSimilarityScore(), 1.0)) {
                return false;
            }
            if (!TestSurfacing.isEqual(sa6_d.getMinimalSimilarityScore(), 0.15384615384615385)) {
                return false;
            }
            if (sa6_d.getN() != 6) {
                return false;
            }
            if (sa6_d.getMaximalDifference() != sa6_d.getMaximalDifferenceInCounts()) {
                return false;
            }
            if (sa6_d.getMaximalDifference() != 11) {
                return false;
            }
            if (sa6_d.getMaximalDifferenceInCounts() != 11) {
                return false;
            }
            SortedSet<DomainSimilarity> sims6_p = calc4.calculateSimilarities(new ProteinCountsBasedPairwiseDomainSimilarityCalculator(), cdc_list6, false, true);
            Iterator sims_it6_p = sims6_p.iterator();
            DomainSimilarity sa6_p = (DomainSimilarity)sims_it6_p.next();
            if (!sa6_p.getDomainId().equals("A")) {
                return false;
            }
            if (sa6_p.getCombinableDomainIds(ciona).size() != 5) {
                return false;
            }
            if (!sa6_p.getCombinableDomainIds(ciona).contains("A")) {
                return false;
            }
            if (!sa6_p.getCombinableDomainIds(ciona).contains("B")) {
                return false;
            }
            if (!sa6_p.getCombinableDomainIds(ciona).contains("F")) {
                return false;
            }
            if (!sa6_p.getCombinableDomainIds(ciona).contains("G")) {
                return false;
            }
            if (!sa6_p.getCombinableDomainIds(ciona).contains("X")) {
                return false;
            }
            if (!TestSurfacing.isEqual(sa6_p.getMeanSimilarityScore(), 0.75)) {
                return false;
            }
            if (!TestSurfacing.isEqual(sa6_p.getMaximalSimilarityScore(), 1.0)) {
                return false;
            }
            if (!TestSurfacing.isEqual(sa6_p.getMinimalSimilarityScore(), 0.5)) {
                return false;
            }
            if (sa6_p.getN() != 6) {
                return false;
            }
            if (sa6_p.getMaximalDifference() != sa6_p.getMaximalDifferenceInCounts()) {
                return false;
            }
            if (sa6_p.getMaximalDifference() != 2) {
                return false;
            }
            if (sa6_p.getMaximalDifferenceInCounts() != 2) {
                return false;
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            return false;
        }
        return true;
    }

    private static boolean testBasicDomainSimilarityCalculatorNotIgnoringSpeciesSpeficDomains() {
        try {
            BasicDomain A = new BasicDomain("A", 1, 2, 1, 1, 0.15, -12.0);
            BasicDomain B = new BasicDomain("B", 1, 2, 1, 1, 0.2, -12.0);
            BasicDomain D = new BasicDomain("D", 1, 2, 1, 1, 0.5, -12.0);
            BasicDomain E = new BasicDomain("E", 1, 2, 1, 1, 0.5, -12.0);
            BasicDomain F = new BasicDomain("F", 1, 2, 1, 1, 0.01, -12.0);
            BasicDomain G = new BasicDomain("G", 1, 2, 1, 1, 0.001, -12.0);
            BasicDomain X = new BasicDomain("X", 1, 2, 1, 1, 1.0E-4, -12.0);
            BasicProtein mouse_1 = new BasicProtein("1", "mouse", 0);
            BasicProtein rabbit_1 = new BasicProtein("1", "rabbit", 0);
            BasicProtein ciona_1 = new BasicProtein("1", "ciona", 0);
            BasicProtein nemve_1 = new BasicProtein("1", "nemve", 0);
            mouse_1.addProteinDomain(A);
            mouse_1.addProteinDomain(D);
            mouse_1.addProteinDomain(E);
            rabbit_1.addProteinDomain(B);
            rabbit_1.addProteinDomain(E);
            rabbit_1.addProteinDomain(F);
            rabbit_1.addProteinDomain(F);
            rabbit_1.addProteinDomain(F);
            rabbit_1.addProteinDomain(F);
            rabbit_1.addProteinDomain(F);
            rabbit_1.addProteinDomain(F);
            ciona_1.addProteinDomain(F);
            ciona_1.addProteinDomain(G);
            ciona_1.addProteinDomain(X);
            nemve_1.addProteinDomain(D);
            nemve_1.addProteinDomain(E);
            nemve_1.addProteinDomain(F);
            nemve_1.addProteinDomain(G);
            ArrayList<Protein> protein_list_mouse = new ArrayList<Protein>();
            ArrayList<Protein> protein_list_rabbit = new ArrayList<Protein>();
            ArrayList<Protein> protein_list_ciona = new ArrayList<Protein>();
            ArrayList<Protein> protein_list_nemve = new ArrayList<Protein>();
            protein_list_mouse.add(mouse_1);
            protein_list_rabbit.add(rabbit_1);
            protein_list_ciona.add(ciona_1);
            protein_list_nemve.add(nemve_1);
            ArrayList<GenomeWideCombinableDomains> cdc_list = new ArrayList<GenomeWideCombinableDomains>();
            cdc_list.add(BasicGenomeWideCombinableDomains.createInstance(protein_list_mouse, true, new BasicSpecies("mouse")));
            cdc_list.add(BasicGenomeWideCombinableDomains.createInstance(protein_list_rabbit, true, new BasicSpecies("rabbit")));
            cdc_list.add(BasicGenomeWideCombinableDomains.createInstance(protein_list_ciona, true, new BasicSpecies("ciona")));
            cdc_list.add(BasicGenomeWideCombinableDomains.createInstance(protein_list_nemve, true, new BasicSpecies("nemve")));
            BasicDomainSimilarityCalculator calc = new BasicDomainSimilarityCalculator(DomainSimilarity.DomainSimilaritySortField.DOMAIN_ID, false, false, true);
            SortedSet<DomainSimilarity> sims = calc.calculateSimilarities(new CombinationsBasedPairwiseDomainSimilarityCalculator(), cdc_list, true, false);
            Iterator sims_it = sims.iterator();
            DomainSimilarity sa = (DomainSimilarity)sims_it.next();
            if (!sa.getDomainId().equals("A")) {
                return false;
            }
            if (sa.getSpeciesData().size() != 1) {
                return false;
            }
            if (!sa.getSpecies().contains(new BasicSpecies("mouse"))) {
                return false;
            }
            if (!TestSurfacing.isEqual(sa.getMeanSimilarityScore(), 1.0)) {
                return false;
            }
            if (!TestSurfacing.isEqual(sa.getStandardDeviationOfSimilarityScore(), 0.0)) {
                return false;
            }
            if (!TestSurfacing.isEqual(sa.getMaximalSimilarityScore(), 1.0)) {
                return false;
            }
            if (!TestSurfacing.isEqual(sa.getMinimalSimilarityScore(), 1.0)) {
                return false;
            }
            if (sa.getN() != 0) {
                return false;
            }
            if (sa.getMaximalDifference() != 0) {
                return false;
            }
            if (sa.getMaximalDifferenceInCounts() != 0) {
                return false;
            }
            DomainSimilarity sb = (DomainSimilarity)sims_it.next();
            if (!sb.getDomainId().equals("B")) {
                return false;
            }
            if (sb.getSpeciesData().size() != 1) {
                return false;
            }
            if (!sb.getSpecies().contains(new BasicSpecies("rabbit"))) {
                return false;
            }
            SortedSet<DomainSimilarity> sims2 = calc.calculateSimilarities(new CombinationsBasedPairwiseDomainSimilarityCalculator(), cdc_list, true, true);
            Iterator sims_it2 = sims2.iterator();
            DomainSimilarity sa2 = (DomainSimilarity)sims_it2.next();
            if (!sa2.getDomainId().equals("D")) {
                return false;
            }
            if (sa2.getSpeciesData().size() != 2) {
                return false;
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            return false;
        }
        return true;
    }

    private static boolean testBasicDomainSimilarityCalculatorRemovalOfSingles() {
        try {
            BasicDomain A = new BasicDomain("A", 1, 2, 1, 1, 0.15, -12.0);
            BasicDomain B = new BasicDomain("B", 1, 2, 1, 1, 0.2, -12.0);
            BasicProtein mouse_1 = new BasicProtein("1", "mouse", 0);
            BasicProtein rabbit_1 = new BasicProtein("1", "rabbit", 0);
            BasicProtein ciona_1 = new BasicProtein("1", "ciona", 0);
            BasicProtein nemve_1 = new BasicProtein("1", "nemve", 0);
            mouse_1.addProteinDomain(A);
            rabbit_1.addProteinDomain(A);
            ciona_1.addProteinDomain(A);
            ciona_1.addProteinDomain(A);
            ciona_1.addProteinDomain(A);
            ciona_1.addProteinDomain(A);
            ciona_1.addProteinDomain(A);
            nemve_1.addProteinDomain(A);
            ArrayList<Protein> protein_list_mouse = new ArrayList<Protein>();
            ArrayList<Protein> protein_list_rabbit = new ArrayList<Protein>();
            ArrayList<Protein> protein_list_ciona = new ArrayList<Protein>();
            ArrayList<Protein> protein_list_nemve = new ArrayList<Protein>();
            protein_list_mouse.add(mouse_1);
            protein_list_rabbit.add(rabbit_1);
            protein_list_ciona.add(ciona_1);
            protein_list_nemve.add(nemve_1);
            ArrayList<GenomeWideCombinableDomains> cdc_list = new ArrayList<GenomeWideCombinableDomains>();
            cdc_list.add(BasicGenomeWideCombinableDomains.createInstance(protein_list_mouse, true, new BasicSpecies("mouse")));
            cdc_list.add(BasicGenomeWideCombinableDomains.createInstance(protein_list_rabbit, true, new BasicSpecies("rabbit")));
            cdc_list.add(BasicGenomeWideCombinableDomains.createInstance(protein_list_ciona, true, new BasicSpecies("ciona")));
            cdc_list.add(BasicGenomeWideCombinableDomains.createInstance(protein_list_nemve, true, new BasicSpecies("nemve")));
            BasicDomainSimilarityCalculator calc = new BasicDomainSimilarityCalculator(DomainSimilarity.DomainSimilaritySortField.DOMAIN_ID, false, false, true);
            SortedSet<DomainSimilarity> sims = calc.calculateSimilarities(new CombinationsBasedPairwiseDomainSimilarityCalculator(), cdc_list, false, true);
            if (sims.size() != 1) {
                return false;
            }
            Iterator sims_it = sims.iterator();
            DomainSimilarity sa = (DomainSimilarity)sims_it.next();
            if (!sa.getDomainId().equals("A")) {
                return false;
            }
            if (sa.getSpeciesData().size() != 4) {
                return false;
            }
            if (!sa.getSpecies().contains(new BasicSpecies("ciona"))) {
                return false;
            }
            if (!sa.getSpecies().contains(new BasicSpecies("mouse"))) {
                return false;
            }
            if (!sa.getSpecies().contains(new BasicSpecies("nemve"))) {
                return false;
            }
            if (!sa.getSpecies().contains(new BasicSpecies("rabbit"))) {
                return false;
            }
            SortedSet<DomainSimilarity> sims_ns = calc.calculateSimilarities(new CombinationsBasedPairwiseDomainSimilarityCalculator(), cdc_list, true, true);
            if (sims_ns.size() != 0) {
                return false;
            }
            BasicProtein mouse_2 = new BasicProtein("1", "mouse", 0);
            BasicProtein rabbit_2 = new BasicProtein("1", "rabbit", 0);
            BasicProtein ciona_2 = new BasicProtein("1", "ciona", 0);
            BasicProtein nemve_2 = new BasicProtein("1", "nemve", 0);
            mouse_2.addProteinDomain(A);
            rabbit_2.addProteinDomain(A);
            ciona_2.addProteinDomain(A);
            ciona_2.addProteinDomain(A);
            ciona_2.addProteinDomain(B);
            ciona_2.addProteinDomain(A);
            ciona_2.addProteinDomain(A);
            ciona_2.addProteinDomain(A);
            nemve_2.addProteinDomain(A);
            ArrayList<Protein> protein_list_mouse2 = new ArrayList<Protein>();
            ArrayList<Protein> protein_list_rabbit2 = new ArrayList<Protein>();
            ArrayList<Protein> protein_list_ciona2 = new ArrayList<Protein>();
            ArrayList<Protein> protein_list_nemve2 = new ArrayList<Protein>();
            protein_list_mouse2.add(mouse_2);
            protein_list_rabbit2.add(rabbit_2);
            protein_list_ciona2.add(ciona_2);
            protein_list_nemve2.add(nemve_2);
            ArrayList<GenomeWideCombinableDomains> cdc_list2 = new ArrayList<GenomeWideCombinableDomains>();
            cdc_list2.add(BasicGenomeWideCombinableDomains.createInstance(protein_list_mouse2, true, new BasicSpecies("mouse")));
            cdc_list2.add(BasicGenomeWideCombinableDomains.createInstance(protein_list_rabbit2, true, new BasicSpecies("rabbit")));
            cdc_list2.add(BasicGenomeWideCombinableDomains.createInstance(protein_list_ciona2, true, new BasicSpecies("ciona")));
            cdc_list2.add(BasicGenomeWideCombinableDomains.createInstance(protein_list_nemve2, true, new BasicSpecies("nemve")));
            SortedSet<DomainSimilarity> sims2 = calc.calculateSimilarities(new CombinationsBasedPairwiseDomainSimilarityCalculator(), cdc_list2, true, true);
            if (sims2.size() != 1) {
                return false;
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            return false;
        }
        return true;
    }

    private static boolean testBinaryDomainCombination() {
        try {
            BasicBinaryDomainCombination s0 = BasicBinaryDomainCombination.obtainInstance("a", "a");
            BasicBinaryDomainCombination s1 = BasicBinaryDomainCombination.obtainInstance("b", "a");
            BasicBinaryDomainCombination s2 = BasicBinaryDomainCombination.obtainInstance("a", "b");
            BasicBinaryDomainCombination s3 = BasicBinaryDomainCombination.obtainInstance("B", "A");
            BasicBinaryDomainCombination s4 = BasicBinaryDomainCombination.obtainInstance("A", "B");
            BasicBinaryDomainCombination s5 = BasicBinaryDomainCombination.obtainInstance("c", "a");
            BasicBinaryDomainCombination s6 = BasicBinaryDomainCombination.obtainInstance("b", "c");
            BasicBinaryDomainCombination s7 = BasicBinaryDomainCombination.obtainInstance("d", "a");
            BasicBinaryDomainCombination s8 = BasicBinaryDomainCombination.obtainInstance("b", "d");
            BinaryDomainCombination s9 = BasicBinaryDomainCombination.obtainInstance("z-z=a-aa");
            if (!s9.toString().equals("a-aa=z-z")) {
                System.out.println(s9.toString());
                return false;
            }
            if (!s0.equals(s0)) {
                return false;
            }
            if (s0.equals(s1)) {
                return false;
            }
            if (s1.equals(s0)) {
                return false;
            }
            if (!s1.equals(s2)) {
                return false;
            }
            if (!s2.equals(s1)) {
                return false;
            }
            if (s2.equals(s3)) {
                return false;
            }
            if (s2.equals(s3)) {
                return false;
            }
            if (s2.equals(s4)) {
                return false;
            }
            TreeSet<BasicBinaryDomainCombination> sorted = new TreeSet<BasicBinaryDomainCombination>();
            sorted.add(s0);
            sorted.add(s1);
            sorted.add(s2);
            sorted.add(s3);
            sorted.add(s3);
            sorted.add(s3);
            sorted.add(s4);
            sorted.add(s5);
            sorted.add(s6);
            sorted.add(s7);
            sorted.add(s7);
            sorted.add(s8);
            if (sorted.size() != 7) {
                System.out.println(sorted.size());
                return false;
            }
            DirectedBinaryDomainCombination aa2 = DirectedBinaryDomainCombination.obtainInstance("a", "a");
            DirectedBinaryDomainCombination ba = DirectedBinaryDomainCombination.obtainInstance("b", "a");
            DirectedBinaryDomainCombination ab = DirectedBinaryDomainCombination.obtainInstance("a", "b");
            DirectedBinaryDomainCombination bb = DirectedBinaryDomainCombination.obtainInstance("b", "b");
            if (!aa2.equals(aa2)) {
                return false;
            }
            if (aa2.equals(bb)) {
                return false;
            }
            if (ab.equals(ba)) {
                return false;
            }
            if (ba.equals(ab)) {
                return false;
            }
            if (!ab.equals(ab)) {
                return false;
            }
            if (ab.equals(aa2)) {
                return false;
            }
            if (ab.equals(bb)) {
                return false;
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            return false;
        }
        return true;
    }

    private static boolean testBinaryStateMatrixToGainLossMatrix(File test_dir) {
        CharacterStateMatrix.BinaryStates I = CharacterStateMatrix.BinaryStates.PRESENT;
        CharacterStateMatrix.BinaryStates O = CharacterStateMatrix.BinaryStates.ABSENT;
        try {
            BasicCharacterStateMatrix<CharacterStateMatrix.BinaryStates> binary_states_matrix_0 = new BasicCharacterStateMatrix<CharacterStateMatrix.BinaryStates>(7, 6);
            binary_states_matrix_0.setIdentifier(0, "A");
            binary_states_matrix_0.setIdentifier(1, "B");
            binary_states_matrix_0.setIdentifier(2, "C");
            binary_states_matrix_0.setIdentifier(3, "D");
            binary_states_matrix_0.setIdentifier(4, "1");
            binary_states_matrix_0.setIdentifier(5, "2");
            binary_states_matrix_0.setIdentifier(6, "3");
            binary_states_matrix_0.setState(0, 0, O);
            binary_states_matrix_0.setState(1, 0, O);
            binary_states_matrix_0.setState(2, 0, O);
            binary_states_matrix_0.setState(3, 0, O);
            binary_states_matrix_0.setState(4, 0, O);
            binary_states_matrix_0.setState(5, 0, O);
            binary_states_matrix_0.setState(6, 0, O);
            binary_states_matrix_0.setState(0, 1, I);
            binary_states_matrix_0.setState(1, 1, O);
            binary_states_matrix_0.setState(2, 1, O);
            binary_states_matrix_0.setState(3, 1, O);
            binary_states_matrix_0.setState(4, 1, O);
            binary_states_matrix_0.setState(5, 1, O);
            binary_states_matrix_0.setState(6, 1, O);
            binary_states_matrix_0.setState(0, 2, O);
            binary_states_matrix_0.setState(1, 2, O);
            binary_states_matrix_0.setState(2, 2, O);
            binary_states_matrix_0.setState(3, 2, O);
            binary_states_matrix_0.setState(4, 2, I);
            binary_states_matrix_0.setState(5, 2, O);
            binary_states_matrix_0.setState(6, 2, O);
            binary_states_matrix_0.setState(0, 3, I);
            binary_states_matrix_0.setState(1, 3, O);
            binary_states_matrix_0.setState(2, 3, O);
            binary_states_matrix_0.setState(3, 3, O);
            binary_states_matrix_0.setState(4, 3, I);
            binary_states_matrix_0.setState(5, 3, O);
            binary_states_matrix_0.setState(6, 3, I);
            binary_states_matrix_0.setState(0, 4, I);
            binary_states_matrix_0.setState(1, 4, O);
            binary_states_matrix_0.setState(2, 4, I);
            binary_states_matrix_0.setState(3, 4, O);
            binary_states_matrix_0.setState(4, 4, I);
            binary_states_matrix_0.setState(5, 4, O);
            binary_states_matrix_0.setState(6, 4, I);
            binary_states_matrix_0.setState(0, 5, I);
            binary_states_matrix_0.setState(1, 5, I);
            binary_states_matrix_0.setState(2, 5, I);
            binary_states_matrix_0.setState(3, 5, I);
            binary_states_matrix_0.setState(4, 5, I);
            binary_states_matrix_0.setState(5, 5, I);
            binary_states_matrix_0.setState(6, 5, I);
            String[] character_labels_0 = new String[]{"first", "second", "third", "forth", "fifth", "sixth"};
            PhylogenyFactory factory = ParserBasedPhylogenyFactory.getInstance();
            Phylogeny phylogeny_0 = factory.create("(((A,B)1,C)2,D)3", new NHXParser())[0];
            DomainParsimonyCalculator dom_pars = DomainParsimonyCalculator.createInstance(phylogeny_0);
            dom_pars.executeOnGivenBinaryStatesMatrix(binary_states_matrix_0, character_labels_0);
            CharacterStateMatrix<CharacterStateMatrix.GainLossStates> gl_matrix_0 = dom_pars.getGainLossMatrix();
            if (dom_pars.getCost() != 13) {
                return false;
            }
            if (dom_pars.getTotalGains() != 5) {
                return false;
            }
            if (dom_pars.getTotalLosses() != 8) {
                return false;
            }
            if (dom_pars.getTotalUnchanged() != 29) {
                return false;
            }
            if (gl_matrix_0.getState("A", 1) != CharacterStateMatrix.GainLossStates.GAIN) {
                return false;
            }
            if (gl_matrix_0.getState("A", 4) != CharacterStateMatrix.GainLossStates.UNCHANGED_PRESENT) {
                return false;
            }
            if (gl_matrix_0.getState("B", 4) != CharacterStateMatrix.GainLossStates.LOSS) {
                return false;
            }
            if (gl_matrix_0.getState("C", 4) != CharacterStateMatrix.GainLossStates.GAIN) {
                return false;
            }
            if (gl_matrix_0.getState("D", 4) != CharacterStateMatrix.GainLossStates.LOSS) {
                return false;
            }
            if (gl_matrix_0.getState("1", 4) != CharacterStateMatrix.GainLossStates.GAIN) {
                return false;
            }
            if (gl_matrix_0.getState("2", 4) != CharacterStateMatrix.GainLossStates.LOSS) {
                return false;
            }
            if (gl_matrix_0.getState("3", 4) != CharacterStateMatrix.GainLossStates.UNCHANGED_PRESENT) {
                return false;
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            return false;
        }
        return true;
    }

    private static boolean testCombinableDomains() {
        try {
            BasicDomain key0 = new BasicDomain("key0", 23, 25, 1, 4, 0.1, -12.0);
            BasicDomain a = new BasicDomain("a", 23, 25, 1, 4, 0.1, -12.0);
            BasicDomain b = new BasicDomain("b", 23, 25, 1, 4, 0.1, -12.0);
            BasicDomain c = new BasicDomain("c", 23, 25, 1, 4, 0.1, -12.0);
            BasicCombinableDomains cd0 = new BasicCombinableDomains(key0.getDomainId(), new BasicSpecies("eel"));
            cd0.addCombinableDomain(a.getDomainId());
            cd0.addCombinableDomain(b.getDomainId());
            cd0.addCombinableDomain(b.getDomainId());
            cd0.addCombinableDomain(c.getDomainId());
            cd0.addCombinableDomain(c.getDomainId());
            cd0.addCombinableDomain(c.getDomainId());
            if (cd0.getNumberOfCombinableDomains() != 3) {
                return false;
            }
            if (cd0.getNumberOfProteinsExhibitingCombination(a.getDomainId()) != 1) {
                return false;
            }
            if (cd0.getNumberOfProteinsExhibitingCombination(b.getDomainId()) != 2) {
                return false;
            }
            if (cd0.getNumberOfProteinsExhibitingCombination(c.getDomainId()) != 3) {
                return false;
            }
            if (cd0.getNumberOfProteinsExhibitingCombination(key0.getDomainId()) != 0) {
                return false;
            }
            if (cd0.getAllDomains().size() != 4) {
                return false;
            }
            if (!cd0.getAllDomains().contains(a.getDomainId())) {
                return false;
            }
            if (!cd0.getAllDomains().contains(b.getDomainId())) {
                return false;
            }
            if (!cd0.getAllDomains().contains(c.getDomainId())) {
                return false;
            }
            if (!cd0.getAllDomains().contains(key0.getDomainId())) {
                return false;
            }
            if (cd0.toBinaryDomainCombinations().size() != 3) {
                return false;
            }
            BasicBinaryDomainCombination s0 = BasicBinaryDomainCombination.obtainInstance("key0", "a");
            BasicBinaryDomainCombination s1 = BasicBinaryDomainCombination.obtainInstance("b", "key0");
            BasicBinaryDomainCombination s2 = BasicBinaryDomainCombination.obtainInstance("key0", "c");
            BasicBinaryDomainCombination s3 = BasicBinaryDomainCombination.obtainInstance("key0", "cc");
            BasicBinaryDomainCombination s4 = BasicBinaryDomainCombination.obtainInstance("c", "key0");
            if (!cd0.toBinaryDomainCombinations().contains(s0)) {
                return false;
            }
            if (!cd0.toBinaryDomainCombinations().contains(s1)) {
                return false;
            }
            if (!cd0.toBinaryDomainCombinations().contains(s2)) {
                return false;
            }
            if (cd0.toBinaryDomainCombinations().contains(s3)) {
                return false;
            }
            if (!cd0.toBinaryDomainCombinations().contains(s4)) {
                return false;
            }
            BasicDomain key1 = new BasicDomain("key1", 23, 25, 1, 4, 0.1, -12.0);
            BasicDomain a1 = new BasicDomain("a1", 23, 25, 1, 4, 0.1, -12.0);
            BasicDomain b1 = new BasicDomain("b1", 23, 25, 1, 4, 0.1, -12.0);
            BasicDomain c1 = new BasicDomain("c1", 23, 25, 1, 4, 0.1, -12.0);
            BasicCombinableDomains cd1 = new BasicCombinableDomains(key1.getDomainId(), new BasicSpecies("eel"));
            cd1.addCombinableDomain(a1.getDomainId());
            cd1.addCombinableDomain(b1.getDomainId());
            cd1.addCombinableDomain(c1.getDomainId());
            cd1.addCombinableDomain(key1.getDomainId());
            if (cd1.getNumberOfCombinableDomains() != 4) {
                return false;
            }
            if (cd1.getNumberOfProteinsExhibitingCombination(a1.getDomainId()) != 1) {
                return false;
            }
            if (cd1.getNumberOfProteinsExhibitingCombination(b1.getDomainId()) != 1) {
                return false;
            }
            if (cd1.getNumberOfProteinsExhibitingCombination(c1.getDomainId()) != 1) {
                return false;
            }
            if (cd1.getNumberOfProteinsExhibitingCombination(key1.getDomainId()) != 1) {
                return false;
            }
            if (cd1.getAllDomains().size() != 4) {
                return false;
            }
            if (cd1.toBinaryDomainCombinations().size() != 4) {
                return false;
            }
            BasicBinaryDomainCombination kk = BasicBinaryDomainCombination.obtainInstance("key1", "key1");
            if (!cd1.toBinaryDomainCombinations().contains(kk)) {
                return false;
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            return false;
        }
        return true;
    }

    private static boolean testCombinationsBasedPairwiseSimilarityCalculator() {
        try {
            BasicDomain a = new BasicDomain("A", 1, 25, 1, 4, 0.1, -12.0);
            BasicDomain b = new BasicDomain("B", 2, 25, 1, 4, 0.1, -12.0);
            BasicDomain c = new BasicDomain("C", 3, 25, 1, 4, 0.1, -12.0);
            BasicDomain one_key = new BasicDomain("bcl2", 4, 25, 1, 4, 0.1, -12.0);
            BasicDomain two_key = new BasicDomain("bcl2", 5, 25, 1, 4, 0.1, -12.0);
            BasicCombinableDomains one = new BasicCombinableDomains(one_key.getDomainId(), new BasicSpecies("mouse"));
            BasicCombinableDomains two = new BasicCombinableDomains(two_key.getDomainId(), new BasicSpecies("rabbit"));
            one.addCombinableDomain(a.getDomainId());
            one.addCombinableDomain(a.getDomainId());
            two.addCombinableDomain(new BasicDomain("A", 1, 5, 1, 4, 0.1, -12.0).getDomainId());
            two.addCombinableDomain(b.getDomainId());
            two.addCombinableDomain(c.getDomainId());
            CombinationsBasedPairwiseDomainSimilarityCalculator calc = new CombinationsBasedPairwiseDomainSimilarityCalculator();
            PairwiseDomainSimilarity s1 = calc.calculateSimilarity(one, two);
            if (!TestSurfacing.isEqual(s1.getSimilarityScore(), 0.3333333333333333)) {
                return false;
            }
            if (s1.getDifferenceInCounts() != -2) {
                return false;
            }
            if (((CombinationsBasedPairwiseDomainSimilarity)s1).getNumberOfDifferentDomains() != 2) {
                return false;
            }
            one.addCombinableDomain(b.getDomainId());
            one.addCombinableDomain(c.getDomainId());
            PairwiseDomainSimilarity s2 = calc.calculateSimilarity(one, two);
            if (!TestSurfacing.isEqual(s2.getSimilarityScore(), 1.0)) {
                return false;
            }
            if (s2.getDifferenceInCounts() != 0) {
                return false;
            }
            if (((CombinationsBasedPairwiseDomainSimilarity)s2).getNumberOfDifferentDomains() != 0) {
                return false;
            }
            BasicDomain d = new BasicDomain("D", 23, 25, 1, 4, 0.1, -12.0);
            BasicDomain e = new BasicDomain("E", 23, 25, 1, 4, 0.1, -12.0);
            BasicDomain f = new BasicDomain("F", 23, 25, 1, 4, 0.1, -12.0);
            one.addCombinableDomain(d.getDomainId());
            one.addCombinableDomain(d.getDomainId());
            one.addCombinableDomain(e.getDomainId());
            one.addCombinableDomain(f.getDomainId());
            PairwiseDomainSimilarity s3 = calc.calculateSimilarity(one, two);
            if (!TestSurfacing.isEqual(s3.getSimilarityScore(), 0.5)) {
                return false;
            }
            if (s3.getDifferenceInCounts() != 3) {
                return false;
            }
            if (((CombinationsBasedPairwiseDomainSimilarity)s3).getNumberOfDifferentDomains() != 3) {
                return false;
            }
            BasicDomain aaa2 = new BasicDomain("aaa", 23, 25, 1, 4, 0.1, -12.0);
            BasicDomain bbb = new BasicDomain("bbb", 23, 25, 1, 4, 0.1, -12.0);
            BasicDomain three_key = new BasicDomain("bcl2", 23, 25, 1, 4, 0.1, -12.0);
            BasicDomain four_key = new BasicDomain("bcl2", 23, 25, 1, 4, 0.1, -12.0);
            BasicCombinableDomains three = new BasicCombinableDomains(three_key.getDomainId(), new BasicSpecies("mouse"));
            BasicCombinableDomains four = new BasicCombinableDomains(four_key.getDomainId(), new BasicSpecies("rabbit"));
            three.addCombinableDomain(aaa2.getDomainId());
            four.addCombinableDomain(bbb.getDomainId());
            CombinationsBasedPairwiseDomainSimilarityCalculator calc2 = new CombinationsBasedPairwiseDomainSimilarityCalculator();
            PairwiseDomainSimilarity s4 = calc2.calculateSimilarity(three, four);
            if (!TestSurfacing.isEqual(s4.getSimilarityScore(), 0.0)) {
                return false;
            }
            BasicDomain aaa22 = new BasicDomain("aaa", 23, 25, 1, 4, 0.1, -12.0);
            four.addCombinableDomain(aaa22.getDomainId());
            PairwiseDomainSimilarity s5 = calc.calculateSimilarity(three, four);
            if (!TestSurfacing.isEqual(s5.getSimilarityScore(), 0.5)) {
                return false;
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            return false;
        }
        return true;
    }

    private static boolean testCopyNumberBasedPairwiseSimilarityCalculator() {
        try {
            BasicDomain one_key = new BasicDomain("bcl2", 4, 25, 1, 4, 0.1, -12.0);
            BasicDomain two_key = new BasicDomain("bcl2", 5, 25, 1, 4, 0.1, -12.0);
            BasicCombinableDomains one = new BasicCombinableDomains(one_key.getDomainId(), new BasicSpecies("mouse"));
            BasicCombinableDomains two = new BasicCombinableDomains(two_key.getDomainId(), new BasicSpecies("rabbit"));
            one.setKeyDomainCount(2);
            two.setKeyDomainCount(3);
            DomainCountsBasedPairwiseSimilarityCalculator calc = new DomainCountsBasedPairwiseSimilarityCalculator();
            PairwiseDomainSimilarity s1 = calc.calculateSimilarity(one, two);
            if (!TestSurfacing.isEqual(s1.getSimilarityScore(), 0.8)) {
                return false;
            }
            if (s1.getDifferenceInCounts() != -1) {
                return false;
            }
            one.setKeyDomainCount(1);
            two.setKeyDomainCount(1);
            s1 = calc.calculateSimilarity(one, two);
            if (!TestSurfacing.isEqual(s1.getSimilarityScore(), 1.0)) {
                return false;
            }
            if (s1.getDifferenceInCounts() != 0) {
                return false;
            }
            one.setKeyDomainCount(1);
            two.setKeyDomainCount(1000);
            s1 = calc.calculateSimilarity(one, two);
            if (!TestSurfacing.isEqual(s1.getSimilarityScore(), 0.0019980019980020414)) {
                return false;
            }
            if (s1.getDifferenceInCounts() != -999) {
                return false;
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            return false;
        }
        return true;
    }

    private static boolean testDirectedCombinableDomains() {
        try {
            BasicDomain key0 = new BasicDomain("key0", 10, 20, 1, 4, 0.1, -12.0);
            BasicDomain a = new BasicDomain("a", 23, 25, 1, 4, 0.1, -12.0);
            BasicDomain b = new BasicDomain("b", 23, 25, 1, 4, 0.1, -12.0);
            BasicDomain c = new BasicDomain("c", 23, 25, 1, 4, 0.1, -12.0);
            DirectedCombinableDomains cd0 = new DirectedCombinableDomains(key0.getDomainId(), new BasicSpecies("eel"));
            cd0.addCombinableDomain(a.getDomainId());
            cd0.addCombinableDomain(b.getDomainId());
            cd0.addCombinableDomain(b.getDomainId());
            cd0.addCombinableDomain(c.getDomainId());
            cd0.addCombinableDomain(c.getDomainId());
            cd0.addCombinableDomain(c.getDomainId());
            if (cd0.getNumberOfCombinableDomains() != 3) {
                return false;
            }
            if (cd0.getNumberOfProteinsExhibitingCombination(a.getDomainId()) != 1) {
                return false;
            }
            if (cd0.getNumberOfProteinsExhibitingCombination(b.getDomainId()) != 2) {
                return false;
            }
            if (cd0.getNumberOfProteinsExhibitingCombination(c.getDomainId()) != 3) {
                return false;
            }
            if (cd0.getNumberOfProteinsExhibitingCombination(key0.getDomainId()) != 0) {
                return false;
            }
            if (cd0.getAllDomains().size() != 4) {
                return false;
            }
            if (!cd0.getAllDomains().contains(a.getDomainId())) {
                return false;
            }
            if (!cd0.getAllDomains().contains(b.getDomainId())) {
                return false;
            }
            if (!cd0.getAllDomains().contains(c.getDomainId())) {
                return false;
            }
            if (!cd0.getAllDomains().contains(key0.getDomainId())) {
                return false;
            }
            if (cd0.toBinaryDomainCombinations().size() != 3) {
                return false;
            }
            DirectedBinaryDomainCombination s0 = DirectedBinaryDomainCombination.obtainInstance("key0", "a");
            DirectedBinaryDomainCombination s1 = DirectedBinaryDomainCombination.obtainInstance("b", "key0");
            DirectedBinaryDomainCombination s2 = DirectedBinaryDomainCombination.obtainInstance("key0", "c");
            DirectedBinaryDomainCombination s3 = DirectedBinaryDomainCombination.obtainInstance("key0", "cc");
            DirectedBinaryDomainCombination s4 = DirectedBinaryDomainCombination.obtainInstance("a", "b");
            DirectedBinaryDomainCombination s5 = DirectedBinaryDomainCombination.obtainInstance("b", "a");
            DirectedBinaryDomainCombination s6 = DirectedBinaryDomainCombination.obtainInstance("key0", "b");
            DirectedBinaryDomainCombination s7 = DirectedBinaryDomainCombination.obtainInstance("a", "key0");
            DirectedBinaryDomainCombination s8 = DirectedBinaryDomainCombination.obtainInstance("c", "key0");
            if (!cd0.toBinaryDomainCombinations().contains(s0)) {
                return false;
            }
            if (cd0.toBinaryDomainCombinations().contains(s1)) {
                return false;
            }
            if (!cd0.toBinaryDomainCombinations().contains(s2)) {
                return false;
            }
            if (cd0.toBinaryDomainCombinations().contains(s3)) {
                return false;
            }
            if (cd0.toBinaryDomainCombinations().contains(s4)) {
                return false;
            }
            if (cd0.toBinaryDomainCombinations().contains(s5)) {
                return false;
            }
            if (!cd0.toBinaryDomainCombinations().contains(s6)) {
                return false;
            }
            if (cd0.toBinaryDomainCombinations().contains(s7)) {
                return false;
            }
            if (cd0.toBinaryDomainCombinations().contains(s8)) {
                return false;
            }
            BasicDomain key1 = new BasicDomain("key1", 1, 2, 1, 4, 0.1, -12.0);
            BasicDomain a1 = new BasicDomain("a1", 23, 25, 1, 4, 0.1, -12.0);
            BasicDomain b1 = new BasicDomain("b1", 23, 25, 1, 4, 0.1, -12.0);
            BasicDomain c1 = new BasicDomain("c1", 23, 25, 1, 4, 0.1, -12.0);
            DirectedCombinableDomains cd1 = new DirectedCombinableDomains(key1.getDomainId(), new BasicSpecies("eel"));
            cd1.addCombinableDomain(a1.getDomainId());
            cd1.addCombinableDomain(b1.getDomainId());
            cd1.addCombinableDomain(c1.getDomainId());
            cd1.addCombinableDomain(key1.getDomainId());
            if (cd1.getNumberOfCombinableDomains() != 4) {
                return false;
            }
            if (cd1.getNumberOfProteinsExhibitingCombination(a1.getDomainId()) != 1) {
                return false;
            }
            if (cd1.getNumberOfProteinsExhibitingCombination(b1.getDomainId()) != 1) {
                return false;
            }
            if (cd1.getNumberOfProteinsExhibitingCombination(c1.getDomainId()) != 1) {
                return false;
            }
            if (cd1.getNumberOfProteinsExhibitingCombination(key1.getDomainId()) != 1) {
                return false;
            }
            if (cd1.getAllDomains().size() != 4) {
                return false;
            }
            if (cd1.toBinaryDomainCombinations().size() != 4) {
                return false;
            }
            DirectedBinaryDomainCombination kk = DirectedBinaryDomainCombination.obtainInstance("key1", "key1");
            if (!cd1.toBinaryDomainCombinations().contains(kk)) {
                return false;
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            return false;
        }
        return true;
    }

    private static boolean testDirectedness() {
        try {
            CharacterStateMatrix.BinaryStates X = CharacterStateMatrix.BinaryStates.PRESENT;
            CharacterStateMatrix.BinaryStates O = CharacterStateMatrix.BinaryStates.ABSENT;
            CharacterStateMatrix.GainLossStates G = CharacterStateMatrix.GainLossStates.GAIN;
            CharacterStateMatrix.GainLossStates L = CharacterStateMatrix.GainLossStates.LOSS;
            CharacterStateMatrix.GainLossStates A = CharacterStateMatrix.GainLossStates.UNCHANGED_ABSENT;
            CharacterStateMatrix.GainLossStates P = CharacterStateMatrix.GainLossStates.UNCHANGED_PRESENT;
            BasicProtein one_1 = new BasicProtein("one", "1", 0);
            BasicProtein two_1 = new BasicProtein("two", "1", 0);
            BasicProtein three_1 = new BasicProtein("three", "1", 0);
            BasicProtein four_1 = new BasicProtein("four", "1", 0);
            BasicProtein five_1 = new BasicProtein("five", "1", 0);
            one_1.addProteinDomain(new BasicDomain("B", 12, 14, 1, 4, 0.1, -12.0));
            one_1.addProteinDomain(new BasicDomain("C", 13, 14, 1, 4, 0.1, -12.0));
            one_1.addProteinDomain(new BasicDomain("A", 11, 12, 1, 4, 0.1, -12.0));
            one_1.addProteinDomain(new BasicDomain("X", 100, 110, 1, 4, 0.1, -12.0));
            one_1.addProteinDomain(new BasicDomain("Y", 200, 210, 1, 4, 0.1, -12.0));
            two_1.addProteinDomain(new BasicDomain("A", 10, 20, 1, 4, 0.1, -12.0));
            two_1.addProteinDomain(new BasicDomain("B", 30, 40, 1, 4, 0.1, -12.0));
            two_1.addProteinDomain(new BasicDomain("Y", 1, 2, 1, 4, 0.1, -12.0));
            two_1.addProteinDomain(new BasicDomain("X", 10, 11, 1, 4, 0.1, -12.0));
            three_1.addProteinDomain(new BasicDomain("P", 10, 11, 1, 4, 0.1, -12.0));
            three_1.addProteinDomain(new BasicDomain("M", 1, 2, 1, 4, 0.1, -12.0));
            three_1.addProteinDomain(new BasicDomain("M", 5, 6, 1, 4, 0.1, -12.0));
            three_1.addProteinDomain(new BasicDomain("N", 7, 8, 1, 4, 0.1, -12.0));
            three_1.addProteinDomain(new BasicDomain("N", 3, 4, 1, 4, 0.1, -12.0));
            four_1.addProteinDomain(new BasicDomain("XX", 10, 20, 1, 4, 0.1, -12.0));
            five_1.addProteinDomain(new BasicDomain("YY", 30, 40, 1, 4, 0.1, -12.0));
            ArrayList<Protein> list_1 = new ArrayList<Protein>();
            list_1.add(one_1);
            list_1.add(two_1);
            list_1.add(three_1);
            list_1.add(four_1);
            list_1.add(five_1);
            BasicGenomeWideCombinableDomains gwcd_1 = BasicGenomeWideCombinableDomains.createInstance(list_1, false, new BasicSpecies("1"), BinaryDomainCombination.DomainCombinationType.DIRECTED);
            if (!gwcd_1.toBinaryDomainCombinations().contains(DirectedBinaryDomainCombination.obtainInstance("A", "B"))) {
                return false;
            }
            if (gwcd_1.toBinaryDomainCombinations().contains(DirectedBinaryDomainCombination.obtainInstance("B", "A"))) {
                return false;
            }
            if (gwcd_1.toBinaryDomainCombinations().contains(DirectedBinaryDomainCombination.obtainInstance("A", "A"))) {
                return false;
            }
            if (!gwcd_1.toBinaryDomainCombinations().contains(DirectedBinaryDomainCombination.obtainInstance("A", "C"))) {
                return false;
            }
            if (gwcd_1.toBinaryDomainCombinations().contains(DirectedBinaryDomainCombination.obtainInstance("C", "A"))) {
                return false;
            }
            if (!gwcd_1.toBinaryDomainCombinations().contains(DirectedBinaryDomainCombination.obtainInstance("B", "C"))) {
                return false;
            }
            if (!gwcd_1.toBinaryDomainCombinations().contains(DirectedBinaryDomainCombination.obtainInstance("C", "X"))) {
                return false;
            }
            if (!gwcd_1.toBinaryDomainCombinations().contains(DirectedBinaryDomainCombination.obtainInstance("C", "Y"))) {
                return false;
            }
            if (!gwcd_1.toBinaryDomainCombinations().contains(DirectedBinaryDomainCombination.obtainInstance("A", "X"))) {
                return false;
            }
            if (!gwcd_1.toBinaryDomainCombinations().contains(DirectedBinaryDomainCombination.obtainInstance("A", "Y"))) {
                return false;
            }
            if (!gwcd_1.toBinaryDomainCombinations().contains(DirectedBinaryDomainCombination.obtainInstance("Y", "A"))) {
                return false;
            }
            if (gwcd_1.toBinaryDomainCombinations().contains(DirectedBinaryDomainCombination.obtainInstance("X", "A"))) {
                return false;
            }
            if (gwcd_1.toBinaryDomainCombinations().contains(DirectedBinaryDomainCombination.obtainInstance("C", "B"))) {
                return false;
            }
            if (!gwcd_1.toBinaryDomainCombinations().contains(DirectedBinaryDomainCombination.obtainInstance("X", "Y"))) {
                return false;
            }
            if (!gwcd_1.toBinaryDomainCombinations().contains(DirectedBinaryDomainCombination.obtainInstance("Y", "X"))) {
                return false;
            }
            if (!gwcd_1.toBinaryDomainCombinations().contains(DirectedBinaryDomainCombination.obtainInstance("A", "Y"))) {
                return false;
            }
            if (!gwcd_1.toBinaryDomainCombinations().contains(DirectedBinaryDomainCombination.obtainInstance("A", "X"))) {
                return false;
            }
            if (gwcd_1.toBinaryDomainCombinations().contains(DirectedBinaryDomainCombination.obtainInstance("Y", "C"))) {
                return false;
            }
            if (!gwcd_1.toBinaryDomainCombinations().contains(DirectedBinaryDomainCombination.obtainInstance("M", "N"))) {
                return false;
            }
            if (!gwcd_1.toBinaryDomainCombinations().contains(DirectedBinaryDomainCombination.obtainInstance("N", "M"))) {
                return false;
            }
            if (!gwcd_1.toBinaryDomainCombinations().contains(DirectedBinaryDomainCombination.obtainInstance("N", "P"))) {
                return false;
            }
            if (!gwcd_1.toBinaryDomainCombinations().contains(DirectedBinaryDomainCombination.obtainInstance("M", "P"))) {
                return false;
            }
            if (gwcd_1.toBinaryDomainCombinations().contains(DirectedBinaryDomainCombination.obtainInstance("P", "N"))) {
                return false;
            }
            if (gwcd_1.toBinaryDomainCombinations().contains(DirectedBinaryDomainCombination.obtainInstance("P", "M"))) {
                return false;
            }
            if (gwcd_1.toBinaryDomainCombinations().contains(DirectedBinaryDomainCombination.obtainInstance("XX", "YY"))) {
                return false;
            }
            if (gwcd_1.toBinaryDomainCombinations().contains(DirectedBinaryDomainCombination.obtainInstance("YY", "XX"))) {
                return false;
            }
            if (gwcd_1.toBinaryDomainCombinations().contains(DirectedBinaryDomainCombination.obtainInstance("B", "B"))) {
                return false;
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            return false;
        }
        return true;
    }

    private static boolean testDirectednessAndAdjacency() {
        try {
            BasicProtein one_1 = new BasicProtein("one", "1", 0);
            BasicProtein two_1 = new BasicProtein("two", "1", 0);
            BasicProtein three_1 = new BasicProtein("three", "1", 0);
            BasicProtein four_1 = new BasicProtein("four", "1", 0);
            BasicProtein five_1 = new BasicProtein("five", "1", 0);
            one_1.addProteinDomain(new BasicDomain("B", 12, 14, 1, 4, 0.1, -12.0));
            one_1.addProteinDomain(new BasicDomain("C", 13, 14, 1, 4, 0.1, -12.0));
            one_1.addProteinDomain(new BasicDomain("A", 11, 12, 1, 4, 0.1, -12.0));
            one_1.addProteinDomain(new BasicDomain("X", 100, 110, 1, 4, 0.1, -12.0));
            one_1.addProteinDomain(new BasicDomain("Y", 200, 210, 1, 4, 0.1, -12.0));
            two_1.addProteinDomain(new BasicDomain("A", 10, 20, 1, 4, 0.1, -12.0));
            two_1.addProteinDomain(new BasicDomain("B", 30, 40, 1, 4, 0.1, -12.0));
            two_1.addProteinDomain(new BasicDomain("Y", 1, 2, 1, 4, 0.1, -12.0));
            two_1.addProteinDomain(new BasicDomain("X", 10, 11, 1, 4, 0.1, -12.0));
            three_1.addProteinDomain(new BasicDomain("P", 10, 11, 1, 4, 0.1, -12.0));
            three_1.addProteinDomain(new BasicDomain("M", 1, 2, 1, 4, 0.1, -12.0));
            three_1.addProteinDomain(new BasicDomain("M", 5, 6, 1, 4, 0.1, -12.0));
            three_1.addProteinDomain(new BasicDomain("N", 7, 8, 1, 4, 0.1, -12.0));
            three_1.addProteinDomain(new BasicDomain("N", 3, 4, 1, 4, 0.1, -12.0));
            four_1.addProteinDomain(new BasicDomain("XX", 10, 20, 1, 4, 0.1, -12.0));
            five_1.addProteinDomain(new BasicDomain("YY", 30, 40, 1, 4, 0.1, -12.0));
            ArrayList<Protein> list_1 = new ArrayList<Protein>();
            list_1.add(one_1);
            list_1.add(two_1);
            list_1.add(three_1);
            list_1.add(four_1);
            list_1.add(five_1);
            BasicGenomeWideCombinableDomains gwcd_1 = BasicGenomeWideCombinableDomains.createInstance(list_1, false, new BasicSpecies("1"), BinaryDomainCombination.DomainCombinationType.DIRECTED_ADJACTANT);
            if (!gwcd_1.toBinaryDomainCombinations().contains(AdjactantDirectedBinaryDomainCombination.obtainInstance("A", "B"))) {
                return false;
            }
            if (gwcd_1.toBinaryDomainCombinations().contains(AdjactantDirectedBinaryDomainCombination.obtainInstance("B", "A"))) {
                return false;
            }
            if (gwcd_1.toBinaryDomainCombinations().contains(AdjactantDirectedBinaryDomainCombination.obtainInstance("A", "A"))) {
                return false;
            }
            if (gwcd_1.toBinaryDomainCombinations().contains(AdjactantDirectedBinaryDomainCombination.obtainInstance("A", "C"))) {
                return false;
            }
            if (gwcd_1.toBinaryDomainCombinations().contains(AdjactantDirectedBinaryDomainCombination.obtainInstance("C", "A"))) {
                return false;
            }
            if (!gwcd_1.toBinaryDomainCombinations().contains(AdjactantDirectedBinaryDomainCombination.obtainInstance("B", "C"))) {
                return false;
            }
            if (!gwcd_1.toBinaryDomainCombinations().contains(AdjactantDirectedBinaryDomainCombination.obtainInstance("C", "X"))) {
                return false;
            }
            if (gwcd_1.toBinaryDomainCombinations().contains(AdjactantDirectedBinaryDomainCombination.obtainInstance("C", "Y"))) {
                return false;
            }
            if (!gwcd_1.toBinaryDomainCombinations().contains(AdjactantDirectedBinaryDomainCombination.obtainInstance("X", "Y"))) {
                return false;
            }
            if (gwcd_1.toBinaryDomainCombinations().contains(AdjactantDirectedBinaryDomainCombination.obtainInstance("A", "X"))) {
                return false;
            }
            if (gwcd_1.toBinaryDomainCombinations().contains(AdjactantDirectedBinaryDomainCombination.obtainInstance("A", "Y"))) {
                return false;
            }
            if (!gwcd_1.toBinaryDomainCombinations().contains(AdjactantDirectedBinaryDomainCombination.obtainInstance("Y", "A"))) {
                return false;
            }
            if (gwcd_1.toBinaryDomainCombinations().contains(AdjactantDirectedBinaryDomainCombination.obtainInstance("X", "A"))) {
                return false;
            }
            if (gwcd_1.toBinaryDomainCombinations().contains(AdjactantDirectedBinaryDomainCombination.obtainInstance("C", "B"))) {
                return false;
            }
            if (!gwcd_1.toBinaryDomainCombinations().contains(AdjactantDirectedBinaryDomainCombination.obtainInstance("X", "Y"))) {
                return false;
            }
            if (gwcd_1.toBinaryDomainCombinations().contains(AdjactantDirectedBinaryDomainCombination.obtainInstance("Y", "X"))) {
                return false;
            }
            if (gwcd_1.toBinaryDomainCombinations().contains(AdjactantDirectedBinaryDomainCombination.obtainInstance("A", "Y"))) {
                return false;
            }
            if (gwcd_1.toBinaryDomainCombinations().contains(AdjactantDirectedBinaryDomainCombination.obtainInstance("A", "X"))) {
                return false;
            }
            if (gwcd_1.toBinaryDomainCombinations().contains(AdjactantDirectedBinaryDomainCombination.obtainInstance("Y", "C"))) {
                return false;
            }
            if (!gwcd_1.toBinaryDomainCombinations().contains(AdjactantDirectedBinaryDomainCombination.obtainInstance("M", "N"))) {
                return false;
            }
            if (!gwcd_1.toBinaryDomainCombinations().contains(AdjactantDirectedBinaryDomainCombination.obtainInstance("N", "M"))) {
                return false;
            }
            if (!gwcd_1.toBinaryDomainCombinations().contains(AdjactantDirectedBinaryDomainCombination.obtainInstance("N", "P"))) {
                return false;
            }
            if (gwcd_1.toBinaryDomainCombinations().contains(AdjactantDirectedBinaryDomainCombination.obtainInstance("M", "P"))) {
                return false;
            }
            if (gwcd_1.toBinaryDomainCombinations().contains(AdjactantDirectedBinaryDomainCombination.obtainInstance("P", "N"))) {
                return false;
            }
            if (gwcd_1.toBinaryDomainCombinations().contains(AdjactantDirectedBinaryDomainCombination.obtainInstance("P", "M"))) {
                return false;
            }
            if (gwcd_1.toBinaryDomainCombinations().contains(AdjactantDirectedBinaryDomainCombination.obtainInstance("XX", "YY"))) {
                return false;
            }
            if (gwcd_1.toBinaryDomainCombinations().contains(AdjactantDirectedBinaryDomainCombination.obtainInstance("YY", "XX"))) {
                return false;
            }
            if (gwcd_1.toBinaryDomainCombinations().contains(AdjactantDirectedBinaryDomainCombination.obtainInstance("B", "B"))) {
                return false;
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            return false;
        }
        return true;
    }

    private static boolean testDomainArchitectureBasedGenomeSimilarityCalculator() {
        try {
            BasicDomain a = new BasicDomain("a", 23, 25, 1, 4, 0.1, -12.0);
            BasicDomain b = new BasicDomain("b", 23, 25, 1, 4, 0.1, -12.0);
            BasicDomain c = new BasicDomain("c", 23, 25, 1, 4, 0.1, -12.0);
            BasicDomain d = new BasicDomain("d", 23, 25, 1, 4, 0.1, -12.0);
            BasicDomain e = new BasicDomain("e", 23, 25, 1, 4, 0.1, -12.0);
            BasicDomain f = new BasicDomain("f", 23, 25, 1, 4, 0.1, -12.0);
            BasicDomain g = new BasicDomain("g", 23, 25, 1, 4, 0.1, -12.0);
            BasicDomain h = new BasicDomain("h", 23, 25, 1, 4, 0.1, -12.0);
            BasicDomain i = new BasicDomain("i", 23, 25, 1, 4, 0.1, -12.0);
            BasicDomain j = new BasicDomain("j", 23, 25, 1, 4, 0.1, -12.0);
            BasicDomain k = new BasicDomain("k", 23, 25, 1, 4, 0.1, -12.0);
            BasicDomain l = new BasicDomain("l", 23, 25, 1, 4, 0.1, -12.0);
            BasicDomain m = new BasicDomain("m", 23, 25, 1, 4, 0.1, -12.0);
            BasicDomain n = new BasicDomain("n", 23, 25, 1, 4, 0.1, -12.0);
            BasicProtein eel_0 = new BasicProtein("0", "eel", 0);
            BasicProtein eel_1 = new BasicProtein("1", "eel", 0);
            BasicProtein eel_2 = new BasicProtein("2", "eel", 0);
            BasicProtein eel_3 = new BasicProtein("3", "eel", 0);
            BasicProtein eel_4 = new BasicProtein("4", "eel", 0);
            BasicProtein eel_5 = new BasicProtein("5", "eel", 0);
            BasicProtein eel_6 = new BasicProtein("6", "eel", 0);
            BasicProtein rat_0 = new BasicProtein("0", "rat", 0);
            BasicProtein rat_1 = new BasicProtein("1", "rat", 0);
            BasicProtein rat_2 = new BasicProtein("2", "rat", 0);
            BasicProtein rat_3 = new BasicProtein("3", "rat", 0);
            BasicProtein rat_4 = new BasicProtein("4", "rat", 0);
            BasicProtein rat_5 = new BasicProtein("5", "rat", 0);
            BasicProtein rat_6 = new BasicProtein("6", "rat", 0);
            BasicProtein rat_7 = new BasicProtein("7", "rat", 0);
            eel_1.addProteinDomain(a);
            eel_2.addProteinDomain(a);
            eel_2.addProteinDomain(b);
            eel_3.addProteinDomain(a);
            eel_3.addProteinDomain(a);
            eel_3.addProteinDomain(b);
            eel_4.addProteinDomain(a);
            eel_4.addProteinDomain(b);
            eel_4.addProteinDomain(c);
            eel_4.addProteinDomain(d);
            eel_4.addProteinDomain(e);
            eel_5.addProteinDomain(e);
            eel_5.addProteinDomain(e);
            eel_5.addProteinDomain(f);
            eel_5.addProteinDomain(f);
            eel_5.addProteinDomain(f);
            eel_5.addProteinDomain(f);
            eel_6.addProteinDomain(g);
            eel_6.addProteinDomain(h);
            rat_1.addProteinDomain(a);
            rat_2.addProteinDomain(a);
            rat_2.addProteinDomain(b);
            rat_3.addProteinDomain(a);
            rat_3.addProteinDomain(a);
            rat_3.addProteinDomain(b);
            rat_4.addProteinDomain(a);
            rat_4.addProteinDomain(b);
            rat_4.addProteinDomain(c);
            rat_4.addProteinDomain(i);
            rat_4.addProteinDomain(l);
            rat_5.addProteinDomain(i);
            rat_5.addProteinDomain(f);
            rat_5.addProteinDomain(f);
            rat_6.addProteinDomain(j);
            rat_6.addProteinDomain(k);
            rat_7.addProteinDomain(m);
            rat_7.addProteinDomain(n);
            ArrayList<Protein> protein_list_eel = new ArrayList<Protein>();
            protein_list_eel.add(eel_0);
            protein_list_eel.add(eel_1);
            protein_list_eel.add(eel_2);
            protein_list_eel.add(eel_3);
            protein_list_eel.add(eel_4);
            protein_list_eel.add(eel_5);
            protein_list_eel.add(eel_6);
            ArrayList<Protein> protein_list_rat = new ArrayList<Protein>();
            protein_list_rat.add(rat_0);
            protein_list_rat.add(rat_1);
            protein_list_rat.add(rat_2);
            protein_list_rat.add(rat_3);
            protein_list_rat.add(rat_4);
            protein_list_rat.add(rat_5);
            protein_list_rat.add(rat_6);
            protein_list_rat.add(rat_7);
            BasicGenomeWideCombinableDomains eel_not_ignore = BasicGenomeWideCombinableDomains.createInstance(protein_list_eel, false, new BasicSpecies("eel"));
            BasicGenomeWideCombinableDomains eel_ignore = BasicGenomeWideCombinableDomains.createInstance(protein_list_eel, true, new BasicSpecies("eel"));
            BasicGenomeWideCombinableDomains rat_not_ignore = BasicGenomeWideCombinableDomains.createInstance(protein_list_rat, false, new BasicSpecies("rat"));
            BasicGenomeWideCombinableDomains rat_ignore = BasicGenomeWideCombinableDomains.createInstance(protein_list_rat, true, new BasicSpecies("rat"));
            DomainArchitectureBasedGenomeSimilarityCalculator calc_ni = new DomainArchitectureBasedGenomeSimilarityCalculator(eel_not_ignore, rat_not_ignore);
            DomainArchitectureBasedGenomeSimilarityCalculator calc_i = new DomainArchitectureBasedGenomeSimilarityCalculator(eel_ignore, rat_ignore);
            if (calc_ni.getAllDomains().size() != 14) {
                return false;
            }
            if (calc_i.getAllDomains().size() != 14) {
                return false;
            }
            if (calc_ni.getDomainsSpecificToGenome0().size() != 4) {
                return false;
            }
            if (calc_i.getDomainsSpecificToGenome0().size() != 4) {
                return false;
            }
            if (calc_ni.getDomainsSpecificToGenome1().size() != 6) {
                return false;
            }
            if (calc_i.getDomainsSpecificToGenome1().size() != 6) {
                return false;
            }
            if (calc_i.getSharedDomains().size() != 4) {
                return false;
            }
            if (calc_ni.getSharedDomains().size() != 4) {
                return false;
            }
            if (!calc_ni.getDomainsSpecificToGenome0().contains(d.getDomainId())) {
                return false;
            }
            if (!calc_ni.getDomainsSpecificToGenome0().contains(e.getDomainId())) {
                return false;
            }
            if (!calc_ni.getDomainsSpecificToGenome0().contains(g.getDomainId())) {
                return false;
            }
            if (!calc_ni.getDomainsSpecificToGenome0().contains(h.getDomainId())) {
                return false;
            }
            if (calc_ni.getDomainsSpecificToGenome0().contains(a.getDomainId())) {
                return false;
            }
            if (calc_ni.getDomainsSpecificToGenome0().contains(i.getDomainId())) {
                return false;
            }
            if (!calc_i.getDomainsSpecificToGenome0().contains(d.getDomainId())) {
                return false;
            }
            if (!calc_i.getDomainsSpecificToGenome0().contains(e.getDomainId())) {
                return false;
            }
            if (!calc_i.getDomainsSpecificToGenome0().contains(g.getDomainId())) {
                return false;
            }
            if (!calc_i.getDomainsSpecificToGenome0().contains(h.getDomainId())) {
                return false;
            }
            if (calc_i.getDomainsSpecificToGenome0().contains(a.getDomainId())) {
                return false;
            }
            if (calc_i.getDomainsSpecificToGenome0().contains(i.getDomainId())) {
                return false;
            }
            if (!calc_ni.getDomainsSpecificToGenome1().contains(i.getDomainId())) {
                return false;
            }
            if (!calc_ni.getDomainsSpecificToGenome1().contains(l.getDomainId())) {
                return false;
            }
            if (!calc_ni.getDomainsSpecificToGenome1().contains(j.getDomainId())) {
                return false;
            }
            if (!calc_ni.getDomainsSpecificToGenome1().contains(k.getDomainId())) {
                return false;
            }
            if (!calc_ni.getDomainsSpecificToGenome1().contains(m.getDomainId())) {
                return false;
            }
            if (!calc_ni.getDomainsSpecificToGenome1().contains(n.getDomainId())) {
                return false;
            }
            if (calc_ni.getDomainsSpecificToGenome1().contains(a.getDomainId())) {
                return false;
            }
            if (calc_ni.getDomainsSpecificToGenome1().contains(b.getDomainId())) {
                return false;
            }
            if (calc_ni.getDomainsSpecificToGenome1().contains(d.getDomainId())) {
                return false;
            }
            if (!calc_i.getDomainsSpecificToGenome1().contains(i.getDomainId())) {
                return false;
            }
            if (!calc_i.getDomainsSpecificToGenome1().contains(l.getDomainId())) {
                return false;
            }
            if (!calc_i.getDomainsSpecificToGenome1().contains(j.getDomainId())) {
                return false;
            }
            if (!calc_i.getDomainsSpecificToGenome1().contains(k.getDomainId())) {
                return false;
            }
            if (!calc_i.getDomainsSpecificToGenome1().contains(m.getDomainId())) {
                return false;
            }
            if (!calc_i.getDomainsSpecificToGenome1().contains(n.getDomainId())) {
                return false;
            }
            if (calc_i.getDomainsSpecificToGenome1().contains(a.getDomainId())) {
                return false;
            }
            if (calc_i.getDomainsSpecificToGenome1().contains(b.getDomainId())) {
                return false;
            }
            if (calc_i.getDomainsSpecificToGenome1().contains(d.getDomainId())) {
                return false;
            }
            if (!calc_i.getSharedDomains().contains(a.getDomainId())) {
                return false;
            }
            if (!calc_i.getSharedDomains().contains(b.getDomainId())) {
                return false;
            }
            if (!calc_i.getSharedDomains().contains(c.getDomainId())) {
                return false;
            }
            if (!calc_i.getSharedDomains().contains(f.getDomainId())) {
                return false;
            }
            Set<String> all = calc_ni.getAllDomains();
            if (!all.contains(a.getDomainId())) {
                return false;
            }
            if (!all.contains(b.getDomainId())) {
                return false;
            }
            if (!all.contains(c.getDomainId())) {
                return false;
            }
            if (!all.contains(d.getDomainId())) {
                return false;
            }
            if (!all.contains(e.getDomainId())) {
                return false;
            }
            if (!all.contains(f.getDomainId())) {
                return false;
            }
            if (!all.contains(g.getDomainId())) {
                return false;
            }
            if (!all.contains(h.getDomainId())) {
                return false;
            }
            if (!all.contains(i.getDomainId())) {
                return false;
            }
            if (!all.contains(l.getDomainId())) {
                return false;
            }
            if (!all.contains(j.getDomainId())) {
                return false;
            }
            if (!all.contains(k.getDomainId())) {
                return false;
            }
            if (!all.contains(m.getDomainId())) {
                return false;
            }
            if (!all.contains(n.getDomainId())) {
                return false;
            }
            Set<BinaryDomainCombination> s_0_ni = calc_ni.getBinaryDomainCombinationsSpecificToGenome0();
            Set<BinaryDomainCombination> s_0_i = calc_i.getBinaryDomainCombinationsSpecificToGenome0();
            Set<BinaryDomainCombination> s_1_ni = calc_ni.getBinaryDomainCombinationsSpecificToGenome1();
            Set<BinaryDomainCombination> s_1_i = calc_i.getBinaryDomainCombinationsSpecificToGenome1();
            Set<BinaryDomainCombination> a_ni = calc_ni.getAllBinaryDomainCombinations();
            Set<BinaryDomainCombination> a_i = calc_i.getAllBinaryDomainCombinations();
            Set<BinaryDomainCombination> shared_ni = calc_ni.getSharedBinaryDomainCombinations();
            Set<BinaryDomainCombination> shared_i = calc_i.getSharedBinaryDomainCombinations();
            if (a_ni.size() != 25) {
                return false;
            }
            if (a_i.size() != 22) {
                return false;
            }
            if (s_0_ni.size() != 10) {
                return false;
            }
            if (s_0_i.size() != 9) {
                return false;
            }
            if (s_1_ni.size() != 10) {
                return false;
            }
            if (s_1_i.size() != 10) {
                return false;
            }
            if (shared_ni.size() != 5) {
                return false;
            }
            if (shared_i.size() != 3) {
                return false;
            }
            if (!a_ni.contains(BasicBinaryDomainCombination.obtainInstance("a", "a"))) {
                return false;
            }
            if (!a_ni.contains(BasicBinaryDomainCombination.obtainInstance("b", "a"))) {
                return false;
            }
            if (!a_ni.contains(BasicBinaryDomainCombination.obtainInstance("a", "c"))) {
                return false;
            }
            if (!a_ni.contains(BasicBinaryDomainCombination.obtainInstance("a", "d"))) {
                return false;
            }
            if (!a_ni.contains(BasicBinaryDomainCombination.obtainInstance("a", "e"))) {
                return false;
            }
            if (!a_ni.contains(BasicBinaryDomainCombination.obtainInstance("b", "c"))) {
                return false;
            }
            if (!a_ni.contains(BasicBinaryDomainCombination.obtainInstance("b", "d"))) {
                return false;
            }
            if (!a_ni.contains(BasicBinaryDomainCombination.obtainInstance("b", "e"))) {
                return false;
            }
            if (!a_ni.contains(BasicBinaryDomainCombination.obtainInstance("c", "d"))) {
                return false;
            }
            if (!a_ni.contains(BasicBinaryDomainCombination.obtainInstance("c", "e"))) {
                return false;
            }
            if (!a_ni.contains(BasicBinaryDomainCombination.obtainInstance("d", "e"))) {
                return false;
            }
            if (!a_ni.contains(BasicBinaryDomainCombination.obtainInstance("e", "f"))) {
                return false;
            }
            if (!a_ni.contains(BasicBinaryDomainCombination.obtainInstance("g", "h"))) {
                return false;
            }
            if (!a_ni.contains(BasicBinaryDomainCombination.obtainInstance("f", "f"))) {
                return false;
            }
            if (!a_ni.contains(BasicBinaryDomainCombination.obtainInstance("e", "e"))) {
                return false;
            }
            if (!a_ni.contains(BasicBinaryDomainCombination.obtainInstance("a", "i"))) {
                return false;
            }
            if (!a_ni.contains(BasicBinaryDomainCombination.obtainInstance("a", "l"))) {
                return false;
            }
            if (!a_ni.contains(BasicBinaryDomainCombination.obtainInstance("b", "i"))) {
                return false;
            }
            if (!a_ni.contains(BasicBinaryDomainCombination.obtainInstance("b", "l"))) {
                return false;
            }
            if (!a_ni.contains(BasicBinaryDomainCombination.obtainInstance("c", "i"))) {
                return false;
            }
            if (!a_ni.contains(BasicBinaryDomainCombination.obtainInstance("c", "l"))) {
                return false;
            }
            if (!a_ni.contains(BasicBinaryDomainCombination.obtainInstance("i", "l"))) {
                return false;
            }
            if (!a_ni.contains(BasicBinaryDomainCombination.obtainInstance("i", "f"))) {
                return false;
            }
            if (!a_ni.contains(BasicBinaryDomainCombination.obtainInstance("m", "n"))) {
                return false;
            }
            if (!a_ni.contains(BasicBinaryDomainCombination.obtainInstance("j", "k"))) {
                return false;
            }
            if (a_ni.contains(BasicBinaryDomainCombination.obtainInstance("a", "g"))) {
                return false;
            }
            if (a_ni.contains(BasicBinaryDomainCombination.obtainInstance("a", "m"))) {
                return false;
            }
            if (a_i.contains(BasicBinaryDomainCombination.obtainInstance("a", "a"))) {
                return false;
            }
            if (a_i.contains(BasicBinaryDomainCombination.obtainInstance("f", "f"))) {
                return false;
            }
            if (a_i.contains(BasicBinaryDomainCombination.obtainInstance("e", "e"))) {
                return false;
            }
            if (!shared_ni.contains(BasicBinaryDomainCombination.obtainInstance("a", "a"))) {
                return false;
            }
            if (!shared_ni.contains(BasicBinaryDomainCombination.obtainInstance("a", "b"))) {
                return false;
            }
            if (!shared_ni.contains(BasicBinaryDomainCombination.obtainInstance("a", "c"))) {
                return false;
            }
            if (!shared_ni.contains(BasicBinaryDomainCombination.obtainInstance("b", "c"))) {
                return false;
            }
            if (!shared_ni.contains(BasicBinaryDomainCombination.obtainInstance("f", "f"))) {
                return false;
            }
            if (shared_ni.contains(BasicBinaryDomainCombination.obtainInstance("m", "n"))) {
                return false;
            }
            if (shared_i.contains(BasicBinaryDomainCombination.obtainInstance("a", "a"))) {
                return false;
            }
            if (!shared_i.contains(BasicBinaryDomainCombination.obtainInstance("a", "b"))) {
                return false;
            }
            if (!shared_i.contains(BasicBinaryDomainCombination.obtainInstance("a", "c"))) {
                return false;
            }
            if (!shared_i.contains(BasicBinaryDomainCombination.obtainInstance("b", "c"))) {
                return false;
            }
            if (shared_i.contains(BasicBinaryDomainCombination.obtainInstance("f", "f"))) {
                return false;
            }
            if (shared_i.contains(BasicBinaryDomainCombination.obtainInstance("m", "n"))) {
                return false;
            }
            if (!s_0_ni.contains(BasicBinaryDomainCombination.obtainInstance("a", "d"))) {
                return false;
            }
            if (!s_0_ni.contains(BasicBinaryDomainCombination.obtainInstance("a", "e"))) {
                return false;
            }
            if (!s_0_ni.contains(BasicBinaryDomainCombination.obtainInstance("b", "d"))) {
                return false;
            }
            if (!s_0_ni.contains(BasicBinaryDomainCombination.obtainInstance("b", "e"))) {
                return false;
            }
            if (!s_0_ni.contains(BasicBinaryDomainCombination.obtainInstance("c", "d"))) {
                return false;
            }
            if (!s_0_ni.contains(BasicBinaryDomainCombination.obtainInstance("c", "e"))) {
                return false;
            }
            if (!s_0_ni.contains(BasicBinaryDomainCombination.obtainInstance("d", "e"))) {
                return false;
            }
            if (!s_0_ni.contains(BasicBinaryDomainCombination.obtainInstance("e", "f"))) {
                return false;
            }
            if (!s_0_ni.contains(BasicBinaryDomainCombination.obtainInstance("g", "h"))) {
                return false;
            }
            if (!s_0_ni.contains(BasicBinaryDomainCombination.obtainInstance("e", "e"))) {
                return false;
            }
            if (!s_0_i.contains(BasicBinaryDomainCombination.obtainInstance("a", "d"))) {
                return false;
            }
            if (!s_0_i.contains(BasicBinaryDomainCombination.obtainInstance("a", "e"))) {
                return false;
            }
            if (!s_0_i.contains(BasicBinaryDomainCombination.obtainInstance("b", "d"))) {
                return false;
            }
            if (!s_0_i.contains(BasicBinaryDomainCombination.obtainInstance("b", "e"))) {
                return false;
            }
            if (!s_0_i.contains(BasicBinaryDomainCombination.obtainInstance("c", "d"))) {
                return false;
            }
            if (!s_0_i.contains(BasicBinaryDomainCombination.obtainInstance("c", "e"))) {
                return false;
            }
            if (!s_0_i.contains(BasicBinaryDomainCombination.obtainInstance("d", "e"))) {
                return false;
            }
            if (!s_0_i.contains(BasicBinaryDomainCombination.obtainInstance("e", "f"))) {
                return false;
            }
            if (!s_0_i.contains(BasicBinaryDomainCombination.obtainInstance("g", "h"))) {
                return false;
            }
            if (s_0_i.contains(BasicBinaryDomainCombination.obtainInstance("e", "e"))) {
                return false;
            }
            if (!s_1_ni.contains(BasicBinaryDomainCombination.obtainInstance("a", "i"))) {
                return false;
            }
            if (!s_1_ni.contains(BasicBinaryDomainCombination.obtainInstance("a", "l"))) {
                return false;
            }
            if (!s_1_ni.contains(BasicBinaryDomainCombination.obtainInstance("b", "i"))) {
                return false;
            }
            if (!s_1_ni.contains(BasicBinaryDomainCombination.obtainInstance("b", "l"))) {
                return false;
            }
            if (!s_1_ni.contains(BasicBinaryDomainCombination.obtainInstance("c", "i"))) {
                return false;
            }
            if (!s_1_ni.contains(BasicBinaryDomainCombination.obtainInstance("c", "l"))) {
                return false;
            }
            if (!s_1_ni.contains(BasicBinaryDomainCombination.obtainInstance("l", "i"))) {
                return false;
            }
            if (!s_1_ni.contains(BasicBinaryDomainCombination.obtainInstance("i", "f"))) {
                return false;
            }
            if (!s_1_ni.contains(BasicBinaryDomainCombination.obtainInstance("m", "n"))) {
                return false;
            }
            if (!s_1_ni.contains(BasicBinaryDomainCombination.obtainInstance("j", "k"))) {
                return false;
            }
            if (s_1_ni.contains(BasicBinaryDomainCombination.obtainInstance("a", "b"))) {
                return false;
            }
            if (!s_1_i.contains(BasicBinaryDomainCombination.obtainInstance("a", "i"))) {
                return false;
            }
            if (!s_1_i.contains(BasicBinaryDomainCombination.obtainInstance("a", "l"))) {
                return false;
            }
            if (!s_1_i.contains(BasicBinaryDomainCombination.obtainInstance("b", "i"))) {
                return false;
            }
            if (!s_1_i.contains(BasicBinaryDomainCombination.obtainInstance("b", "l"))) {
                return false;
            }
            if (!s_1_i.contains(BasicBinaryDomainCombination.obtainInstance("c", "i"))) {
                return false;
            }
            if (!s_1_i.contains(BasicBinaryDomainCombination.obtainInstance("c", "l"))) {
                return false;
            }
            if (!s_1_i.contains(BasicBinaryDomainCombination.obtainInstance("l", "i"))) {
                return false;
            }
            if (!s_1_i.contains(BasicBinaryDomainCombination.obtainInstance("i", "f"))) {
                return false;
            }
            if (!s_1_i.contains(BasicBinaryDomainCombination.obtainInstance("m", "n"))) {
                return false;
            }
            if (!s_1_i.contains(BasicBinaryDomainCombination.obtainInstance("j", "k"))) {
                return false;
            }
            if (s_1_i.contains(BasicBinaryDomainCombination.obtainInstance("a", "b"))) {
                return false;
            }
            if (!TestSurfacing.isEqual(calc_ni.calculateSharedBinaryDomainCombinationBasedGenomeSimilarityScore(), 0.19999999999999996)) {
                return false;
            }
            if (!TestSurfacing.isEqual(calc_i.calculateSharedBinaryDomainCombinationBasedGenomeSimilarityScore(), 0.13636363636363635)) {
                return false;
            }
            if (!TestSurfacing.isEqual(calc_ni.calculateSharedDomainsBasedGenomeSimilarityScore(), 0.2857142857142857)) {
                return false;
            }
            if (!TestSurfacing.isEqual(calc_i.calculateSharedDomainsBasedGenomeSimilarityScore(), 0.2857142857142857)) {
                return false;
            }
            BasicDomain u = new BasicDomain("u", 23, 25, 1, 4, 0.1, -12.0);
            BasicDomain v = new BasicDomain("v", 23, 25, 1, 4, 0.1, -12.0);
            BasicDomain w = new BasicDomain("w", 23, 25, 1, 4, 0.1, -12.0);
            BasicDomain x = new BasicDomain("x", 23, 25, 1, 4, 0.1, -12.0);
            BasicDomain y = new BasicDomain("y", 23, 25, 1, 4, 0.1, -12.0);
            BasicDomain z = new BasicDomain("z", 23, 25, 1, 4, 0.1, -12.0);
            BasicProtein a_0 = new BasicProtein("0", "a", 0);
            BasicProtein a_1 = new BasicProtein("1", "a", 0);
            BasicProtein a_2 = new BasicProtein("2", "a", 0);
            BasicProtein b_0 = new BasicProtein("0", "b", 0);
            BasicProtein b_1 = new BasicProtein("1", "b", 0);
            a_0.addProteinDomain(u);
            a_0.addProteinDomain(v);
            a_0.addProteinDomain(w);
            a_1.addProteinDomain(w);
            a_1.addProteinDomain(x);
            a_2.addProteinDomain(y);
            a_2.addProteinDomain(z);
            b_0.addProteinDomain(u);
            b_0.addProteinDomain(w);
            b_1.addProteinDomain(y);
            b_1.addProteinDomain(z);
            ArrayList<Protein> protein_list_a = new ArrayList<Protein>();
            protein_list_a.add(a_0);
            protein_list_a.add(a_1);
            protein_list_a.add(a_2);
            ArrayList<Protein> protein_list_b = new ArrayList<Protein>();
            protein_list_b.add(b_0);
            protein_list_b.add(b_1);
            BasicGenomeWideCombinableDomains ca = BasicGenomeWideCombinableDomains.createInstance(protein_list_a, false, new BasicSpecies("a"));
            BasicGenomeWideCombinableDomains cb = BasicGenomeWideCombinableDomains.createInstance(protein_list_b, true, new BasicSpecies("b"));
            DomainArchitectureBasedGenomeSimilarityCalculator calc_u = new DomainArchitectureBasedGenomeSimilarityCalculator(ca, cb);
            calc_u.setAllowDomainsToBeIgnored(true);
            if (calc_u.getAllDomains().size() != 6) {
                return false;
            }
            if (calc_u.getDomainsSpecificToGenome0().size() != 2) {
                return false;
            }
            if (calc_u.getDomainsSpecificToGenome1().size() != 0) {
                return false;
            }
            if (!calc_u.getDomainsSpecificToGenome0().contains(v.getDomainId())) {
                return false;
            }
            if (!calc_u.getDomainsSpecificToGenome0().contains(x.getDomainId())) {
                return false;
            }
            if (calc_u.getSharedDomains().size() != 4) {
                return false;
            }
            if (!calc_u.getSharedDomains().contains(u.getDomainId())) {
                return false;
            }
            if (!calc_u.getSharedDomains().contains(w.getDomainId())) {
                return false;
            }
            if (!calc_u.getSharedDomains().contains(y.getDomainId())) {
                return false;
            }
            if (!calc_u.getSharedDomains().contains(z.getDomainId())) {
                return false;
            }
            if (calc_u.getAllDomains().size() != 6) {
                return false;
            }
            if (!calc_u.getAllDomains().contains(u.getDomainId())) {
                return false;
            }
            if (!calc_u.getAllDomains().contains(w.getDomainId())) {
                return false;
            }
            if (!calc_u.getAllDomains().contains(y.getDomainId())) {
                return false;
            }
            if (!calc_u.getAllDomains().contains(z.getDomainId())) {
                return false;
            }
            if (!calc_u.getAllDomains().contains(v.getDomainId())) {
                return false;
            }
            if (!calc_u.getAllDomains().contains(x.getDomainId())) {
                return false;
            }
            if (calc_u.getBinaryDomainCombinationsSpecificToGenome0().size() != 3) {
                return false;
            }
            if (calc_u.getBinaryDomainCombinationsSpecificToGenome1().size() != 0) {
                return false;
            }
            if (calc_u.getSharedBinaryDomainCombinations().size() != 2) {
                return false;
            }
            if (calc_u.getAllBinaryDomainCombinations().size() != 5) {
                return false;
            }
            if (!calc_u.getBinaryDomainCombinationsSpecificToGenome0().contains(BasicBinaryDomainCombination.obtainInstance("v", "u"))) {
                return false;
            }
            if (!calc_u.getBinaryDomainCombinationsSpecificToGenome0().contains(BasicBinaryDomainCombination.obtainInstance("w", "v"))) {
                return false;
            }
            if (!calc_u.getBinaryDomainCombinationsSpecificToGenome0().contains(BasicBinaryDomainCombination.obtainInstance("w", "x"))) {
                return false;
            }
            if (!calc_u.getSharedBinaryDomainCombinations().contains(BasicBinaryDomainCombination.obtainInstance("w", "u"))) {
                return false;
            }
            if (!calc_u.getSharedBinaryDomainCombinations().contains(BasicBinaryDomainCombination.obtainInstance("z", "y"))) {
                return false;
            }
            if (!calc_u.getAllBinaryDomainCombinations().contains(BasicBinaryDomainCombination.obtainInstance("v", "u"))) {
                return false;
            }
            if (!calc_u.getAllBinaryDomainCombinations().contains(BasicBinaryDomainCombination.obtainInstance("w", "v"))) {
                return false;
            }
            if (!calc_u.getAllBinaryDomainCombinations().contains(BasicBinaryDomainCombination.obtainInstance("w", "x"))) {
                return false;
            }
            if (!calc_u.getAllBinaryDomainCombinations().contains(BasicBinaryDomainCombination.obtainInstance("w", "u"))) {
                return false;
            }
            if (!calc_u.getAllBinaryDomainCombinations().contains(BasicBinaryDomainCombination.obtainInstance("z", "y"))) {
                return false;
            }
            calc_u.setAllowDomainsToBeIgnored(true);
            calc_u.addDomainIdToIgnore(u.getDomainId());
            calc_u.addDomainIdToIgnore("other");
            calc_u.addDomainIdToIgnore("other_too");
            if (calc_u.getAllDomains().size() != 5) {
                return false;
            }
            if (calc_u.getDomainsSpecificToGenome0().size() != 2) {
                return false;
            }
            if (calc_u.getDomainsSpecificToGenome1().size() != 0) {
                return false;
            }
            if (!calc_u.getDomainsSpecificToGenome0().contains(v.getDomainId())) {
                return false;
            }
            if (!calc_u.getDomainsSpecificToGenome0().contains(x.getDomainId())) {
                return false;
            }
            if (calc_u.getSharedDomains().size() != 3) {
                return false;
            }
            if (calc_u.getSharedDomains().contains(u.getDomainId())) {
                return false;
            }
            if (!calc_u.getSharedDomains().contains(w.getDomainId())) {
                return false;
            }
            if (!calc_u.getSharedDomains().contains(y.getDomainId())) {
                return false;
            }
            if (!calc_u.getSharedDomains().contains(z.getDomainId())) {
                return false;
            }
            if (calc_u.getAllDomains().size() != 5) {
                return false;
            }
            if (calc_u.getAllDomains().contains(u.getDomainId())) {
                return false;
            }
            if (!calc_u.getAllDomains().contains(w.getDomainId())) {
                return false;
            }
            if (!calc_u.getAllDomains().contains(y.getDomainId())) {
                return false;
            }
            if (!calc_u.getAllDomains().contains(z.getDomainId())) {
                return false;
            }
            if (!calc_u.getAllDomains().contains(v.getDomainId())) {
                return false;
            }
            if (!calc_u.getAllDomains().contains(x.getDomainId())) {
                return false;
            }
            if (calc_u.getBinaryDomainCombinationsSpecificToGenome0().size() != 2) {
                return false;
            }
            if (calc_u.getBinaryDomainCombinationsSpecificToGenome1().size() != 0) {
                return false;
            }
            if (calc_u.getSharedBinaryDomainCombinations().size() != 1) {
                return false;
            }
            if (calc_u.getAllBinaryDomainCombinations().size() != 3) {
                return false;
            }
            if (calc_u.getBinaryDomainCombinationsSpecificToGenome0().contains(BasicBinaryDomainCombination.obtainInstance("v", "u"))) {
                return false;
            }
            if (!calc_u.getBinaryDomainCombinationsSpecificToGenome0().contains(BasicBinaryDomainCombination.obtainInstance("w", "v"))) {
                return false;
            }
            if (!calc_u.getBinaryDomainCombinationsSpecificToGenome0().contains(BasicBinaryDomainCombination.obtainInstance("w", "x"))) {
                return false;
            }
            if (calc_u.getSharedBinaryDomainCombinations().contains(BasicBinaryDomainCombination.obtainInstance("w", "u"))) {
                return false;
            }
            if (!calc_u.getSharedBinaryDomainCombinations().contains(BasicBinaryDomainCombination.obtainInstance("z", "y"))) {
                return false;
            }
            if (calc_u.getAllBinaryDomainCombinations().contains(BasicBinaryDomainCombination.obtainInstance("v", "u"))) {
                return false;
            }
            if (!calc_u.getAllBinaryDomainCombinations().contains(BasicBinaryDomainCombination.obtainInstance("w", "v"))) {
                return false;
            }
            if (!calc_u.getAllBinaryDomainCombinations().contains(BasicBinaryDomainCombination.obtainInstance("w", "x"))) {
                return false;
            }
            if (calc_u.getAllBinaryDomainCombinations().contains(BasicBinaryDomainCombination.obtainInstance("w", "u"))) {
                return false;
            }
            if (!calc_u.getAllBinaryDomainCombinations().contains(BasicBinaryDomainCombination.obtainInstance("z", "y"))) {
                return false;
            }
            calc_u.setAllowDomainsToBeIgnored(false);
            if (calc_u.getAllDomains().size() != 6) {
                return false;
            }
            calc_u.setAllowDomainsToBeIgnored(true);
            calc_u.deleteAllDomainIdsToIgnore();
            calc_u.addDomainIdToIgnore("v");
            calc_u.addDomainIdToIgnore("w");
            calc_u.addDomainIdToIgnore("other");
            calc_u.addDomainIdToIgnore("other_too");
            if (calc_u.getAllDomains().size() != 4) {
                return false;
            }
            if (calc_u.getDomainsSpecificToGenome0().size() != 1) {
                return false;
            }
            if (calc_u.getDomainsSpecificToGenome1().size() != 0) {
                return false;
            }
            if (calc_u.getDomainsSpecificToGenome0().contains(v.getDomainId())) {
                return false;
            }
            if (!calc_u.getDomainsSpecificToGenome0().contains(x.getDomainId())) {
                return false;
            }
            if (calc_u.getSharedDomains().size() != 3) {
                return false;
            }
            if (!calc_u.getSharedDomains().contains(u.getDomainId())) {
                return false;
            }
            if (calc_u.getSharedDomains().contains(w.getDomainId())) {
                return false;
            }
            if (!calc_u.getSharedDomains().contains(y.getDomainId())) {
                return false;
            }
            if (!calc_u.getSharedDomains().contains(z.getDomainId())) {
                return false;
            }
            if (calc_u.getAllDomains().size() != 4) {
                return false;
            }
            if (!calc_u.getAllDomains().contains(u.getDomainId())) {
                return false;
            }
            if (calc_u.getAllDomains().contains(w.getDomainId())) {
                return false;
            }
            if (!calc_u.getAllDomains().contains(y.getDomainId())) {
                return false;
            }
            if (!calc_u.getAllDomains().contains(z.getDomainId())) {
                return false;
            }
            if (calc_u.getAllDomains().contains(v.getDomainId())) {
                return false;
            }
            if (!calc_u.getAllDomains().contains(x.getDomainId())) {
                return false;
            }
            if (calc_u.getBinaryDomainCombinationsSpecificToGenome0().size() != 0) {
                return false;
            }
            if (calc_u.getBinaryDomainCombinationsSpecificToGenome1().size() != 0) {
                return false;
            }
            if (calc_u.getSharedBinaryDomainCombinations().size() != 1) {
                return false;
            }
            if (calc_u.getAllBinaryDomainCombinations().size() != 1) {
                return false;
            }
            if (!calc_u.getSharedBinaryDomainCombinations().contains(BasicBinaryDomainCombination.obtainInstance("y", "z"))) {
                return false;
            }
            if (!calc_u.getAllBinaryDomainCombinations().contains(BasicBinaryDomainCombination.obtainInstance("z", "y"))) {
                return false;
            }
            if (!TestSurfacing.isEqual(calc_u.calculateSharedBinaryDomainCombinationBasedGenomeSimilarityScore(), 1.0)) {
                return false;
            }
            if (!TestSurfacing.isEqual(calc_u.calculateSharedDomainsBasedGenomeSimilarityScore(), 0.75)) {
                return false;
            }
            calc_u.setAllowDomainsToBeIgnored(false);
            if (!TestSurfacing.isEqual(calc_u.calculateSharedBinaryDomainCombinationBasedGenomeSimilarityScore(), 0.4)) {
                return false;
            }
            if (!TestSurfacing.isEqual(calc_u.calculateSharedDomainsBasedGenomeSimilarityScore(), 0.6666666666666667)) {
                return false;
            }
            calc_u.setAllowDomainsToBeIgnored(true);
            if (!TestSurfacing.isEqual(calc_u.calculateSharedBinaryDomainCombinationBasedGenomeSimilarityScore(), 1.0)) {
                return false;
            }
            if (!TestSurfacing.isEqual(calc_u.calculateSharedDomainsBasedGenomeSimilarityScore(), 0.75)) {
                return false;
            }
            calc_u.deleteAllDomainIdsToIgnore();
            if (!TestSurfacing.isEqual(calc_u.calculateSharedBinaryDomainCombinationBasedGenomeSimilarityScore(), 0.4)) {
                return false;
            }
            if (!TestSurfacing.isEqual(calc_u.calculateSharedDomainsBasedGenomeSimilarityScore(), 0.6666666666666667)) {
                return false;
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            return false;
        }
        return true;
    }

    private static boolean testDomainCombinationCounting(File test_dir) {
        try {
            HmmPfamOutputParser parser = new HmmPfamOutputParser(new File(test_dir + ForesterUtil.getFileSeparator() + "hmmpfam_output2"), "human", "ls");
            parser.setEValueMaximum(0.2);
            parser.setIgnoreDufs(true);
            parser.setReturnType(HmmPfamOutputParser.ReturnType.UNORDERED_PROTEIN_DOMAIN_COLLECTION_PER_PROTEIN);
            List<Protein> domain_collections = parser.parse();
            BasicGenomeWideCombinableDomains cdcc = BasicGenomeWideCombinableDomains.createInstance(domain_collections, false, new BasicSpecies("human"));
            CombinableDomains cd = cdcc.get("A");
            if (cd.getKeyDomainCount() != 9) {
                return false;
            }
            if (cd.getKeyDomainProteinsCount() != 7) {
                return false;
            }
            if (cd.getNumberOfCombinableDomains() != 11) {
                return false;
            }
            if (cd.getNumberOfProteinsExhibitingCombination(new SimpleDomain("A").getDomainId()) != 2) {
                return false;
            }
            if (cd.getNumberOfProteinsExhibitingCombination(new SimpleDomain("B").getDomainId()) != 6) {
                return false;
            }
            if (cd.getNumberOfProteinsExhibitingCombination(new SimpleDomain("C").getDomainId()) != 4) {
                return false;
            }
            if (cd.getNumberOfProteinsExhibitingCombination(new SimpleDomain("D").getDomainId()) != 3) {
                return false;
            }
            if (cd.getNumberOfProteinsExhibitingCombination(new SimpleDomain("E").getDomainId()) != 1) {
                return false;
            }
            if (cd.getNumberOfProteinsExhibitingCombination(new SimpleDomain("U").getDomainId()) != 1) {
                return false;
            }
            if (cd.getNumberOfProteinsExhibitingCombination(new SimpleDomain("V").getDomainId()) != 1) {
                return false;
            }
            if (cd.getNumberOfProteinsExhibitingCombination(new SimpleDomain("W").getDomainId()) != 1) {
                return false;
            }
            if (cd.getNumberOfProteinsExhibitingCombination(new SimpleDomain("X").getDomainId()) != 1) {
                return false;
            }
            if (cd.getNumberOfProteinsExhibitingCombination(new SimpleDomain("Y").getDomainId()) != 1) {
                return false;
            }
            if (cd.getNumberOfProteinsExhibitingCombination(new SimpleDomain("Z").getDomainId()) != 1) {
                return false;
            }
            if (cd.getNumberOfProteinsExhibitingCombination(new SimpleDomain("NN").getDomainId()) != 0) {
                return false;
            }
            if (cd.getKeyDomainCount() != 9) {
                return false;
            }
            cd = cdcc.get("B");
            if (cd.getKeyDomainCount() != 12) {
                return false;
            }
            if (cd.getKeyDomainProteinsCount() != 7) {
                return false;
            }
            if (cd.getNumberOfCombinableDomains() != 11) {
                return false;
            }
            if (cd.getNumberOfProteinsExhibitingCombination(new SimpleDomain("A").getDomainId()) != 6) {
                return false;
            }
            if (cd.getNumberOfProteinsExhibitingCombination(new SimpleDomain("B").getDomainId()) != 4) {
                return false;
            }
            if (cd.getNumberOfProteinsExhibitingCombination(new SimpleDomain("C").getDomainId()) != 4) {
                return false;
            }
            if (cd.getNumberOfProteinsExhibitingCombination(new SimpleDomain("D").getDomainId()) != 3) {
                return false;
            }
            if (cd.getNumberOfProteinsExhibitingCombination(new SimpleDomain("E").getDomainId()) != 1) {
                return false;
            }
            if (cd.getNumberOfProteinsExhibitingCombination(new SimpleDomain("U").getDomainId()) != 1) {
                return false;
            }
            if (cd.getNumberOfProteinsExhibitingCombination(new SimpleDomain("V").getDomainId()) != 1) {
                return false;
            }
            if (cd.getNumberOfProteinsExhibitingCombination(new SimpleDomain("W").getDomainId()) != 1) {
                return false;
            }
            if (cd.getNumberOfProteinsExhibitingCombination(new SimpleDomain("X").getDomainId()) != 1) {
                return false;
            }
            if (cd.getNumberOfProteinsExhibitingCombination(new SimpleDomain("Y").getDomainId()) != 1) {
                return false;
            }
            if (cd.getNumberOfProteinsExhibitingCombination(new SimpleDomain("Z").getDomainId()) != 1) {
                return false;
            }
            if (cd.getNumberOfProteinsExhibitingCombination(new SimpleDomain("NN").getDomainId()) != 0) {
                return false;
            }
            if (cd.getKeyDomainCount() != 12) {
                return false;
            }
            cd = cdcc.get("C");
            if (cd.getKeyDomainCount() != 10) {
                return false;
            }
            if (cd.getKeyDomainProteinsCount() != 7) {
                return false;
            }
            if (cd.getNumberOfCombinableDomains() != 11) {
                return false;
            }
            if (cd.getNumberOfProteinsExhibitingCombination(new SimpleDomain("A").getDomainId()) != 4) {
                return false;
            }
            if (cd.getNumberOfProteinsExhibitingCombination(new SimpleDomain("B").getDomainId()) != 4) {
                return false;
            }
            if (cd.getNumberOfProteinsExhibitingCombination(new SimpleDomain("C").getDomainId()) != 2) {
                return false;
            }
            if (cd.getNumberOfProteinsExhibitingCombination(new SimpleDomain("D").getDomainId()) != 3) {
                return false;
            }
            if (cd.getNumberOfProteinsExhibitingCombination(new SimpleDomain("E").getDomainId()) != 1) {
                return false;
            }
            if (cd.getNumberOfProteinsExhibitingCombination(new SimpleDomain("U").getDomainId()) != 1) {
                return false;
            }
            if (cd.getNumberOfProteinsExhibitingCombination(new SimpleDomain("V").getDomainId()) != 1) {
                return false;
            }
            if (cd.getNumberOfProteinsExhibitingCombination(new SimpleDomain("W").getDomainId()) != 1) {
                return false;
            }
            if (cd.getNumberOfProteinsExhibitingCombination(new SimpleDomain("X").getDomainId()) != 2) {
                return false;
            }
            if (cd.getNumberOfProteinsExhibitingCombination(new SimpleDomain("Y").getDomainId()) != 2) {
                return false;
            }
            if (cd.getNumberOfProteinsExhibitingCombination(new SimpleDomain("Z").getDomainId()) != 2) {
                return false;
            }
            if (cd.getNumberOfProteinsExhibitingCombination(new SimpleDomain("NN").getDomainId()) != 0) {
                return false;
            }
            cd = cdcc.get("D");
            if (cd.getKeyDomainCount() != 15) {
                return false;
            }
            if (cd.getKeyDomainProteinsCount() != 6) {
                return false;
            }
            if (cd.getNumberOfCombinableDomains() != 11) {
                return false;
            }
            cd = cdcc.get("E");
            if (cd.getNumberOfCombinableDomains() != 10) {
                return false;
            }
            if (cd.getKeyDomainCount() != 1) {
                return false;
            }
            if (cd.getKeyDomainProteinsCount() != 1) {
                return false;
            }
            cd = cdcc.get("U");
            if (cd.getNumberOfCombinableDomains() != 11) {
                return false;
            }
            if (cd.getKeyDomainCount() != 6) {
                return false;
            }
            if (cd.getKeyDomainProteinsCount() != 3) {
                return false;
            }
            cd = cdcc.get("V");
            if (cd.getNumberOfCombinableDomains() != 11) {
                return false;
            }
            if (cd.getKeyDomainCount() != 3) {
                return false;
            }
            if (cd.getKeyDomainProteinsCount() != 2) {
                return false;
            }
            cd = cdcc.get("W");
            if (cd.getNumberOfCombinableDomains() != 10) {
                return false;
            }
            if (cd.getKeyDomainCount() != 2) {
                return false;
            }
            if (cd.getKeyDomainProteinsCount() != 2) {
                return false;
            }
            cd = cdcc.get("X");
            if (cd.getNumberOfCombinableDomains() != 10) {
                return false;
            }
            if (cd.getKeyDomainCount() != 2) {
                return false;
            }
            cd = cdcc.get("Y");
            if (cd.getNumberOfCombinableDomains() != 10) {
                return false;
            }
            cd = cdcc.get("Z");
            if (cd.getNumberOfCombinableDomains() != 10) {
                return false;
            }
            cd = cdcc.get("NN");
            if (cd.getKeyDomainCount() != 1) {
                return false;
            }
            if (cd.getKeyDomainProteinsCount() != 1) {
                return false;
            }
            if (cd.getNumberOfCombinableDomains() != 0) {
                return false;
            }
            if (cd.getNumberOfProteinsExhibitingCombination(new SimpleDomain("NN").getDomainId()) != 0) {
                return false;
            }
            cd = cdcc.get("MM");
            if (cd.getNumberOfCombinableDomains() != 1) {
                return false;
            }
            if (cd.getNumberOfProteinsExhibitingCombination(new SimpleDomain("MM").getDomainId()) != 0) {
                return false;
            }
            if (cd.getNumberOfProteinsExhibitingCombination(new SimpleDomain("OO").getDomainId()) != 1) {
                return false;
            }
            cd = cdcc.get("OO");
            if (cd.getNumberOfCombinableDomains() != 2) {
                return false;
            }
            if (cd.getNumberOfProteinsExhibitingCombination(new SimpleDomain("OO").getDomainId()) != 1) {
                return false;
            }
            if (cd.getNumberOfProteinsExhibitingCombination(new SimpleDomain("MM").getDomainId()) != 1) {
                return false;
            }
            cd = cdcc.get("QQ");
            if (cd.getNumberOfCombinableDomains() != 1) {
                return false;
            }
            if (cd.getKeyDomainCount() != 17) {
                return false;
            }
            if (cd.getKeyDomainProteinsCount() != 4) {
                return false;
            }
            if (cd.getNumberOfProteinsExhibitingCombination(new SimpleDomain("QQ").getDomainId()) != 3) {
                return false;
            }
            cd = cdcc.get("PP");
            if (cd.getNumberOfCombinableDomains() != 0) {
                return false;
            }
            if (cd.getKeyDomainCount() != 2) {
                return false;
            }
            if (cd.getKeyDomainProteinsCount() != 2) {
                return false;
            }
            cd = cdcc.get("singlet");
            if (cd.getKeyDomainCount() != 1) {
                return false;
            }
            if (cd.getKeyDomainProteinsCount() != 1) {
                return false;
            }
            if (cd.getNumberOfCombinableDomains() != 0) {
                return false;
            }
            if (cd.getNumberOfProteinsExhibitingCombination(new SimpleDomain("singlet").getDomainId()) != 0) {
                return false;
            }
            cd = cdcc.get("three");
            if (cd.getKeyDomainCount() != 3) {
                return false;
            }
            if (cd.getKeyDomainProteinsCount() != 1) {
                return false;
            }
            if (cd.getNumberOfCombinableDomains() != 1) {
                return false;
            }
            if (cd.getNumberOfProteinsExhibitingCombination("three") != 1) {
                return false;
            }
            if (cd.getNumberOfProteinsExhibitingCombination("so_far_so_bad") != 0) {
                return false;
            }
            BasicGenomeWideCombinableDomains cdcc2 = BasicGenomeWideCombinableDomains.createInstance(domain_collections, true, new BasicSpecies("human"), null, BinaryDomainCombination.DomainCombinationType.BASIC, null, null);
            cd = cdcc2.get("A");
            if (cd.getKeyDomainCount() != 9) {
                return false;
            }
            if (cd.getKeyDomainProteinsCount() != 7) {
                return false;
            }
            if (cd.getNumberOfCombinableDomains() != 10) {
                return false;
            }
            if (cd.getNumberOfProteinsExhibitingCombination(new SimpleDomain("A").getDomainId()) != 0) {
                return false;
            }
            if (cd.getNumberOfProteinsExhibitingCombination(new SimpleDomain("B").getDomainId()) != 6) {
                return false;
            }
            if (cd.getNumberOfProteinsExhibitingCombination(new SimpleDomain("C").getDomainId()) != 4) {
                return false;
            }
            if (cd.getNumberOfProteinsExhibitingCombination(new SimpleDomain("D").getDomainId()) != 3) {
                return false;
            }
            if (cd.getNumberOfProteinsExhibitingCombination(new SimpleDomain("E").getDomainId()) != 1) {
                return false;
            }
            if (cd.getNumberOfProteinsExhibitingCombination("U") != 1) {
                return false;
            }
            if (cd.getNumberOfProteinsExhibitingCombination("V") != 1) {
                return false;
            }
            if (cd.getNumberOfProteinsExhibitingCombination("W") != 1) {
                return false;
            }
            if (cd.getNumberOfProteinsExhibitingCombination("X") != 1) {
                return false;
            }
            if (cd.getNumberOfProteinsExhibitingCombination("Y") != 1) {
                return false;
            }
            if (cd.getNumberOfProteinsExhibitingCombination("Z") != 1) {
                return false;
            }
            if (cd.getNumberOfProteinsExhibitingCombination("NN") != 0) {
                return false;
            }
            cd = cdcc2.get("B");
            if (cd.getKeyDomainCount() != 12) {
                return false;
            }
            if (cd.getKeyDomainProteinsCount() != 7) {
                return false;
            }
            if (cd.getNumberOfCombinableDomains() != 10) {
                return false;
            }
            if (cd.getNumberOfProteinsExhibitingCombination("A") != 6) {
                return false;
            }
            if (cd.getNumberOfProteinsExhibitingCombination("B") != 0) {
                return false;
            }
            if (cd.getNumberOfProteinsExhibitingCombination("C") != 4) {
                return false;
            }
            if (cd.getNumberOfProteinsExhibitingCombination("D") != 3) {
                return false;
            }
            if (cd.getNumberOfProteinsExhibitingCombination("E") != 1) {
                return false;
            }
            if (cd.getNumberOfProteinsExhibitingCombination("U") != 1) {
                return false;
            }
            if (cd.getNumberOfProteinsExhibitingCombination("V") != 1) {
                return false;
            }
            if (cd.getNumberOfProteinsExhibitingCombination("W") != 1) {
                return false;
            }
            if (cd.getNumberOfProteinsExhibitingCombination("X") != 1) {
                return false;
            }
            if (cd.getNumberOfProteinsExhibitingCombination("Y") != 1) {
                return false;
            }
            if (cd.getNumberOfProteinsExhibitingCombination("Z") != 1) {
                return false;
            }
            if (cd.getNumberOfProteinsExhibitingCombination("NN") != 0) {
                return false;
            }
            cd = cdcc2.get("C");
            if (cd.getKeyDomainCount() != 10) {
                return false;
            }
            if (cd.getKeyDomainProteinsCount() != 7) {
                return false;
            }
            if (cd.getNumberOfCombinableDomains() != 10) {
                return false;
            }
            if (cd.getNumberOfProteinsExhibitingCombination("A") != 4) {
                return false;
            }
            if (cd.getNumberOfProteinsExhibitingCombination("B") != 4) {
                return false;
            }
            if (cd.getNumberOfProteinsExhibitingCombination("C") != 0) {
                return false;
            }
            if (cd.getNumberOfProteinsExhibitingCombination("D") != 3) {
                return false;
            }
            if (cd.getNumberOfProteinsExhibitingCombination("E") != 1) {
                return false;
            }
            if (cd.getNumberOfProteinsExhibitingCombination("U") != 1) {
                return false;
            }
            if (cd.getNumberOfProteinsExhibitingCombination("V") != 1) {
                return false;
            }
            if (cd.getNumberOfProteinsExhibitingCombination("W") != 1) {
                return false;
            }
            if (cd.getNumberOfProteinsExhibitingCombination("X") != 2) {
                return false;
            }
            if (cd.getNumberOfProteinsExhibitingCombination("Y") != 2) {
                return false;
            }
            if (cd.getNumberOfProteinsExhibitingCombination("Z") != 2) {
                return false;
            }
            if (cd.getNumberOfProteinsExhibitingCombination("NN") != 0) {
                return false;
            }
            cd = cdcc2.get("D");
            if (cd.getNumberOfCombinableDomains() != 10) {
                return false;
            }
            cd = cdcc2.get("E");
            if (cd.getNumberOfCombinableDomains() != 10) {
                return false;
            }
            if (cd.getKeyDomainCount() != 1) {
                return false;
            }
            cd = cdcc2.get("U");
            if (cd.getNumberOfCombinableDomains() != 10) {
                return false;
            }
            cd = cdcc2.get("V");
            if (cd.getNumberOfCombinableDomains() != 10) {
                return false;
            }
            cd = cdcc2.get("W");
            if (cd.getNumberOfCombinableDomains() != 10) {
                return false;
            }
            cd = cdcc2.get("X");
            if (cd.getNumberOfCombinableDomains() != 10) {
                return false;
            }
            cd = cdcc2.get("Y");
            if (cd.getNumberOfCombinableDomains() != 10) {
                return false;
            }
            cd = cdcc2.get("Z");
            if (cd.getNumberOfCombinableDomains() != 10) {
                return false;
            }
            cd = cdcc2.get("NN");
            if (cd.getNumberOfCombinableDomains() != 0) {
                return false;
            }
            if (cd.getNumberOfProteinsExhibitingCombination("NN") != 0) {
                return false;
            }
            cd = cdcc2.get("MM");
            if (cd.getNumberOfCombinableDomains() != 1) {
                return false;
            }
            if (cd.getNumberOfProteinsExhibitingCombination("MM") != 0) {
                return false;
            }
            if (cd.getNumberOfProteinsExhibitingCombination("OO") != 1) {
                return false;
            }
            cd = cdcc2.get("OO");
            if (cd.getNumberOfCombinableDomains() != 1) {
                return false;
            }
            if (cd.getNumberOfProteinsExhibitingCombination("OO") != 0) {
                return false;
            }
            if (cd.getNumberOfProteinsExhibitingCombination("MM") != 1) {
                return false;
            }
            cd = cdcc2.get("QQ");
            if (cd.getNumberOfCombinableDomains() != 0) {
                return false;
            }
            if (cd.getNumberOfProteinsExhibitingCombination("QQ") != 0) {
                return false;
            }
            cd = cdcc2.get("singlet");
            if (cd.getKeyDomainCount() != 1) {
                return false;
            }
            if (cd.getKeyDomainProteinsCount() != 1) {
                return false;
            }
            if (cd.getNumberOfCombinableDomains() != 0) {
                return false;
            }
            if (cd.getNumberOfProteinsExhibitingCombination("singlet") != 0) {
                return false;
            }
            cd = cdcc2.get("three");
            if (cd.getKeyDomainCount() != 3) {
                return false;
            }
            if (cd.getKeyDomainProteinsCount() != 1) {
                return false;
            }
            if (cd.getNumberOfCombinableDomains() != 0) {
                return false;
            }
            if (cd.getNumberOfProteinsExhibitingCombination("three") != 0) {
                return false;
            }
            if (cd.getNumberOfProteinsExhibitingCombination("so_far_so_bad") != 0) {
                return false;
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            return false;
        }
        return true;
    }

    private static boolean testDomainSorting() {
        try {
            BasicDomain A = new BasicDomain("A", 1, 2, 1, 1, 0.1, -12.0);
            BasicDomain B = new BasicDomain("B", 1, 2, 1, 1, 0.1, -12.0);
            BasicDomain C = new BasicDomain("C", 1, 2, 1, 1, 0.2, -12.0);
            BasicDomain D = new BasicDomain("D", 1, 2, 1, 1, 0.3, -12.0);
            BasicDomain E = new BasicDomain("E", 1, 2, 1, 1, 0.4, -12.0);
            BasicDomain F = new BasicDomain("F", 1, 2, 1, 1, 0.5, -12.0);
            BasicDomain G = new BasicDomain("G", 1, 2, 1, 1, 0.6, -12.0);
            BasicDomain H1 = new BasicDomain("H", 100, 200, 1, 5, 0.7, -12.0);
            BasicDomain H2 = new BasicDomain("H", 300, 400, 2, 5, 0.7, -12.0);
            BasicDomain H3 = new BasicDomain("H", 500, 600, 3, 5, 0.7, -12.0);
            BasicDomain H4 = new BasicDomain("H", 700, 800, 4, 5, 0.7, -12.0);
            BasicDomain H5 = new BasicDomain("H", 700, 800, 5, 5, 0.7, -12.0);
            BasicDomain H6 = new BasicDomain("H", 1199, 1299, 6, 6, 0.7, -0.111);
            BasicDomain H7 = new BasicDomain("H7", 700, 800, 5, 5, 0.7, -12.0);
            BasicDomain H8 = new BasicDomain("H7", 700, 800, 5, 200, 0.7, -12.0);
            BasicProtein protein = new BasicProtein("00", "bat", 0);
            protein.addProteinDomain(H5);
            protein.addProteinDomain(H2);
            protein.addProteinDomain(H7);
            protein.addProteinDomain(H6);
            protein.addProteinDomain(A);
            protein.addProteinDomain(G);
            protein.addProteinDomain(H4);
            protein.addProteinDomain(D);
            protein.addProteinDomain(H1);
            protein.addProteinDomain(C);
            protein.addProteinDomain(E);
            protein.addProteinDomain(F);
            protein.addProteinDomain(B);
            protein.addProteinDomain(H3);
            protein.addProteinDomain(H7);
            protein.addProteinDomain(H7);
            protein.addProteinDomain(H8);
            List<Domain> sorted = SurfacingUtil.sortDomainsWithAscendingConfidenceValues(protein);
            if (sorted.size() != 17) {
                return false;
            }
            if (!sorted.get(0).getDomainId().equals("A")) {
                return false;
            }
            if (sorted.get(0).getNumber() != 1) {
                return false;
            }
            if (!sorted.get(1).getDomainId().equals("B")) {
                return false;
            }
            if (sorted.get(1).getNumber() != 1) {
                return false;
            }
            if (!sorted.get(2).getDomainId().equals("C")) {
                return false;
            }
            if (sorted.get(2).getNumber() != 1) {
                return false;
            }
            if (!sorted.get(3).getDomainId().equals("D")) {
                return false;
            }
            if (sorted.get(3).getNumber() != 1) {
                return false;
            }
            if (!sorted.get(4).getDomainId().equals("E")) {
                return false;
            }
            if (sorted.get(4).getNumber() != 1) {
                return false;
            }
            if (!sorted.get(5).getDomainId().equals("F")) {
                return false;
            }
            if (sorted.get(5).getNumber() != 1) {
                return false;
            }
            if (!sorted.get(6).getDomainId().equals("G")) {
                return false;
            }
            if (sorted.get(6).getNumber() != 1) {
                return false;
            }
            if (!sorted.get(7).getDomainId().equals("H")) {
                return false;
            }
            if (sorted.get(7).getNumber() != 5) {
                return false;
            }
            if (!sorted.get(8).getDomainId().equals("H")) {
                return false;
            }
            if (sorted.get(8).getNumber() != 2) {
                return false;
            }
            if (!sorted.get(9).getDomainId().equals("H")) {
                return false;
            }
            if (sorted.get(9).getNumber() != 6) {
                return false;
            }
            if (!sorted.get(10).getDomainId().equals("H")) {
                return false;
            }
            if (sorted.get(10).getNumber() != 4) {
                return false;
            }
            if (!sorted.get(11).getDomainId().equals("H")) {
                return false;
            }
            if (sorted.get(11).getNumber() != 1) {
                return false;
            }
            if (sorted.get(11).getTotalCount() != 5) {
                return false;
            }
            if (!sorted.get(12).getDomainId().equals("H")) {
                return false;
            }
            if (sorted.get(12).getNumber() != 3) {
                return false;
            }
            if (!sorted.get(13).getDomainId().equals("H7")) {
                return false;
            }
            if (sorted.get(13).getNumber() != 5) {
                return false;
            }
            if (!sorted.get(14).getDomainId().equals("H7")) {
                return false;
            }
            if (sorted.get(14).getNumber() != 5) {
                return false;
            }
            if (!sorted.get(15).getDomainId().equals("H7")) {
                return false;
            }
            if (sorted.get(15).getNumber() != 5) {
                return false;
            }
            if (!sorted.get(16).getDomainId().equals("H7")) {
                return false;
            }
            if (sorted.get(16).getNumber() != 5) {
                return false;
            }
            if (sorted.get(16).getTotalCount() != 200) {
                return false;
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            return false;
        }
        return true;
    }

    private static boolean testGenomeWideCombinableDomains() {
        try {
            BasicDomain a = new BasicDomain("a", 23, 25, 1, 4, 0.1, -12.0);
            BasicDomain b = new BasicDomain("b", 23, 25, 1, 4, 0.1, -12.0);
            BasicDomain c = new BasicDomain("c", 23, 25, 1, 4, 0.1, -12.0);
            BasicDomain d = new BasicDomain("d", 23, 25, 1, 4, 0.1, -12.0);
            BasicDomain e = new BasicDomain("e", 23, 25, 1, 4, 0.1, -12.0);
            BasicDomain f = new BasicDomain("f", 23, 25, 1, 4, 0.1, -12.0);
            BasicDomain g = new BasicDomain("g", 23, 25, 1, 4, 0.1, -12.0);
            BasicDomain h = new BasicDomain("h", 23, 25, 1, 4, 0.1, -12.0);
            BasicDomain x = new BasicDomain("x", 23, 25, 1, 4, 0.1, -12.0);
            BasicProtein eel_0 = new BasicProtein("0", "eel", 0);
            BasicProtein eel_1 = new BasicProtein("1", "eel", 0);
            BasicProtein eel_2 = new BasicProtein("2", "eel", 0);
            BasicProtein eel_3 = new BasicProtein("3", "eel", 0);
            BasicProtein eel_4 = new BasicProtein("4", "eel", 0);
            BasicProtein eel_5 = new BasicProtein("5", "eel", 0);
            BasicProtein eel_6 = new BasicProtein("6", "eel", 0);
            eel_1.addProteinDomain(a);
            eel_2.addProteinDomain(a);
            eel_2.addProteinDomain(b);
            eel_3.addProteinDomain(a);
            eel_3.addProteinDomain(a);
            eel_3.addProteinDomain(b);
            eel_4.addProteinDomain(a);
            eel_4.addProteinDomain(b);
            eel_4.addProteinDomain(c);
            eel_4.addProteinDomain(d);
            eel_4.addProteinDomain(e);
            eel_5.addProteinDomain(e);
            eel_5.addProteinDomain(e);
            eel_5.addProteinDomain(f);
            eel_5.addProteinDomain(f);
            eel_5.addProteinDomain(f);
            eel_5.addProteinDomain(f);
            eel_6.addProteinDomain(g);
            eel_6.addProteinDomain(h);
            ArrayList<Protein> protein_list_eel = new ArrayList<Protein>();
            protein_list_eel.add(eel_0);
            protein_list_eel.add(eel_1);
            protein_list_eel.add(eel_2);
            protein_list_eel.add(eel_3);
            protein_list_eel.add(eel_4);
            protein_list_eel.add(eel_5);
            protein_list_eel.add(eel_6);
            BasicGenomeWideCombinableDomains eel_not_ignore = BasicGenomeWideCombinableDomains.createInstance(protein_list_eel, false, new BasicSpecies("eel"));
            BasicGenomeWideCombinableDomains eel_ignore = BasicGenomeWideCombinableDomains.createInstance(protein_list_eel, true, new BasicSpecies("eel"));
            if (!eel_not_ignore.contains("a")) {
                return false;
            }
            if (!eel_not_ignore.contains("b")) {
                return false;
            }
            if (!eel_not_ignore.contains("c")) {
                return false;
            }
            if (!eel_not_ignore.contains("d")) {
                return false;
            }
            if (!eel_not_ignore.contains("e")) {
                return false;
            }
            if (!eel_not_ignore.contains("f")) {
                return false;
            }
            if (!eel_not_ignore.contains("g")) {
                return false;
            }
            if (!eel_not_ignore.contains("h")) {
                return false;
            }
            if (eel_not_ignore.contains("x")) {
                return false;
            }
            if (!eel_ignore.contains("a")) {
                return false;
            }
            if (!eel_ignore.contains("b")) {
                return false;
            }
            if (!eel_ignore.contains("c")) {
                return false;
            }
            if (!eel_ignore.contains("d")) {
                return false;
            }
            if (!eel_ignore.contains("e")) {
                return false;
            }
            if (!eel_ignore.contains("f")) {
                return false;
            }
            if (!eel_ignore.contains("g")) {
                return false;
            }
            if (!eel_ignore.contains("h")) {
                return false;
            }
            if (eel_ignore.contains("x")) {
                return false;
            }
            if (eel_not_ignore.getSize() != 8) {
                return false;
            }
            if (eel_ignore.getSize() != 8) {
                return false;
            }
            if (eel_not_ignore.get("a").getCombinableDomainsIds().size() != 5) {
                return false;
            }
            if (eel_not_ignore.get("b").getCombinableDomainsIds().size() != 4) {
                return false;
            }
            if (eel_not_ignore.get("c").getCombinableDomainsIds().size() != 4) {
                return false;
            }
            if (eel_not_ignore.get("d").getCombinableDomainsIds().size() != 4) {
                return false;
            }
            if (eel_not_ignore.get("e").getCombinableDomainsIds().size() != 6) {
                return false;
            }
            if (eel_not_ignore.get("f").getCombinableDomainsIds().size() != 2) {
                return false;
            }
            if (eel_not_ignore.get("g").getCombinableDomainsIds().size() != 1) {
                return false;
            }
            if (eel_not_ignore.get("h").getCombinableDomainsIds().size() != 1) {
                return false;
            }
            if (eel_ignore.get("a").getCombinableDomainsIds().size() != 4) {
                return false;
            }
            if (eel_ignore.get("b").getCombinableDomainsIds().size() != 4) {
                return false;
            }
            if (eel_ignore.get("c").getCombinableDomainsIds().size() != 4) {
                return false;
            }
            if (eel_ignore.get("d").getCombinableDomainsIds().size() != 4) {
                return false;
            }
            if (eel_ignore.get("e").getCombinableDomainsIds().size() != 5) {
                return false;
            }
            if (eel_ignore.get("f").getCombinableDomainsIds().size() != 1) {
                return false;
            }
            if (eel_ignore.get("g").getCombinableDomainsIds().size() != 1) {
                return false;
            }
            if (eel_ignore.get("h").getCombinableDomainsIds().size() != 1) {
                return false;
            }
            if (eel_not_ignore.getAllDomainIds().size() != 8) {
                return false;
            }
            if (!eel_not_ignore.getAllDomainIds().contains(a.getDomainId())) {
                return false;
            }
            if (!eel_not_ignore.getAllDomainIds().contains(b.getDomainId())) {
                return false;
            }
            if (!eel_not_ignore.getAllDomainIds().contains(c.getDomainId())) {
                return false;
            }
            if (!eel_not_ignore.getAllDomainIds().contains(d.getDomainId())) {
                return false;
            }
            if (!eel_not_ignore.getAllDomainIds().contains(e.getDomainId())) {
                return false;
            }
            if (!eel_not_ignore.getAllDomainIds().contains(f.getDomainId())) {
                return false;
            }
            if (!eel_not_ignore.getAllDomainIds().contains(g.getDomainId())) {
                return false;
            }
            if (!eel_not_ignore.getAllDomainIds().contains(h.getDomainId())) {
                return false;
            }
            if (eel_not_ignore.getAllDomainIds().contains(x.getDomainId())) {
                return false;
            }
            if (eel_ignore.getAllDomainIds().size() != 8) {
                return false;
            }
            if (!eel_ignore.getAllDomainIds().contains(a.getDomainId())) {
                return false;
            }
            if (!eel_ignore.getAllDomainIds().contains(b.getDomainId())) {
                return false;
            }
            if (!eel_ignore.getAllDomainIds().contains(c.getDomainId())) {
                return false;
            }
            if (!eel_ignore.getAllDomainIds().contains(d.getDomainId())) {
                return false;
            }
            if (!eel_ignore.getAllDomainIds().contains(e.getDomainId())) {
                return false;
            }
            if (!eel_ignore.getAllDomainIds().contains(f.getDomainId())) {
                return false;
            }
            if (!eel_ignore.getAllDomainIds().contains(g.getDomainId())) {
                return false;
            }
            if (!eel_ignore.getAllDomainIds().contains(h.getDomainId())) {
                return false;
            }
            if (eel_ignore.getAllDomainIds().contains(x.getDomainId())) {
                return false;
            }
            SortedSet<BinaryDomainCombination> bc0 = eel_not_ignore.toBinaryDomainCombinations();
            if (bc0.size() != 15) {
                return false;
            }
            if (!bc0.contains(BasicBinaryDomainCombination.obtainInstance("a", "a"))) {
                return false;
            }
            if (!bc0.contains(BasicBinaryDomainCombination.obtainInstance("a", "b"))) {
                return false;
            }
            if (!bc0.contains(BasicBinaryDomainCombination.obtainInstance("b", "a"))) {
                return false;
            }
            if (!bc0.contains(BasicBinaryDomainCombination.obtainInstance("a", "c"))) {
                return false;
            }
            if (!bc0.contains(BasicBinaryDomainCombination.obtainInstance("a", "d"))) {
                return false;
            }
            if (!bc0.contains(BasicBinaryDomainCombination.obtainInstance("a", "e"))) {
                return false;
            }
            if (!bc0.contains(BasicBinaryDomainCombination.obtainInstance("b", "c"))) {
                return false;
            }
            if (!bc0.contains(BasicBinaryDomainCombination.obtainInstance("b", "d"))) {
                return false;
            }
            if (!bc0.contains(BasicBinaryDomainCombination.obtainInstance("b", "e"))) {
                return false;
            }
            if (!bc0.contains(BasicBinaryDomainCombination.obtainInstance("c", "d"))) {
                return false;
            }
            if (!bc0.contains(BasicBinaryDomainCombination.obtainInstance("c", "e"))) {
                return false;
            }
            if (!bc0.contains(BasicBinaryDomainCombination.obtainInstance("d", "e"))) {
                return false;
            }
            if (!bc0.contains(BasicBinaryDomainCombination.obtainInstance("e", "f"))) {
                return false;
            }
            if (!bc0.contains(BasicBinaryDomainCombination.obtainInstance("e", "e"))) {
                return false;
            }
            if (!bc0.contains(BasicBinaryDomainCombination.obtainInstance("f", "f"))) {
                return false;
            }
            if (!bc0.contains(BasicBinaryDomainCombination.obtainInstance("g", "h"))) {
                return false;
            }
            if (bc0.contains(BasicBinaryDomainCombination.obtainInstance("f", "a"))) {
                return false;
            }
            if (bc0.contains(BasicBinaryDomainCombination.obtainInstance("f", "b"))) {
                return false;
            }
            if (bc0.contains(BasicBinaryDomainCombination.obtainInstance("a", "h"))) {
                return false;
            }
            if (bc0.contains(BasicBinaryDomainCombination.obtainInstance("a", "g"))) {
                return false;
            }
            SortedSet<BinaryDomainCombination> bc1 = eel_ignore.toBinaryDomainCombinations();
            if (bc1.size() != 12) {
                return false;
            }
            if (bc1.contains(BasicBinaryDomainCombination.obtainInstance("a", "a"))) {
                return false;
            }
            if (!bc1.contains(BasicBinaryDomainCombination.obtainInstance("a", "b"))) {
                return false;
            }
            if (!bc1.contains(BasicBinaryDomainCombination.obtainInstance("b", "a"))) {
                return false;
            }
            if (!bc1.contains(BasicBinaryDomainCombination.obtainInstance("a", "c"))) {
                return false;
            }
            if (!bc1.contains(BasicBinaryDomainCombination.obtainInstance("a", "d"))) {
                return false;
            }
            if (!bc1.contains(BasicBinaryDomainCombination.obtainInstance("a", "e"))) {
                return false;
            }
            if (!bc1.contains(BasicBinaryDomainCombination.obtainInstance("b", "c"))) {
                return false;
            }
            if (!bc1.contains(BasicBinaryDomainCombination.obtainInstance("b", "d"))) {
                return false;
            }
            if (!bc1.contains(BasicBinaryDomainCombination.obtainInstance("b", "e"))) {
                return false;
            }
            if (!bc1.contains(BasicBinaryDomainCombination.obtainInstance("c", "d"))) {
                return false;
            }
            if (!bc1.contains(BasicBinaryDomainCombination.obtainInstance("c", "e"))) {
                return false;
            }
            if (!bc1.contains(BasicBinaryDomainCombination.obtainInstance("d", "e"))) {
                return false;
            }
            if (!bc1.contains(BasicBinaryDomainCombination.obtainInstance("e", "f"))) {
                return false;
            }
            if (!bc1.contains(BasicBinaryDomainCombination.obtainInstance("g", "h"))) {
                return false;
            }
            if (bc1.contains(BasicBinaryDomainCombination.obtainInstance("e", "e"))) {
                return false;
            }
            if (bc1.contains(BasicBinaryDomainCombination.obtainInstance("f", "f"))) {
                return false;
            }
            if (bc1.contains(BasicBinaryDomainCombination.obtainInstance("f", "a"))) {
                return false;
            }
            if (bc1.contains(BasicBinaryDomainCombination.obtainInstance("f", "b"))) {
                return false;
            }
            if (bc1.contains(BasicBinaryDomainCombination.obtainInstance("a", "g"))) {
                return false;
            }
            if (bc1.contains(BasicBinaryDomainCombination.obtainInstance("b", "g"))) {
                return false;
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            return false;
        }
        return true;
    }

    private static boolean testHmmPfamOutputParser(File test_dir) {
        try {
            HmmPfamOutputParser parser = new HmmPfamOutputParser(new File(test_dir + ForesterUtil.getFileSeparator() + "hmmpfam_output"), "human", "ls");
            parser.setEValueMaximum(0.2);
            parser.setIgnoreDufs(true);
            parser.setReturnType(HmmPfamOutputParser.ReturnType.UNORDERED_PROTEIN_DOMAIN_COLLECTION_PER_PROTEIN);
            List<Protein> domain_collections = null;
            domain_collections = parser.parse();
            if (parser.getDomainsEncountered() != 4) {
                return false;
            }
            if (parser.getDomainsIgnoredDueToDuf() != 0) {
                return false;
            }
            if (parser.getDomainsIgnoredDueToEval() != 1) {
                return false;
            }
            if (parser.getDomainsIgnoredDueToOverlap() != 0) {
                return false;
            }
            if (parser.getDomainsStored() != 3) {
                return false;
            }
            if (domain_collections.size() != 1) {
                return false;
            }
            Protein pdc = domain_collections.get(0);
            if (!pdc.getProteinId().equals(new ProteinId("ENSP00000285681"))) {
                return false;
            }
            if (!pdc.getSpecies().getSpeciesId().equals("human")) {
                return false;
            }
            if (pdc.getNumberOfProteinDomains() != 3) {
                return false;
            }
            if (!pdc.getAccession().equals("acc_ENSP00000285681")) {
                return false;
            }
            if (!pdc.getDescription().equals("pep:known chromosome:NCBI36:21:16024215:16174248:1 gene:ENSG00000155313 transcript:ENST00000285681")) {
                return false;
            }
            List<Domain> uba = pdc.getProteinDomains("UBA");
            List<Domain> uim = pdc.getProteinDomains("UIM");
            List<Domain> uch = pdc.getProteinDomains("UCH");
            if (uba.size() != 1) {
                return false;
            }
            if (uim.size() != 2) {
                return false;
            }
            if (uch.size() != 0) {
                return false;
            }
            BasicDomain uim_domain = (BasicDomain)uim.get(1);
            if (!uim_domain.getDomainId().equals("UIM")) {
                return false;
            }
            if (uim_domain.getTotalCount() != 2) {
                return false;
            }
            BasicDomain uba_domain = (BasicDomain)uba.get(0);
            if (!uba_domain.getDomainId().equals("UBA")) {
                return false;
            }
            if (uba_domain.getNumber() != 1) {
                return false;
            }
            if (uba_domain.getTotalCount() != 1) {
                return false;
            }
            if (uba_domain.getFrom() != 16) {
                return false;
            }
            if (uba_domain.getTo() != 57) {
                return false;
            }
            HmmPfamOutputParser parser2 = new HmmPfamOutputParser(new File(test_dir + ForesterUtil.getFileSeparator() + "hmmpfam_output_short"), "human", "ls");
            parser2.setEValueMaximum(0.2);
            parser2.setIgnoreDufs(true);
            parser2.setReturnType(HmmPfamOutputParser.ReturnType.UNORDERED_PROTEIN_DOMAIN_COLLECTION_PER_PROTEIN);
            List<Protein> domain_collections2 = null;
            domain_collections2 = parser2.parse();
            if (parser2.getDomainsEncountered() != 4) {
                return false;
            }
            if (parser.getDomainsIgnoredDueToDuf() != 0) {
                return false;
            }
            if (parser.getDomainsIgnoredDueToEval() != 1) {
                return false;
            }
            if (parser.getDomainsIgnoredDueToOverlap() != 0) {
                return false;
            }
            if (parser2.getDomainsStored() != 3) {
                return false;
            }
            if (domain_collections2.size() != 1) {
                return false;
            }
            Protein pdc2 = domain_collections2.get(0);
            if (!pdc2.getProteinId().getId().equals("ENSP00000285681")) {
                return false;
            }
            if (!pdc2.getSpecies().getSpeciesId().equals("human")) {
                return false;
            }
            if (!pdc2.getName().equals("")) {
                return false;
            }
            if (!pdc2.getAccession().equals("223")) {
                return false;
            }
            if (!pdc2.getDescription().equals("pep:known chromosome:NCBI36:21:16024215:16174248:1 gene:ENSG00000155313 transcript:ENST00000285681")) {
                return false;
            }
            if (pdc2.getNumberOfProteinDomains() != 3) {
                return false;
            }
            List<Domain> uba2 = pdc2.getProteinDomains("UBA");
            List<Domain> uim2 = pdc2.getProteinDomains("UIM");
            List<Domain> uch2 = pdc2.getProteinDomains("UCH");
            if (uba2.size() != 1) {
                return false;
            }
            if (uim2.size() != 2) {
                return false;
            }
            if (uch2.size() != 0) {
                return false;
            }
            BasicDomain uim_domain2 = (BasicDomain)uim2.get(1);
            if (!uim_domain2.getDomainId().equals("UIM")) {
                return false;
            }
            if (uim_domain2.getTotalCount() != 2) {
                return false;
            }
            BasicDomain uba_domain2 = (BasicDomain)uba2.get(0);
            if (!uba_domain2.getDomainId().equals("UBA")) {
                return false;
            }
            if (uba_domain2.getNumber() != 1) {
                return false;
            }
            if (uba_domain2.getTotalCount() != 1) {
                return false;
            }
            if (uba_domain2.getFrom() != 16) {
                return false;
            }
            if (uba_domain2.getTo() != 57) {
                return false;
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            return false;
        }
        return true;
    }

    private static boolean testHmmPfamOutputParserWithFilter(File test_dir) {
        try {
            HmmPfamOutputParser parser = new HmmPfamOutputParser(new File(test_dir + ForesterUtil.getFileSeparator() + "hmmpfam_output3"), "human", "ls");
            parser.setEValueMaximum(0.2);
            parser.setIgnoreDufs(true);
            parser.setReturnType(HmmPfamOutputParser.ReturnType.UNORDERED_PROTEIN_DOMAIN_COLLECTION_PER_PROTEIN);
            List<Protein> proteins = null;
            proteins = parser.parse();
            if (parser.getProteinsIgnoredDueToFilter() != 0) {
                return false;
            }
            if (proteins.size() != 4) {
                return false;
            }
            TreeSet<String> filter = new TreeSet<String>();
            filter.add("beauty");
            filter.add("strange");
            parser = new HmmPfamOutputParser(new File(test_dir + ForesterUtil.getFileSeparator() + "hmmpfam_output3"), "human", filter, HmmPfamOutputParser.FilterType.NEGATIVE_PROTEIN);
            parser.setEValueMaximum(0.2);
            parser.setIgnoreDufs(true);
            parser.setReturnType(HmmPfamOutputParser.ReturnType.UNORDERED_PROTEIN_DOMAIN_COLLECTION_PER_PROTEIN);
            proteins = null;
            proteins = parser.parse();
            if (parser.getProteinsIgnoredDueToFilter() != 0) {
                return false;
            }
            if (proteins.size() != 4) {
                return false;
            }
            filter = new TreeSet();
            filter.add("beauty");
            filter.add("strange");
            parser = new HmmPfamOutputParser(new File(test_dir + ForesterUtil.getFileSeparator() + "hmmpfam_output3"), "human", filter, HmmPfamOutputParser.FilterType.POSITIVE_PROTEIN);
            parser.setEValueMaximum(0.2);
            parser.setIgnoreDufs(true);
            parser.setReturnType(HmmPfamOutputParser.ReturnType.UNORDERED_PROTEIN_DOMAIN_COLLECTION_PER_PROTEIN);
            proteins = null;
            proteins = parser.parse();
            if (parser.getProteinsIgnoredDueToFilter() != 4) {
                return false;
            }
            if (proteins.size() != 0) {
                return false;
            }
            filter = new TreeSet();
            filter.add("UIM");
            filter.add("A");
            filter.add("C");
            parser = new HmmPfamOutputParser(new File(test_dir + ForesterUtil.getFileSeparator() + "hmmpfam_output3"), "human", filter, HmmPfamOutputParser.FilterType.POSITIVE_PROTEIN);
            parser.setEValueMaximum(0.2);
            parser.setIgnoreDufs(true);
            parser.setReturnType(HmmPfamOutputParser.ReturnType.UNORDERED_PROTEIN_DOMAIN_COLLECTION_PER_PROTEIN);
            proteins = null;
            proteins = parser.parse();
            if (parser.getProteinsIgnoredDueToFilter() != 0) {
                return false;
            }
            if (proteins.size() != 4) {
                return false;
            }
            filter = new TreeSet();
            filter.add("UIM");
            filter.add("A");
            filter.add("C");
            filter.add("X");
            parser = new HmmPfamOutputParser(new File(test_dir + ForesterUtil.getFileSeparator() + "hmmpfam_output3"), "human", filter, HmmPfamOutputParser.FilterType.NEGATIVE_DOMAIN);
            parser.setEValueMaximum(0.2);
            parser.setIgnoreDufs(true);
            parser.setReturnType(HmmPfamOutputParser.ReturnType.UNORDERED_PROTEIN_DOMAIN_COLLECTION_PER_PROTEIN);
            proteins = null;
            proteins = parser.parse();
            if (parser.getDomainsIgnoredDueToNegativeDomainFilter() != 7) {
                return false;
            }
            if (proteins.size() != 3) {
                return false;
            }
            filter = new TreeSet();
            filter.add("UIM");
            filter.add("A");
            filter.add("C");
            parser = new HmmPfamOutputParser(new File(test_dir + ForesterUtil.getFileSeparator() + "hmmpfam_output3"), "human", filter, HmmPfamOutputParser.FilterType.NEGATIVE_PROTEIN);
            parser.setEValueMaximum(0.2);
            parser.setIgnoreDufs(true);
            parser.setReturnType(HmmPfamOutputParser.ReturnType.UNORDERED_PROTEIN_DOMAIN_COLLECTION_PER_PROTEIN);
            proteins = null;
            proteins = parser.parse();
            if (parser.getProteinsIgnoredDueToFilter() != 4) {
                return false;
            }
            if (proteins.size() != 0) {
                return false;
            }
            filter = new TreeSet();
            filter.add("UIM");
            parser = new HmmPfamOutputParser(new File(test_dir + ForesterUtil.getFileSeparator() + "hmmpfam_output3"), "human", filter, HmmPfamOutputParser.FilterType.NEGATIVE_PROTEIN);
            parser.setEValueMaximum(0.2);
            parser.setIgnoreDufs(true);
            parser.setReturnType(HmmPfamOutputParser.ReturnType.UNORDERED_PROTEIN_DOMAIN_COLLECTION_PER_PROTEIN);
            proteins = null;
            proteins = parser.parse();
            if (parser.getProteinsIgnoredDueToFilter() != 1) {
                return false;
            }
            if (parser.getProteinsStored() != 3) {
                return false;
            }
            if (proteins.size() != 3) {
                return false;
            }
            filter = new TreeSet();
            filter.add("UIM");
            parser = new HmmPfamOutputParser(new File(test_dir + ForesterUtil.getFileSeparator() + "hmmpfam_output3"), "human", filter, HmmPfamOutputParser.FilterType.POSITIVE_PROTEIN);
            parser.setEValueMaximum(0.2);
            parser.setIgnoreDufs(true);
            parser.setReturnType(HmmPfamOutputParser.ReturnType.UNORDERED_PROTEIN_DOMAIN_COLLECTION_PER_PROTEIN);
            proteins = null;
            proteins = parser.parse();
            if (parser.getProteinsIgnoredDueToFilter() != 3) {
                return false;
            }
            if (parser.getProteinsStored() != 1) {
                return false;
            }
            if (proteins.size() != 1) {
                return false;
            }
            filter = new TreeSet();
            filter.add("A");
            filter.add("C");
            parser = new HmmPfamOutputParser(new File(test_dir + ForesterUtil.getFileSeparator() + "hmmpfam_output3"), "human", filter, HmmPfamOutputParser.FilterType.POSITIVE_PROTEIN);
            parser.setEValueMaximum(0.2);
            parser.setIgnoreDufs(true);
            parser.setReturnType(HmmPfamOutputParser.ReturnType.UNORDERED_PROTEIN_DOMAIN_COLLECTION_PER_PROTEIN);
            proteins = null;
            proteins = parser.parse();
            if (parser.getDomainsEncountered() != 11) {
                return false;
            }
            if (parser.getProteinsEncountered() != 4) {
                return false;
            }
            if (parser.getProteinsIgnoredDueToFilter() != 1) {
                return false;
            }
            if (parser.getProteinsStored() != 3) {
                return false;
            }
            if (proteins.size() != 3) {
                return false;
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            return false;
        }
        return true;
    }

    private static boolean testParsimony() {
        try {
            CharacterStateMatrix.BinaryStates X = CharacterStateMatrix.BinaryStates.PRESENT;
            CharacterStateMatrix.BinaryStates O = CharacterStateMatrix.BinaryStates.ABSENT;
            CharacterStateMatrix.GainLossStates G = CharacterStateMatrix.GainLossStates.GAIN;
            CharacterStateMatrix.GainLossStates L = CharacterStateMatrix.GainLossStates.LOSS;
            CharacterStateMatrix.GainLossStates A = CharacterStateMatrix.GainLossStates.UNCHANGED_ABSENT;
            CharacterStateMatrix.GainLossStates P = CharacterStateMatrix.GainLossStates.UNCHANGED_PRESENT;
            BasicDomain a = new BasicDomain("A", 1, 25, 1, 4, 0.1, -12.0);
            BasicDomain b = new BasicDomain("B", 2, 25, 1, 4, 0.1, -12.0);
            BasicDomain c = new BasicDomain("C", 3, 25, 1, 4, 0.1, -12.0);
            BasicDomain d = new BasicDomain("D", 1, 25, 1, 4, 0.1, -12.0);
            BasicDomain e = new BasicDomain("E", 2, 25, 1, 4, 0.1, -12.0);
            BasicDomain f = new BasicDomain("F", 3, 25, 1, 4, 0.1, -12.0);
            BasicDomain g = new BasicDomain("G", 1, 25, 1, 4, 0.1, -12.0);
            BasicDomain h = new BasicDomain("H", 2, 25, 1, 4, 0.1, -12.0);
            BasicDomain i = new BasicDomain("I", 3, 25, 1, 4, 0.1, -12.0);
            BasicDomain j = new BasicDomain("J", 1, 25, 1, 4, 0.1, -12.0);
            BasicDomain l = new BasicDomain("L", 3, 25, 1, 4, 0.1, -12.0);
            BasicDomain m = new BasicDomain("M", 1, 25, 1, 4, 0.1, -12.0);
            BasicDomain n = new BasicDomain("N", 2, 25, 1, 4, 0.1, -12.0);
            BasicDomain o = new BasicDomain("O", 3, 25, 1, 4, 0.1, -12.0);
            BasicDomain p = new BasicDomain("P", 1, 25, 1, 4, 0.1, -12.0);
            BasicDomain q = new BasicDomain("Q", 2, 25, 1, 4, 0.1, -12.0);
            BasicDomain r = new BasicDomain("R", 3, 25, 1, 4, 0.1, -12.0);
            BasicProtein aa1 = new BasicProtein("aa1", "one", 0);
            aa1.addProteinDomain(a);
            aa1.addProteinDomain(a);
            BasicProtein ab1 = new BasicProtein("ab1", "one", 0);
            ab1.addProteinDomain(a);
            ab1.addProteinDomain(b);
            BasicProtein ac1 = new BasicProtein("ac1", "one", 0);
            ac1.addProteinDomain(a);
            ac1.addProteinDomain(c);
            BasicProtein efgh1 = new BasicProtein("efgh1", "one", 0);
            efgh1.addProteinDomain(e);
            efgh1.addProteinDomain(f);
            efgh1.addProteinDomain(g);
            efgh1.addProteinDomain(h);
            BasicProtein lm1 = new BasicProtein("lm1", "one", 0);
            lm1.addProteinDomain(l);
            lm1.addProteinDomain(m);
            BasicProtein ab2 = new BasicProtein("ab2", "two", 0);
            ab2.addProteinDomain(a);
            ab2.addProteinDomain(b);
            BasicProtein ac2 = new BasicProtein("ac2", "two", 0);
            ac2.addProteinDomain(a);
            ac2.addProteinDomain(c);
            BasicProtein efgi2 = new BasicProtein("efgi2", "two", 0);
            efgi2.addProteinDomain(e);
            efgi2.addProteinDomain(f);
            efgi2.addProteinDomain(g);
            efgi2.addProteinDomain(i);
            BasicProtein no2 = new BasicProtein("no2", "two", 0);
            no2.addProteinDomain(n);
            no2.addProteinDomain(o);
            BasicProtein ab3 = new BasicProtein("ab3", "three", 0);
            ab3.addProteinDomain(a);
            ab3.addProteinDomain(b);
            BasicProtein ad3 = new BasicProtein("ad3", "three", 0);
            ad3.addProteinDomain(a);
            ad3.addProteinDomain(d);
            BasicProtein efgj3 = new BasicProtein("efgj3", "three", 0);
            efgj3.addProteinDomain(e);
            efgj3.addProteinDomain(f);
            efgj3.addProteinDomain(g);
            efgj3.addProteinDomain(j);
            BasicProtein pq3 = new BasicProtein("pq3", "three", 0);
            pq3.addProteinDomain(p);
            pq3.addProteinDomain(q);
            BasicProtein ab4 = new BasicProtein("ab4", "four", 0);
            ab4.addProteinDomain(a);
            ab4.addProteinDomain(b);
            BasicProtein ad4 = new BasicProtein("ad4", "four", 0);
            ad4.addProteinDomain(a);
            ad4.addProteinDomain(d);
            BasicProtein pr4 = new BasicProtein("pr4", "four", 0);
            pr4.addProteinDomain(p);
            pr4.addProteinDomain(r);
            ArrayList<Protein> one_list = new ArrayList<Protein>();
            one_list.add(aa1);
            one_list.add(ab1);
            one_list.add(ac1);
            one_list.add(efgh1);
            one_list.add(lm1);
            ArrayList<Protein> two_list = new ArrayList<Protein>();
            two_list.add(ab2);
            two_list.add(ac2);
            two_list.add(efgi2);
            two_list.add(no2);
            ArrayList<Protein> three_list = new ArrayList<Protein>();
            three_list.add(ab3);
            three_list.add(ad3);
            three_list.add(efgj3);
            three_list.add(pq3);
            ArrayList<Protein> four_list = new ArrayList<Protein>();
            four_list.add(ab4);
            four_list.add(ad4);
            four_list.add(pr4);
            BasicGenomeWideCombinableDomains one = BasicGenomeWideCombinableDomains.createInstance(one_list, false, new BasicSpecies("one"));
            BasicGenomeWideCombinableDomains two = BasicGenomeWideCombinableDomains.createInstance(two_list, false, new BasicSpecies("two"));
            BasicGenomeWideCombinableDomains three = BasicGenomeWideCombinableDomains.createInstance(three_list, false, new BasicSpecies("three"));
            BasicGenomeWideCombinableDomains four = BasicGenomeWideCombinableDomains.createInstance(four_list, false, new BasicSpecies("four"));
            ArrayList<GenomeWideCombinableDomains> gwcd_list = new ArrayList<GenomeWideCombinableDomains>();
            gwcd_list.add(one);
            gwcd_list.add(two);
            gwcd_list.add(three);
            gwcd_list.add(four);
            CharacterStateMatrix<CharacterStateMatrix.BinaryStates> matrix_d = DomainParsimonyCalculator.createMatrixOfDomainPresenceOrAbsence(gwcd_list);
            CharacterStateMatrix<CharacterStateMatrix.BinaryStates> matrix_bc = DomainParsimonyCalculator.createMatrixOfBinaryDomainCombinationPresenceOrAbsence(gwcd_list);
            if (matrix_d.getState(0, 0) != X) {
                return false;
            }
            if (matrix_d.getState(0, 1) != X) {
                return false;
            }
            if (matrix_d.getState(0, 2) != X) {
                return false;
            }
            if (matrix_d.getState(0, 3) != O) {
                return false;
            }
            if (matrix_d.getState(0, 4) != X) {
                return false;
            }
            if (matrix_d.getState(0, 5) != X) {
                return false;
            }
            if (matrix_d.getState(0, 6) != X) {
                return false;
            }
            if (matrix_d.getState(0, 7) != X) {
                return false;
            }
            if (matrix_d.getState(0, 8) != O) {
                return false;
            }
            if (matrix_bc.getState(0, 0) != X) {
                return false;
            }
            if (matrix_bc.getState(0, 1) != X) {
                return false;
            }
            if (matrix_bc.getState(0, 2) != X) {
                return false;
            }
            if (matrix_bc.getState(0, 3) != O) {
                return false;
            }
            if (matrix_bc.getState(0, 4) != X) {
                return false;
            }
            if (matrix_bc.getState(1, 0) != O) {
                return false;
            }
            if (matrix_bc.getState(1, 1) != X) {
                return false;
            }
            if (matrix_bc.getState(1, 2) != X) {
                return false;
            }
            if (matrix_bc.getState(1, 3) != O) {
                return false;
            }
            if (matrix_bc.getState(1, 4) != X) {
                return false;
            }
            if (matrix_bc.getState(2, 0) != O) {
                return false;
            }
            if (matrix_bc.getState(2, 1) != X) {
                return false;
            }
            if (matrix_bc.getState(2, 2) != O) {
                return false;
            }
            if (matrix_bc.getState(2, 3) != X) {
                return false;
            }
            if (matrix_bc.getState(2, 4) != X) {
                return false;
            }
            PhylogenyFactory factory0 = ParserBasedPhylogenyFactory.getInstance();
            String p0_str = "((one,two)1-2,(three,four)3-4)root";
            Phylogeny p0 = factory0.create("((one,two)1-2,(three,four)3-4)root", new NHXParser())[0];
            DomainParsimonyCalculator dp0 = DomainParsimonyCalculator.createInstance(p0, gwcd_list);
            dp0.executeDolloParsimonyOnDomainPresence();
            CharacterStateMatrix<CharacterStateMatrix.GainLossStates> gl_matrix_d = dp0.getGainLossMatrix();
            CharacterStateMatrix<CharacterStateMatrix.BinaryStates> is_matrix_d = dp0.getInternalStatesMatrix();
            dp0.executeDolloParsimonyOnBinaryDomainCombintionPresence();
            CharacterStateMatrix<CharacterStateMatrix.GainLossStates> gl_matrix_bc = dp0.getGainLossMatrix();
            CharacterStateMatrix<CharacterStateMatrix.BinaryStates> is_matrix_bc = dp0.getInternalStatesMatrix();
            if (is_matrix_d.getState("root", "A") != X) {
                return false;
            }
            if (is_matrix_d.getState("root", "B") != X) {
                return false;
            }
            if (is_matrix_d.getState("root", "C") != O) {
                return false;
            }
            if (is_matrix_d.getState("root", "D") != O) {
                return false;
            }
            if (is_matrix_d.getState("root", "E") != X) {
                return false;
            }
            if (is_matrix_bc.getState("root", "A=A") != O) {
                return false;
            }
            if (is_matrix_bc.getState("root", "A=B") != X) {
                return false;
            }
            if (is_matrix_bc.getState("root", "A=C") != O) {
                return false;
            }
            if (is_matrix_bc.getState("root", "A=D") != O) {
                return false;
            }
            if (is_matrix_bc.getState("root", "G=H") != O) {
                return false;
            }
            if (is_matrix_bc.getState("1-2", "G=H") != O) {
                return false;
            }
            if (is_matrix_bc.getState("root", "E=F") != X) {
                return false;
            }
            if (gl_matrix_bc.getState("root", "E=F") != P) {
                return false;
            }
            if (gl_matrix_bc.getState("root", "A=A") != A) {
                return false;
            }
            if (gl_matrix_bc.getState("one", "A=A") != G) {
                return false;
            }
            if (gl_matrix_bc.getState("root", "A=B") != P) {
                return false;
            }
            if (gl_matrix_bc.getState("3-4", "A=D") != G) {
                return false;
            }
            if (gl_matrix_bc.getState("four", "E=F") != L) {
                return false;
            }
            if (gl_matrix_d.getState("3-4", "P") != G) {
                return false;
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            return false;
        }
        return true;
    }

    private static boolean testParsimonyOnSecondaryFeatures() {
        try {
            CharacterStateMatrix.BinaryStates X = CharacterStateMatrix.BinaryStates.PRESENT;
            CharacterStateMatrix.BinaryStates O = CharacterStateMatrix.BinaryStates.ABSENT;
            CharacterStateMatrix.GainLossStates G = CharacterStateMatrix.GainLossStates.GAIN;
            CharacterStateMatrix.GainLossStates L = CharacterStateMatrix.GainLossStates.LOSS;
            CharacterStateMatrix.GainLossStates A = CharacterStateMatrix.GainLossStates.UNCHANGED_ABSENT;
            CharacterStateMatrix.GainLossStates P = CharacterStateMatrix.GainLossStates.UNCHANGED_PRESENT;
            BasicDomain a = new BasicDomain("A", 1, 25, 1, 4, 0.1, -12.0);
            BasicDomain b = new BasicDomain("B", 2, 25, 1, 4, 0.1, -12.0);
            BasicDomain c = new BasicDomain("C", 3, 25, 1, 4, 0.1, -12.0);
            BasicDomain d = new BasicDomain("D", 1, 25, 1, 4, 0.1, -12.0);
            BasicDomain e = new BasicDomain("E", 2, 25, 1, 4, 0.1, -12.0);
            BasicDomain f = new BasicDomain("F", 3, 25, 1, 4, 0.1, -12.0);
            BasicDomain g = new BasicDomain("G", 1, 25, 1, 4, 0.1, -12.0);
            BasicDomain h = new BasicDomain("H", 2, 25, 1, 4, 0.1, -12.0);
            BasicDomain i = new BasicDomain("I", 3, 25, 1, 4, 0.1, -12.0);
            BasicDomain j = new BasicDomain("J", 1, 25, 1, 4, 0.1, -12.0);
            BasicDomain l = new BasicDomain("L", 3, 25, 1, 4, 0.1, -12.0);
            BasicDomain m = new BasicDomain("M", 1, 25, 1, 4, 0.1, -12.0);
            BasicDomain n = new BasicDomain("N", 2, 25, 1, 4, 0.1, -12.0);
            BasicDomain o = new BasicDomain("O", 3, 25, 1, 4, 0.1, -12.0);
            BasicDomain p = new BasicDomain("P", 1, 25, 1, 4, 0.1, -12.0);
            BasicDomain q = new BasicDomain("Q", 2, 25, 1, 4, 0.1, -12.0);
            BasicDomain r = new BasicDomain("R", 3, 25, 1, 4, 0.1, -12.0);
            BasicProtein aa1 = new BasicProtein("aa1", "one", 0);
            aa1.addProteinDomain(a);
            aa1.addProteinDomain(a);
            BasicProtein ab1 = new BasicProtein("ab1", "one", 0);
            ab1.addProteinDomain(a);
            ab1.addProteinDomain(b);
            BasicProtein ac1 = new BasicProtein("ac1", "one", 0);
            ac1.addProteinDomain(a);
            ac1.addProteinDomain(c);
            BasicProtein efgh1 = new BasicProtein("efgh1", "one", 0);
            efgh1.addProteinDomain(e);
            efgh1.addProteinDomain(f);
            efgh1.addProteinDomain(g);
            efgh1.addProteinDomain(h);
            BasicProtein lm1 = new BasicProtein("lm1", "one", 0);
            lm1.addProteinDomain(l);
            lm1.addProteinDomain(m);
            BasicProtein ab2 = new BasicProtein("ab2", "two", 0);
            ab2.addProteinDomain(a);
            ab2.addProteinDomain(b);
            BasicProtein ac2 = new BasicProtein("ac2", "two", 0);
            ac2.addProteinDomain(a);
            ac2.addProteinDomain(c);
            BasicProtein efgi2 = new BasicProtein("efgi2", "two", 0);
            efgi2.addProteinDomain(e);
            efgi2.addProteinDomain(f);
            efgi2.addProteinDomain(g);
            efgi2.addProteinDomain(i);
            BasicProtein no2 = new BasicProtein("no2", "two", 0);
            no2.addProteinDomain(n);
            no2.addProteinDomain(o);
            BasicProtein ab3 = new BasicProtein("ab3", "three", 0);
            ab3.addProteinDomain(a);
            ab3.addProteinDomain(b);
            BasicProtein ad3 = new BasicProtein("ad3", "three", 0);
            ad3.addProteinDomain(a);
            ad3.addProteinDomain(d);
            BasicProtein efgj3 = new BasicProtein("efgj3", "three", 0);
            efgj3.addProteinDomain(e);
            efgj3.addProteinDomain(f);
            efgj3.addProteinDomain(g);
            efgj3.addProteinDomain(j);
            BasicProtein pq3 = new BasicProtein("pq3", "three", 0);
            pq3.addProteinDomain(p);
            pq3.addProteinDomain(q);
            BasicProtein ab4 = new BasicProtein("ab4", "four", 0);
            ab4.addProteinDomain(a);
            ab4.addProteinDomain(b);
            BasicProtein ad4 = new BasicProtein("ad4", "four", 0);
            ad4.addProteinDomain(a);
            ad4.addProteinDomain(d);
            BasicProtein pr4 = new BasicProtein("pr4", "four", 0);
            pr4.addProteinDomain(p);
            pr4.addProteinDomain(r);
            ArrayList<Protein> one_list = new ArrayList<Protein>();
            one_list.add(aa1);
            one_list.add(ab1);
            one_list.add(ac1);
            one_list.add(efgh1);
            one_list.add(lm1);
            ArrayList<Protein> two_list = new ArrayList<Protein>();
            two_list.add(ab2);
            two_list.add(ac2);
            two_list.add(efgi2);
            two_list.add(no2);
            ArrayList<Protein> three_list = new ArrayList<Protein>();
            three_list.add(ab3);
            three_list.add(ad3);
            three_list.add(efgj3);
            three_list.add(pq3);
            ArrayList<Protein> four_list = new ArrayList<Protein>();
            four_list.add(ab4);
            four_list.add(ad4);
            four_list.add(pr4);
            BasicGenomeWideCombinableDomains one = BasicGenomeWideCombinableDomains.createInstance(one_list, false, new BasicSpecies("one"));
            BasicGenomeWideCombinableDomains two = BasicGenomeWideCombinableDomains.createInstance(two_list, false, new BasicSpecies("two"));
            BasicGenomeWideCombinableDomains three = BasicGenomeWideCombinableDomains.createInstance(three_list, false, new BasicSpecies("three"));
            BasicGenomeWideCombinableDomains four = BasicGenomeWideCombinableDomains.createInstance(four_list, false, new BasicSpecies("four"));
            ArrayList<GenomeWideCombinableDomains> gwcd_list = new ArrayList<GenomeWideCombinableDomains>();
            gwcd_list.add(one);
            gwcd_list.add(two);
            gwcd_list.add(three);
            gwcd_list.add(four);
            HashMap<String, Set<String>> map_same = new HashMap<String, Set<String>>();
            HashSet<String> a_s = new HashSet<String>();
            a_s.add("AAA");
            HashSet<String> b_s = new HashSet<String>();
            b_s.add("BBB");
            HashSet<String> c_s = new HashSet<String>();
            c_s.add("CCC");
            HashSet<String> d_s = new HashSet<String>();
            d_s.add("DDD");
            HashSet<String> e_s = new HashSet<String>();
            e_s.add("EEE");
            HashSet<String> f_s = new HashSet<String>();
            f_s.add("FFF");
            HashSet<String> g_s = new HashSet<String>();
            g_s.add("GGG");
            HashSet<String> h_s = new HashSet<String>();
            h_s.add("HHH");
            HashSet<String> i_s = new HashSet<String>();
            i_s.add("III");
            HashSet<String> j_s = new HashSet<String>();
            j_s.add("JJJ");
            HashSet<String> l_s = new HashSet<String>();
            l_s.add("LLL");
            HashSet<String> m_s = new HashSet<String>();
            m_s.add("MMM");
            HashSet<String> n_s = new HashSet<String>();
            n_s.add("NNN");
            HashSet<String> o_s = new HashSet<String>();
            o_s.add("OOO");
            HashSet<String> p_s = new HashSet<String>();
            p_s.add("PPP");
            HashSet<String> q_s = new HashSet<String>();
            q_s.add("QQQ");
            HashSet<String> r_s = new HashSet<String>();
            r_s.add("RRR");
            map_same.put(a.getDomainId(), a_s);
            map_same.put(b.getDomainId(), b_s);
            map_same.put(c.getDomainId(), c_s);
            map_same.put(d.getDomainId(), d_s);
            map_same.put(e.getDomainId(), e_s);
            map_same.put(f.getDomainId(), f_s);
            map_same.put(g.getDomainId(), g_s);
            map_same.put(h.getDomainId(), h_s);
            map_same.put(i.getDomainId(), i_s);
            map_same.put(j.getDomainId(), j_s);
            map_same.put(l.getDomainId(), l_s);
            map_same.put(m.getDomainId(), m_s);
            map_same.put(n.getDomainId(), n_s);
            map_same.put(o.getDomainId(), o_s);
            map_same.put(p.getDomainId(), p_s);
            map_same.put(q.getDomainId(), q_s);
            map_same.put(r.getDomainId(), r_s);
            CharacterStateMatrix<CharacterStateMatrix.BinaryStates> matrix_s = DomainParsimonyCalculator.createMatrixOfSecondaryFeaturePresenceOrAbsence(gwcd_list, map_same, null);
            if (matrix_s.getState(0, 0) != X) {
                return false;
            }
            if (matrix_s.getState(0, 1) != X) {
                return false;
            }
            if (matrix_s.getState(0, 2) != X) {
                return false;
            }
            if (matrix_s.getState(0, 3) != O) {
                return false;
            }
            if (matrix_s.getState(0, 4) != X) {
                return false;
            }
            if (matrix_s.getState(0, 5) != X) {
                return false;
            }
            if (matrix_s.getState(0, 6) != X) {
                return false;
            }
            if (matrix_s.getState(0, 7) != X) {
                return false;
            }
            if (matrix_s.getState(0, 8) != O) {
                return false;
            }
            PhylogenyFactory factory0 = ParserBasedPhylogenyFactory.getInstance();
            String p0_str = "((one,two)1-2,(three,four)3-4)root";
            Phylogeny p0 = factory0.create("((one,two)1-2,(three,four)3-4)root", new NHXParser())[0];
            DomainParsimonyCalculator dp0 = DomainParsimonyCalculator.createInstance(p0, gwcd_list, map_same);
            dp0.executeDolloParsimonyOnSecondaryFeatures(null);
            CharacterStateMatrix<CharacterStateMatrix.GainLossStates> gl_matrix_d = dp0.getGainLossMatrix();
            CharacterStateMatrix<CharacterStateMatrix.BinaryStates> is_matrix_d = dp0.getInternalStatesMatrix();
            if (is_matrix_d.getState("root", "AAA") != X) {
                return false;
            }
            if (is_matrix_d.getState("root", "BBB") != X) {
                return false;
            }
            if (is_matrix_d.getState("root", "CCC") != O) {
                return false;
            }
            if (is_matrix_d.getState("root", "DDD") != O) {
                return false;
            }
            if (is_matrix_d.getState("root", "EEE") != X) {
                return false;
            }
            if (gl_matrix_d.getState("3-4", "PPP") != G) {
                return false;
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            return false;
        }
        return true;
    }

    private static boolean testPaupLogParser(File test_dir) {
        try {
            PaupLogParser parser = new PaupLogParser();
            parser.setSource(new File(test_dir + ForesterUtil.getFileSeparator() + "paup_log_test_1"));
            CharacterStateMatrix<CharacterStateMatrix.BinaryStates> matrix = parser.parse();
            if (matrix.getNumberOfIdentifiers() != 8) {
                return false;
            }
            if (!matrix.getIdentifier(0).equals("MOUSE")) {
                return false;
            }
            if (!matrix.getIdentifier(1).equals("NEMVE")) {
                return false;
            }
            if (!matrix.getIdentifier(2).equals("MONBE")) {
                return false;
            }
            if (!matrix.getIdentifier(3).equals("DICDI")) {
                return false;
            }
            if (!matrix.getIdentifier(4).equals("ARATH")) {
                return false;
            }
            if (!matrix.getIdentifier(5).equals("6")) {
                return false;
            }
            if (!matrix.getIdentifier(6).equals("7")) {
                return false;
            }
            if (!matrix.getIdentifier(7).equals("8")) {
                return false;
            }
            if (matrix.getNumberOfCharacters() != 160) {
                return false;
            }
            if (matrix.getState(0, 4) != CharacterStateMatrix.BinaryStates.ABSENT) {
                return false;
            }
            if (matrix.getState(0, 5) != CharacterStateMatrix.BinaryStates.PRESENT) {
                return false;
            }
            if (matrix.getState(1, 5) != CharacterStateMatrix.BinaryStates.PRESENT) {
                return false;
            }
            if (matrix.getState(7, 154) != CharacterStateMatrix.BinaryStates.ABSENT) {
                return false;
            }
            if (matrix.getState(7, 155) != CharacterStateMatrix.BinaryStates.PRESENT) {
                return false;
            }
            if (matrix.getState(7, 156) != CharacterStateMatrix.BinaryStates.PRESENT) {
                return false;
            }
            if (matrix.getState(7, 157) != CharacterStateMatrix.BinaryStates.ABSENT) {
                return false;
            }
            if (matrix.getState(7, 158) != CharacterStateMatrix.BinaryStates.PRESENT) {
                return false;
            }
            if (matrix.getState(7, 159) != CharacterStateMatrix.BinaryStates.ABSENT) {
                return false;
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            return false;
        }
        return true;
    }
}

