/*
 * Decompiled with CFR 0.152.
 */
package org.forester.util;

import org.forester.util.BasicDescriptiveStatistics;
import org.forester.util.DescriptiveStatistics;
import org.forester.util.ForesterUtil;

public class AsciiHistogram {
    private final DescriptiveStatistics _stats;
    private final String _title;

    public AsciiHistogram(DescriptiveStatistics stats) {
        this._stats = stats;
        this._title = "";
    }

    public AsciiHistogram(DescriptiveStatistics stats, String title) {
        this._stats = stats;
        this._title = title;
    }

    private void drawToStringBuffer(double min, char symbol, int size, int digits, StringBuffer sb, int[] bins, int max_count, int under, int over, double binning_factor, String indent) {
        double draw_factor = (double)max_count / (double)size;
        int counts_size = ForesterUtil.roundToInt(Math.log10(max_count)) + 1;
        if (!ForesterUtil.isEmpty(this.getTitle())) {
            sb.append(this.getTitle());
            sb.append(ForesterUtil.LINE_SEPARATOR);
            sb.append(ForesterUtil.LINE_SEPARATOR);
        }
        if (under > 0) {
            if (!ForesterUtil.isEmpty(indent)) {
                sb.append(indent);
            }
            sb.append("[" + under + "] ");
            sb.append(ForesterUtil.LINE_SEPARATOR);
        }
        for (int i = 0; i < bins.length; ++i) {
            int count = bins[i];
            double label = ForesterUtil.round(min + (double)i * (1.0 / binning_factor), digits);
            if (!ForesterUtil.isEmpty(indent)) {
                sb.append(indent);
            }
            sb.append(ForesterUtil.pad(label + "", digits, '0', false));
            sb.append(" [" + ForesterUtil.pad(count + "", counts_size, ' ', true) + "] ");
            int s = ForesterUtil.roundToInt((double)count / draw_factor);
            for (int j = 0; j < s; ++j) {
                sb.append(symbol);
            }
            sb.append(ForesterUtil.LINE_SEPARATOR);
        }
        if (over > 0) {
            if (!ForesterUtil.isEmpty(indent)) {
                sb.append(indent);
            }
            sb.append("[" + over + "] ");
            sb.append(ForesterUtil.LINE_SEPARATOR);
        }
    }

    private DescriptiveStatistics getDescriptiveStatistics() {
        return this._stats;
    }

    private String getTitle() {
        return this._title;
    }

    public StringBuffer toStringBuffer(double min, double max, int number_of_bins, char symbol, int size, int digits, String indent) {
        int[] bins;
        if (min >= max) {
            throw new IllegalArgumentException("min [" + min + "] is larger than or equal to max [" + max + "]");
        }
        if (number_of_bins < 3) {
            throw new IllegalArgumentException("number of bins is smaller than 3");
        }
        if (size < 2) {
            throw new IllegalArgumentException("size is smaller than 2");
        }
        StringBuffer sb = new StringBuffer();
        int max_count = 0;
        double binning_factor = (double)number_of_bins / (max - min);
        for (int bin : bins = BasicDescriptiveStatistics.performBinning(this.getDescriptiveStatistics().getDataAsDoubleArray(), min, max, number_of_bins)) {
            if (bin <= max_count) continue;
            max_count = bin;
        }
        this.drawToStringBuffer(min, symbol, size, digits, sb, bins, max_count, 0, 0, binning_factor, indent);
        return sb;
    }

    public StringBuffer toStringBuffer(int bins, char symbol, int size, int digits, String indent) {
        return this.toStringBuffer(this.getDescriptiveStatistics().getMin(), this.getDescriptiveStatistics().getMax(), bins, symbol, size, digits, indent);
    }

    public StringBuffer toStringBuffer(int bins, char symbol, int size, int digits) {
        return this.toStringBuffer(this.getDescriptiveStatistics().getMin(), this.getDescriptiveStatistics().getMax(), bins, symbol, size, digits, null);
    }
}

