/*
 * Decompiled with CFR 0.152.
 */
package org.forester.util;

import java.util.HashMap;
import java.util.Map;

public final class TaxonomyUtil {
    private static final Map<String, String> _default_taxcode_taxgroup_map = new HashMap<String, String>();
    private static final Map<String, Integer> FAKE_CODE_TO_ID_MAP;

    public static String getTaxGroupByTaxCode(String code) {
        return _default_taxcode_taxgroup_map.get(code);
    }

    public static int getTaxIdFromFakeTaxCode(String code) {
        return FAKE_CODE_TO_ID_MAP.get(code);
    }

    public static boolean isHasTaxIdFromFakeTaxCode(String code) {
        return FAKE_CODE_TO_ID_MAP.containsKey(code);
    }

    private static void put(String code, String group) {
        if (_default_taxcode_taxgroup_map.containsKey(code)) {
            throw new RuntimeException("duplicate code: " + code);
        }
        _default_taxcode_taxgroup_map.put(code, group);
    }

    static {
        TaxonomyUtil.put("BUFBU", "deuterostomia");
        TaxonomyUtil.put("NOTVI", "deuterostomia");
        TaxonomyUtil.put("SIRIN", "deuterostomia");
        TaxonomyUtil.put("ASTMX", "deuterostomia");
        TaxonomyUtil.put("CALMI", "deuterostomia");
        TaxonomyUtil.put("FICAL", "deuterostomia");
        TaxonomyUtil.put("LEPOC", "deuterostomia");
        TaxonomyUtil.put("LYTVA", "deuterostomia");
        TaxonomyUtil.put("OPHHA", "deuterostomia");
        TaxonomyUtil.put("PYTBI", "deuterostomia");
        TaxonomyUtil.put("PATMI", "deuterostomia");
        TaxonomyUtil.put("HUMAN", "deuterostomia");
        TaxonomyUtil.put("HOMSA", "deuterostomia");
        TaxonomyUtil.put("PANTR", "deuterostomia");
        TaxonomyUtil.put("GORGO", "deuterostomia");
        TaxonomyUtil.put("PONAB", "deuterostomia");
        TaxonomyUtil.put("NOMLE", "deuterostomia");
        TaxonomyUtil.put("MACMU", "deuterostomia");
        TaxonomyUtil.put("PAPHA", "deuterostomia");
        TaxonomyUtil.put("CALJA", "deuterostomia");
        TaxonomyUtil.put("TARSY", "deuterostomia");
        TaxonomyUtil.put("MICMU", "deuterostomia");
        TaxonomyUtil.put("OTOGA", "deuterostomia");
        TaxonomyUtil.put("TUPBE", "deuterostomia");
        TaxonomyUtil.put("MOUSE", "deuterostomia");
        TaxonomyUtil.put("RAT", "deuterostomia");
        TaxonomyUtil.put("MESAU", "deuterostomia");
        TaxonomyUtil.put("DIPOR", "deuterostomia");
        TaxonomyUtil.put("CAVPO", "deuterostomia");
        TaxonomyUtil.put("HETGA", "deuterostomia");
        TaxonomyUtil.put("SPETR", "deuterostomia");
        TaxonomyUtil.put("OCHPR", "deuterostomia");
        TaxonomyUtil.put("RABIT", "deuterostomia");
        TaxonomyUtil.put("BOVIN", "deuterostomia");
        TaxonomyUtil.put("SHEEP", "deuterostomia");
        TaxonomyUtil.put("BALMU", "deuterostomia");
        TaxonomyUtil.put("TURTR", "deuterostomia");
        TaxonomyUtil.put("PIG", "deuterostomia");
        TaxonomyUtil.put("LAMPA", "deuterostomia");
        TaxonomyUtil.put("HORSE", "deuterostomia");
        TaxonomyUtil.put("MYOLU", "deuterostomia");
        TaxonomyUtil.put("PTEVA", "deuterostomia");
        TaxonomyUtil.put("AILME", "deuterostomia");
        TaxonomyUtil.put("CANFA", "deuterostomia");
        TaxonomyUtil.put("FELCA", "deuterostomia");
        TaxonomyUtil.put("ERIEU", "deuterostomia");
        TaxonomyUtil.put("SORAR", "deuterostomia");
        TaxonomyUtil.put("LOXAF", "deuterostomia");
        TaxonomyUtil.put("PROCA", "deuterostomia");
        TaxonomyUtil.put("ECHTE", "deuterostomia");
        TaxonomyUtil.put("CHOHO", "deuterostomia");
        TaxonomyUtil.put("DASNO", "deuterostomia");
        TaxonomyUtil.put("MACEU", "deuterostomia");
        TaxonomyUtil.put("SARHA", "deuterostomia");
        TaxonomyUtil.put("MONDO", "deuterostomia");
        TaxonomyUtil.put("ORNAN", "deuterostomia");
        TaxonomyUtil.put("CHICK", "deuterostomia");
        TaxonomyUtil.put("MELGA", "deuterostomia");
        TaxonomyUtil.put("ANAPL", "deuterostomia");
        TaxonomyUtil.put("TAEGU", "deuterostomia");
        TaxonomyUtil.put("ALLMI", "deuterostomia");
        TaxonomyUtil.put("PELSI", "deuterostomia");
        TaxonomyUtil.put("ANOCA", "deuterostomia");
        TaxonomyUtil.put("XENLA", "deuterostomia");
        TaxonomyUtil.put("XENTR", "deuterostomia");
        TaxonomyUtil.put("MESAL", "deuterostomia");
        TaxonomyUtil.put("OSCOC", "deuterostomia");
        TaxonomyUtil.put("POLSP", "deuterostomia");
        TaxonomyUtil.put("ERPCA", "deuterostomia");
        TaxonomyUtil.put("LATCH", "deuterostomia");
        TaxonomyUtil.put("ORYLA", "deuterostomia");
        TaxonomyUtil.put("XIPMA", "deuterostomia");
        TaxonomyUtil.put("GASAC", "deuterostomia");
        TaxonomyUtil.put("TAKRU", "deuterostomia");
        TaxonomyUtil.put("TETNG", "deuterostomia");
        TaxonomyUtil.put("ORENI", "deuterostomia");
        TaxonomyUtil.put("GADMO", "deuterostomia");
        TaxonomyUtil.put("DANRE", "deuterostomia");
        TaxonomyUtil.put("PETMA", "deuterostomia");
        TaxonomyUtil.put("CIOIN", "deuterostomia");
        TaxonomyUtil.put("CIOSA", "deuterostomia");
        TaxonomyUtil.put("OIKDI", "deuterostomia");
        TaxonomyUtil.put("BRAFL", "deuterostomia");
        TaxonomyUtil.put("SACKO", "deuterostomia");
        TaxonomyUtil.put("STRPU", "deuterostomia");
        TaxonomyUtil.put("HYMMI", "protostomia");
        TaxonomyUtil.put("ECHMU", "protostomia");
        TaxonomyUtil.put("DROSE", "protostomia");
        TaxonomyUtil.put("DROSI", "protostomia");
        TaxonomyUtil.put("DROME", "protostomia");
        TaxonomyUtil.put("DROYA", "protostomia");
        TaxonomyUtil.put("DROER", "protostomia");
        TaxonomyUtil.put("DROAN", "protostomia");
        TaxonomyUtil.put("DROPE", "protostomia");
        TaxonomyUtil.put("DROPS", "protostomia");
        TaxonomyUtil.put("DROWI", "protostomia");
        TaxonomyUtil.put("DROMO", "protostomia");
        TaxonomyUtil.put("DROVI", "protostomia");
        TaxonomyUtil.put("DROGR", "protostomia");
        TaxonomyUtil.put("AEDAE", "protostomia");
        TaxonomyUtil.put("ANOGA", "protostomia");
        TaxonomyUtil.put("CULPI", "protostomia");
        TaxonomyUtil.put("BOMMO", "protostomia");
        TaxonomyUtil.put("DANPL", "protostomia");
        TaxonomyUtil.put("ATTCE", "protostomia");
        TaxonomyUtil.put("ACREC", "protostomia");
        TaxonomyUtil.put("CAMFO", "protostomia");
        TaxonomyUtil.put("APIME", "protostomia");
        TaxonomyUtil.put("NASVI", "protostomia");
        TaxonomyUtil.put("TRICA", "protostomia");
        TaxonomyUtil.put("ACYPI", "protostomia");
        TaxonomyUtil.put("RHOPR", "protostomia");
        TaxonomyUtil.put("PEDHC", "protostomia");
        TaxonomyUtil.put("ARTSF", "protostomia");
        TaxonomyUtil.put("DAPPU", "protostomia");
        TaxonomyUtil.put("HOMAM", "protostomia");
        TaxonomyUtil.put("ANTGC", "protostomia");
        TaxonomyUtil.put("NARAN", "protostomia");
        TaxonomyUtil.put("SCUCO", "protostomia");
        TaxonomyUtil.put("STRMM", "protostomia");
        TaxonomyUtil.put("IXOSC", "protostomia");
        TaxonomyUtil.put("TETUR", "protostomia");
        TaxonomyUtil.put("MESMA", "protostomia");
        TaxonomyUtil.put("LIMPO", "protostomia");
        TaxonomyUtil.put("HYPDU", "protostomia");
        TaxonomyUtil.put("CAEBR", "protostomia");
        TaxonomyUtil.put("CAERE", "protostomia");
        TaxonomyUtil.put("CAEBE", "protostomia");
        TaxonomyUtil.put("CAEEL", "protostomia");
        TaxonomyUtil.put("CAEJA", "protostomia");
        TaxonomyUtil.put("PRIPA", "protostomia");
        TaxonomyUtil.put("BRUMA", "protostomia");
        TaxonomyUtil.put("WUCBA", "protostomia");
        TaxonomyUtil.put("TRISP", "protostomia");
        TaxonomyUtil.put("APLCA", "protostomia");
        TaxonomyUtil.put("LOTGI", "protostomia");
        TaxonomyUtil.put("CRAGI", "protostomia");
        TaxonomyUtil.put("PINFU", "protostomia");
        TaxonomyUtil.put("CAPTE", "protostomia");
        TaxonomyUtil.put("HELRO", "protostomia");
        TaxonomyUtil.put("SCHMA", "protostomia");
        TaxonomyUtil.put("CLOSI", "protostomia");
        TaxonomyUtil.put("SCHMD", "protostomia");
        TaxonomyUtil.put("ANOGL", "protostomia");
        TaxonomyUtil.put("BLAGE", "protostomia");
        TaxonomyUtil.put("ZOONE", "protostomia");
        TaxonomyUtil.put("SCHAM", "protostomia");
        TaxonomyUtil.put("GRYPE", "protostomia");
        TaxonomyUtil.put("ONCFA", "protostomia");
        TaxonomyUtil.put("ACRDI", "cnidaria");
        TaxonomyUtil.put("NEMVE", "cnidaria");
        TaxonomyUtil.put("HYDVU", "cnidaria");
        TaxonomyUtil.put("TRIAD", "placozoa");
        TaxonomyUtil.put("MNELE", "ctenophora");
        TaxonomyUtil.put("AMPQE", "porifera");
        TaxonomyUtil.put("MONBE", "choanoflagellida");
        TaxonomyUtil.put("SALS5", "choanoflagellida");
        TaxonomyUtil.put("SALR5", "choanoflagellida");
        TaxonomyUtil.put("AMOPA", "ichthyophonida & filasterea");
        TaxonomyUtil.put("SARXX", "ichthyophonida & filasterea");
        TaxonomyUtil.put("CAPO3", "ichthyophonida & filasterea");
        TaxonomyUtil.put("AALXX", "dikarya");
        TaxonomyUtil.put("GIBZE", "dikarya");
        TaxonomyUtil.put("HYPVG", "dikarya");
        TaxonomyUtil.put("MAGGR", "dikarya");
        TaxonomyUtil.put("THIHA", "dikarya");
        TaxonomyUtil.put("THITE", "dikarya");
        TaxonomyUtil.put("CHAGB", "dikarya");
        TaxonomyUtil.put("NEUCR", "dikarya");
        TaxonomyUtil.put("BOTF4", "dikarya");
        TaxonomyUtil.put("SCLS1", "dikarya");
        TaxonomyUtil.put("PFIXX", "dikarya");
        TaxonomyUtil.put("MYCGM", "dikarya");
        TaxonomyUtil.put("MYCPJ", "dikarya");
        TaxonomyUtil.put("SPHMS", "dikarya");
        TaxonomyUtil.put("BCOXX", "dikarya");
        TaxonomyUtil.put("APPXX", "dikarya");
        TaxonomyUtil.put("APMXX", "dikarya");
        TaxonomyUtil.put("APSXX", "dikarya");
        TaxonomyUtil.put("COCSA", "dikarya");
        TaxonomyUtil.put("SETTU", "dikarya");
        TaxonomyUtil.put("PYRTR", "dikarya");
        TaxonomyUtil.put("PHANO", "dikarya");
        TaxonomyUtil.put("ASPFN", "dikarya");
        TaxonomyUtil.put("ASPNC", "dikarya");
        TaxonomyUtil.put("ASPCL", "dikarya");
        TaxonomyUtil.put("EMENI", "dikarya");
        TaxonomyUtil.put("NEOFI", "dikarya");
        TaxonomyUtil.put("COCIM", "dikarya");
        TaxonomyUtil.put("UNCRE", "dikarya");
        TaxonomyUtil.put("AJECG", "dikarya");
        TaxonomyUtil.put("TUBMM", "dikarya");
        TaxonomyUtil.put("NAUCC", "dikarya");
        TaxonomyUtil.put("YEAST", "dikarya");
        TaxonomyUtil.put("KLULA", "dikarya");
        TaxonomyUtil.put("ASHGO", "dikarya");
        TaxonomyUtil.put("CANAL", "dikarya");
        TaxonomyUtil.put("CANTT", "dikarya");
        TaxonomyUtil.put("DEBHA", "dikarya");
        TaxonomyUtil.put("YARLI", "dikarya");
        TaxonomyUtil.put("SCHJY", "dikarya");
        TaxonomyUtil.put("SCHOT", "dikarya");
        TaxonomyUtil.put("SCHPO", "dikarya");
        TaxonomyUtil.put("PNECA", "dikarya");
        TaxonomyUtil.put("AGABU", "dikarya");
        TaxonomyUtil.put("COPC7", "dikarya");
        TaxonomyUtil.put("LACBS", "dikarya");
        TaxonomyUtil.put("LACBI", "dikarya");
        TaxonomyUtil.put("PLEOS", "dikarya");
        TaxonomyUtil.put("CPUXX", "dikarya");
        TaxonomyUtil.put("SERL9", "dikarya");
        TaxonomyUtil.put("JARXX", "dikarya");
        TaxonomyUtil.put("GLOTR", "dikarya");
        TaxonomyUtil.put("FPIXX", "dikarya");
        TaxonomyUtil.put("PPLXX", "dikarya");
        TaxonomyUtil.put("TRAVE", "dikarya");
        TaxonomyUtil.put("WOLCO", "dikarya");
        TaxonomyUtil.put("CERSU", "dikarya");
        TaxonomyUtil.put("DICSQ", "dikarya");
        TaxonomyUtil.put("HETAN", "dikarya");
        TaxonomyUtil.put("CRYNE", "dikarya");
        TaxonomyUtil.put("TREME", "dikarya");
        TaxonomyUtil.put("MALGO", "dikarya");
        TaxonomyUtil.put("USTMA", "dikarya");
        TaxonomyUtil.put("MELLP", "dikarya");
        TaxonomyUtil.put("PUCGR", "dikarya");
        TaxonomyUtil.put("RHOGR", "dikarya");
        TaxonomyUtil.put("SPORO", "dikarya");
        TaxonomyUtil.put("WALSC", "dikarya");
        TaxonomyUtil.put("RHIID", "other fungi");
        TaxonomyUtil.put("RHIO9", "other fungi");
        TaxonomyUtil.put("MUCCI", "other fungi");
        TaxonomyUtil.put("PHYBL", "other fungi");
        TaxonomyUtil.put("RHIOR", "other fungi");
        TaxonomyUtil.put("MVNXX", "other fungi");
        TaxonomyUtil.put("CREXX", "other fungi");
        TaxonomyUtil.put("ALLMA", "other fungi");
        TaxonomyUtil.put("BATDJ", "other fungi");
        TaxonomyUtil.put("SPIPN", "other fungi");
        TaxonomyUtil.put("GONPR", "other fungi");
        TaxonomyUtil.put("PIRSE", "other fungi");
        TaxonomyUtil.put("ENCCU", "other fungi");
        TaxonomyUtil.put("ENCHA", "other fungi");
        TaxonomyUtil.put("VITCO", "other fungi");
        TaxonomyUtil.put("ENTBH", "other fungi");
        TaxonomyUtil.put("TRAHO", "other fungi");
        TaxonomyUtil.put("VAVCU", "other fungi");
        TaxonomyUtil.put("EDHAE", "other fungi");
        TaxonomyUtil.put("FALXX", "nucleariidae and fonticula group");
        TaxonomyUtil.put("DICDI", "amoebozoa");
        TaxonomyUtil.put("DICPU", "amoebozoa");
        TaxonomyUtil.put("DICFS", "amoebozoa");
        TaxonomyUtil.put("POLPA", "amoebozoa");
        TaxonomyUtil.put("ENTHI", "amoebozoa");
        TaxonomyUtil.put("ENTDS", "amoebozoa");
        TaxonomyUtil.put("AMBTC", "embryophyta");
        TaxonomyUtil.put("FRAVE", "embryophyta");
        TaxonomyUtil.put("PRUPE", "embryophyta");
        TaxonomyUtil.put("CUCSA", "embryophyta");
        TaxonomyUtil.put("SOYBN", "embryophyta");
        TaxonomyUtil.put("MEDTR", "embryophyta");
        TaxonomyUtil.put("MANES", "embryophyta");
        TaxonomyUtil.put("RICCO", "embryophyta");
        TaxonomyUtil.put("POPTR", "embryophyta");
        TaxonomyUtil.put("ARALY", "embryophyta");
        TaxonomyUtil.put("ARATH", "embryophyta");
        TaxonomyUtil.put("THEHA", "embryophyta");
        TaxonomyUtil.put("CARPA", "embryophyta");
        TaxonomyUtil.put("CCLXX", "embryophyta");
        TaxonomyUtil.put("CITSI", "embryophyta");
        TaxonomyUtil.put("EUCGR", "embryophyta");
        TaxonomyUtil.put("VITVI", "embryophyta");
        TaxonomyUtil.put("SOLLC", "embryophyta");
        TaxonomyUtil.put("SOLPI", "embryophyta");
        TaxonomyUtil.put("SOLTU", "embryophyta");
        TaxonomyUtil.put("TOBAC", "embryophyta");
        TaxonomyUtil.put("MIMGU", "embryophyta");
        TaxonomyUtil.put("AQUCA", "embryophyta");
        TaxonomyUtil.put("SORBI", "embryophyta");
        TaxonomyUtil.put("MAIZE", "embryophyta");
        TaxonomyUtil.put("PANVG", "embryophyta");
        TaxonomyUtil.put("SETIT", "embryophyta");
        TaxonomyUtil.put("ORYSA", "embryophyta");
        TaxonomyUtil.put("ORYSJ", "embryophyta");
        TaxonomyUtil.put("BRADI", "embryophyta");
        TaxonomyUtil.put("HORVD", "embryophyta");
        TaxonomyUtil.put("MUSAM", "embryophyta");
        TaxonomyUtil.put("PICAB", "embryophyta");
        TaxonomyUtil.put("SELML", "embryophyta");
        TaxonomyUtil.put("PHYPA", "embryophyta");
        TaxonomyUtil.put("OSTLU", "chlorophyta");
        TaxonomyUtil.put("ORCXX", "chlorophyta");
        TaxonomyUtil.put("OSTTA", "chlorophyta");
        TaxonomyUtil.put("MICPC", "chlorophyta");
        TaxonomyUtil.put("MICSR", "chlorophyta");
        TaxonomyUtil.put("ASCXX", "chlorophyta");
        TaxonomyUtil.put("CHLVA", "chlorophyta");
        TaxonomyUtil.put("CSUXX", "chlorophyta");
        TaxonomyUtil.put("CHLRE", "chlorophyta");
        TaxonomyUtil.put("VOLCA", "chlorophyta");
        TaxonomyUtil.put("CYAME", "rhodophyta");
        TaxonomyUtil.put("GALSU", "rhodophyta");
        TaxonomyUtil.put("CHOCR", "rhodophyta");
        TaxonomyUtil.put("CYAPA", "glaucocystophyceae");
        TaxonomyUtil.put("EMIHU", "hacrobia");
        TaxonomyUtil.put("GUITH", "hacrobia");
        TaxonomyUtil.put("PLACH", "alveolata");
        TaxonomyUtil.put("PLAF7", "alveolata");
        TaxonomyUtil.put("PLAYO", "alveolata");
        TaxonomyUtil.put("PLAVS", "alveolata");
        TaxonomyUtil.put("THEAN", "alveolata");
        TaxonomyUtil.put("THEPA", "alveolata");
        TaxonomyUtil.put("BABBO", "alveolata");
        TaxonomyUtil.put("EIMAC", "alveolata");
        TaxonomyUtil.put("EIMTE", "alveolata");
        TaxonomyUtil.put("TOXGO", "alveolata");
        TaxonomyUtil.put("CRYHO", "alveolata");
        TaxonomyUtil.put("CRYPV", "alveolata");
        TaxonomyUtil.put("CRYPI", "alveolata");
        TaxonomyUtil.put("CRYCO", "alveolata");
        TaxonomyUtil.put("THOHE", "alveolata");
        TaxonomyUtil.put("PARTE", "alveolata");
        TaxonomyUtil.put("TETTS", "alveolata");
        TaxonomyUtil.put("OTRXX", "alveolata");
        TaxonomyUtil.put("BLEJA", "alveolata");
        TaxonomyUtil.put("PERM5", "alveolata");
        TaxonomyUtil.put("ICHMG", "alveolata");
        TaxonomyUtil.put("FCYXX", "stramenopiles");
        TaxonomyUtil.put("PHATR", "stramenopiles");
        TaxonomyUtil.put("THAPS", "stramenopiles");
        TaxonomyUtil.put("THAOC", "stramenopiles");
        TaxonomyUtil.put("AURAN", "stramenopiles");
        TaxonomyUtil.put("ECTSI", "stramenopiles");
        TaxonomyUtil.put("PHYIN", "stramenopiles");
        TaxonomyUtil.put("PHYRM", "stramenopiles");
        TaxonomyUtil.put("PHYSO", "stramenopiles");
        TaxonomyUtil.put("PHYCI", "stramenopiles");
        TaxonomyUtil.put("PHYCP", "stramenopiles");
        TaxonomyUtil.put("HYAAE", "stramenopiles");
        TaxonomyUtil.put("PYTUL", "stramenopiles");
        TaxonomyUtil.put("AKEXX", "stramenopiles");
        TaxonomyUtil.put("SAGXX", "stramenopiles");
        TaxonomyUtil.put("ALIXX", "stramenopiles");
        TaxonomyUtil.put("BLAHO", "stramenopiles");
        TaxonomyUtil.put("BIGNA", "rhizaria");
        TaxonomyUtil.put("RETFI", "rhizaria");
        TaxonomyUtil.put("TRYB2", "excavata");
        TaxonomyUtil.put("TRYCR", "excavata");
        TaxonomyUtil.put("LEIMA", "excavata");
        TaxonomyUtil.put("LEIIN", "excavata");
        TaxonomyUtil.put("LEIBR", "excavata");
        TaxonomyUtil.put("BODSA", "excavata");
        TaxonomyUtil.put("NAEGR", "excavata");
        TaxonomyUtil.put("GIAIC", "excavata");
        TaxonomyUtil.put("TRIVA", "excavata");
        TaxonomyUtil.put("TTRXX", "apusozoa");
        TaxonomyUtil.put("THEKO", "archaea");
        TaxonomyUtil.put("METAC", "archaea");
        TaxonomyUtil.put("METBF", "archaea");
        TaxonomyUtil.put("METMA", "archaea");
        TaxonomyUtil.put("METBU", "archaea");
        TaxonomyUtil.put("METB6", "archaea");
        TaxonomyUtil.put("METHU", "archaea");
        TaxonomyUtil.put("METMJ", "archaea");
        TaxonomyUtil.put("METLZ", "archaea");
        TaxonomyUtil.put("METTP", "archaea");
        TaxonomyUtil.put("HALMA", "archaea");
        TaxonomyUtil.put("NATPH", "archaea");
        TaxonomyUtil.put("HALS3", "archaea");
        TaxonomyUtil.put("HALSP", "archaea");
        TaxonomyUtil.put("HALWD", "archaea");
        TaxonomyUtil.put("ARCFU", "archaea");
        TaxonomyUtil.put("METJA", "archaea");
        TaxonomyUtil.put("META3", "archaea");
        TaxonomyUtil.put("METMP", "archaea");
        TaxonomyUtil.put("METVS", "archaea");
        TaxonomyUtil.put("METS3", "archaea");
        TaxonomyUtil.put("METST", "archaea");
        TaxonomyUtil.put("METTH", "archaea");
        TaxonomyUtil.put("METKA", "archaea");
        TaxonomyUtil.put("PYRFU", "archaea");
        TaxonomyUtil.put("PYRKO", "archaea");
        TaxonomyUtil.put("PYRAB", "archaea");
        TaxonomyUtil.put("PYRHO", "archaea");
        TaxonomyUtil.put("THEON", "archaea");
        TaxonomyUtil.put("NANEQ", "archaea");
        TaxonomyUtil.put("NITMS", "archaea");
        TaxonomyUtil.put("THEAC", "archaea");
        TaxonomyUtil.put("THEVO", "archaea");
        TaxonomyUtil.put("PICTO", "archaea");
        TaxonomyUtil.put("PYRAR", "archaea");
        TaxonomyUtil.put("PYRCJ", "archaea");
        TaxonomyUtil.put("PYRAE", "archaea");
        TaxonomyUtil.put("PYRIL", "archaea");
        TaxonomyUtil.put("THENV", "archaea");
        TaxonomyUtil.put("CALMQ", "archaea");
        TaxonomyUtil.put("SULAC", "archaea");
        TaxonomyUtil.put("SULTO", "archaea");
        TaxonomyUtil.put("SULSO", "archaea");
        TaxonomyUtil.put("METS5", "archaea");
        TaxonomyUtil.put("AERPE", "archaea");
        TaxonomyUtil.put("STAMF", "archaea");
        TaxonomyUtil.put("THEPD", "archaea");
        TaxonomyUtil.put("HYPBU", "archaea");
        TaxonomyUtil.put("IGNH4", "archaea");
        TaxonomyUtil.put("KORCO", "archaea");
        TaxonomyUtil.put("KORVE", "bacteria");
        TaxonomyUtil.put("ECOLI", "bacteria");
        TaxonomyUtil.put("ECO57", "bacteria");
        TaxonomyUtil.put("SHIFL", "bacteria");
        TaxonomyUtil.put("SALTY", "bacteria");
        TaxonomyUtil.put("YERPE", "bacteria");
        TaxonomyUtil.put("PHOLU", "bacteria");
        TaxonomyUtil.put("PHOPR", "bacteria");
        TaxonomyUtil.put("VIBCH", "bacteria");
        TaxonomyUtil.put("SHEDO", "bacteria");
        TaxonomyUtil.put("PSEF5", "bacteria");
        TaxonomyUtil.put("PSEPF", "bacteria");
        TaxonomyUtil.put("PSEAE", "bacteria");
        TaxonomyUtil.put("CHRSD", "bacteria");
        TaxonomyUtil.put("DECAR", "bacteria");
        TaxonomyUtil.put("RALME", "bacteria");
        TaxonomyUtil.put("NITEU", "bacteria");
        TaxonomyUtil.put("NITMU", "bacteria");
        TaxonomyUtil.put("THIDE", "bacteria");
        TaxonomyUtil.put("ALHEH", "bacteria");
        TaxonomyUtil.put("HALHL", "bacteria");
        TaxonomyUtil.put("NITOC", "bacteria");
        TaxonomyUtil.put("THICR", "bacteria");
        TaxonomyUtil.put("IDILO", "bacteria");
        TaxonomyUtil.put("LEGPN", "bacteria");
        TaxonomyUtil.put("XANAC", "bacteria");
        TaxonomyUtil.put("XYLFT", "bacteria");
        TaxonomyUtil.put("AGRT5", "bacteria");
        TaxonomyUtil.put("RHIEC", "bacteria");
        TaxonomyUtil.put("BRAJA", "bacteria");
        TaxonomyUtil.put("RHOPT", "bacteria");
        TaxonomyUtil.put("RHOS1", "bacteria");
        TaxonomyUtil.put("ROSDO", "bacteria");
        TaxonomyUtil.put("CAUCR", "bacteria");
        TaxonomyUtil.put("ACICY", "bacteria");
        TaxonomyUtil.put("RHORU", "bacteria");
        TaxonomyUtil.put("HAEIN", "bacteria");
        TaxonomyUtil.put("PASMU", "bacteria");
        TaxonomyUtil.put("NEIME", "bacteria");
        TaxonomyUtil.put("ACIFE", "bacteria");
        TaxonomyUtil.put("DESPS", "bacteria");
        TaxonomyUtil.put("DESDE", "bacteria");
        TaxonomyUtil.put("SYNAS", "bacteria");
        TaxonomyUtil.put("GEOME", "bacteria");
        TaxonomyUtil.put("GEOSL", "bacteria");
        TaxonomyUtil.put("ANADE", "bacteria");
        TaxonomyUtil.put("MYXXA", "bacteria");
        TaxonomyUtil.put("ACIBL", "bacteria");
        TaxonomyUtil.put("SOLUS", "bacteria");
        TaxonomyUtil.put("RHOBA", "bacteria");
        TaxonomyUtil.put("KINRD", "bacteria");
        TaxonomyUtil.put("KOCRD", "bacteria");
        TaxonomyUtil.put("MICPN", "bacteria");
        TaxonomyUtil.put("STRCO", "bacteria");
        TaxonomyUtil.put("THEFY", "bacteria");
        TaxonomyUtil.put("MYCLE", "bacteria");
        TaxonomyUtil.put("MYCTU", "bacteria");
        TaxonomyUtil.put("CORJK", "bacteria");
        TaxonomyUtil.put("RHOOB", "bacteria");
        TaxonomyUtil.put("RUBXD", "bacteria");
        TaxonomyUtil.put("CHLAU", "bacteria");
        TaxonomyUtil.put("ROSCS", "bacteria");
        TaxonomyUtil.put("HERAU", "bacteria");
        TaxonomyUtil.put("SPHTD", "bacteria");
        TaxonomyUtil.put("DEIGD", "bacteria");
        TaxonomyUtil.put("DEIRA", "bacteria");
        TaxonomyUtil.put("THET8", "bacteria");
        TaxonomyUtil.put("ANAVT", "bacteria");
        TaxonomyUtil.put("NOSS7", "bacteria");
        TaxonomyUtil.put("NOSP7", "bacteria");
        TaxonomyUtil.put("ACAM1", "bacteria");
        TaxonomyUtil.put("MICAN", "bacteria");
        TaxonomyUtil.put("TRIER", "bacteria");
        TaxonomyUtil.put("SYNEL", "bacteria");
        TaxonomyUtil.put("SYNY3", "bacteria");
        TaxonomyUtil.put("GLOVI", "bacteria");
        TaxonomyUtil.put("PROMA", "bacteria");
        TaxonomyUtil.put("PROMP", "bacteria");
        TaxonomyUtil.put("PROMM", "bacteria");
        TaxonomyUtil.put("SYNS3", "bacteria");
        TaxonomyUtil.put("CHLPB", "bacteria");
        TaxonomyUtil.put("PROAE", "bacteria");
        TaxonomyUtil.put("PELLU", "bacteria");
        TaxonomyUtil.put("PROVI", "bacteria");
        TaxonomyUtil.put("CHLP8", "bacteria");
        TaxonomyUtil.put("CHLTE", "bacteria");
        TaxonomyUtil.put("CHLCH", "bacteria");
        TaxonomyUtil.put("CHLTA", "bacteria");
        TaxonomyUtil.put("FLAJO", "bacteria");
        TaxonomyUtil.put("GRAFK", "bacteria");
        TaxonomyUtil.put("CYTH3", "bacteria");
        TaxonomyUtil.put("BACFR", "bacteria");
        TaxonomyUtil.put("BACTN", "bacteria");
        TaxonomyUtil.put("PORGI", "bacteria");
        TaxonomyUtil.put("SALRD", "bacteria");
        TaxonomyUtil.put("AKKM8", "bacteria");
        TaxonomyUtil.put("METI4", "bacteria");
        TaxonomyUtil.put("LEPIC", "bacteria");
        TaxonomyUtil.put("BACAN", "bacteria");
        TaxonomyUtil.put("BACC3", "bacteria");
        TaxonomyUtil.put("BACSU", "bacteria");
        TaxonomyUtil.put("BACHD", "bacteria");
        TaxonomyUtil.put("GEOKA", "bacteria");
        TaxonomyUtil.put("LISMO", "bacteria");
        TaxonomyUtil.put("STAAU", "bacteria");
        TaxonomyUtil.put("CLOP1", "bacteria");
        TaxonomyUtil.put("CARHZ", "bacteria");
        TaxonomyUtil.put("THETN", "bacteria");
        TaxonomyUtil.put("DESHA", "bacteria");
        TaxonomyUtil.put("EUBR3", "bacteria");
        TaxonomyUtil.put("FERNB", "bacteria");
        TaxonomyUtil.put("THELT", "bacteria");
        TaxonomyUtil.put("THEMA", "bacteria");
        TaxonomyUtil.put("MYCGE", "bacteria");
        TaxonomyUtil.put("MYCPN", "bacteria");
        TaxonomyUtil.put("MESFL", "bacteria");
        TaxonomyUtil.put("UREPA", "bacteria");
        TaxonomyUtil.put("BORBU", "bacteria");
        TaxonomyUtil.put("TREPA", "bacteria");
        TaxonomyUtil.put("CHLPN", "bacteria");
        TaxonomyUtil.put("CHLFF", "bacteria");
        TaxonomyUtil.put("CHLMU", "bacteria");
        TaxonomyUtil.put("RICTY", "bacteria");
        TaxonomyUtil.put("BARHE", "bacteria");
        TaxonomyUtil.put("PELUB", "bacteria");
        TaxonomyUtil.put("RICB8", "bacteria");
        TaxonomyUtil.put("RICRO", "bacteria");
        TaxonomyUtil.put("FRATU", "bacteria");
        TaxonomyUtil.put("STRPN", "bacteria");
        TaxonomyUtil.put("STRPY", "bacteria");
        TaxonomyUtil.put("LACLA", "bacteria");
        TaxonomyUtil.put("LACAC", "bacteria");
        TaxonomyUtil.put("BIFLO", "bacteria");
        TaxonomyUtil.put("FUSNU", "bacteria");
        TaxonomyUtil.put("DEHE1", "bacteria");
        TaxonomyUtil.put("DEHSB", "bacteria");
        TaxonomyUtil.put("NITSB", "bacteria");
        TaxonomyUtil.put("SULNB", "bacteria");
        TaxonomyUtil.put("CAMJE", "bacteria");
        TaxonomyUtil.put("HELPH", "bacteria");
        TaxonomyUtil.put("AQUAE", "bacteria");
        FAKE_CODE_TO_ID_MAP = new HashMap<String, Integer>();
        FAKE_CODE_TO_ID_MAP.put("CTEXX", 283909);
        FAKE_CODE_TO_ID_MAP.put("HMAXX", 6085);
        FAKE_CODE_TO_ID_MAP.put("SARXX", 72019);
        FAKE_CODE_TO_ID_MAP.put("SPHAR", 72019);
        FAKE_CODE_TO_ID_MAP.put("AALXX", 398408);
        FAKE_CODE_TO_ID_MAP.put("PFIXX", 83344);
        FAKE_CODE_TO_ID_MAP.put("MPSXX", 692275);
        FAKE_CODE_TO_ID_MAP.put("BCOXX", 430998);
        FAKE_CODE_TO_ID_MAP.put("APPXX", 178873);
        FAKE_CODE_TO_ID_MAP.put("APMXX", 46634);
        FAKE_CODE_TO_ID_MAP.put("APSXX", 1042127);
        FAKE_CODE_TO_ID_MAP.put("CPUXX", 80637);
        FAKE_CODE_TO_ID_MAP.put("JARXX", 202697);
        FAKE_CODE_TO_ID_MAP.put("FPIXX", 40483);
        FAKE_CODE_TO_ID_MAP.put("PPLXX", 104341);
        FAKE_CODE_TO_ID_MAP.put("MVNXX", 1069443);
        FAKE_CODE_TO_ID_MAP.put("CREXX", 61392);
        FAKE_CODE_TO_ID_MAP.put("FALXX", 691883);
        FAKE_CODE_TO_ID_MAP.put("CCLXX", 85681);
        FAKE_CODE_TO_ID_MAP.put("ORCXX", 385169);
        FAKE_CODE_TO_ID_MAP.put("ASCXX", 763042);
        FAKE_CODE_TO_ID_MAP.put("CSUXX", 574566);
        FAKE_CODE_TO_ID_MAP.put("OTRXX", 1172189);
        FAKE_CODE_TO_ID_MAP.put("FCYXX", 186039);
        FAKE_CODE_TO_ID_MAP.put("AKEXX", 702273);
        FAKE_CODE_TO_ID_MAP.put("SAGXX", 876976);
        FAKE_CODE_TO_ID_MAP.put("ALIXX", 87102);
        FAKE_CODE_TO_ID_MAP.put("TTRXX", 529818);
    }
}

