/*
 * Decompiled with CFR 0.152.
 */
package org.forester.ws.seqdb;

import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.forester.go.GoTerm;
import org.forester.phylogeny.data.Accession;
import org.forester.phylogeny.data.Annotation;
import org.forester.sequence.MolecularSequence;
import org.forester.util.ForesterUtil;
import org.forester.ws.seqdb.SequenceDatabaseEntry;
import org.forester.ws.seqdb.SequenceDbWsTools;

public final class EbiDbEntry
implements SequenceDatabaseEntry {
    private static final boolean DEBUG = false;
    private SortedSet<Annotation> _annotations;
    private String _chromosome;
    private SortedSet<Accession> _cross_references;
    private String _de;
    private String _gene_name;
    private String _map;
    private String _os;
    private String _pa;
    private String _provider;
    private String _symbol;
    private String _tax_id;

    private EbiDbEntry() {
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    @Override
    public String getAccession() {
        return this._pa;
    }

    @Override
    public SortedSet<Annotation> getAnnotations() {
        return this._annotations;
    }

    @Override
    public String getChromosome() {
        return this._chromosome;
    }

    @Override
    public SortedSet<Accession> getCrossReferences() {
        return this._cross_references;
    }

    @Override
    public String getGeneName() {
        return this._gene_name;
    }

    @Override
    public SortedSet<GoTerm> getGoTerms() {
        return null;
    }

    @Override
    public String getMap() {
        return this._map;
    }

    @Override
    public String getProvider() {
        return this._provider;
    }

    @Override
    public String getSequenceName() {
        return this._de;
    }

    @Override
    public String getSequenceSymbol() {
        return this._symbol;
    }

    @Override
    public String getTaxonomyIdentifier() {
        return this._tax_id;
    }

    @Override
    public String getTaxonomyScientificName() {
        return this._os;
    }

    @Override
    public boolean isEmpty() {
        return ForesterUtil.isEmpty(this.getAccession()) && ForesterUtil.isEmpty(this.getSequenceName()) && ForesterUtil.isEmpty(this.getTaxonomyScientificName()) && ForesterUtil.isEmpty(this.getTaxonomyIdentifier()) && ForesterUtil.isEmpty(this.getSequenceSymbol());
    }

    public void setProvider(String provider) {
        this._provider = provider;
    }

    private void addAnnotation(Annotation annotation) {
        if (this._annotations == null) {
            this._annotations = new TreeSet<Annotation>();
        }
        this._annotations.add(annotation);
    }

    private void addCrossReference(Accession accession) {
        if (this._cross_references == null) {
            this._cross_references = new TreeSet<Accession>();
        }
        this._cross_references.add(accession);
    }

    private void setAccession(String pa) {
        if (this._pa == null) {
            this._pa = pa;
        }
    }

    private void setChromosome(String chromosome) {
        this._chromosome = chromosome;
    }

    private void setGeneName(String gene_name) {
        if (this._gene_name == null) {
            this._gene_name = gene_name;
        }
    }

    private void setMap(String map) {
        this._map = map;
    }

    private void setSequenceName(String rec_name) {
        if (this._de == null) {
            this._de = rec_name;
        }
    }

    private void setSequenceSymbol(String symbol) {
        this._symbol = symbol;
    }

    private void setTaxId(String tax_id) {
        if (this._tax_id == null) {
            this._tax_id = tax_id;
        }
    }

    private void setTaxonomyScientificName(String os) {
        if (this._os == null) {
            this._os = os;
        }
    }

    public static SequenceDatabaseEntry createInstanceFromPlainTextForRefSeq(List<String> lines) {
        Pattern X_PATTERN = Pattern.compile("^[A-Z]+");
        Pattern chromosome_PATTERN = Pattern.compile("\\s+/chromosome=\"(\\w+)\"");
        Pattern map_PATTERN = Pattern.compile("\\s+/map=\"([\\w+\\.])\"");
        Pattern gene_PATTERN = Pattern.compile("\\s+/gene=\"(.+)\"");
        Pattern mim_PATTERN = Pattern.compile("\\s+/db_xref=\"MIM:(\\d+)\"");
        Pattern taxon_PATTERN = Pattern.compile("\\s+/db_xref=\"taxon:(\\d+)\"");
        Pattern interpro_PATTERN = Pattern.compile("\\s+/db_xref=\"InterPro:([A-Z0-9]+)\"");
        Pattern uniprot_PATTERN = Pattern.compile("\\s+/db_xref=\"UniProtKB/[A-Za-z-]*:(\\w+)\"");
        Pattern hgnc_PATTERN = Pattern.compile("\\s+/db_xref=\"[A-Z:]*HGNC:(\\d+)\"");
        Pattern geneid_PATTERN = Pattern.compile("\\s+/db_xref=\"GeneID:(\\d+)\"");
        Pattern pdb_PATTERN = Pattern.compile("\\s+/db_xref=\"PDB:([A-Z0-9]+)\"");
        Pattern ec_PATTERN = Pattern.compile("\\s+/EC_number=\"([\\.\\-\\d]+)\"");
        Pattern product_PATTERN = Pattern.compile("\\s+/product=\"(\\w{1,10})\"");
        EbiDbEntry e = new EbiDbEntry();
        StringBuilder def = new StringBuilder();
        boolean in_definition = false;
        boolean in_features = false;
        boolean in_source = false;
        boolean in_gene = false;
        boolean in_cds = false;
        boolean in_mrna = false;
        boolean in_protein = false;
        for (String line : lines) {
            Matcher pdb;
            Matcher product;
            Matcher mim;
            Matcher interpro;
            Matcher uniprot;
            Matcher gene;
            if (line.startsWith("ACCESSION ")) {
                e.setAccession(SequenceDbWsTools.extractFrom(line, "ACCESSION"));
                in_definition = false;
            } else if (line.startsWith("ID ")) {
                e.setAccession(SequenceDbWsTools.extractFromTo(line, "ID", ";"));
                in_definition = false;
            } else if (line.startsWith("DEFINITION ") || line.startsWith("DE ")) {
                boolean definiton = false;
                if (line.startsWith("DEFINITION ")) {
                    definiton = true;
                }
                if (line.indexOf("[") > 0) {
                    if (definiton) {
                        EbiDbEntry.x(def, SequenceDbWsTools.extractFromTo(line, "DEFINITION", "["));
                    } else {
                        EbiDbEntry.x(def, SequenceDbWsTools.extractFromTo(line, "DE", "["));
                    }
                } else if (line.indexOf(".") > 0) {
                    if (definiton) {
                        EbiDbEntry.x(def, SequenceDbWsTools.extractFromTo(line, "DEFINITION", "."));
                    } else {
                        EbiDbEntry.x(def, SequenceDbWsTools.extractFromTo(line, "DE", "."));
                    }
                } else if (definiton) {
                    EbiDbEntry.x(def, SequenceDbWsTools.extractFrom(line, "DEFINITION"));
                } else {
                    EbiDbEntry.x(def, SequenceDbWsTools.extractFrom(line, "DE"));
                }
                if (definiton) {
                    in_definition = true;
                }
            } else if (line.startsWith("  ORGANISM ")) {
                if (line.indexOf("(") > 0) {
                    e.setTaxonomyScientificName(SequenceDbWsTools.extractFromTo(line, "  ORGANISM", "("));
                } else {
                    e.setTaxonomyScientificName(SequenceDbWsTools.extractFrom(line, "  ORGANISM"));
                }
            } else if (line.startsWith("OS ")) {
                if (line.indexOf("(") > 0) {
                    e.setTaxonomyScientificName(SequenceDbWsTools.extractFromTo(line, "OS", "("));
                } else {
                    e.setTaxonomyScientificName(SequenceDbWsTools.extractFrom(line, "OS"));
                }
            } else if (line.startsWith(" ") && in_definition) {
                def.append(" ");
                if (line.indexOf("[") > 0) {
                    def.append(SequenceDbWsTools.extractTo(line, "["));
                } else if (line.indexOf(".") > 0) {
                    def.append(SequenceDbWsTools.extractTo(line, "."));
                } else {
                    def.append(line.trim());
                }
            } else {
                in_definition = false;
            }
            if (!line.startsWith("FT ") && X_PATTERN.matcher(line).find()) {
                in_features = false;
                in_source = false;
                in_gene = false;
                in_cds = false;
                in_mrna = false;
                in_protein = false;
            }
            if (line.startsWith("FEATURES ") || line.startsWith("FT ")) {
                in_features = true;
            }
            if (in_features && (line.startsWith("     source ") || line.startsWith("FT   source "))) {
                in_source = true;
                in_gene = false;
                in_cds = false;
                in_mrna = false;
                in_protein = false;
            }
            if (in_features && (line.startsWith("     gene ") || line.startsWith("FT   gene "))) {
                in_source = false;
                in_gene = true;
                in_cds = false;
                in_mrna = false;
                in_protein = false;
            }
            if (in_features && (line.startsWith("     CDS ") || line.startsWith("FT   CDS "))) {
                in_source = false;
                in_gene = false;
                in_cds = true;
                in_mrna = false;
                in_protein = false;
            }
            if (in_features && (line.startsWith("     Protein ") || line.startsWith("FT   Protein "))) {
                in_source = false;
                in_gene = false;
                in_cds = false;
                in_mrna = false;
                in_protein = true;
            }
            if (in_features && (line.startsWith("     mRNA ") || line.startsWith("FT   mRNA "))) {
                in_source = false;
                in_gene = false;
                in_cds = false;
                in_mrna = true;
                in_protein = false;
            }
            if (in_source) {
                Matcher map;
                Matcher chr;
                Matcher ti = taxon_PATTERN.matcher(line);
                if (ti.find()) {
                    e.setTaxId(ti.group(1));
                }
                if ((chr = chromosome_PATTERN.matcher(line)).find()) {
                    e.setChromosome(chr.group(1));
                }
                if ((map = map_PATTERN.matcher(line)).find()) {
                    e.setMap(map.group(1));
                }
            }
            if (in_cds || in_gene) {
                Matcher geneid;
                Matcher hgnc = hgnc_PATTERN.matcher(line);
                if (hgnc.find()) {
                    e.addCrossReference(new Accession(hgnc.group(1), "hgnc"));
                }
                if ((geneid = geneid_PATTERN.matcher(line)).find()) {
                    e.addCrossReference(new Accession(geneid.group(1), "geneid"));
                }
            }
            if (!in_protein && !in_cds && !in_gene && !in_mrna) continue;
            Matcher ec = ec_PATTERN.matcher(line);
            if (ec.find()) {
                e.addAnnotation(new Annotation("EC", ec.group(1)));
            }
            if ((gene = gene_PATTERN.matcher(line)).find()) {
                e.setGeneName(gene.group(1));
            }
            if ((uniprot = uniprot_PATTERN.matcher(line)).find()) {
                e.addCrossReference(new Accession(uniprot.group(1), "uniprot"));
            }
            if ((interpro = interpro_PATTERN.matcher(line)).find()) {
                e.addCrossReference(new Accession(interpro.group(1), "interpro"));
            }
            if ((mim = mim_PATTERN.matcher(line)).find()) {
                e.addCrossReference(new Accession(mim.group(1), "mim"));
            }
            if ((product = product_PATTERN.matcher(line)).find()) {
                e.setSequenceSymbol(product.group(1));
            }
            if (!(pdb = pdb_PATTERN.matcher(line)).find()) continue;
            e.addCrossReference(new Accession(pdb.group(1), "pdb"));
        }
        if (def.length() > 0) {
            e.setSequenceName(def.toString().trim());
        }
        return e;
    }

    private static void x(StringBuilder sb, String s) {
        if (sb.length() > 0) {
            sb.append(" ");
        }
        sb.append(s.trim());
    }

    @Override
    public MolecularSequence getMolecularSequence() {
        return null;
    }
}

