/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.filter;

import fr.proline.studio.export.ExportFontData;
import fr.proline.studio.extendedtablemodel.ExtraDataType;
import fr.proline.studio.extendedtablemodel.GlobalTableModelInterface;
import fr.proline.studio.filter.Filter;
import fr.proline.studio.filter.FilterTableModelInterface;
import fr.proline.studio.filter.LockedFilterTableModel;
import fr.proline.studio.graphics.PlotInformation;
import fr.proline.studio.graphics.PlotType;
import fr.proline.studio.table.DecoratedTableModel;
import fr.proline.studio.table.LazyData;
import fr.proline.studio.utils.StudioExceptions;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellRenderer;
import org.jdesktop.swingx.JXTable;

public class FilterTableModel
extends DecoratedTableModel
implements FilterTableModelInterface,
TableModelListener {
    protected LinkedHashMap<Integer, Filter> m_filters = null;
    protected HashSet<Integer> m_restrainIds = null;
    protected ArrayList<Integer> m_filteredIds = null;
    private ArrayList<Integer> m_searchIds = null;
    private int m_searchIndex = 0;
    protected GlobalTableModelInterface m_tableModelSource = null;
    private boolean m_isFiltering = false;
    private boolean m_valueBeingSet = false;

    public FilterTableModel(GlobalTableModelInterface tableModelSource) {
        this.setTableModelSource(tableModelSource);
    }

    @Override
    public void setTableModelSource(GlobalTableModelInterface tableModelSource) {
        if (this.m_tableModelSource != null) {
            this.m_tableModelSource.removeTableModelListener(this);
        }
        this.m_tableModelSource = tableModelSource;
        this.m_tableModelSource.addTableModelListener(this);
        this.initFilters();
    }

    @Override
    public GlobalTableModelInterface getTableModelSource() {
        return this.m_tableModelSource;
    }

    @Override
    public LinkedHashMap<Integer, Filter> getFilters() {
        return this.m_filters;
    }

    protected void setFilters(LinkedHashMap<Integer, Filter> filters) {
        this.m_filters = filters;
    }

    @Override
    public Filter getColumnFilter(int col) {
        return this.m_filters.get(col);
    }

    @Override
    public boolean filter(int row) {
        int nbCol = this.getColumnCount();
        for (int i = 0; i < nbCol; ++i) {
            if (this.filter(row, i)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int convertRowToOriginalModel(int row) {
        if (this.m_filteredIds == null) {
            return row;
        }
        return this.m_filteredIds.get(row);
    }

    @Override
    public int convertOriginalModelToRow(int row) {
        if (this.m_filteredIds == null) {
            return row;
        }
        int nb = this.m_filteredIds.size();
        for (int i = 0; i < nb; ++i) {
            if (row != this.m_filteredIds.get(i)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void restrain(HashSet<Integer> restrainRowSet) {
        this.m_restrainIds = restrainRowSet;
        this.filter();
    }

    @Override
    public HashSet<Integer> getRestrainRowSet() {
        return this.m_restrainIds;
    }

    @Override
    public boolean hasRestrain() {
        return this.m_restrainIds != null && !this.m_restrainIds.isEmpty();
    }

    @Override
    public String getToolTipForHeader(int col) {
        return this.m_tableModelSource.getToolTipForHeader(col);
    }

    @Override
    public String getTootlTipValue(int row, int col) {
        int rowFiltered = row;
        if (!this.m_isFiltering && this.m_filteredIds != null) {
            rowFiltered = this.m_filteredIds.get(row);
        }
        return this.m_tableModelSource.getTootlTipValue(rowFiltered, col);
    }

    @Override
    public int getRowCount() {
        if (!this.m_isFiltering && this.m_filteredIds != null) {
            return this.m_filteredIds.size();
        }
        return this.m_tableModelSource.getRowCount();
    }

    @Override
    public int getColumnCount() {
        return this.m_tableModelSource.getColumnCount();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        int rowFiltered = rowIndex;
        if (!this.m_isFiltering && this.m_filteredIds != null) {
            rowFiltered = this.m_filteredIds.get(rowIndex);
        }
        return this.m_tableModelSource.getValueAt(rowFiltered, columnIndex);
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        int rowFiltered = rowIndex;
        if (!this.m_isFiltering && this.m_filteredIds != null) {
            rowFiltered = this.m_filteredIds.get(rowIndex);
        }
        return this.m_tableModelSource.isCellEditable(rowFiltered, columnIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        this.m_valueBeingSet = true;
        try {
            int rowFiltered = rowIndex;
            if (!this.m_isFiltering && this.m_filteredIds != null) {
                rowFiltered = this.m_filteredIds.get(rowIndex);
            }
            this.m_tableModelSource.setValueAt(aValue, rowFiltered, columnIndex);
        }
        finally {
            this.m_valueBeingSet = false;
        }
    }

    public Class getColumnClass(int columnIndex) {
        return this.m_tableModelSource.getColumnClass(columnIndex);
    }

    @Override
    public void initFilters() {
        if (this.m_filters == null) {
            this.m_filters = new LinkedHashMap();
        }
        this.m_tableModelSource.addFilters(this.m_filters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean filter() {
        this.m_searchIds = null;
        try {
            int nbData = this.m_tableModelSource.getRowCount();
            this.m_isFiltering = true;
            try {
                if (this.m_filteredIds == null) {
                    this.m_filteredIds = new ArrayList(nbData);
                } else {
                    this.m_filteredIds.clear();
                }
                for (int i = 0; i < nbData; ++i) {
                    Integer iInteger = i;
                    if (this.m_restrainIds != null && !this.m_restrainIds.isEmpty() && !this.m_restrainIds.contains(iInteger) || !this.filter(i)) continue;
                    this.m_filteredIds.add(iInteger);
                }
            }
            finally {
                this.m_isFiltering = false;
            }
            this.fireTableDataChanged();
        }
        catch (Exception e) {
            StudioExceptions.logAndNotify("ProlineStudio.Commons", "Error during table filtering", e);
        }
        return true;
    }

    @Override
    public boolean filter(int row, int col) {
        Filter filter = this.getColumnFilter(col);
        if (filter == null || !filter.isUsed()) {
            return true;
        }
        int extraCol = filter.getExtraModelColumn();
        return this.filter(filter, row, col, extraCol);
    }

    private boolean filter(Filter filter, int row, int col1, int col2) {
        Object data1 = this.getValueAt(row, col1);
        if ((data1 = filter.convertValue(data1)) == null) {
            return false;
        }
        Object data2 = null;
        if (col2 != -1) {
            data2 = this.getValueAt(row, col2);
        }
        return filter.filter(data1, data2);
    }

    @Override
    public boolean isLoaded() {
        return this.m_tableModelSource.isLoaded();
    }

    @Override
    public int getLoadingPercentage() {
        return this.m_tableModelSource.getLoadingPercentage();
    }

    @Override
    public Long getTaskId() {
        return this.m_tableModelSource.getTaskId();
    }

    @Override
    public LazyData getLazyData(int row, int col) {
        return this.m_tableModelSource.getLazyData(row, col);
    }

    @Override
    public void givePriorityTo(Long taskId, int row, int col) {
        this.m_tableModelSource.givePriorityTo(taskId, row, col);
    }

    @Override
    public void sortingChanged(int col) {
        this.m_searchIds = null;
        this.m_tableModelSource.sortingChanged(col);
    }

    @Override
    public int getSubTaskId(int col) {
        return this.m_tableModelSource.getSubTaskId(col);
    }

    @Override
    public String getDataColumnIdentifier(int columnIndex) {
        return this.m_tableModelSource.getDataColumnIdentifier(columnIndex);
    }

    @Override
    public Class getDataColumnClass(int columnIndex) {
        return this.m_tableModelSource.getDataColumnClass(columnIndex);
    }

    @Override
    public Object getDataValueAt(int rowIndex, int columnIndex) {
        int rowFiltered = rowIndex;
        if (!this.m_isFiltering && this.m_filteredIds != null) {
            rowFiltered = this.m_filteredIds.get(rowIndex);
        }
        return this.m_tableModelSource.getDataValueAt(rowFiltered, columnIndex);
    }

    @Override
    public int[] getKeysColumn() {
        return this.m_tableModelSource.getKeysColumn();
    }

    @Override
    public int getInfoColumn() {
        return this.m_tableModelSource.getInfoColumn();
    }

    @Override
    public void setName(String name) {
        this.m_tableModelSource.setName(name);
    }

    @Override
    public String getName() {
        return this.m_tableModelSource.getName();
    }

    @Override
    public Map<String, Object> getExternalData() {
        return this.m_tableModelSource.getExternalData();
    }

    @Override
    public PlotInformation getPlotInformation() {
        return this.m_tableModelSource.getPlotInformation();
    }

    @Override
    public void addFilters(LinkedHashMap<Integer, Filter> filtersMap) {
        this.m_tableModelSource.addFilters(filtersMap);
    }

    @Override
    public PlotType getBestPlotType() {
        return this.m_tableModelSource.getBestPlotType();
    }

    @Override
    public int[] getBestColIndex(PlotType plotType) {
        return this.m_tableModelSource.getBestColIndex(plotType);
    }

    @Override
    public String getExportRowCell(int row, int col) {
        int rowFiltered = row;
        if (!this.m_isFiltering && this.m_filteredIds != null) {
            rowFiltered = this.m_filteredIds.get(row);
        }
        return this.m_tableModelSource.getExportRowCell(rowFiltered, col);
    }

    @Override
    public ArrayList<ExportFontData> getExportFonts(int row, int col) {
        int rowFiltered = row;
        if (!this.m_isFiltering && this.m_filteredIds != null) {
            rowFiltered = this.m_filteredIds.get(row);
        }
        return this.m_tableModelSource.getExportFonts(rowFiltered, col);
    }

    @Override
    public String getExportColumnName(int col) {
        return this.m_tableModelSource.getExportColumnName(col);
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        if (this.m_valueBeingSet) {
            return;
        }
        this.restrain(null);
    }

    @Override
    public String getColumnName(int column) {
        return this.m_tableModelSource.getColumnName(column);
    }

    @Override
    public TableCellRenderer getRenderer(int row, int col) {
        int rowFiltered = row;
        if (!this.m_isFiltering && this.m_filteredIds != null) {
            rowFiltered = this.m_filteredIds.get(row);
        }
        return this.m_tableModelSource.getRenderer(rowFiltered, col);
    }

    @Override
    public long row2UniqueId(int rowIndex) {
        rowIndex = this.convertRowToOriginalModel(rowIndex);
        return this.m_tableModelSource.row2UniqueId(rowIndex);
    }

    @Override
    public int uniqueId2Row(long id) {
        int rowSource = this.m_tableModelSource.uniqueId2Row(id);
        return this.convertOriginalModelToRow(rowSource);
    }

    @Override
    public GlobalTableModelInterface getFrozzenModel() {
        return new LockedFilterTableModel(this.m_restrainIds, this.m_filteredIds, this.m_tableModelSource);
    }

    @Override
    public int search(JXTable table, Filter filter, boolean newSearch) {
        if (this.m_searchIds == null) {
            this.m_searchIds = new ArrayList();
            newSearch = true;
        }
        if (newSearch) {
            this.m_searchIndex = 0;
            this.m_searchIds.clear();
            int nb = this.getRowCount();
            for (int row = 0; row < nb; ++row) {
                int col;
                int searchRow = table != null ? table.convertRowIndexToModel(row) : row;
                boolean found = this.filter(filter, searchRow, col = filter.getModelColumn(), -1);
                if (!found) continue;
                this.m_searchIds.add(searchRow);
            }
        } else {
            ++this.m_searchIndex;
            if (this.m_searchIndex >= this.m_searchIds.size()) {
                this.m_searchIndex = 0;
            }
        }
        if (this.m_searchIds.isEmpty()) {
            return -1;
        }
        return this.m_searchIds.get(this.m_searchIndex);
    }

    @Override
    public ArrayList<ExtraDataType> getExtraDataTypes() {
        return this.m_tableModelSource.getExtraDataTypes();
    }

    @Override
    public Object getValue(Class c) {
        return this.m_tableModelSource.getValue(c);
    }

    @Override
    public Object getRowValue(Class c, int rowIndex) {
        int rowFiltered = rowIndex;
        if (!this.m_isFiltering && this.m_filteredIds != null) {
            rowFiltered = this.m_filteredIds.get(rowIndex);
        }
        return this.m_tableModelSource.getRowValue(c, rowFiltered);
    }

    @Override
    public Object getColValue(Class c, int col) {
        return this.m_tableModelSource.getColValue(c, col);
    }

    @Override
    public void addSingleValue(Object v) {
        this.m_tableModelSource.addSingleValue(v);
    }

    @Override
    public Object getSingleValue(Class c) {
        return this.m_tableModelSource.getSingleValue(c);
    }

    public String toString() {
        return this.getClass().getName() + this.m_tableModelSource.toString();
    }
}

