/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.graphics;

import fr.proline.studio.export.ExportButton;
import fr.proline.studio.extendedtablemodel.ExtendedTableModelInterface;
import fr.proline.studio.extendedtablemodel.LockedDataModel;
import fr.proline.studio.graphics.BestGraphicsInterface;
import fr.proline.studio.graphics.CrossSelectionInterface;
import fr.proline.studio.graphics.PlotBaseAbstract;
import fr.proline.studio.graphics.PlotHistogram;
import fr.proline.studio.graphics.PlotLinear;
import fr.proline.studio.graphics.PlotPanel;
import fr.proline.studio.graphics.PlotParallelCoordinates;
import fr.proline.studio.graphics.PlotScatter;
import fr.proline.studio.graphics.PlotType;
import fr.proline.studio.graphics.PlotVennDiagram;
import fr.proline.studio.graphics.ReferenceIdName;
import fr.proline.studio.graphics.core.GraphicsToolbarPanel;
import fr.proline.studio.gui.AdvancedSelectionPanel;
import fr.proline.studio.parameter.DefaultParameterDialog;
import fr.proline.studio.parameter.MultiObjectParameter;
import fr.proline.studio.parameter.ParameterList;
import fr.proline.studio.parameter.SettingsButton;
import fr.proline.studio.utils.IconManager;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import org.openide.windows.WindowManager;

public class MonoGraphicsPanel
extends GraphicsToolbarPanel {
    private JComboBox<PlotType> m_allPlotsComboBox;
    private JComboBox<String> m_valueXComboBox;
    private JComboBox<String> m_valueYComboBox;
    private JComboBox<String> m_valueZComboBox;
    private JButton m_selectDataColumnsButton;
    private JLabel m_valueXLabel;
    private JLabel m_valueYLabel;
    private JLabel m_valueZLabel;
    private MultiObjectParameter m_columnsParameter = null;
    private PlotBaseAbstract m_plotGraphics = null;
    private ExtendedTableModelInterface m_values = null;
    private CrossSelectionInterface m_crossSelectionInterface = null;
    private boolean m_isUpdatingCbx = false;

    public MonoGraphicsPanel(boolean dataLocked) {
        super(dataLocked, false);
        this.fillGraphicToolbar();
    }

    public PlotBaseAbstract getPlotGraphics() {
        return this.m_plotGraphics;
    }

    public JPanel getPlotPanel() {
        return this.m_plotPanel;
    }

    @Override
    protected final JPanel createInternalPanel() {
        JPanel internalPanel = new JPanel();
        internalPanel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 1;
        c.insets = new Insets(0, 5, 0, 5);
        PlotPanel panel = new PlotPanel(false);
        this.m_plotPanel = panel.getBasePlotPanel();
        this.m_plotPanel.setPlotToolbarListener(this);
        JPanel selectPanel = this.createSelectPanel();
        c.gridx = 0;
        c.gridy = 0;
        internalPanel.add((Component)selectPanel, c);
        ++c.gridy;
        c.weightx = 1.0;
        c.weighty = 1.0;
        internalPanel.add((Component)panel, c);
        return internalPanel;
    }

    @Override
    public final void fillToolbar(JToolBar toolbar) {
        SettingsButton settingsButton = new SettingsButton(null, this.m_plotPanel);
        this.m_importSelectionButton = new JButton(IconManager.getIcon(IconManager.IconType.IMPORT_TABLE_SELECTION));
        this.m_importSelectionButton.setToolTipText("Import Selection from Previous View");
        this.m_importSelectionButton.setFocusPainted(false);
        this.m_importSelectionButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (MonoGraphicsPanel.this.m_crossSelectionInterface != null) {
                    ArrayList<Long> selection = MonoGraphicsPanel.this.m_crossSelectionInterface.getSelection();
                    MonoGraphicsPanel.this.m_plotPanel.setSelection(selection);
                }
            }
        });
        this.m_exportSelectionButton = new JButton(IconManager.getIcon(IconManager.IconType.EXPORT_TABLE_SELECTION));
        this.m_exportSelectionButton.setToolTipText("Export Selection to Previous View");
        this.m_exportSelectionButton.setFocusPainted(false);
        this.m_exportSelectionButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (MonoGraphicsPanel.this.m_crossSelectionInterface != null) {
                    MonoGraphicsPanel.this.m_crossSelectionInterface.select(MonoGraphicsPanel.this.m_plotPanel.getSelection());
                }
            }
        });
        final JButton lockButton = new JButton(this.m_dataLocked ? IconManager.getIcon(IconManager.IconType.LOCK) : IconManager.getIcon(IconManager.IconType.UNLOCK));
        lockButton.setToolTipText("Lock/Unlock Input Data");
        lockButton.setFocusPainted(false);
        lockButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MonoGraphicsPanel.this.m_dataLocked = !MonoGraphicsPanel.this.m_dataLocked;
                if (MonoGraphicsPanel.this.m_dataLocked) {
                    MonoGraphicsPanel.this.m_values = new LockedDataModel(MonoGraphicsPanel.this.m_values);
                } else {
                    MonoGraphicsPanel.this.m_values = ((LockedDataModel)MonoGraphicsPanel.this.m_values).getSrcDataInterface();
                }
                MonoGraphicsPanel.this.m_plotPanel.lockData(MonoGraphicsPanel.this.m_dataLocked);
                MonoGraphicsPanel.this.setDataImpl(MonoGraphicsPanel.this.m_values, MonoGraphicsPanel.this.m_crossSelectionInterface);
                if (MonoGraphicsPanel.this.m_dataLocked) {
                    lockButton.setIcon(IconManager.getIcon(IconManager.IconType.LOCK));
                } else {
                    lockButton.setIcon(IconManager.getIcon(IconManager.IconType.UNLOCK));
                }
            }
        });
        ExportButton exportImageButton = new ExportButton("Graphic", this.m_plotPanel);
        toolbar.add(settingsButton);
        toolbar.addSeparator();
        toolbar.add(lockButton);
        toolbar.add(this.m_importSelectionButton);
        toolbar.add(this.m_exportSelectionButton);
        toolbar.addSeparator();
        toolbar.add(exportImageButton);
    }

    private JPanel createSelectPanel() {
        JPanel selectPanel = new JPanel();
        selectPanel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        JLabel selectLabel = new JLabel("Graphic :");
        this.m_allPlotsComboBox = new JComboBox<PlotType>(PlotType.ALL_PLOTS);
        this.m_valueXComboBox = new JComboBox();
        this.m_valueYComboBox = new JComboBox();
        this.m_valueZComboBox = new JComboBox();
        this.m_selectDataColumnsButton = new JButton("Select Data Columns");
        this.m_valueXLabel = new JLabel();
        this.m_valueYLabel = new JLabel();
        this.m_valueZLabel = new JLabel();
        this.updateXYCbxVisibility();
        this.m_allPlotsComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (MonoGraphicsPanel.this.m_isUpdatingCbx) {
                    return;
                }
                MonoGraphicsPanel.this.fillXYCombobox(false);
                MonoGraphicsPanel.this.updateXYCbxVisibility();
            }
        });
        this.m_selectDataColumnsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ParameterList parameterList = new ParameterList("MULTI_COLUMNS_GRAPHICS");
                if (MonoGraphicsPanel.this.m_columnsParameter == null) {
                    ArrayList<String> columnNamesArrayList = new ArrayList<String>();
                    ArrayList<Integer> columnIdsArrayList = new ArrayList<Integer>();
                    int nbColumns = MonoGraphicsPanel.this.m_values.getColumnCount();
                    for (int i = 0; i < nbColumns; ++i) {
                        Class c = MonoGraphicsPanel.this.m_values.getDataColumnClass(i);
                        if (!c.equals(Double.class) && !c.equals(Float.class) && !c.equals(Long.class) && !c.equals(Integer.class) && !c.equals(String.class)) continue;
                        columnNamesArrayList.add(MonoGraphicsPanel.this.m_values.getDataColumnIdentifier(i));
                        columnIdsArrayList.add(i);
                    }
                    int nb = columnNamesArrayList.size();
                    boolean[] selection = new boolean[nb];
                    for (int i = 0; i < nb; ++i) {
                        selection[i] = false;
                    }
                    String[] columnNamesArray = columnNamesArrayList.toArray(new String[nb]);
                    Object[] columnIdsArray = columnIdsArrayList.toArray(new Integer[nb]);
                    MonoGraphicsPanel.this.m_columnsParameter = new MultiObjectParameter<String>("MULTI_COLUMNS", "Columns Selection", "Selected Columns", "Unselected Columns", AdvancedSelectionPanel.class, columnNamesArray, columnIdsArray, selection, null);
                }
                parameterList.add(MonoGraphicsPanel.this.m_columnsParameter);
                ArrayList<ParameterList> parameterListArray = new ArrayList<ParameterList>(1);
                parameterListArray.add(parameterList);
                DefaultParameterDialog parameterDialog = new DefaultParameterDialog((Window)WindowManager.getDefault().getMainWindow(), "Columns Parameters", parameterListArray);
                parameterDialog.setLocationRelativeTo(MonoGraphicsPanel.this.m_plotPanel);
                parameterDialog.setVisible(true);
                if (parameterDialog.getButtonClicked() == 0) {
                    ArrayList selectedColumnsList = (ArrayList)MonoGraphicsPanel.this.m_columnsParameter.getAssociatedValues(true);
                    int nbSelected = selectedColumnsList.size();
                    int[] cols = new int[nbSelected];
                    for (int i = 0; i < nbSelected; ++i) {
                        cols[i] = (Integer)selectedColumnsList.get(i);
                    }
                    MonoGraphicsPanel.this.m_plotGraphics.update(cols, null);
                }
            }
        });
        c.gridx = 0;
        c.gridy = 0;
        selectPanel.add((Component)selectLabel, c);
        ++c.gridx;
        selectPanel.add(this.m_allPlotsComboBox, c);
        ++c.gridx;
        selectPanel.add((Component)this.m_valueXLabel, c);
        ++c.gridx;
        selectPanel.add(this.m_valueXComboBox, c);
        ++c.gridx;
        selectPanel.add((Component)this.m_selectDataColumnsButton, c);
        ++c.gridx;
        selectPanel.add((Component)this.m_valueYLabel, c);
        ++c.gridx;
        selectPanel.add(this.m_valueYComboBox, c);
        ++c.gridx;
        selectPanel.add((Component)this.m_valueZLabel, c);
        ++c.gridx;
        selectPanel.add(this.m_valueZComboBox, c);
        ++c.gridx;
        c.weightx = 1.0;
        selectPanel.add(Box.createHorizontalGlue(), c);
        return selectPanel;
    }

    private void updateXYCbxVisibility() {
        PlotType plotType = (PlotType)((Object)this.m_allPlotsComboBox.getSelectedItem());
        this.m_valueXLabel.setVisible(plotType.needsX() || plotType.needsMultiData());
        this.m_valueXComboBox.setVisible(plotType.needsX());
        this.m_selectDataColumnsButton.setVisible(plotType.needsMultiData());
        this.m_valueYLabel.setVisible(plotType.needsY());
        this.m_valueYComboBox.setVisible(plotType.needsY());
        this.m_valueZLabel.setVisible(plotType.needsZ());
        this.m_valueZComboBox.setVisible(plotType.needsZ());
        if (plotType.needsX() || plotType.needsMultiData()) {
            this.m_valueXLabel.setText(plotType.getXLabel());
        }
        if (plotType.needsY()) {
            this.m_valueYLabel.setText(plotType.getYLabel());
        }
        if (plotType.needsZ()) {
            this.m_valueZLabel.setText(plotType.getZLabel());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fillXYCombobox(boolean changePlotType) {
        this.m_isUpdatingCbx = true;
        try {
            BestGraphicsInterface bestGraphics;
            int[] cols;
            if (this.m_values == null) {
                return;
            }
            ((DefaultComboBoxModel)this.m_valueXComboBox.getModel()).removeAllElements();
            ((DefaultComboBoxModel)this.m_valueYComboBox.getModel()).removeAllElements();
            ((DefaultComboBoxModel)this.m_valueZComboBox.getModel()).removeAllElements();
            PlotType plotType = null;
            if (changePlotType && this.m_values instanceof BestGraphicsInterface && (plotType = ((BestGraphicsInterface)((Object)this.m_values)).getBestPlotType()) != null) {
                this.m_allPlotsComboBox.setSelectedItem((Object)plotType);
            }
            if (plotType == null) {
                plotType = (PlotType)((Object)this.m_allPlotsComboBox.getSelectedItem());
            }
            if (changePlotType) {
                this.updateXYCbxVisibility();
            }
            HashSet<Class> acceptedValues = plotType.getAcceptedXValues();
            int nbValuesType = this.m_values.getColumnCount();
            int bestColX = -1;
            int bestColY = -1;
            if (this.m_values instanceof BestGraphicsInterface && (cols = (bestGraphics = (BestGraphicsInterface)((Object)this.m_values)).getBestColIndex(plotType)) != null) {
                bestColX = cols[0];
                bestColY = cols[1];
            }
            int bestColIndexXCbx = 0;
            int bestColIndexYCbx = nbValuesType >= 2 ? 1 : 0;
            int nbValuesInCbx = 0;
            for (int i = 0; i < nbValuesType; ++i) {
                Class c = this.m_values.getDataColumnClass(i);
                if (!acceptedValues.contains(c)) continue;
                ReferenceIdName ref = new ReferenceIdName(this.m_values.getDataColumnIdentifier(i), i);
                ((DefaultComboBoxModel)this.m_valueXComboBox.getModel()).addElement(ref);
                ((DefaultComboBoxModel)this.m_valueYComboBox.getModel()).addElement(ref);
                if (bestColX == i) {
                    bestColIndexXCbx = nbValuesInCbx;
                }
                if (bestColY == i) {
                    bestColIndexYCbx = nbValuesInCbx;
                }
                ++nbValuesInCbx;
            }
            this.m_valueXComboBox.setSelectedIndex(bestColIndexXCbx);
            this.m_valueYComboBox.setSelectedIndex(bestColIndexYCbx);
            if (plotType.needsZ()) {
                ArrayList<String> zValues = plotType.getZValues();
                for (int i = 0; i < zValues.size(); ++i) {
                    ((DefaultComboBoxModel)this.m_valueZComboBox.getModel()).addElement(zValues.get(i));
                }
            }
            this.setDataImpl(this.m_values, this.m_crossSelectionInterface);
        }
        finally {
            this.m_isUpdatingCbx = false;
        }
    }

    public void setXColTypeIndex(int index) {
        DefaultComboBoxModel model = (DefaultComboBoxModel)this.m_valueXComboBox.getModel();
        int count = model.getSize();
        for (int i = 0; i < count; ++i) {
            ReferenceIdName ref = (ReferenceIdName)model.getElementAt(i);
            if (ref.getColumnIndex() != index) continue;
            this.m_valueXComboBox.setSelectedIndex(index);
            break;
        }
    }

    public void setYColTypeIndex(int index) {
        DefaultComboBoxModel model = (DefaultComboBoxModel)this.m_valueYComboBox.getModel();
        int count = model.getSize();
        for (int i = 0; i < count; ++i) {
            ReferenceIdName ref = (ReferenceIdName)model.getElementAt(i);
            if (ref.getColumnIndex() != index) continue;
            this.m_valueYComboBox.setSelectedIndex(index);
            break;
        }
    }

    public void setData(ExtendedTableModelInterface values, CrossSelectionInterface crossSelectionInterface) {
        if (this.m_plotPanel.isLocked()) {
            return;
        }
        if (this.m_dataLocked && !(values instanceof LockedDataModel)) {
            values = new LockedDataModel(values);
        }
        this.setDataImpl(values, crossSelectionInterface);
        if (this.m_dataLocked) {
            this.m_plotPanel.lockData(this.m_dataLocked);
        }
    }

    private void setDataImpl(ExtendedTableModelInterface values, CrossSelectionInterface crossSelectionInterface) {
        this.m_values = values;
        this.m_crossSelectionInterface = crossSelectionInterface;
        if (values == null) {
            return;
        }
        if (this.m_valueXComboBox.getItemCount() == 0) {
            this.fillXYCombobox(true);
            ActionListener actionForXYCbx = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (MonoGraphicsPanel.this.m_isUpdatingCbx) {
                        return;
                    }
                    ReferenceIdName refX = (ReferenceIdName)MonoGraphicsPanel.this.m_valueXComboBox.getSelectedItem();
                    ReferenceIdName refY = (ReferenceIdName)MonoGraphicsPanel.this.m_valueYComboBox.getSelectedItem();
                    String zParameter = (String)MonoGraphicsPanel.this.m_valueZComboBox.getSelectedItem();
                    int[] cols = new int[]{refX.getColumnIndex(), refY.getColumnIndex()};
                    MonoGraphicsPanel.this.m_plotGraphics.update(cols, zParameter);
                }
            };
            this.m_valueXComboBox.addActionListener(actionForXYCbx);
            this.m_valueYComboBox.addActionListener(actionForXYCbx);
            this.m_valueZComboBox.addActionListener(actionForXYCbx);
        }
        PlotType plotType = (PlotType)((Object)this.m_allPlotsComboBox.getSelectedItem());
        int[] cols = null;
        if (this.m_columnsParameter == null) {
            if (this.m_values instanceof BestGraphicsInterface) {
                int j;
                BestGraphicsInterface bestGraphics = (BestGraphicsInterface)((Object)this.m_values);
                cols = bestGraphics.getBestColIndex(PlotType.VENN_DIAGRAM_PLOT);
                if (cols == null) {
                    cols = bestGraphics.getBestColIndex(PlotType.PARALLEL_COORDINATES_PLOT);
                }
                boolean[] done = null;
                if (cols != null) {
                    done = new boolean[cols.length];
                    Arrays.fill(done, Boolean.FALSE);
                }
                ArrayList<String> columnNamesArrayList = new ArrayList<String>();
                ArrayList<Integer> columnIdsArrayList = new ArrayList<Integer>();
                int nbColumns = this.m_values.getColumnCount();
                int indexCur = 0;
                for (int i = 0; i < nbColumns; ++i) {
                    Class c = this.m_values.getDataColumnClass(i);
                    if (c == null || !c.equals(Double.class) && !c.equals(Float.class) && !c.equals(Long.class) && !c.equals(Integer.class) && !c.equals(String.class)) continue;
                    columnNamesArrayList.add(this.m_values.getDataColumnIdentifier(i));
                    columnIdsArrayList.add(i);
                    if (cols != null) {
                        for (j = 0; j < cols.length; ++j) {
                            if (done[j] || cols[j] != i) continue;
                            cols[j] = indexCur;
                            done[j] = true;
                        }
                    }
                    ++indexCur;
                }
                int nb = columnNamesArrayList.size();
                boolean[] selection = new boolean[nb];
                for (int i = 0; i < nb; ++i) {
                    selection[i] = false;
                }
                if (cols != null) {
                    for (j = 0; j < cols.length; ++j) {
                        selection[cols[j]] = true;
                    }
                }
                String[] columnNamesArray = columnNamesArrayList.toArray(new String[nb]);
                Object[] columnIdsArray = columnIdsArrayList.toArray(new Integer[nb]);
                this.m_columnsParameter = new MultiObjectParameter<String>("MULTI_COLUMNS", "Columns Selection", "Selected Columns", "Unselected Columns", AdvancedSelectionPanel.class, columnNamesArray, columnIdsArray, selection, null);
                this.m_columnsParameter.getComponent(null);
            }
        } else {
            ArrayList selectedColumnsList = (ArrayList)this.m_columnsParameter.getAssociatedValues(true);
            int nbSelected = selectedColumnsList.size();
            cols = new int[nbSelected];
            for (int i = 0; i < nbSelected; ++i) {
                cols[i] = (Integer)selectedColumnsList.get(i);
            }
        }
        ReferenceIdName refX = (ReferenceIdName)this.m_valueXComboBox.getSelectedItem();
        ReferenceIdName refY = (ReferenceIdName)this.m_valueYComboBox.getSelectedItem();
        String zParameter = (String)this.m_valueZComboBox.getSelectedItem();
        this.m_gridButton.setEnabled(true);
        this.m_importSelectionButton.setEnabled(true);
        this.m_exportSelectionButton.setEnabled(true);
        switch (plotType) {
            case HISTOGRAM_PLOT: {
                this.m_plotGraphics = new PlotHistogram(this.m_plotPanel, this.m_values, this.m_crossSelectionInterface, refX.getColumnIndex(), zParameter);
                this.m_plotPanel.setPlot(this.m_plotGraphics);
                break;
            }
            case SCATTER_PLOT: {
                this.m_plotGraphics = new PlotScatter(this.m_plotPanel, this.m_values, this.m_crossSelectionInterface, refX.getColumnIndex(), refY.getColumnIndex());
                this.m_plotPanel.setPlot(this.m_plotGraphics);
                break;
            }
            case VENN_DIAGRAM_PLOT: {
                this.m_plotGraphics = new PlotVennDiagram(this.m_plotPanel, this.m_values, this.m_crossSelectionInterface, cols);
                this.m_plotPanel.setPlot(this.m_plotGraphics);
                break;
            }
            case PARALLEL_COORDINATES_PLOT: {
                this.m_plotGraphics = new PlotParallelCoordinates(this.m_plotPanel, this.m_values, this.m_crossSelectionInterface, cols);
                this.m_plotPanel.setPlot(this.m_plotGraphics);
                break;
            }
            case LINEAR_PLOT: {
                this.m_plotGraphics = new PlotLinear(this.m_plotPanel, this.m_values, this.m_crossSelectionInterface, refX.getColumnIndex(), refY.getColumnIndex());
                this.m_plotPanel.setPlot(this.m_plotGraphics);
            }
        }
    }
}

