/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.graphics;

public class PanAxisGesture {
    public static final int X_AXIS_PAN = 0;
    public static final int Y_AXIS_PAN = 1;
    public static final int Y_AT_RIGHT_AXIS_PAN = 2;
    private static final int MIN_PANNING_DELTA = 10;
    public static final int ACTION_NONE = 0;
    public static final int ACTION_PAN = 1;
    private boolean m_isPanning = false;
    private int m_x1;
    private int m_x2;
    private int m_y1;
    private int m_y2;
    private int m_panningAxis;
    private int m_action = 0;

    public int getPanningAxis() {
        return this.m_panningAxis;
    }

    public boolean isPanning() {
        return this.m_isPanning;
    }

    public void startPanning(int x, int y, int panningAxis) {
        this.m_x1 = x;
        this.m_y1 = y;
        this.m_x2 = x;
        this.m_y2 = y;
        this.m_isPanning = true;
        this.m_panningAxis = panningAxis;
        this.m_action = 0;
    }

    public void movePan(int x, int y) {
        boolean yPanning = this.m_panningAxis == 1 || this.m_panningAxis == 2;
        this.m_x2 = x;
        if (yPanning) {
            this.m_y2 = y;
        }
        this.m_action = Math.abs(this.m_x2 - this.m_x1) <= 10 && this.m_panningAxis == 0 || Math.abs(this.m_y2 - this.m_y1) <= 10 && yPanning ? 0 : 1;
    }

    public void stopPanning(int x, int y) {
        this.m_isPanning = false;
        this.m_action = 0;
    }

    public int getPreviousX() {
        return this.m_x2;
    }

    public int getPreviousY() {
        return this.m_y2;
    }

    public int getAction() {
        return this.m_action;
    }
}

