/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.graphics.colorpicker;

import fr.proline.studio.graphics.colorpicker.ColorDataInterface;
import fr.proline.studio.graphics.colorpicker.ColorPalettePanel;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ColorPickerPanel
extends JPanel
implements ColorDataInterface {
    private final int MAIN_SIZE = 200;
    private final int DELTA = 1;
    private final int MARGIN_HEIGHT = 6;
    private final BasicStroke STROKE_1 = new BasicStroke(1.0f);
    private final BasicStroke STROKE_3 = new BasicStroke(3.0f);
    final int PALETTE_DELTA = 4;
    final int PALETTE_SQUARE_SIZE = 18;
    final int PALETTE_WIDTH = 9;
    private boolean m_imageUnset = true;
    private int m_r = 255;
    private int m_g = 255;
    private int m_b = 255;
    private int m_alpha = 255;
    private float m_hue = 0.0f;
    private float m_saturation = 0.0f;
    private float m_brightness = 1.0f;
    private Color[] m_palette = null;
    private boolean m_colorIsChanging = false;
    private final ArrayList<ColorChanged> m_colorChangedListeners = new ArrayList();
    private float[] hsbArray = new float[3];

    public ColorPickerPanel(Color[] palette) {
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        HSBPanel hsbPanel = new HSBPanel();
        c.gridx = 0;
        c.gridy = 0;
        this.add((Component)hsbPanel, c);
        BrightnessSelectionPanel bPanel = new BrightnessSelectionPanel();
        ++c.gridx;
        this.add((Component)bPanel, c);
        RGBSelectionPanel rgbSelectionPanel = new RGBSelectionPanel();
        ++c.gridx;
        c.gridheight = 2;
        c.weighty = 1.0;
        this.add((Component)rgbSelectionPanel, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridheight = 1;
        c.gridwidth = 2;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.anchor = 10;
        c.fill = 0;
        ColorPalettePanel palettePanel = new ColorPalettePanel(this, palette, 18, 4, 9);
        this.add((Component)palettePanel, c);
        this.m_colorChangedListeners.add(rgbSelectionPanel);
    }

    public void setColor(Color c) {
        this.propagateColorChanged(c.getRed(), c.getGreen(), c.getBlue());
        this.propagateAlphaChanged(c.getAlpha());
    }

    public void setColor(int r, int g, int b, int alpha) {
        this.propagateColorChanged(r, g, b);
        this.propagateAlphaChanged(alpha);
    }

    public Color getColor() {
        return new Color(this.m_r, this.m_g, this.m_b, this.m_alpha);
    }

    public void repaintAll() {
        this.m_imageUnset = true;
        this.repaint();
    }

    @Override
    public void propagateColorChanged(int r, int g, int b) {
        this.propagateColorChanged(r, g, b, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void propagateColorChanged(int r, int g, int b, boolean calculateHSB) {
        if (this.m_colorIsChanging) {
            return;
        }
        if (r == this.m_r && g == this.m_g && b == this.m_b) {
            if (!calculateHSB) {
                this.repaintAll();
            }
            return;
        }
        this.m_colorIsChanging = true;
        try {
            this.m_r = r;
            this.m_g = g;
            this.m_b = b;
            if (calculateHSB) {
                this.m_hue = this.getH();
                this.m_saturation = this.getS();
                this.m_brightness = this.getB();
            }
            for (ColorChanged c : this.m_colorChangedListeners) {
                c.colorChanged();
            }
        }
        finally {
            this.m_colorIsChanging = false;
        }
        this.repaintAll();
    }

    public void propagateColorChanged(float h, float s, float b) {
        if (this.m_colorIsChanging) {
            return;
        }
        this.m_hue = h;
        this.m_saturation = s;
        this.m_brightness = b;
        int rgbValue = Color.HSBtoRGB(h, s, b);
        int r2 = (rgbValue & 0xFF0000) >> 16;
        int g2 = (rgbValue & 0xFF00) >> 8;
        int b2 = rgbValue & 0xFF;
        this.propagateColorChanged(r2, g2, b2, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void propagateAlphaChanged(int alpha) {
        if (this.m_colorIsChanging) {
            return;
        }
        this.m_colorIsChanging = true;
        try {
            this.m_alpha = alpha;
            for (ColorChanged c : this.m_colorChangedListeners) {
                c.alphaChanged();
            }
        }
        finally {
            this.m_colorIsChanging = false;
        }
    }

    private float[] getHSBArray() {
        Color.RGBtoHSB(this.m_r, this.m_g, this.m_b, this.hsbArray);
        return this.hsbArray;
    }

    private float getH() {
        return this.getHSBArray()[0];
    }

    private float getS() {
        return this.getHSBArray()[1];
    }

    private float getB() {
        return this.getHSBArray()[2];
    }

    @Override
    public int getRed() {
        return this.m_r;
    }

    @Override
    public int getGreen() {
        return this.m_g;
    }

    @Override
    public int getBlue() {
        return this.m_b;
    }

    @Override
    public void addListener(ColorDataInterface colorDataInterface) {
    }

    private static interface ColorChanged {
        public void colorChanged();

        public void alphaChanged();
    }

    private class SelectedColorPanel
    extends JPanel {
        private final int SQUARE_SIZE = 10;

        @Override
        public void paint(Graphics g) {
            int height = this.getHeight();
            int width = this.getWidth();
            g.setColor(Color.white);
            g.fillRect(0, 0, width - 1, height - 1);
            g.setColor(Color.gray);
            int y = 0;
            do {
                int x = 0;
                do {
                    if ((x + y) % 2 != 0) continue;
                    g.fillRect(x * 10, y * 10, 10, 10);
                } while (++x * 10 <= width);
            } while (++y * 10 <= height);
            g.setColor(new Color(ColorPickerPanel.this.m_r, ColorPickerPanel.this.m_g, ColorPickerPanel.this.m_b, ColorPickerPanel.this.m_alpha));
            g.fillRect(0, 0, width - 1, height - 1);
            g.setColor(Color.black);
            g.drawRect(0, 0, width - 1, height - 1);
        }
    }

    private class RGBSelectionPanel
    extends JPanel
    implements ColorChanged {
        private final JSlider m_RSlider;
        private final JSlider m_GSlider;
        private final JSlider m_BSlider;
        private final JSlider m_ASlider;
        private final JSpinner m_Rspinner;
        private final JSpinner m_Gspinner;
        private final JSpinner m_Bspinner;
        private final JSpinner m_Aspinner;

        private RGBSelectionPanel() {
            this.setLayout(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.anchor = 18;
            c.fill = 1;
            c.insets = new Insets(5, 5, 0, 5);
            JLabel rLabel = new JLabel("Red :");
            JLabel gLabel = new JLabel("Green :");
            JLabel bLabel = new JLabel("Blue :");
            JLabel aLabel = new JLabel("Alpha :");
            this.m_RSlider = new JSlider(0, 255, 255);
            this.m_GSlider = new JSlider(0, 255, 255);
            this.m_BSlider = new JSlider(0, 255, 255);
            this.m_ASlider = new JSlider(0, 255, 255);
            this.m_Rspinner = new JSpinner(new SpinnerNumberModel(255, 0, 255, 1));
            this.m_Gspinner = new JSpinner(new SpinnerNumberModel(255, 0, 255, 1));
            this.m_Bspinner = new JSpinner(new SpinnerNumberModel(255, 0, 255, 1));
            this.m_Aspinner = new JSpinner(new SpinnerNumberModel(255, 0, 255, 1));
            ChangeListener sliderChangeListener = new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    ColorPickerPanel.this.propagateColorChanged(RGBSelectionPanel.this.m_RSlider.getValue(), RGBSelectionPanel.this.m_GSlider.getValue(), RGBSelectionPanel.this.m_BSlider.getValue());
                }
            };
            this.m_RSlider.addChangeListener(sliderChangeListener);
            this.m_GSlider.addChangeListener(sliderChangeListener);
            this.m_BSlider.addChangeListener(sliderChangeListener);
            this.m_ASlider.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    ColorPickerPanel.this.propagateAlphaChanged(RGBSelectionPanel.this.m_ASlider.getValue());
                }
            });
            ChangeListener spinnerChangeListener = new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    int r = ((SpinnerNumberModel)RGBSelectionPanel.this.m_Rspinner.getModel()).getNumber().intValue();
                    int g = ((SpinnerNumberModel)RGBSelectionPanel.this.m_Gspinner.getModel()).getNumber().intValue();
                    int b = ((SpinnerNumberModel)RGBSelectionPanel.this.m_Bspinner.getModel()).getNumber().intValue();
                    ColorPickerPanel.this.propagateColorChanged(r, g, b);
                }
            };
            this.m_Rspinner.addChangeListener(spinnerChangeListener);
            this.m_Gspinner.addChangeListener(spinnerChangeListener);
            this.m_Bspinner.addChangeListener(spinnerChangeListener);
            this.m_Aspinner.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    int alpha = ((SpinnerNumberModel)RGBSelectionPanel.this.m_Aspinner.getModel()).getNumber().intValue();
                    ColorPickerPanel.this.propagateAlphaChanged(alpha);
                }
            });
            c.gridx = 0;
            c.gridy = 0;
            c.anchor = 12;
            this.add((Component)rLabel, c);
            ++c.gridy;
            this.add((Component)gLabel, c);
            ++c.gridy;
            this.add((Component)bLabel, c);
            ++c.gridy;
            this.add((Component)aLabel, c);
            ++c.gridx;
            c.gridy = 0;
            c.weightx = 1.0;
            c.anchor = 18;
            this.add((Component)this.m_RSlider, c);
            ++c.gridy;
            this.add((Component)this.m_GSlider, c);
            ++c.gridy;
            this.add((Component)this.m_BSlider, c);
            ++c.gridy;
            this.add((Component)this.m_ASlider, c);
            ++c.gridx;
            c.gridy = 0;
            c.weightx = 0.0;
            this.add((Component)this.m_Rspinner, c);
            ++c.gridy;
            this.add((Component)this.m_Gspinner, c);
            ++c.gridy;
            this.add((Component)this.m_Bspinner, c);
            ++c.gridy;
            this.add((Component)this.m_Aspinner, c);
            c.gridx = 0;
            ++c.gridy;
            c.gridwidth = 3;
            c.weightx = 1.0;
            c.weighty = 1.0;
            this.add((Component)new SelectedColorPanel(), c);
        }

        @Override
        public void colorChanged() {
            this.m_RSlider.setValue(ColorPickerPanel.this.m_r);
            this.m_GSlider.setValue(ColorPickerPanel.this.m_g);
            this.m_BSlider.setValue(ColorPickerPanel.this.m_b);
            ((SpinnerNumberModel)this.m_Rspinner.getModel()).setValue(ColorPickerPanel.this.m_r);
            ((SpinnerNumberModel)this.m_Gspinner.getModel()).setValue(ColorPickerPanel.this.m_g);
            ((SpinnerNumberModel)this.m_Bspinner.getModel()).setValue(ColorPickerPanel.this.m_b);
        }

        @Override
        public void alphaChanged() {
            this.m_ASlider.setValue(ColorPickerPanel.this.m_alpha);
            ((SpinnerNumberModel)this.m_Aspinner.getModel()).setValue(ColorPickerPanel.this.m_alpha);
            this.repaint();
        }
    }

    private class BrightnessSelectionPanel
    extends JPanel
    implements MouseListener,
    MouseMotionListener {
        private final int TRIANGLE_SIZE = 12;
        private final int COL_WIDTH = 20;
        private final int COL_HEIGHT = 200;
        private final Dimension m_dimension = new Dimension(34, 214);
        private int[] m_triangleX = new int[3];
        private int[] m_triangleY = new int[3];

        public BrightnessSelectionPanel() {
            this.setPreferredSize(this.m_dimension);
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
        }

        @Override
        public void paint(Graphics g) {
            g.setColor(UIManager.getColor("Panel.background"));
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            float h = ColorPickerPanel.this.m_hue;
            float s = ColorPickerPanel.this.m_saturation;
            for (int y = 0; y < 200; ++y) {
                float b = (float)y / 200.0f;
                if (b < 0.0f) {
                    b = 0.0f;
                } else if (b > 1.0f) {
                    b = 1.0f;
                }
                g.setColor(Color.getHSBColor(h, s, b));
                g.drawLine(1, y + 6 + 1, 21, y + 6 + 1);
            }
            int x = 22;
            int yBase = Math.round(ColorPickerPanel.this.m_brightness * 200.0f) + 6 + 1;
            this.m_triangleX[0] = x + 1;
            this.m_triangleY[0] = yBase;
            this.m_triangleX[1] = x + 1 + 6;
            this.m_triangleY[1] = yBase - 6;
            this.m_triangleX[2] = x + 1 + 6;
            this.m_triangleY[2] = yBase + 6;
            g.setColor(Color.black);
            g.fillPolygon(this.m_triangleX, this.m_triangleY, this.m_triangleX.length);
            g.setColor(Color.black);
            g.drawRect(0, 6, 22, 201);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.changeBrightness(e.getY());
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.changeBrightness(e.getY());
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            this.changeBrightness(e.getY());
        }

        @Override
        public void mouseMoved(MouseEvent e) {
        }

        private void changeBrightness(int y) {
            if (y < 7) {
                y = 7;
            } else if (y > 207) {
                y = 207;
            }
            float b = (float)(y -= 7) / 200.0f;
            ColorPickerPanel.this.propagateColorChanged(ColorPickerPanel.this.m_hue, ColorPickerPanel.this.m_saturation, b);
        }
    }

    private class HSBPanel
    extends JPanel
    implements MouseListener,
    MouseMotionListener {
        private final int OVAL_SIZE = 8;
        private final Dimension m_dimension = new Dimension(214, 214);
        private BufferedImage m_image = null;

        public HSBPanel() {
            this.setPreferredSize(this.m_dimension);
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
        }

        @Override
        public void paint(Graphics g) {
            if (ColorPickerPanel.this.m_imageUnset) {
                this.initImage();
                ColorPickerPanel.this.m_imageUnset = false;
            }
            Graphics2D g2d = (Graphics2D)g;
            g2d.drawImage((Image)this.m_image, 0, 0, this);
            int x = 7 + Math.round(ColorPickerPanel.this.m_hue * 200.0f);
            int y = 7 + Math.round(ColorPickerPanel.this.m_saturation * 200.0f);
            g2d.setColor(Color.black);
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2d.setStroke(ColorPickerPanel.this.STROKE_3);
            g.drawOval(x - 4, y - 4, 8, 8);
            g2d.setColor(Color.white);
            g2d.setStroke(ColorPickerPanel.this.STROKE_1);
            g.drawOval(x - 4, y - 4, 8, 8);
        }

        private void initImage() {
            if (this.m_image == null) {
                this.m_image = new BufferedImage(this.m_dimension.width, this.m_dimension.height, 2);
            }
            Graphics2D g2d = this.m_image.createGraphics();
            float b = ColorPickerPanel.this.m_brightness;
            int width = 200;
            int height = 200;
            for (int x = 0; x < width; ++x) {
                float h = (float)x / (float)width;
                if (h < 0.0f) {
                    h = 0.0f;
                } else if (h > 1.0f) {
                    h = 1.0f;
                }
                for (int y = 0; y < height; ++y) {
                    float s = (float)y / (float)height;
                    g2d.setColor(Color.getHSBColor(h, s, b));
                    g2d.drawLine(x + 6 + 1, y + 6 + 1, x + 6 + 1, y + 6 + 1);
                }
            }
            g2d.setColor(Color.black);
            g2d.drawRect(6, 6, 201, 201);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.changeHS(e.getX(), e.getY());
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.changeHS(e.getX(), e.getY());
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            this.changeHS(e.getX(), e.getY());
        }

        @Override
        public void mouseMoved(MouseEvent e) {
        }

        private void changeHS(int x, int y) {
            if (x < 7) {
                x = 7;
            } else if (x > 207) {
                x = 207;
            }
            float h = (float)(x -= 7) / 200.0f;
            if (h < 0.0f) {
                h = 0.0f;
            } else if (h > 1.0f) {
                h = 1.0f;
            }
            if (y < 7) {
                y = 7;
            } else if (y > 207) {
                y = 207;
            }
            float s = (float)(y -= 7) / 200.0f;
            if (s < 0.0f) {
                s = 0.0f;
            } else if (s > 1.0f) {
                s = 1.0f;
            }
            ColorPickerPanel.this.propagateColorChanged(h, s, ColorPickerPanel.this.m_brightness);
        }
    }
}

