/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.graphics.marker;

import fr.proline.studio.graphics.BasePlotPanel;
import fr.proline.studio.graphics.XAxis;
import fr.proline.studio.graphics.YAxis;
import fr.proline.studio.graphics.marker.AbstractMarker;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;

public class XDeltaMarker
extends AbstractMarker {
    private double m_x1;
    private double m_x2;
    private double m_y;

    public XDeltaMarker(BasePlotPanel plotPanel, double x1, double x2, double y) {
        super(plotPanel);
        this.m_x1 = x1;
        this.m_x2 = x2;
        this.m_y = y;
    }

    public void set(double x1, double x2) {
        this.m_x1 = x1;
        this.m_x2 = x2;
    }

    @Override
    public void paint(Graphics2D g) {
        int x2;
        XAxis xAxis = this.m_plotPanel.getXAxis();
        YAxis yAxis = this.m_plotPanel.getYAxis();
        int x1 = xAxis.valueToPixel(this.m_x1);
        if (x1 > (x2 = xAxis.valueToPixel(this.m_x2))) {
            int tmp = x2;
            x2 = x1;
            x1 = tmp;
        }
        int y = yAxis.valueToPixel(this.m_y);
        g.setColor(Color.black);
        g.setStroke(new BasicStroke(1.0f));
        g.drawLine(x1, y, x2, y);
        int ARROW_SIZE = 3;
        g.drawLine(x1, y, x1 + 3, y - 3);
        g.drawLine(x1, y, x1 + 3, y + 3);
        g.drawLine(x2, y, x2 - 3, y - 3);
        g.drawLine(x2, y, x2 - 3, y + 3);
    }
}

