/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.graphics.parallelcoordinates;

import fr.proline.studio.graphics.parallelcoordinates.AbstractValue;

public class NumberValue
extends AbstractValue {
    private boolean m_error = false;
    private Number m_n;

    public NumberValue(Number n, int rowIndex) {
        super(AbstractValue.ValueTypeEnum.NUMBER, rowIndex);
        this.m_n = n;
    }

    public void setValue(Number n) {
        this.m_n = n;
    }

    public String toString() {
        return this.m_n.toString();
    }

    public double doubleValue() {
        return this.m_n.doubleValue();
    }

    @Override
    public int compareTo(AbstractValue o) {
        double v1 = this.m_n.doubleValue();
        double v2 = ((NumberValue)o).m_n.doubleValue();
        if (Double.isNaN(v1)) {
            if (Double.isNaN(v2)) {
                return 0;
            }
            return -1;
        }
        if (Double.isNaN(v2)) {
            return 1;
        }
        double delta = v1 - v2;
        if (delta > 0.0) {
            return 1;
        }
        if (delta < 0.0) {
            return -1;
        }
        return 0;
    }

    @Override
    public boolean isNan() {
        return Double.isNaN(this.doubleValue());
    }

    public void log() {
        this.m_n = Math.log10(this.m_n.doubleValue());
    }

    @Override
    public boolean error() {
        if (this.isNan()) {
            return true;
        }
        return this.m_error;
    }

    public void setError(boolean b) {
        this.m_error = b;
    }
}

