/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.graphics.venndiagram;

import fr.proline.studio.graphics.venndiagram.Calculations;
import fr.proline.studio.graphics.venndiagram.Circle;
import fr.proline.studio.graphics.venndiagram.IntersectArea;
import fr.proline.studio.graphics.venndiagram.Set;
import fr.proline.studio.graphics.venndiagram.SetIntersection;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import org.apache.commons.math3.analysis.MultivariateFunction;
import org.apache.commons.math3.optim.InitialGuess;
import org.apache.commons.math3.optim.MaxEval;
import org.apache.commons.math3.optim.OptimizationData;
import org.apache.commons.math3.optim.nonlinear.scalar.GoalType;
import org.apache.commons.math3.optim.nonlinear.scalar.ObjectiveFunction;
import org.apache.commons.math3.optim.nonlinear.scalar.noderiv.NelderMeadSimplex;
import org.apache.commons.math3.optim.nonlinear.scalar.noderiv.SimplexOptimizer;

public class SetList {
    private final ArrayList<Set> m_setArrayList = new ArrayList(16);
    private final HashMap<Set, Integer> m_setMap = new HashMap();
    private ArrayList<IntersectArea> m_areas = null;
    private int m_scaleX = -1;
    private int m_scaleY = -1;

    public ArrayList<Set> getList() {
        return this.m_setArrayList;
    }

    public void addSet(Set s) {
        int index = this.m_setArrayList.size();
        this.m_setArrayList.add(s);
        this.m_setMap.put(s, index);
    }

    public Set getSet(int i) {
        return this.m_setArrayList.get(i);
    }

    public void addIntersection(Set s1, Set s2, double size) {
        SetIntersection intersection = new SetIntersection(s1, s2, size);
        s1.addIntersection(intersection);
        s2.addIntersection(intersection);
    }

    public void approximateSolution() {
        int nbPositionned = 0;
        int setNb = this.m_setArrayList.size();
        if (setNb == 0) {
            return;
        }
        Set[] setArray = this.m_setArrayList.toArray(new Set[setNb]);
        Arrays.sort(setArray, Collections.reverseOrder());
        Set firstSet = setArray[0];
        firstSet.getCircle().setPosition(0.0, 0.0);
        ++nbPositionned;
        if (setNb == 1) {
            return;
        }
        Set secondSet = null;
        for (int i = 1; i < setNb; ++i) {
            Set s = setArray[i];
            if (!firstSet.intersect(s)) continue;
            secondSet = s;
            break;
        }
        if (secondSet != null) {
            double areaIntersection = firstSet.getIntersection(secondSet);
            double distance = Calculations.circleDistanceForIntersectionArea(0.001, areaIntersection, firstSet.getCircle().getRadius(), secondSet.getCircle().getRadius());
            secondSet.getCircle().setPosition(distance, 0.0);
        } else {
            secondSet = setArray[1];
            secondSet.getCircle().setPosition(firstSet.getCircle().getRadius() + secondSet.getCircle().getRadius(), 0.0);
        }
        ++nbPositionned;
        Arrays.sort(setArray, Collections.reverseOrder());
        ArrayList<Point2D.Double> intersectionPoints = new ArrayList<Point2D.Double>();
        while (nbPositionned < setNb) {
            Circle c2;
            Set setCur = setArray[0];
            Circle cCur = setCur.getCircle();
            Circle[] circles = new Circle[nbPositionned];
            for (int i = setNb - nbPositionned; i < setNb; ++i) {
                Circle c;
                Set set2 = setArray[i];
                c2 = set2.getCircle();
                double distance = setCur.intersect(set2) ? Calculations.circleDistanceForIntersectionArea(0.001, setCur.getIntersection(set2), cCur.getRadius(), c2.getRadius()) : cCur.getRadius() + c2.getRadius();
                circles[i - setNb + nbPositionned] = c = new Circle(c2.getX(), c2.getY(), distance);
            }
            int nbCircles = circles.length;
            for (int i = 0; i < nbCircles; ++i) {
                Circle c1 = circles[i];
                for (int j = i + 1; j < nbCircles; ++j) {
                    c2 = circles[j];
                    Circle.intersection(c1, c2, intersectionPoints);
                }
            }
            if (intersectionPoints.isEmpty()) {
                double positionXMax = Double.NEGATIVE_INFINITY;
                double positionY = 0.0;
                for (int i = setNb - nbPositionned; i < setNb; ++i) {
                    Set set2 = setArray[i];
                    Circle c22 = set2.getCircle();
                    double positionX = c22.getX() + c22.getRadius();
                    if (!(positionX > positionXMax)) continue;
                    positionXMax = positionX;
                    positionY = c22.getY();
                }
                cCur.setPosition(positionXMax + cCur.getRadius(), positionY);
            } else {
                this.generateBarycenterPoints(intersectionPoints);
                Set[] lossCalculationSetArray = new Set[nbPositionned + 1];
                lossCalculationSetArray[0] = setCur;
                for (int i = setNb - nbPositionned; i < setNb; ++i) {
                    lossCalculationSetArray[i - setNb + nbPositionned + 1] = setArray[i];
                }
                double bestLoss = Double.POSITIVE_INFINITY;
                Point2D.Double bestPoint = null;
                for (Point2D.Double point : intersectionPoints) {
                    cCur.setPosition(point.x, point.y);
                    double loss = this.lossFunction(lossCalculationSetArray);
                    if (!(loss < bestLoss)) continue;
                    bestLoss = loss;
                    bestPoint = point;
                }
                cCur.setPosition(bestPoint.x, bestPoint.y);
            }
            ++nbPositionned;
            intersectionPoints.clear();
            Arrays.sort(setArray, Collections.reverseOrder());
        }
    }

    public void optimizeSolution() {
        int nb = this.m_setArrayList.size();
        if (nb < 2) {
            return;
        }
        SimplexOptimizer optimizer = new SimplexOptimizer(1.0E-5, 1.0E-10);
        EvaluateFunction evaluateFunction = new EvaluateFunction(this.m_setArrayList);
        ObjectiveFunction objectiveFunction = new ObjectiveFunction((MultivariateFunction)evaluateFunction);
        int simplexDimension = this.m_setArrayList.size() * 2;
        NelderMeadSimplex simplex = new NelderMeadSimplex(simplexDimension);
        optimizer.optimize(new OptimizationData[]{new MaxEval(1000), objectiveFunction, simplex, GoalType.MINIMIZE, new InitialGuess(evaluateFunction.getCurrentGuess())});
    }

    public void generateAreas() {
        int nb = this.m_setArrayList.size();
        if (nb == 0) {
            return;
        }
        ArrayList<IntersectArea> resultList = new ArrayList<IntersectArea>();
        ArrayList<IntersectArea> todoList = new ArrayList<IntersectArea>();
        resultList.add(new IntersectArea(this.m_setArrayList.get(0)));
        for (int i = 1; i < nb; ++i) {
            todoList.add(new IntersectArea(this.m_setArrayList.get(i)));
        }
        this.m_areas = this.generateAreasImpl(resultList, todoList);
        Collections.sort(this.m_areas);
    }

    private ArrayList<IntersectArea> generateAreasImpl(ArrayList<IntersectArea> resultList, ArrayList<IntersectArea> todoList) {
        if (todoList.isEmpty()) {
            return resultList;
        }
        IntersectArea pivotArea = todoList.remove(todoList.size() - 1);
        ArrayList<IntersectArea> resultListModified = new ArrayList<IntersectArea>(resultList);
        for (IntersectArea area : resultList) {
            ArrayList<IntersectArea> intersectionList = null;
            if (pivotArea.isPotentialIntersect(area)) {
                intersectionList = pivotArea.intersect(area);
            }
            if (intersectionList == null) continue;
            for (IntersectArea a : intersectionList) {
                resultListModified.add(a);
            }
        }
        resultListModified.add(pivotArea);
        return this.generateAreasImpl(resultListModified, todoList);
    }

    public ArrayList<IntersectArea> getGeneratedAreas() {
        return this.m_areas;
    }

    public boolean scale(int width, int height, int margin) {
        if (this.m_scaleX == (width -= 2 * margin) && this.m_scaleY == (height -= 2 * margin)) {
            return false;
        }
        this.m_scaleX = width;
        this.m_scaleY = height;
        double minX = Double.POSITIVE_INFINITY;
        double maxX = Double.NEGATIVE_INFINITY;
        double minY = Double.POSITIVE_INFINITY;
        double maxY = Double.NEGATIVE_INFINITY;
        for (Set set : this.m_setArrayList) {
            Circle c = set.getCircle();
            double x = c.getX();
            double y = c.getY();
            double r = c.getRadius();
            if (x - r < minX) {
                minX = x - r;
            }
            if (x + r > maxX) {
                maxX = x + r;
            }
            if (y - r < minY) {
                minY = y - r;
            }
            if (!(y + r > maxY)) continue;
            maxY = y + r;
        }
        double oldWidth = maxX - minX;
        double scaleFactorX = (double)width / oldWidth;
        double oldHeight = maxY - minY;
        double scaleFactorY = (double)height / oldHeight;
        double scale = scaleFactorX > scaleFactorY ? scaleFactorY : scaleFactorX;
        for (Set set : this.m_setArrayList) {
            Circle c = set.getCircle();
            double x2 = (c.getX() - minX) * scale + (double)margin;
            double y2 = -((c.getY() - minY) * scale - (double)height) + (double)margin;
            double r = c.getRadius() * scale;
            c.scale(x2, y2, r);
        }
        return true;
    }

    private double lossFunction(Set[] setArray) {
        double loss = 0.0;
        int n = setArray.length;
        for (int i = 0; i < n; ++i) {
            Set s1 = setArray[i];
            Circle c1 = s1.getCircle();
            for (int j = i + 1; j < n; ++j) {
                Set s2 = setArray[j];
                Circle c2 = s2.getCircle();
                double area = c1.intersectionArea(c2);
                double wantedArea = s1.getIntersection(s2);
                double delta = wantedArea - area;
                loss += delta * delta;
            }
        }
        return loss;
    }

    private void generateBarycenterPoints(ArrayList<Point2D.Double> srcPoints) {
        Point2D.Double p3;
        int k;
        Point2D.Double p2;
        int j;
        Point2D.Double p1;
        int i;
        int n = srcPoints.size();
        if (n <= 2) {
            return;
        }
        for (i = 0; i < n; ++i) {
            p1 = srcPoints.get(i);
            for (j = i + 1; j < n; ++j) {
                p2 = srcPoints.get(j);
                srcPoints.add(new Point2D.Double((p1.x + p2.x) / 2.0, (p1.y + p2.y) / 2.0));
            }
        }
        for (i = 0; i < n; ++i) {
            p1 = srcPoints.get(i);
            for (j = i + 1; j < n; ++j) {
                p2 = srcPoints.get(j);
                for (k = j + 1; k < n; ++k) {
                    p3 = srcPoints.get(k);
                    srcPoints.add(new Point2D.Double((p1.x + p2.x + p3.x) / 3.0, (p1.y + p2.y + p3.y) / 3.0));
                }
            }
        }
        for (i = 0; i < n; ++i) {
            p1 = srcPoints.get(i);
            for (j = i + 1; j < n; ++j) {
                p2 = srcPoints.get(j);
                for (k = j + 1; k < n; ++k) {
                    p3 = srcPoints.get(k);
                    for (int m = k + 1; m < n; ++m) {
                        Point2D.Double p4 = srcPoints.get(m);
                        srcPoints.add(new Point2D.Double((p1.x + p2.x + p3.x + p4.x) / 3.0, (p1.y + p2.y + p3.y + p4.y) / 4.0));
                    }
                }
            }
        }
    }

    public class EvaluateFunction
    implements MultivariateFunction {
        private final Set[] m_lossCalculationSetArray;

        public EvaluateFunction(ArrayList<Set> setArrayList) {
            this.m_lossCalculationSetArray = setArrayList.toArray(new Set[setArrayList.size()]);
        }

        public double[] getCurrentGuess() {
            int nb = this.m_lossCalculationSetArray.length;
            double[] guess = new double[nb * 2];
            for (int i = 0; i < nb; ++i) {
                Set s = this.m_lossCalculationSetArray[i];
                guess[i * 2] = s.getCircle().getX();
                guess[i * 2 + 1] = s.getCircle().getY();
            }
            return guess;
        }

        public double value(double[] doubles) {
            int nb = this.m_lossCalculationSetArray.length;
            for (int i = 0; i < nb; ++i) {
                Set s = this.m_lossCalculationSetArray[i];
                s.getCircle().setPosition(doubles[i * 2], doubles[i * 2 + 1]);
            }
            return SetList.this.lossFunction(this.m_lossCalculationSetArray);
        }
    }
}

