/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.SwingUtilities;
import javax.swing.border.AbstractBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class CheckBoxTitledBorder
extends AbstractBorder
implements MouseListener,
ChangeListener {
    private final TitledBorder m_border;
    private final JCheckBox m_checkBox;
    private Container m_container;
    private Rectangle m_rectangle;

    public CheckBoxTitledBorder(String title, boolean selected) {
        this.m_border = BorderFactory.createTitledBorder(title);
        this.m_checkBox = new JCheckBox(title, selected);
        this.m_checkBox.setHorizontalTextPosition(4);
        this.m_checkBox.addChangeListener(this);
    }

    public JCheckBox getInternalCheckBox() {
        return this.m_checkBox;
    }

    public boolean isSelected() {
        return this.m_checkBox.isSelected();
    }

    public void setSelected(boolean isSelected) {
        this.m_checkBox.setSelected(isSelected);
    }

    public void setEnabled(boolean isEnabled) {
        this.m_checkBox.setEnabled(isEnabled);
    }

    public void addActionListener(ActionListener listener) {
        this.m_checkBox.addActionListener(listener);
    }

    public void addChangeListener(ChangeListener listener) {
        this.m_checkBox.addChangeListener(listener);
    }

    @Override
    public boolean isBorderOpaque() {
        return true;
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        Insets borderInsets = this.m_border.getBorderInsets(c);
        Insets insets = this.getBorderInsets(c);
        int temp = (insets.top - borderInsets.top) / 2;
        this.m_border.paintBorder(c, g, x, y + temp, width, height - temp);
        Dimension size = this.m_checkBox.getPreferredSize();
        if (c != this.m_container) {
            this.m_container = (Container)c;
            this.m_container.addMouseListener(this);
        }
        this.m_rectangle = new Rectangle(5, 0, size.width, size.height);
        SwingUtilities.paintComponent(g, this.m_checkBox, this.m_container, this.m_rectangle);
    }

    @Override
    public Insets getBorderInsets(Component c) {
        Insets insets = this.m_border.getBorderInsets(c);
        insets.top = Math.max(insets.top, this.m_checkBox.getPreferredSize().height);
        return insets;
    }

    private void dispatchEvent(MouseEvent me) {
        if (this.m_rectangle != null && this.m_rectangle.contains(me.getX(), me.getY())) {
            Point pt = me.getPoint();
            pt.translate(-5, 0);
            this.m_checkBox.setBounds(this.m_rectangle);
            this.m_checkBox.dispatchEvent(new MouseEvent(this.m_checkBox, me.getID(), me.getWhen(), me.getModifiers(), pt.x, pt.y, me.getClickCount(), me.isPopupTrigger(), me.getButton()));
            if (!this.m_checkBox.isValid() && this.m_container != null) {
                this.m_container.repaint();
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent me) {
        this.dispatchEvent(me);
    }

    @Override
    public void mouseReleased(MouseEvent me) {
        this.dispatchEvent(me);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.dispatchEvent(e);
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.dispatchEvent(e);
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.dispatchEvent(e);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (this.m_container != null) {
            this.m_container.repaint();
        }
    }
}

