/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.gui;

import fr.proline.studio.gui.CollapseListener;
import fr.proline.studio.utils.IconManager;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class CollapsablePanel
extends JPanel {
    private boolean m_expanded;
    private JPanel m_contentPanel;
    private HeaderLabel m_headerLabel;
    private final List<CollapseListener> m_listeners = new ArrayList<CollapseListener>();

    public CollapsablePanel(String headerTitle, JPanel contentPanel, boolean defaultExpand) {
        super(new GridBagLayout());
        this.m_expanded = defaultExpand;
        this.initPanel(headerTitle, contentPanel);
    }

    private void initPanel(String text, JPanel panel) {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(1, 3, 0, 3);
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        this.m_headerLabel = new HeaderLabel(text, this.m_expanded);
        this.m_contentPanel = panel;
        gbc.gridx = 0;
        gbc.gridy = 0;
        this.add((Component)this.m_headerLabel, gbc);
        ++gbc.gridy;
        gbc.weighty = 1.0;
        this.add((Component)this.m_contentPanel, gbc);
        this.m_contentPanel.setVisible(this.m_expanded);
    }

    public void toggleSelection() {
        this.m_expanded = !this.m_expanded;
        this.m_headerLabel.setIcon(null);
        if (this.m_contentPanel.isShowing()) {
            this.m_contentPanel.setVisible(false);
        } else {
            this.m_contentPanel.setVisible(true);
        }
        this.validate();
        this.m_headerLabel.setIcon(this.m_expanded ? IconManager.getIcon(IconManager.IconType.ARROW_DOWN) : IconManager.getIcon(IconManager.IconType.ARROW_RIGHT));
        this.m_headerLabel.repaint();
        for (CollapseListener l : this.m_listeners) {
            l.collapse(!this.m_expanded);
        }
    }

    public void addCollapseListener(CollapseListener toAdd) {
        this.m_listeners.add(toAdd);
    }

    private class HeaderLabel
    extends JLabel
    implements MouseListener {
        public HeaderLabel(String text, boolean defaultExpand) {
            super(text, defaultExpand ? IconManager.getIcon(IconManager.IconType.ARROW_DOWN) : IconManager.getIcon(IconManager.IconType.ARROW_RIGHT), 2);
            this.addMouseListener(this);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            CollapsablePanel.this.toggleSelection();
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }
    }
}

