/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.gui;

import fr.proline.studio.utils.IconManager;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.Timer;

public class HourglassPanel
extends JPanel
implements ActionListener {
    private boolean m_loading = false;
    private boolean m_calculating = false;
    private int m_id = -1;
    private static Font m_loadingFont = null;
    private static int m_fontAscent = 0;

    public void setLoading(int id, boolean calculating) {
        this.m_id = id;
        this.m_calculating = calculating;
        this.setLoading(true);
    }

    public boolean isLoading() {
        return this.m_loading;
    }

    public void setLoading(int id) {
        this.setLoading(id, false);
    }

    public void setLoaded(int id) {
        if (id >= this.m_id) {
            this.setLoading(false);
        }
    }

    private void setLoading(boolean loading) {
        boolean needRepaint = this.m_loading ^ loading;
        this.m_loading = loading;
        if (needRepaint) {
            if (!this.m_loading) {
                this.repaint();
            } else {
                Timer timer = new Timer(500, this);
                timer.setRepeats(false);
                timer.start();
            }
        }
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (!this.m_loading) {
            return;
        }
        int height = this.getHeight();
        int width = this.getWidth();
        int PAD = 10;
        int INTERNAL_PAD = 5;
        int ICON_WIDTH = 16;
        int BOX_HEIGHT = 26;
        int BOX_WIDTH = 130;
        g.setColor(Color.white);
        g.fillRect(10, height - 26 - 10, 130, 26);
        g.setColor(Color.darkGray);
        g.drawRect(12, height - 26 - 10 + 2, 126, 22);
        ImageIcon hourGlassIcon = IconManager.getIcon(IconManager.IconType.HOUR_GLASS);
        g.drawImage(hourGlassIcon.getImage(), 15, height - 26 - 10 + 5, null);
        if (m_loadingFont == null) {
            m_loadingFont = new Font("SansSerif", 1, 12);
            FontMetrics metrics = g.getFontMetrics(m_loadingFont);
            m_fontAscent = metrics.getAscent();
        }
        g.setFont(m_loadingFont);
        g.setColor(Color.black);
        if (this.m_calculating) {
            g.drawString("Calculating...", 36, height - 26 - 10 + 5 + m_fontAscent);
        } else {
            g.drawString("Loading Data...", 36, height - 26 - 10 + 5 + m_fontAscent);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.m_loading) {
            this.repaint();
        }
    }
}

