/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.gui;

import fr.proline.studio.gui.JCheckBoxList;
import fr.proline.studio.utils.IconManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class JCheckBoxListPanel
extends JPanel {
    private JCheckBoxList m_checkBoxList = null;
    private JCheckBox m_selectAllCheckBox = null;

    public JCheckBoxListPanel(JCheckBoxList checkBoxList, boolean showSelectAll) {
        this.setLayout(new GridBagLayout());
        this.setBackground(Color.white);
        this.m_checkBoxList = checkBoxList;
        if (showSelectAll) {
            this.m_selectAllCheckBox = new JCheckBox("Select / Unselect All", IconManager.getIcon(IconManager.IconType.SELECTED_CHECKBOXES));
            this.m_selectAllCheckBox.setBackground(Color.white);
            this.m_selectAllCheckBox.setFocusPainted(false);
            this.m_selectAllCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (JCheckBoxListPanel.this.m_selectAllCheckBox.isSelected()) {
                        JCheckBoxListPanel.this.m_checkBoxList.selectAll();
                    } else {
                        JCheckBoxListPanel.this.m_checkBoxList.unselectAll();
                    }
                    JCheckBoxListPanel.this.repaint();
                }
            });
        }
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 1;
        c.insets = new Insets(0, 5, 0, 5);
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        JScrollPane scrollPane = new JScrollPane(this.m_checkBoxList);
        this.add((Component)scrollPane, c);
        if (showSelectAll) {
            ++c.gridy;
            c.weighty = 0.0;
            this.add((Component)this.m_selectAllCheckBox, c);
        }
    }

    public JCheckBoxList getCheckBoxList() {
        return this.m_checkBoxList;
    }
}

