/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.gui;

import fr.proline.studio.gui.DefaultDialog;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class OptionDialog
extends DefaultDialog {
    private OptionDialogType m_dialogType;
    private JTextField m_optionTextfield = null;
    private JTextArea m_optionTextArea = null;
    private String m_message = null;
    private String m_labelForText = null;
    private boolean m_allowEmptyText = false;

    public OptionDialog(Window parent, String title, String message) {
        super(parent, Dialog.ModalityType.APPLICATION_MODAL);
        this.m_dialogType = OptionDialogType.NO_TEXT;
        this.setStatusVisible(false);
        this.m_message = message;
        this.setTitle(title);
        this.setButtonVisible(5, false);
        this.initInternalPanel();
    }

    public OptionDialog(Window parent, String title, String message, String labelForText, OptionDialogType dialogType) {
        super(parent, Dialog.ModalityType.APPLICATION_MODAL);
        this.m_dialogType = dialogType;
        this.m_message = message;
        this.m_labelForText = labelForText;
        this.setTitle(title);
        this.setButtonVisible(5, false);
        this.initInternalPanel();
    }

    private void initInternalPanel() {
        JPanel internalPanel = new JPanel();
        internalPanel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        internalPanel.add((Component)this.getTextfieldPanel(), c);
        this.setInternalComponent(internalPanel);
    }

    private JPanel getTextfieldPanel() {
        JLabel textfieldLabel;
        JPanel renamePanel = new JPanel();
        renamePanel.setLayout(new GridBagLayout());
        renamePanel.setBorder(BorderFactory.createTitledBorder(""));
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.gridx = 0;
        c.gridy = 0;
        if (this.m_message != null) {
            c.gridwidth = 2;
            String[] messageArray = this.m_message.split("\n");
            for (int i = 0; i < messageArray.length; ++i) {
                JLabel messageLabel = new JLabel(messageArray[i]);
                renamePanel.add((Component)messageLabel, c);
                ++c.gridy;
            }
            c.gridwidth = 1;
        }
        if (this.m_dialogType == OptionDialogType.TEXTFIELD) {
            textfieldLabel = new JLabel(this.m_labelForText + " :");
            this.m_optionTextfield = new JTextField(30);
            c.gridx = 0;
            renamePanel.add((Component)textfieldLabel, c);
            ++c.gridx;
            c.weightx = 1.0;
            renamePanel.add((Component)this.m_optionTextfield, c);
        } else if (this.m_dialogType == OptionDialogType.TEXTAREA) {
            textfieldLabel = new JLabel(this.m_labelForText + " :");
            this.m_optionTextArea = new JTextArea();
            JScrollPane desciptionScrollPane = new JScrollPane(this.m_optionTextArea){
                private Dimension preferredSize;
                {
                    this.preferredSize = new Dimension(360, 200);
                }

                @Override
                public Dimension getPreferredSize() {
                    return this.preferredSize;
                }
            };
            c.gridx = 0;
            renamePanel.add((Component)textfieldLabel, c);
            ++c.gridx;
            c.weightx = 1.0;
            renamePanel.add((Component)desciptionScrollPane, c);
        }
        return renamePanel;
    }

    @Override
    protected boolean okCalled() {
        if (this.m_optionTextfield != null) {
            String text = this.m_optionTextfield.getText();
            if (!this.m_allowEmptyText && text.isEmpty()) {
                this.setStatus(true, "You must fill the field " + this.m_labelForText + ".");
                this.highlight(this.m_optionTextfield);
                return false;
            }
        } else if (this.m_optionTextArea != null) {
            String text = this.m_optionTextArea.getText();
            if (!this.m_allowEmptyText && text.isEmpty()) {
                this.setStatus(true, "You must fill the field " + this.m_labelForText + ".");
                this.highlight(this.m_optionTextArea);
                return false;
            }
        }
        return true;
    }

    public void setAllowEmptyText(boolean allowEmptyText) {
        this.m_allowEmptyText = allowEmptyText;
    }

    public void setText(String name) {
        if (this.m_optionTextfield != null) {
            this.m_optionTextfield.setText(name);
            this.m_optionTextfield.requestFocus();
            this.m_optionTextfield.setSelectionStart(0);
            this.m_optionTextfield.setSelectionEnd(name.length());
        } else if (this.m_optionTextArea != null) {
            this.m_optionTextArea.setText(name);
            this.m_optionTextArea.requestFocus();
            this.m_optionTextArea.setSelectionStart(0);
            this.m_optionTextArea.setSelectionEnd(name.length());
        }
    }

    public String getText() {
        if (this.m_optionTextfield != null) {
            return this.m_optionTextfield.getText();
        }
        if (this.m_optionTextArea != null) {
            return this.m_optionTextArea.getText();
        }
        return "";
    }

    public static enum OptionDialogType {
        NO_TEXT,
        TEXTFIELD,
        TEXTAREA;

    }
}

