/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.markerbar;

import fr.proline.studio.gui.DefaultDialog;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class AnnotationMarkerDialog
extends DefaultDialog {
    private static AnnotationMarkerDialog m_singletonDialog = null;
    private JTextField m_descriptionTextfield = null;

    public static AnnotationMarkerDialog getDialog(Window parent) {
        if (m_singletonDialog == null) {
            m_singletonDialog = new AnnotationMarkerDialog(parent);
        }
        m_singletonDialog.reinit();
        return m_singletonDialog;
    }

    private AnnotationMarkerDialog(Window parent) {
        super(parent, Dialog.ModalityType.APPLICATION_MODAL);
        this.setTitle("Add Annotation");
        this.setButtonVisible(5, false);
        this.initInternalPanel();
    }

    private void initInternalPanel() {
        JPanel internalPanel = new JPanel();
        internalPanel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        internalPanel.add((Component)this.getRenamePanel(), c);
        this.setInternalComponent(internalPanel);
    }

    private JPanel getRenamePanel() {
        JPanel renamePanel = new JPanel();
        renamePanel.setLayout(new GridBagLayout());
        renamePanel.setBorder(BorderFactory.createTitledBorder(""));
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        JLabel renameLabel = new JLabel("Description :");
        this.m_descriptionTextfield = new JTextField(30);
        c.gridx = 0;
        c.gridy = 0;
        renamePanel.add((Component)renameLabel, c);
        ++c.gridx;
        c.weightx = 1.0;
        renamePanel.add((Component)this.m_descriptionTextfield, c);
        return renamePanel;
    }

    private void reinit() {
        this.m_descriptionTextfield.setText("");
    }

    @Override
    protected boolean okCalled() {
        String name = this.m_descriptionTextfield.getText();
        if (name.isEmpty()) {
            this.setStatus(true, "You must fill the description.");
            this.highlight(this.m_descriptionTextfield);
            return false;
        }
        return true;
    }

    public void setDescriptionField(String name) {
        this.m_descriptionTextfield.setText(name);
    }

    public String getDescriptionField() {
        return this.m_descriptionTextfield.getText();
    }
}

