/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.settings;

import java.io.File;
import java.util.ArrayList;
import java.util.prefs.Preferences;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.openide.util.NbPreferences;

public class SettingsUtils {
    private static final String SETTINGS_DIRECTORY_POSTFIX = "SettingsDirectory";
    private static final String FILE_PATH_POSTFIX = ".filePath_";

    public static String readDefaultDirectory(String settingsKey) {
        Preferences preferences = NbPreferences.root();
        return preferences.get(settingsKey + SETTINGS_DIRECTORY_POSTFIX, null);
    }

    public static void writeDefaultDirectory(String settingsKey, String directoryPath) {
        Preferences preferences = NbPreferences.root();
        preferences.put(settingsKey + SETTINGS_DIRECTORY_POSTFIX, directoryPath);
    }

    public static void addSettingsPath(String settingsKey, String filePath) {
        ArrayList<String> filePathList = SettingsUtils.readSettingsPaths(settingsKey);
        boolean pathFound = false;
        for (int i = 0; i < filePathList.size(); ++i) {
            String pathCur = filePathList.get(i);
            if (pathCur.compareTo(filePath) != 0) continue;
            pathFound = true;
            break;
        }
        if (!pathFound) {
            filePathList.add(0, filePath);
        }
        SettingsUtils.writeSettingsPath(settingsKey, filePathList);
    }

    public static ArrayList<String> readSettingsPaths(String settingsKey) {
        String filePath;
        Preferences preferences = NbPreferences.root();
        String settingsDirectoryKey = settingsKey + FILE_PATH_POSTFIX;
        ArrayList<String> filePathList = new ArrayList<String>();
        for (int i = 1; i < 10 && (filePath = preferences.get(settingsDirectoryKey + i, null)) != null; ++i) {
            filePathList.add(filePath);
        }
        return filePathList;
    }

    public static void writeSettingsPath(String settingsKey, ArrayList<String> filePathList) {
        String key;
        String regex;
        int i;
        Preferences preferences = NbPreferences.root();
        String settingsDirectoryKey = settingsKey + FILE_PATH_POSTFIX;
        for (i = 1; i < 10 && (regex = preferences.get(key = settingsDirectoryKey + i, null)) != null; ++i) {
            preferences.remove(key);
        }
        for (i = 0; i < filePathList.size(); ++i) {
            key = settingsDirectoryKey + (i + 1);
            preferences.put(key, filePathList.get(i));
        }
    }

    public static JFileChooser getFileChooser(String settingsKey) {
        return new SettingsFileChooser(settingsKey);
    }

    private static class SettingsFileChooser
    extends JFileChooser {
        public SettingsFileChooser(String settingsKey) {
            super(SettingsUtils.readDefaultDirectory(settingsKey));
            this.setMultiSelectionEnabled(false);
            FileNameExtensionFilter filter = new FileNameExtensionFilter("Proline Settings File", "settings");
            this.addChoosableFileFilter(filter);
            this.setFileFilter(filter);
        }

        @Override
        public File getSelectedFile() {
            File f = super.getSelectedFile();
            if (f != null && !f.getAbsolutePath().endsWith(".settings")) {
                return new File(f.getAbsolutePath() + ".settings");
            }
            return f;
        }
    }
}

