/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.utils;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;

public class SerializedPropertiesUtil {
    private static final StringBuilder m_sb = new StringBuilder();

    public static void getProperties(HashMap<String, String> propertiesList, String name, Map<String, Object> serializedPropertiesMap) {
        SerializedPropertiesUtil.getPropertiesImpl(propertiesList, name, serializedPropertiesMap);
        m_sb.setLength(0);
    }

    private static void getPropertiesImpl(HashMap<String, String> propertiesList, String name, Map serializedPropertiesMap) {
        if (serializedPropertiesMap == null) {
            return;
        }
        boolean nonMapObject = false;
        for (Object key : serializedPropertiesMap.keySet()) {
            Object value = serializedPropertiesMap.get(key);
            if (value instanceof Map) continue;
            nonMapObject = true;
        }
        if (nonMapObject) {
            SerializedPropertiesUtil.createPropertyGroup(propertiesList, name, serializedPropertiesMap);
        } else {
            for (Object key : serializedPropertiesMap.keySet()) {
                Map map = (Map)serializedPropertiesMap.get(key);
                SerializedPropertiesUtil.createPropertyGroup(propertiesList, key.toString(), map);
            }
        }
    }

    public static void getProperties(Sheet sheet, String name, Map serializedPropertiesMap) {
        SerializedPropertiesUtil.getPropertiesImpl(sheet, name, serializedPropertiesMap);
        m_sb.setLength(0);
    }

    private static void getPropertiesImpl(Sheet sheet, String name, Map serializedPropertiesMap) {
        if (serializedPropertiesMap == null) {
            return;
        }
        boolean nonMapObject = false;
        for (Object key : serializedPropertiesMap.keySet()) {
            Object value = serializedPropertiesMap.get(key);
            if (value instanceof Map) continue;
            nonMapObject = true;
        }
        if (nonMapObject) {
            SerializedPropertiesUtil.createPropertyGroup(sheet, name, serializedPropertiesMap);
        } else {
            for (Object key : serializedPropertiesMap.keySet()) {
                Map map = (Map)serializedPropertiesMap.get(key);
                SerializedPropertiesUtil.createPropertyGroup(sheet, key.toString(), map);
            }
        }
    }

    private static void createPropertyGroup(HashMap<String, String> propertiesList, String name, Map map) {
        String nameParam = name.compareTo("validation_properties") == 0 ? "validation_properties" : null;
        SerializedPropertiesUtil.addProperties(propertiesList, nameParam, map);
    }

    private static void createPropertyGroup(Sheet sheet, String name, Map map) {
        Sheet.Set propGroup = Sheet.createPropertiesSet();
        propGroup.setName(name);
        propGroup.setDisplayName(name);
        SerializedPropertiesUtil.addProperties(propGroup, null, map);
        sheet.put(propGroup);
    }

    private static void addProperties(HashMap<String, String> propertiesList, String name, Map serializedPropertiesMap) {
        ArrayList listOfKeyMap = null;
        ArrayList<Map> listOfMaps = null;
        for (Object key : serializedPropertiesMap.keySet()) {
            String valueString;
            Object value = serializedPropertiesMap.get(key);
            if (value instanceof Map) {
                if (listOfMaps == null) {
                    listOfMaps = new ArrayList<Map>();
                    listOfKeyMap = new ArrayList();
                }
                listOfMaps.add((Map)value);
                listOfKeyMap.add(key);
                continue;
            }
            if (value instanceof List) {
                m_sb.setLength(0);
                List l = (List)value;
                Iterator itList = l.iterator();
                while (itList.hasNext()) {
                    Object valueList;
                    if (m_sb.length() > 0) {
                        m_sb.append(',');
                    }
                    if ((valueList = itList.next()) instanceof Map) {
                        if (listOfMaps == null) {
                            listOfMaps = new ArrayList();
                            listOfKeyMap = new ArrayList();
                        }
                        listOfMaps.add((Map)valueList);
                        listOfKeyMap.add(key);
                        continue;
                    }
                    if (valueList == null) {
                        m_sb.append("null");
                        continue;
                    }
                    m_sb.append(valueList.toString());
                }
                if (m_sb.length() == 0) continue;
                valueString = m_sb.toString();
            } else {
                valueString = value == null ? "null" : value.toString();
            }
            String propName = name == null ? key.toString() : name + " / " + key.toString();
            propertiesList.put(propName, valueString);
        }
        if (listOfMaps != null) {
            HashMap propIndex = new HashMap();
            int nbMap = listOfMaps.size();
            for (int i = 0; i < nbMap; ++i) {
                Object key = listOfKeyMap.get(i);
                StringBuilder keyName = new StringBuilder(key.toString());
                if (propIndex.containsKey(key)) {
                    keyName.append("#").append(((Integer)propIndex.get(key)).toString());
                    propIndex.put(key, (Integer)propIndex.get(key) + 1);
                } else if (Collections.frequency(listOfKeyMap, key) > 1) {
                    keyName.append("#1");
                    propIndex.put(key, 2);
                }
                Map map = (Map)listOfMaps.get(i);
                String propName = name == null ? keyName.toString() : name + " / " + keyName.toString();
                SerializedPropertiesUtil.addProperties(propertiesList, propName, map);
            }
        }
    }

    private static void addProperties(Sheet.Set propGroup, String name, Map serializedPropertiesMap) {
        ArrayList listOfKeyMap = null;
        ArrayList<Map> listOfMaps = null;
        for (Object key : serializedPropertiesMap.keySet()) {
            String valueString;
            Object value = serializedPropertiesMap.get(key);
            if (value instanceof Map) {
                if (listOfMaps == null) {
                    listOfMaps = new ArrayList<Map>();
                    listOfKeyMap = new ArrayList();
                }
                listOfMaps.add((Map)value);
                listOfKeyMap.add(key);
                continue;
            }
            if (value instanceof List) {
                m_sb.setLength(0);
                List l = (List)value;
                Iterator itList = l.iterator();
                while (itList.hasNext()) {
                    Object valueList;
                    if (m_sb.length() > 0) {
                        m_sb.append(',');
                    }
                    if ((valueList = itList.next()) instanceof Map) {
                        if (listOfMaps == null) {
                            listOfMaps = new ArrayList();
                            listOfKeyMap = new ArrayList();
                        }
                        listOfMaps.add((Map)valueList);
                        listOfKeyMap.add(key);
                        continue;
                    }
                    if (valueList == null) {
                        m_sb.append("null");
                        continue;
                    }
                    m_sb.append(valueList.toString());
                }
                if (m_sb.length() == 0) continue;
                valueString = m_sb.toString();
            } else {
                valueString = value == null ? "null" : value.toString();
            }
            String propName = name == null ? key.toString() : name + " / " + key.toString();
            final String _valueString = valueString;
            PropertySupport.ReadOnly prop = new PropertySupport.ReadOnly(propName, String.class, propName, propName){

                public Object getValue() throws InvocationTargetException {
                    return _valueString;
                }
            };
            propGroup.put((Node.Property)prop);
        }
        if (listOfMaps != null) {
            HashMap propIndex = new HashMap();
            int nbMap = listOfMaps.size();
            for (int i = 0; i < nbMap; ++i) {
                Object key = listOfKeyMap.get(i);
                StringBuilder keyName = new StringBuilder(key.toString());
                if (propIndex.containsKey(key)) {
                    keyName.append("#").append(((Integer)propIndex.get(key)).toString());
                    propIndex.put(key, (Integer)propIndex.get(key) + 1);
                } else if (Collections.frequency(listOfKeyMap, key) > 1) {
                    keyName.append("#1");
                    propIndex.put(key, 2);
                }
                Map map = (Map)listOfMaps.get(i);
                String propName = name == null ? keyName.toString() : name + " / " + keyName.toString();
                SerializedPropertiesUtil.addProperties(propGroup, propName, map);
            }
        }
    }
}

