/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.utils;

import fr.proline.studio.utils.IconManager;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.prefs.Preferences;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.openide.util.NbPreferences;
import org.slf4j.LoggerFactory;

public class URLCellRenderer
extends DefaultTableCellRenderer
implements MouseListener,
MouseMotionListener {
    private String m_preferenceKey;
    private String m_defaultURLTemplate;
    private int m_column;

    public URLCellRenderer(String preferenceKey, String defaultURLTemplate, int column) {
        this.m_preferenceKey = preferenceKey;
        this.m_column = column;
        this.m_defaultURLTemplate = defaultURLTemplate;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        super.getTableCellRendererComponent(table, value, isSelected, false, row, column);
        this.setIcon(IconManager.getIcon(IconManager.IconType.WEB_LINK));
        return this;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        JTable table = (JTable)e.getSource();
        Point pt = e.getPoint();
        int col = table.columnAtPoint(pt);
        int row = table.rowAtPoint(pt);
        int modelCol = table.convertColumnIndexToModel(col);
        if (modelCol != this.m_column || row == -1) {
            return;
        }
        JTableHeader th = table.getTableHeader();
        TableColumnModel tcm = th.getColumnModel();
        int columnStart = 0;
        for (int i = 0; i < col; ++i) {
            TableColumn column = tcm.getColumn(i);
            columnStart += column.getWidth();
        }
        if (columnStart + 20 < e.getX()) {
            return;
        }
        Object value = table.getValueAt(row, col);
        try {
            if (Desktop.isDesktopSupported()) {
                String info;
                Preferences preferences = NbPreferences.root();
                String template = preferences.get(this.m_preferenceKey, null);
                if (template == null) {
                    template = this.m_defaultURLTemplate;
                    preferences.put(this.m_preferenceKey, this.m_defaultURLTemplate);
                }
                if ((info = value.toString()).startsWith("sp|")) {
                    info = info.substring(3, info.length());
                }
                if (info.subSequence(2, 3).equals("|")) {
                    info = info.substring(3, info.length());
                }
                if (info.contains("|")) {
                    info = info.substring(0, info.indexOf("|"));
                }
                info = URLCellRenderer.encode(info);
                Desktop.getDesktop().browse(new URL(template + info).toURI());
            }
        }
        catch (IOException | URISyntaxException ex) {
            LoggerFactory.getLogger((String)"ProlineStudio.Commons").error(this.getClass().getSimpleName() + " failed", (Throwable)ex);
        }
    }

    private static String encode(String input) {
        StringBuilder resultStr = new StringBuilder();
        for (char ch : input.toCharArray()) {
            if (URLCellRenderer.isUnsafe(ch)) {
                resultStr.append('%');
                resultStr.append(URLCellRenderer.toHex(ch / 16));
                resultStr.append(URLCellRenderer.toHex(ch % 16));
                continue;
            }
            resultStr.append(ch);
        }
        return resultStr.toString();
    }

    private static char toHex(int ch) {
        return (char)(ch < 10 ? 48 + ch : 65 + ch - 10);
    }

    private static boolean isUnsafe(char ch) {
        if (ch > '\u0080' || ch < '\u0000') {
            return true;
        }
        return " %$&+,/:;=?@<>#%|".indexOf(ch) >= 0;
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.checkCursor(e);
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.checkCursor(e);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.checkCursor(e);
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.checkCursor(e);
    }

    private void checkCursor(MouseEvent e) {
        JTable table = (JTable)e.getSource();
        Point pt = e.getPoint();
        int col = table.columnAtPoint(pt);
        int row = table.rowAtPoint(pt);
        int modelCol = table.convertColumnIndexToModel(col);
        if (modelCol != this.m_column || row == -1) {
            table.setCursor(Cursor.getDefaultCursor());
            return;
        }
        JTableHeader th = table.getTableHeader();
        TableColumnModel tcm = th.getColumnModel();
        int columnStart = 0;
        for (int i = 0; i < col; ++i) {
            TableColumn column = tcm.getColumn(i);
            columnStart += column.getWidth();
        }
        if (columnStart + 20 < e.getX()) {
            table.setCursor(Cursor.getDefaultCursor());
            return;
        }
        table.setCursor(Cursor.getPredefinedCursor(12));
    }
}

