/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.mzdb.algo;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import fr.profi.ms.algo.IsotopePatternEstimator$;
import fr.profi.ms.model.TheoreticalIsotopePattern;
import fr.profi.mzdb.algo.IsotopicPatternScorer$;
import fr.profi.mzdb.model.SpectrumData;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.HashMap;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;

public final class IsotopicPatternScorer$
implements LazyLogging {
    public static final IsotopicPatternScorer$ MODULE$;
    private final int MAX_CHARGE;
    private final Logger logger;
    private volatile boolean bitmap$0;

    static {
        new IsotopicPatternScorer$();
    }

    private Logger logger$lzycompute() {
        IsotopicPatternScorer$ isotopicPatternScorer$ = this;
        synchronized (isotopicPatternScorer$) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    private int MAX_CHARGE() {
        return this.MAX_CHARGE;
    }

    public Tuple2<Object, TheoreticalIsotopePattern>[] calcIsotopicPatternHypotheses(SpectrumData spectrum, double mz, double ppmTol) {
        ObjectRef result2 = ObjectRef.create((Object)((ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$)));
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), this.MAX_CHARGE()).foreach$mVc$sp((Function1)new Serializable(spectrum, mz, ppmTol, result2){
            public static final long serialVersionUID = 0L;
            public final SpectrumData spectrum$1;
            public final double mz$1;
            public final double ppmTol$1;
            public final ObjectRef result$1;

            public final void apply(int charge) {
                this.apply$mcVI$sp(charge);
            }

            public void apply$mcVI$sp(int charge) {
                Tuple2<Object, TheoreticalIsotopePattern> tuple2 = IsotopicPatternScorer$.MODULE$.getIPHypothesis(this.spectrum$1, this.mz$1, 0, charge, this.ppmTol$1);
                if (tuple2 != null) {
                    Tuple2 tuple22;
                    double score = tuple2._1$mcD$sp();
                    TheoreticalIsotopePattern theoreticalIP = (TheoreticalIsotopePattern)tuple2._2();
                    Tuple2 tuple23 = tuple22 = new Tuple2((Object)BoxesRunTime.boxToDouble((double)score), (Object)theoreticalIP);
                    double score2 = tuple23._1$mcD$sp();
                    TheoreticalIsotopePattern theoreticalIP2 = (TheoreticalIsotopePattern)tuple23._2();
                    ((ArrayBuffer)this.result$1.elem).$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToDouble((double)score2)), (Object)theoreticalIP2));
                    RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), theoreticalIP2.theoreticalMaxPeakelIndex() + 1).foreach((Function1)new Serializable(this, charge){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.calcIsotopicPatternHypotheses.1 $outer;
                        private final int charge$3;

                        public final ArrayBuffer<Tuple2<Object, TheoreticalIsotopePattern>> apply(int j) {
                            Tuple2<Object, TheoreticalIsotopePattern> tuple2 = IsotopicPatternScorer$.MODULE$.getIPHypothesis(this.$outer.spectrum$1, this.$outer.mz$1, j, this.charge$3, this.$outer.ppmTol$1);
                            if (tuple2 != null) {
                                Tuple2 tuple22;
                                double score = tuple2._1$mcD$sp();
                                TheoreticalIsotopePattern theoreticalIP = (TheoreticalIsotopePattern)tuple2._2();
                                Tuple2 tuple23 = tuple22 = new Tuple2((Object)BoxesRunTime.boxToDouble((double)score), (Object)theoreticalIP);
                                double score2 = tuple23._1$mcD$sp();
                                TheoreticalIsotopePattern theoreticalIP2 = (TheoreticalIsotopePattern)tuple23._2();
                                return ((ArrayBuffer)this.$outer.result$1.elem).$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToDouble((double)score2)), (Object)theoreticalIP2));
                            }
                            throw new MatchError(tuple2);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.charge$3 = charge$3;
                        }
                    });
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                this.spectrum$1 = spectrum$1;
                this.mz$1 = mz$1;
                this.ppmTol$1 = ppmTol$1;
                this.result$1 = result$1;
            }
        });
        result2.elem = (ArrayBuffer)((ArrayBuffer)result2.elem).sortWith((Function2)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<Object, TheoreticalIsotopePattern> p1, Tuple2<Object, TheoreticalIsotopePattern> p2) {
                return p1._1$mcD$sp() == p2._1$mcD$sp() && ((TheoreticalIsotopePattern)p1._2()).charge() < ((TheoreticalIsotopePattern)p2._2()).charge() || p1._1$mcD$sp() != p2._1$mcD$sp() && p1._1$mcD$sp() < p2._1$mcD$sp();
            }
        });
        return (Tuple2[])((ArrayBuffer)result2.elem).toArray(ClassTag$.MODULE$.apply(Tuple2.class));
    }

    public Tuple2<Object, TheoreticalIsotopePattern> getIPHypothesis(SpectrumData spectrum, double initialMz, int isotopicShift, int charge, double ppmTol) {
        DoubleRef score = DoubleRef.create((double)0.0);
        double alternativeMoz = initialMz - (double)isotopicShift * 1.0027 / (double)charge;
        TheoreticalIsotopePattern pattern = IsotopePatternEstimator$.MODULE$.getTheoreticalPattern(alternativeMoz, charge);
        float isotopeAbundance = spectrum.getIntensityList()[spectrum.getNearestPeakIndex(alternativeMoz)];
        float normAbundance = BoxesRunTime.unboxToFloat((Object)pattern.mzAbundancePairs()[0]._2());
        DoubleRef ipMoz = DoubleRef.create((double)alternativeMoz);
        boolean rank = false;
        IntRef matches = IntRef.create((int)0);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), pattern.mzAbundancePairs().length).foreach$mVc$sp((Function1)new Serializable(spectrum, isotopicShift, charge, ppmTol, score, pattern, isotopeAbundance, normAbundance, ipMoz, matches){
            public static final long serialVersionUID = 0L;
            private final SpectrumData spectrum$2;
            private final int isotopicShift$1;
            private final int charge$1;
            private final double ppmTol$2;
            private final DoubleRef score$1;
            private final TheoreticalIsotopePattern pattern$1;
            private final float isotopeAbundance$1;
            private final float normAbundance$1;
            private final DoubleRef ipMoz$1;
            private final IntRef matches$1;

            public final void apply(int rank) {
                this.apply$mcVI$sp(rank);
            }

            public void apply$mcVI$sp(int rank) {
                float f;
                double rankPenality;
                this.ipMoz$1.elem = rank == 0 ? this.ipMoz$1.elem : this.ipMoz$1.elem + 1.0027 / (double)this.charge$1;
                float ipAbundance = BoxesRunTime.unboxToFloat((Object)this.pattern$1.mzAbundancePairs()[rank]._2()) * this.isotopeAbundance$1 / this.normAbundance$1;
                int nearestPeakIdx = this.spectrum$2.getNearestPeakIndex(this.ipMoz$1.elem);
                double d = rankPenality = rank == this.isotopicShift$1 ? 100.0 : Math.max(0.01, Math.pow(10.0, -(2 * rank - 4)));
                if (1000000.0 * Math.abs(this.spectrum$2.getMzList()[nearestPeakIdx] - this.ipMoz$1.elem) / this.ipMoz$1.elem < this.ppmTol$2) {
                    this.ipMoz$1.elem = this.spectrum$2.getMzList()[nearestPeakIdx];
                    ++this.matches$1.elem;
                    f = this.spectrum$2.getIntensityList()[nearestPeakIdx];
                } else {
                    f = ipAbundance / 1000.0f;
                }
                float abundance2 = f;
                double d2 = (double)((ipAbundance - abundance2) / package$.MODULE$.min(abundance2, ipAbundance)) * rankPenality;
                this.score$1.elem += d2 * d2;
            }
            {
                this.spectrum$2 = spectrum$2;
                this.isotopicShift$1 = isotopicShift$1;
                this.charge$1 = charge$1;
                this.ppmTol$2 = ppmTol$2;
                this.score$1 = score$1;
                this.pattern$1 = pattern$1;
                this.isotopeAbundance$1 = isotopeAbundance$1;
                this.normAbundance$1 = normAbundance$1;
                this.ipMoz$1 = ipMoz$1;
                this.matches$1 = matches$1;
            }
        });
        score.elem = Math.log10(score.elem) - (double)matches.elem;
        return new Tuple2((Object)BoxesRunTime.boxToDouble((double)score.elem), (Object)pattern);
    }

    private Tuple2<Object, TheoreticalIsotopePattern>[] calcIsotopicPatternHypothesesV2(SpectrumData spectrum, double mz, double ppmTol) {
        HashMap mzIntPairCache = new HashMap();
        Serializable getNearestMzIntPair = new Serializable(spectrum, mzIntPairCache){
            public static final long serialVersionUID = 0L;
            public final SpectrumData spectrum$3;
            private final HashMap mzIntPairCache$1;

            public final Tuple2<Object, Object> apply(double mz) {
                return (Tuple2)this.mzIntPairCache$1.getOrElseUpdate((Object)BoxesRunTime.boxToDouble((double)mz), (Function0)new Serializable(this, mz){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.1 $outer;
                    private final double mz$3;

                    public final Tuple2<Object, Object> apply() {
                        int peakIdx = this.$outer.spectrum$3.getNearestPeakIndex(this.mz$3);
                        return new Tuple2((Object)BoxesRunTime.boxToDouble((double)this.$outer.spectrum$3.getMzList()[peakIdx]), (Object)BoxesRunTime.boxToFloat((float)this.$outer.spectrum$3.getIntensityList()[peakIdx]));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.mz$3 = mz$3;
                    }
                });
            }
            {
                this.spectrum$3 = spectrum$3;
                this.mzIntPairCache$1 = mzIntPairCache$1;
            }
        };
        return this.calcIsotopicPatternHypotheses((Function1<Object, Tuple2<Object, Object>>)getNearestMzIntPair, mz, ppmTol);
    }

    private Tuple2<Object, TheoreticalIsotopePattern>[] calcIsotopicPatternHypotheses(Function1<Object, Tuple2<Object, Object>> getNearestMzIntPair, double mz, double ppmTol) {
        int maxExpectedResultsCount = this.MAX_CHARGE() * 4;
        ArrayBuffer results = new ArrayBuffer(maxExpectedResultsCount);
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), this.MAX_CHARGE()).foreach$mVc$sp((Function1)new Serializable(getNearestMzIntPair, mz, ppmTol, results){
            public static final long serialVersionUID = 0L;
            public final Function1 getNearestMzIntPair$1;
            public final double mz$2;
            public final double ppmTol$3;
            public final ArrayBuffer results$1;

            public final void apply(int charge) {
                this.apply$mcVI$sp(charge);
            }

            public void apply$mcVI$sp(int charge) {
                Tuple2<Object, TheoreticalIsotopePattern> tuple2 = IsotopicPatternScorer$.MODULE$.fr$profi$mzdb$algo$IsotopicPatternScorer$$calcIsotopicPatternHypothesis((Function1<Object, Tuple2<Object, Object>>)this.getNearestMzIntPair$1, this.mz$2, 0, charge, this.ppmTol$3);
                if (tuple2 != null) {
                    Tuple2 tuple22;
                    double score = tuple2._1$mcD$sp();
                    TheoreticalIsotopePattern theoreticalIP = (TheoreticalIsotopePattern)tuple2._2();
                    Tuple2 tuple23 = tuple22 = new Tuple2((Object)BoxesRunTime.boxToDouble((double)score), (Object)theoreticalIP);
                    double score2 = tuple23._1$mcD$sp();
                    TheoreticalIsotopePattern theoreticalIP2 = (TheoreticalIsotopePattern)tuple23._2();
                    this.results$1.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToDouble((double)score2)), (Object)theoreticalIP2));
                    RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), theoreticalIP2.theoreticalMaxPeakelIndex() + 1).foreach((Function1)new Serializable(this, charge){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.calcIsotopicPatternHypotheses.2 $outer;
                        private final int charge$4;

                        public final ArrayBuffer<Tuple2<Object, TheoreticalIsotopePattern>> apply(int j) {
                            return this.$outer.results$1.$plus$eq(IsotopicPatternScorer$.MODULE$.fr$profi$mzdb$algo$IsotopicPatternScorer$$calcIsotopicPatternHypothesis((Function1<Object, Tuple2<Object, Object>>)this.$outer.getNearestMzIntPair$1, this.$outer.mz$2, j, this.charge$4, this.$outer.ppmTol$3));
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.charge$4 = charge$4;
                        }
                    });
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                this.getNearestMzIntPair$1 = getNearestMzIntPair$1;
                this.mz$2 = mz$2;
                this.ppmTol$3 = ppmTol$3;
                this.results$1 = results$1;
            }
        });
        return (Tuple2[])((TraversableOnce)results.sortWith((Function2)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<Object, TheoreticalIsotopePattern> x0$1, Tuple2<Object, TheoreticalIsotopePattern> x1$1) {
                Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
                if (tuple2 != null) {
                    Tuple2 tuple22 = (Tuple2)tuple2._1();
                    Tuple2 tuple23 = (Tuple2)tuple2._2();
                    if (tuple22 != null) {
                        double s1 = tuple22._1$mcD$sp();
                        TheoreticalIsotopePattern p1 = (TheoreticalIsotopePattern)tuple22._2();
                        double d = s1;
                        if (p1 != null) {
                            TheoreticalIsotopePattern theoreticalIsotopePattern = p1;
                            if (tuple23 != null) {
                                double s2 = tuple23._1$mcD$sp();
                                TheoreticalIsotopePattern p2 = (TheoreticalIsotopePattern)tuple23._2();
                                double d2 = s2;
                                if (p2 != null) {
                                    TheoreticalIsotopePattern theoreticalIsotopePattern2 = p2;
                                    boolean bl = d == d2 && theoreticalIsotopePattern.charge() < theoreticalIsotopePattern2.charge() || d < d2;
                                    return bl;
                                }
                            }
                        }
                    }
                }
                throw new MatchError((Object)tuple2);
            }
        })).toArray(ClassTag$.MODULE$.apply(Tuple2.class));
    }

    public Tuple2<Object, TheoreticalIsotopePattern> fr$profi$mzdb$algo$IsotopicPatternScorer$$calcIsotopicPatternHypothesis(Function1<Object, Tuple2<Object, Object>> getNearestMzIntPair, double initialMz, int isotopicShift, int charge, double ppmTol) {
        double alternativeMz = initialMz - (double)isotopicShift * 1.0027 / (double)charge;
        TheoreticalIsotopePattern pattern = IsotopePatternEstimator$.MODULE$.getTheoreticalPattern(alternativeMz, charge);
        Tuple2 mzIntPair = (Tuple2)getNearestMzIntPair.apply((Object)BoxesRunTime.boxToDouble((double)alternativeMz));
        float monoIsoAb = BoxesRunTime.unboxToFloat((Object)mzIntPair._2());
        float monoIsoTheoAb = BoxesRunTime.unboxToFloat((Object)pattern.mzAbundancePairs()[0]._2());
        DoubleRef score = DoubleRef.create((double)0.0);
        DoubleRef ipMz = DoubleRef.create((double)alternativeMz);
        boolean rank = false;
        IntRef matches = IntRef.create((int)0);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), pattern.mzAbundancePairs().length).foreach$mVc$sp((Function1)new Serializable(getNearestMzIntPair, isotopicShift, charge, ppmTol, alternativeMz, pattern, monoIsoAb, monoIsoTheoAb, score, ipMz, matches){
            public static final long serialVersionUID = 0L;
            private final Function1 getNearestMzIntPair$2;
            private final int isotopicShift$2;
            private final int charge$2;
            private final double ppmTol$4;
            private final double alternativeMz$1;
            private final TheoreticalIsotopePattern pattern$2;
            private final float monoIsoAb$1;
            private final float monoIsoTheoAb$1;
            private final DoubleRef score$2;
            private final DoubleRef ipMz$1;
            private final IntRef matches$2;

            public final void apply(int rank) {
                this.apply$mcVI$sp(rank);
            }

            public void apply$mcVI$sp(int rank) {
                float f;
                this.ipMz$1.elem = rank == 0 ? this.ipMz$1.elem : this.ipMz$1.elem + 1.0027 / (double)this.charge$2;
                double rankPenality = rank == this.isotopicShift$2 ? 100.0 : Math.max(0.01, Math.pow(10.0, -(2 * rank - 4)));
                float scalingToMonoFactor = BoxesRunTime.unboxToFloat((Object)this.pattern$2.mzAbundancePairs()[rank]._2()) / this.monoIsoTheoAb$1;
                float expectedAbundance = this.monoIsoAb$1 * scalingToMonoFactor;
                Tuple2 nearestMzIntPair = (Tuple2)this.getNearestMzIntPair$2.apply((Object)BoxesRunTime.boxToDouble((double)this.alternativeMz$1));
                double mzValue = nearestMzIntPair._1$mcD$sp();
                if (1000000.0 * Math.abs(mzValue - this.ipMz$1.elem) / this.ipMz$1.elem < this.ppmTol$4) {
                    this.ipMz$1.elem = mzValue;
                    ++this.matches$2.elem;
                    f = BoxesRunTime.unboxToFloat((Object)nearestMzIntPair._2());
                } else {
                    f = expectedAbundance / 1000.0f;
                }
                float foundAbundance = f;
                double relativeDiff = (double)((expectedAbundance - foundAbundance) / package$.MODULE$.min(foundAbundance, expectedAbundance)) * rankPenality;
                this.score$2.elem += relativeDiff * relativeDiff;
            }
            {
                this.getNearestMzIntPair$2 = getNearestMzIntPair$2;
                this.isotopicShift$2 = isotopicShift$2;
                this.charge$2 = charge$2;
                this.ppmTol$4 = ppmTol$4;
                this.alternativeMz$1 = alternativeMz$1;
                this.pattern$2 = pattern$2;
                this.monoIsoAb$1 = monoIsoAb$1;
                this.monoIsoTheoAb$1 = monoIsoTheoAb$1;
                this.score$2 = score$2;
                this.ipMz$1 = ipMz$1;
                this.matches$2 = matches$2;
            }
        });
        score.elem = Math.log10(score.elem) - (double)matches.elem;
        return new Tuple2((Object)BoxesRunTime.boxToDouble((double)score.elem), (Object)pattern);
    }

    private IsotopicPatternScorer$() {
        MODULE$ = this;
        LazyLogging.class.$init$((LazyLogging)this);
        this.MAX_CHARGE = 5;
    }
}

