/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.mzdb.algo;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import fr.profi.ms.model.TheoreticalIsotopePattern;
import fr.profi.mzdb.algo.IIsotopicPatternPredictor;
import fr.profi.mzdb.algo.IIsotopicPatternPredictor$class;
import fr.profi.mzdb.algo.IsotopicPatternScorer$;
import fr.profi.mzdb.model.Peakel;
import fr.profi.mzdb.model.PeakelCursor;
import fr.profi.mzdb.model.SpectrumData;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.mutable.ArrayBuffer;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class PeakelsPatternPredictor$
implements IIsotopicPatternPredictor {
    public static final PeakelsPatternPredictor$ MODULE$;
    private final Logger logger;
    private volatile boolean bitmap$0;

    static {
        new PeakelsPatternPredictor$();
    }

    @Override
    public boolean isMatchReliable(SpectrumData spectrumData, float ppm, double moz, int charge, double mozTolInDa) {
        return IIsotopicPatternPredictor$class.isMatchReliable(this, spectrumData, ppm, moz, charge, mozTolInDa);
    }

    private Logger logger$lzycompute() {
        PeakelsPatternPredictor$ peakelsPatternPredictor$ = this;
        synchronized (peakelsPatternPredictor$) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public Tuple2<Object, TheoreticalIsotopePattern> getBestExplanation(float mozTolPPM, Seq<Peakel> coelutingPeakels, Peakel peakel, int charge, double mozTolInDa) {
        Tuple2<ArrayBuffer<Object>, ArrayBuffer<Object>> tuple2 = this.slicePeakels(coelutingPeakels, peakel);
        if (tuple2 != null) {
            Tuple2 tuple22;
            ArrayBuffer mzList = (ArrayBuffer)tuple2._1();
            ArrayBuffer intensityList = (ArrayBuffer)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)mzList, (Object)intensityList);
            ArrayBuffer mzList2 = (ArrayBuffer)tuple23._1();
            ArrayBuffer intensityList2 = (ArrayBuffer)tuple23._2();
            SpectrumData spectrumData = new SpectrumData((double[])mzList2.toArray(ClassTag$.MODULE$.Double()), (float[])intensityList2.toArray(ClassTag$.MODULE$.Float()));
            Tuple2<Object, TheoreticalIsotopePattern>[] putativePatterns = IsotopicPatternScorer$.MODULE$.calcIsotopicPatternHypotheses(spectrumData, peakel.getApexMz(), (double)mozTolPPM);
            return (Tuple2)Predef$.MODULE$.refArrayOps((Object[])putativePatterns).head();
        }
        throw new MatchError(tuple2);
    }

    public ArrayBuffer<Tuple2<Peakel, Object>> assessReliability(float mozTolPPM, Seq<Peakel> coelutingPeakels, Seq<Peakel> matchingPeakels, int charge, double mozTolInDa) {
        ArrayBuffer filteredPeakels = new ArrayBuffer(matchingPeakels.length());
        matchingPeakels.foreach((Function1)new Serializable(mozTolPPM, coelutingPeakels, charge, mozTolInDa, filteredPeakels){
            public static final long serialVersionUID = 0L;
            private final float mozTolPPM$1;
            private final Seq coelutingPeakels$1;
            private final int charge$2;
            private final double mozTolInDa$2;
            private final ArrayBuffer filteredPeakels$2;

            public final ArrayBuffer<Tuple2<Peakel, Object>> apply(Peakel matchingPeakel) {
                Tuple2<ArrayBuffer<Object>, ArrayBuffer<Object>> tuple2 = PeakelsPatternPredictor$.MODULE$.slicePeakels((Seq<Peakel>)this.coelutingPeakels$1, matchingPeakel);
                if (tuple2 != null) {
                    Tuple2 tuple22;
                    ArrayBuffer mzList = (ArrayBuffer)tuple2._1();
                    ArrayBuffer intensityList = (ArrayBuffer)tuple2._2();
                    Tuple2 tuple23 = tuple22 = new Tuple2((Object)mzList, (Object)intensityList);
                    ArrayBuffer mzList2 = (ArrayBuffer)tuple23._1();
                    ArrayBuffer intensityList2 = (ArrayBuffer)tuple23._2();
                    SpectrumData spectrumData = new SpectrumData((double[])mzList2.toArray(ClassTag$.MODULE$.Double()), (float[])intensityList2.toArray(ClassTag$.MODULE$.Float()));
                    boolean isReliable = PeakelsPatternPredictor$.MODULE$.isMatchReliable(spectrumData, this.mozTolPPM$1, matchingPeakel.getApexMz(), this.charge$2, this.mozTolInDa$2);
                    return this.filteredPeakels$2.$plus$eq((Object)new Tuple2((Object)matchingPeakel, (Object)BoxesRunTime.boxToBoolean((boolean)isReliable)));
                }
                throw new MatchError(tuple2);
            }
            {
                this.mozTolPPM$1 = mozTolPPM$1;
                this.coelutingPeakels$1 = coelutingPeakels$1;
                this.charge$2 = charge$2;
                this.mozTolInDa$2 = mozTolInDa$2;
                this.filteredPeakels$2 = filteredPeakels$2;
            }
        });
        return filteredPeakels;
    }

    public Tuple2<ArrayBuffer<Object>, ArrayBuffer<Object>> slicePeakels(Seq<Peakel> coelutingPeakels, Peakel matchingPeakel) {
        long matchingSpectrumId = matchingPeakel.getApexSpectrumId();
        int coelutingPeakelsCount = coelutingPeakels.length();
        ArrayBuffer mzList = new ArrayBuffer(coelutingPeakelsCount);
        ArrayBuffer intensityList = new ArrayBuffer(coelutingPeakelsCount);
        ((TraversableLike)coelutingPeakels.sortBy((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply(Peakel x$5) {
                return x$5.getApexMz();
            }
        }, (Ordering)Ordering.Double$.MODULE$)).map((Function1)new Serializable(matchingSpectrumId, mzList, intensityList){
            public static final long serialVersionUID = 0L;
            private final long matchingSpectrumId$1;
            private final ArrayBuffer mzList$1;
            private final ArrayBuffer intensityList$1;

            public final void apply(Peakel peakel) {
                PeakelCursor peakelCursor = peakel.getNewCursor();
                boolean foundPeak = false;
                while (peakelCursor.next() && !foundPeak) {
                    if (peakelCursor.getSpectrumId() != this.matchingSpectrumId$1) continue;
                    this.mzList$1.$plus$eq((Object)BoxesRunTime.boxToDouble((double)peakelCursor.getMz()));
                    this.intensityList$1.$plus$eq((Object)BoxesRunTime.boxToFloat((float)peakelCursor.getIntensity()));
                    foundPeak = true;
                }
            }
            {
                this.matchingSpectrumId$1 = matchingSpectrumId$1;
                this.mzList$1 = mzList$1;
                this.intensityList$1 = intensityList$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
        return new Tuple2((Object)mzList, (Object)intensityList);
    }

    private PeakelsPatternPredictor$() {
        MODULE$ = this;
        LazyLogging.class.$init$((LazyLogging)this);
        IIsotopicPatternPredictor$class.$init$(this);
    }
}

