/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.mzdb.algo.feature.scoring;

import fr.profi.mzdb.algo.feature.scoring.FeatureEvaluation;
import fr.profi.mzdb.algo.feature.scoring.FeatureQualityAssessment;
import fr.profi.mzdb.algo.feature.scoring.FeatureQualityEvaluator$;
import fr.profi.mzdb.algo.feature.scoring.FeatureQualityVector;
import fr.profi.mzdb.algo.feature.scoring.FeatureScorer$;
import fr.profi.mzdb.algo.feature.scoring.FeatureScoringConfig;
import fr.profi.mzdb.algo.feature.scoring.FeatureScoringConfig$;
import fr.profi.mzdb.algo.feature.scoring.IFeatureThresholdsComputer;
import fr.profi.mzdb.algo.feature.scoring.QualityVectorThresholds;
import fr.profi.mzdb.model.Feature;
import fr.profi.mzdb.model.FeatureOverlapProperties;
import fr.profi.mzdb.model.ILcContext;
import fr.profi.mzdb.model.Peakel;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.generic.CanBuildFrom;
import scala.collection.mutable.LongMap;
import scala.collection.parallel.ParIterableLike;
import scala.collection.parallel.ParSeq$;
import scala.collection.parallel.mutable.ParArray$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class FeatureEvaluator$ {
    public static final FeatureEvaluator$ MODULE$;

    static {
        new FeatureEvaluator$();
    }

    public Seq<FeatureEvaluation> evaluateFeatures(Seq<Feature> features, FeatureScoringConfig ftScoringConfig, IFeatureThresholdsComputer thresholdComputer, LongMap<ILcContext> lcContextBySpectrumId) {
        FeatureQualityVector[] fq = (FeatureQualityVector[])((ParIterableLike)((ParIterableLike)features.par()).map((Function1)new Serializable(ftScoringConfig, lcContextBySpectrumId){
            public static final long serialVersionUID = 0L;
            private final FeatureScoringConfig ftScoringConfig$1;
            private final LongMap lcContextBySpectrumId$1;

            public final FeatureQualityVector apply(Feature f) {
                return FeatureEvaluator$.MODULE$.computeQualityVector(f, this.ftScoringConfig$1, (LongMap<ILcContext>)this.lcContextBySpectrumId$1);
            }
            {
                this.ftScoringConfig$1 = ftScoringConfig$1;
                this.lcContextBySpectrumId$1 = lcContextBySpectrumId$1;
            }
        }, (CanBuildFrom)ParSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(FeatureQualityVector.class));
        QualityVectorThresholds qualThresholds = thresholdComputer.getThresholds(fq);
        return Predef$.MODULE$.refArrayOps((Object[])((ParIterableLike)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])fq).zip(features, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).par().map((Function1)new Serializable(qualThresholds){
            public static final long serialVersionUID = 0L;
            private final QualityVectorThresholds qualThresholds$1;

            public final FeatureEvaluation apply(Tuple2<FeatureQualityVector, Feature> x0$1) {
                Tuple2<FeatureQualityVector, Feature> tuple2 = x0$1;
                if (tuple2 != null) {
                    FeatureQualityVector fq = (FeatureQualityVector)tuple2._1();
                    Feature f = (Feature)tuple2._2();
                    FeatureEvaluation featureEvaluation = FeatureEvaluator$.MODULE$.evaluateQualityVector(f, fq, this.qualThresholds$1);
                    return featureEvaluation;
                }
                throw new MatchError(tuple2);
            }
            {
                this.qualThresholds$1 = qualThresholds$1;
            }
        }, (CanBuildFrom)ParArray$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(FeatureEvaluation.class))).toSeq();
    }

    public FeatureQualityVector computeQualityVector(Feature f, FeatureScoringConfig ftScoringConfig, LongMap<ILcContext> lcContextBySpectrumId) {
        Tuple2 tuple2;
        block2: {
            block5: {
                float shape;
                block4: {
                    Object object;
                    float signalFluctuation;
                    block3: {
                        Tuple2 tuple22;
                        tuple2 = new Tuple2((Object)BoxesRunTime.boxToFloat((float)0.0f), (Object)BoxesRunTime.boxToFloat((float)0.0f));
                        if (tuple2 == null) break block2;
                        float signalFluctuation2 = BoxesRunTime.unboxToFloat((Object)tuple2._1());
                        float shape2 = BoxesRunTime.unboxToFloat((Object)tuple2._2());
                        Tuple2 tuple23 = tuple22 = new Tuple2((Object)BoxesRunTime.boxToFloat((float)signalFluctuation2), (Object)BoxesRunTime.boxToFloat((float)shape2));
                        signalFluctuation = BoxesRunTime.unboxToFloat((Object)tuple23._1());
                        shape = BoxesRunTime.unboxToFloat((Object)tuple23._2());
                        object = ftScoringConfig.methods().apply((Object)"signalFluctuation");
                        if (!"BasicPeakelFinder".equals(object)) break block3;
                        signalFluctuation = FeatureScorer$.MODULE$.calcSignalFluctuationByBasicPeakelFinder(f, lcContextBySpectrumId);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break block4;
                    }
                    if (!"WaveletBasedPeakelFinder".equals(object)) break block5;
                    signalFluctuation = FeatureScorer$.MODULE$.calcSignalFluctuationByWaveletBasedPeakelFinder(f, lcContextBySpectrumId);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
                int isotopesCount = f.getPeakelsCount();
                float isotopesPattern = FeatureScorer$.MODULE$.calcRmsdIsotopicPattern(f);
                float peakelsWidth = 0.0f;
                Peakel[] peakels = f.getPeakels();
                float peakelsCorrelation = FeatureScorer$.MODULE$.calcMeanPeakelCorrelation((Seq<Peakel>)Predef$.MODULE$.wrapRefArray((Object[])peakels));
                float peakelsApexDeviation = FeatureScorer$.MODULE$.calcMeanPeakelsApexDeviation(peakels);
                return new FeatureQualityVector(f.getMs1Count(), FeatureScorer$.MODULE$.calcStdDevPeakelsMzPrecision(f), shape, isotopesCount, isotopesPattern, peakelsWidth, peakelsCorrelation, peakelsApexDeviation, BoxesRunTime.unboxToFloat((Object)Option$.MODULE$.apply((Object)f.overlapProperties()).map((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final float apply(FeatureOverlapProperties x$14) {
                        return x$14.getOverlapPMCC();
                    }
                }).getOrElse((Function0)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final float apply() {
                        return this.apply$mcF$sp();
                    }

                    public float apply$mcF$sp() {
                        return 0.0f;
                    }
                })), FeatureScorer$.MODULE$.calcOverlappingFactor(f, 5.0));
            }
            throw new Exception("Error when assigning a  shape to a feature");
        }
        throw new MatchError((Object)tuple2);
    }

    public FeatureScoringConfig computeQualityVector$default$2() {
        return new FeatureScoringConfig(FeatureScoringConfig$.MODULE$.apply$default$1());
    }

    public FeatureEvaluation evaluateQualityVector(Feature f, FeatureQualityVector qualityVector, QualityVectorThresholds thresholds) {
        FeatureQualityAssessment assessment = FeatureQualityEvaluator$.MODULE$.evaluate(qualityVector, thresholds);
        return new FeatureEvaluation(f, qualityVector, assessment, qualityVector.overlappingFactor() == 0.0f);
    }

    private FeatureEvaluator$() {
        MODULE$ = this;
    }
}

