/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.mzdb.algo.feature.scoring;

import fr.profi.ms.algo.IsotopePatternInterpolator$;
import fr.profi.ms.model.TheoreticalIsotopePattern;
import fr.profi.mzdb.algo.feature.scoring.FeatureScorer$;
import fr.profi.mzdb.algo.signal.detection.BasicPeakelFinder;
import fr.profi.mzdb.algo.signal.detection.BasicPeakelFinder$;
import fr.profi.mzdb.algo.signal.detection.waveletImpl.WaveletDetectorDuMethod;
import fr.profi.mzdb.model.Feature;
import fr.profi.mzdb.model.ILcContext;
import fr.profi.mzdb.model.OverlappingFeature;
import fr.profi.mzdb.model.Peak;
import fr.profi.mzdb.model.Peakel;
import fr.profi.mzdb.util.math.VectorSimilarity$;
import org.apache.commons.math3.stat.descriptive.moment.StandardDeviation;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.LongMap;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.FloatRef;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;

public final class FeatureScorer$ {
    public static final FeatureScorer$ MODULE$;
    private final BasicPeakelFinder basicPeakelFinder;

    static {
        new FeatureScorer$();
    }

    public BasicPeakelFinder basicPeakelFinder() {
        return this.basicPeakelFinder;
    }

    public float calcMeanPeakelCorrelation(Seq<Peakel> peakels) {
        int peakelsCount = peakels.length();
        if (peakelsCount < 2) {
            return 0.0f;
        }
        DoubleRef peakelCorrSum = DoubleRef.create((double)0.0);
        peakels.sliding(2).foreach((Function1)new Serializable(peakelCorrSum){
            public static final long serialVersionUID = 0L;
            private final DoubleRef peakelCorrSum$1;

            public final void apply(Seq<Peakel> x0$1) {
                Seq<Peakel> seq = x0$1;
                Some some = Seq$.MODULE$.unapplySeq(seq);
                if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(2) == 0) {
                    Peakel p1 = (Peakel)((SeqLike)some.get()).apply(0);
                    Peakel p2 = (Peakel)((SeqLike)some.get()).apply(1);
                    this.peakelCorrSum$1.elem += FeatureScorer$.MODULE$.calcPeakelCorrelation(p1, p2);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(seq);
            }
            {
                this.peakelCorrSum$1 = peakelCorrSum$1;
            }
        });
        return (float)(peakelCorrSum.elem / (double)(peakelsCount - 1));
    }

    public double calcPeakelCorrelation(Peakel firstPeakel, Peakel secondPeakel) {
        Map firstPeakelIntensityByTime = Predef$.MODULE$.refArrayOps((Object[])firstPeakel.getElutionTimeIntensityPairs()).toMap(Predef$.MODULE$.$conforms());
        Map secondPeakelIntensityByTime = Predef$.MODULE$.refArrayOps((Object[])secondPeakel.getElutionTimeIntensityPairs()).toMap(Predef$.MODULE$.$conforms());
        ArrayBuffer firstPeakelIntensities = new ArrayBuffer();
        ArrayBuffer secondPeakelIntensities = new ArrayBuffer();
        Predef$.MODULE$.floatArrayOps(firstPeakel.elutionTimes()).foreach((Function1)new Serializable(firstPeakelIntensityByTime, secondPeakelIntensityByTime, firstPeakelIntensities, secondPeakelIntensities){
            public static final long serialVersionUID = 0L;
            private final Map firstPeakelIntensityByTime$1;
            private final Map secondPeakelIntensityByTime$1;
            private final ArrayBuffer firstPeakelIntensities$1;
            private final ArrayBuffer secondPeakelIntensities$1;

            public final Object apply(float elutionTime) {
                BoxedUnit boxedUnit;
                Option secondPeakelIntensityOpt = this.secondPeakelIntensityByTime$1.get((Object)BoxesRunTime.boxToFloat((float)elutionTime));
                if (secondPeakelIntensityOpt.isDefined()) {
                    this.firstPeakelIntensities$1.$plus$eq((Object)BoxesRunTime.boxToDouble((double)BoxesRunTime.unboxToFloat((Object)this.firstPeakelIntensityByTime$1.apply((Object)BoxesRunTime.boxToFloat((float)elutionTime)))));
                    boxedUnit = this.secondPeakelIntensities$1.$plus$eq((Object)BoxesRunTime.boxToDouble((double)BoxesRunTime.unboxToFloat((Object)secondPeakelIntensityOpt.get())));
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                return boxedUnit;
            }
            {
                this.firstPeakelIntensityByTime$1 = firstPeakelIntensityByTime$1;
                this.secondPeakelIntensityByTime$1 = secondPeakelIntensityByTime$1;
                this.firstPeakelIntensities$1 = firstPeakelIntensities$1;
                this.secondPeakelIntensities$1 = secondPeakelIntensities$1;
            }
        });
        if (firstPeakelIntensities.isEmpty()) {
            return Double.NaN;
        }
        return VectorSimilarity$.MODULE$.pearsonCorrelation((double[])firstPeakelIntensities.toArray(ClassTag$.MODULE$.Double()), (double[])secondPeakelIntensities.toArray(ClassTag$.MODULE$.Double()));
    }

    public float calcOverlappingFactor(Feature f, double mzTolInPpm) {
        if (f.overlapProperties() == null || f.overlapProperties().overlappingFeatures() == null) {
            return 0.0f;
        }
        double of = 0.0;
        double mz = f.getMz();
        double mzTolInDa = mz * mzTolInPpm / 1000000.0;
        ArrayBuffer overlappingMap = new ArrayBuffer();
        Peakel peakel = f.getFirstPeakel();
        long refSpectrumID = peakel.getApexSpectrumId();
        Tuple2 tuple2 = new Tuple2((Object)Option$.MODULE$.empty(), (Object)Option$.MODULE$.empty());
        if (tuple2 != null) {
            Tuple2 tuple22;
            Option leftOverlappingPeaks = (Option)tuple2._1();
            Option rightOverlappingPeaks = (Option)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)leftOverlappingPeaks, (Object)rightOverlappingPeaks);
            ObjectRef leftOverlappingPeaks2 = ObjectRef.create((Object)((Option)tuple23._1()));
            ObjectRef rightOverlappingPeaks2 = ObjectRef.create((Object)((Option)tuple23._2()));
            Predef$.MODULE$.refArrayOps((Object[])f.overlapProperties().overlappingFeatures()).foreach((Function1)new Serializable(mz, mzTolInDa, overlappingMap, peakel, refSpectrumID, leftOverlappingPeaks2, rightOverlappingPeaks2){
                public static final long serialVersionUID = 0L;
                public final double mz$1;
                public final double mzTolInDa$1;
                private final ArrayBuffer overlappingMap$1;
                private final Peakel peakel$1;
                public final long refSpectrumID$1;
                public final ObjectRef leftOverlappingPeaks$1;
                public final ObjectRef rightOverlappingPeaks$1;

                public final ArrayBuffer<Tuple3<Peakel, Option<Peakel>, Option<Peakel>>> apply(OverlappingFeature ovlFeature) {
                    Predef$.MODULE$.refArrayOps((Object[])ovlFeature.feature().indexedPeakels()).foreach((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.calcOverlappingFactor.1 $outer;

                        public final void apply(Tuple2<Peakel, Object> x0$2) {
                            Tuple2<Peakel, Object> tuple2 = x0$2;
                            if (tuple2 != null) {
                                BoxedUnit boxedUnit;
                                Peakel p = (Peakel)tuple2._1();
                                if (p.getMz() - this.$outer.mz$1 < this.$outer.mzTolInDa$1) {
                                    if (p.getApexSpectrumId() < this.$outer.refSpectrumID$1) {
                                        this.$outer.leftOverlappingPeaks$1.elem = new Some((Object)p);
                                    }
                                    if (p.getApexSpectrumId() > this.$outer.refSpectrumID$1) {
                                        this.$outer.rightOverlappingPeaks$1.elem = new Some((Object)p);
                                        boxedUnit = BoxedUnit.UNIT;
                                    } else {
                                        boxedUnit = BoxedUnit.UNIT;
                                    }
                                } else {
                                    boxedUnit = BoxedUnit.UNIT;
                                }
                                BoxedUnit boxedUnit2 = boxedUnit;
                                return;
                            }
                            throw new MatchError(tuple2);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    });
                    return this.overlappingMap$1.$plus$eq((Object)new Tuple3((Object)this.peakel$1, (Object)((Option)this.leftOverlappingPeaks$1.elem), (Object)((Option)this.rightOverlappingPeaks$1.elem)));
                }
                {
                    this.mz$1 = mz$1;
                    this.mzTolInDa$1 = mzTolInDa$1;
                    this.overlappingMap$1 = overlappingMap$1;
                    this.peakel$1 = peakel$1;
                    this.refSpectrumID$1 = refSpectrumID$1;
                    this.leftOverlappingPeaks$1 = leftOverlappingPeaks$1;
                    this.rightOverlappingPeaks$1 = rightOverlappingPeaks$1;
                }
            });
            return this.calcMeanOverlappingFactor((Seq<Tuple3<Peakel, Option<Peakel>, Option<Peakel>>>)overlappingMap);
        }
        throw new MatchError((Object)tuple2);
    }

    public float calcMeanOverlappingFactor(Seq<Tuple3<Peakel, Option<Peakel>, Option<Peakel>>> peakels) {
        if (peakels.isEmpty()) {
            return 0.0f;
        }
        FloatRef m = FloatRef.create((float)0.0f);
        peakels.foreach((Function1)new Serializable(m){
            public static final long serialVersionUID = 0L;
            private final FloatRef m$1;

            public final void apply(Tuple3<Peakel, Option<Peakel>, Option<Peakel>> p) {
                this.m$1.elem += FeatureScorer$.MODULE$.calcOverlappingFactor((Peakel)p._1(), (Option<Peakel>)((Option)p._2()), (Option<Peakel>)((Option)p._3()), FeatureScorer$.MODULE$.calcOverlappingFactor$default$4());
            }
            {
                this.m$1 = m$1;
            }
        });
        return m.elem / (float)peakels.length();
    }

    /*
     * Enabled aggressive block sorting
     */
    public float calcOverlappingFactor(Peakel peakel, Option<Peakel> leftOverlappingPeakel, Option<Peakel> rightOverlappingPeakel, float baseline) {
        Object object;
        Tuple2 tuple2;
        FloatRef of = FloatRef.create((float)0.0f);
        Serializable calcLeftOverlappingFactor = new Serializable(of){
            public static final long serialVersionUID = 0L;
            private final FloatRef of$1;

            public final void apply(Peakel p, Peakel lop) {
                Tuple2 tuple2 = new Tuple2(Predef$.MODULE$.floatArrayOps(p.intensityValues()).head(), Predef$.MODULE$.floatArrayOps(p.intensityValues()).last());
                if (tuple2 != null) {
                    Tuple2 tuple22;
                    float overlappingIntens = BoxesRunTime.unboxToFloat((Object)tuple2._1());
                    float refIntens = BoxesRunTime.unboxToFloat((Object)tuple2._2());
                    Tuple2 tuple23 = tuple22 = new Tuple2((Object)BoxesRunTime.boxToFloat((float)overlappingIntens), (Object)BoxesRunTime.boxToFloat((float)refIntens));
                    float overlappingIntens2 = BoxesRunTime.unboxToFloat((Object)tuple23._1());
                    float refIntens2 = BoxesRunTime.unboxToFloat((Object)tuple23._2());
                    this.of$1.elem += overlappingIntens2 / refIntens2 * (lop.getApexIntensity() / p.getApexIntensity());
                    return;
                }
                throw new MatchError((Object)tuple2);
            }
            {
                this.of$1 = of$1;
            }
        };
        Serializable calcRightOverlappingFactor = new Serializable(of){
            public static final long serialVersionUID = 0L;
            private final FloatRef of$1;

            public final void apply(Peakel p, Peakel rop) {
                Tuple2 tuple2 = new Tuple2(Predef$.MODULE$.floatArrayOps(p.intensityValues()).last(), Predef$.MODULE$.floatArrayOps(p.intensityValues()).head());
                if (tuple2 != null) {
                    Tuple2 tuple22;
                    float overlappingIntens = BoxesRunTime.unboxToFloat((Object)tuple2._1());
                    float refIntens = BoxesRunTime.unboxToFloat((Object)tuple2._2());
                    Tuple2 tuple23 = tuple22 = new Tuple2((Object)BoxesRunTime.boxToFloat((float)overlappingIntens), (Object)BoxesRunTime.boxToFloat((float)refIntens));
                    float overlappingIntens2 = BoxesRunTime.unboxToFloat((Object)tuple23._1());
                    float refIntens2 = BoxesRunTime.unboxToFloat((Object)tuple23._2());
                    this.of$1.elem += overlappingIntens2 / refIntens2 * (rop.getApexIntensity() / p.getApexIntensity());
                    return;
                }
                throw new MatchError((Object)tuple2);
            }
            {
                this.of$1 = of$1;
            }
        };
        Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToDouble((double)peakel.getApexMz()), (Object)BoxesRunTime.boxToFloat((float)peakel.getApexIntensity()));
        if (tuple22 == null) throw new MatchError((Object)tuple22);
        double mz = tuple22._1$mcD$sp();
        float intens = BoxesRunTime.unboxToFloat((Object)tuple22._2());
        Tuple2 tuple23 = tuple2 = new Tuple2((Object)BoxesRunTime.boxToDouble((double)mz), (Object)BoxesRunTime.boxToFloat((float)intens));
        double mz2 = tuple23._1$mcD$sp();
        float intens2 = BoxesRunTime.unboxToFloat((Object)tuple23._2());
        float lastIntens = BoxesRunTime.unboxToFloat((Object)Predef$.MODULE$.floatArrayOps(peakel.intensityValues()).last());
        float firstIntens = BoxesRunTime.unboxToFloat((Object)Predef$.MODULE$.floatArrayOps(peakel.intensityValues()).head());
        Option<Peakel> option = leftOverlappingPeakel;
        None$ none$ = None$.MODULE$;
        if (!(option != null ? !option.equals((Object)none$) : none$ != null)) {
            Option<Peakel> option2 = rightOverlappingPeakel;
            None$ none$2 = None$.MODULE$;
            if (!(option2 != null ? !option2.equals((Object)none$2) : none$2 != null)) {
                object = BoxedUnit.UNIT;
                return of.elem;
            }
        }
        Option<Peakel> option3 = leftOverlappingPeakel;
        None$ none$3 = None$.MODULE$;
        if (option3 == null ? none$3 != null : !option3.equals((Object)none$3)) {
            Option<Peakel> option4 = rightOverlappingPeakel;
            None$ none$4 = None$.MODULE$;
            if (!(option4 != null ? !option4.equals((Object)none$4) : none$4 != null)) {
                object = calcLeftOverlappingFactor.apply((Object)peakel, leftOverlappingPeakel.get());
                return of.elem;
            }
        }
        Option<Peakel> option5 = leftOverlappingPeakel;
        None$ none$5 = None$.MODULE$;
        if (!(option5 != null ? !option5.equals((Object)none$5) : none$5 != null)) {
            Option<Peakel> option6 = rightOverlappingPeakel;
            None$ none$6 = None$.MODULE$;
            if (option6 == null ? none$6 != null : !option6.equals((Object)none$6)) {
                object = calcRightOverlappingFactor.apply((Object)peakel, rightOverlappingPeakel.get());
                return of.elem;
            }
        }
        calcLeftOverlappingFactor.apply((Object)peakel, leftOverlappingPeakel.get());
        object = calcRightOverlappingFactor.apply((Object)peakel, rightOverlappingPeakel.get());
        return of.elem;
    }

    public float calcOverlappingFactor$default$4() {
        return 0.0f;
    }

    public float calcRmsdIsotopicPattern(Feature f) {
        Tuple2 tuple2;
        if (f.getPeakelsCount() < 2) {
            return Float.NaN;
        }
        double mz = f.getMz();
        TheoreticalIsotopePattern theoPattern = IsotopePatternInterpolator$.MODULE$.getTheoreticalPattern(mz, f.getCharge());
        double[] theoAbundances = (double[])Predef$.MODULE$.floatArrayOps(theoPattern.abundances()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply(float x$5) {
                return this.apply$mcDF$sp(x$5);
            }

            public double apply$mcDF$sp(float x$5) {
                return x$5 / (float)100;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
        double[] obsAbundances = (double[])Predef$.MODULE$.refArrayOps((Object[])f.indexedPeakels()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply(Tuple2<Peakel, Object> x$6) {
                return ((Peakel)x$6._1()).area();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
        double maxIntens = BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.doubleArrayOps(obsAbundances).max((Ordering)Ordering.Double$.MODULE$));
        double[] normAbundances = (double[])Predef$.MODULE$.doubleArrayOps(obsAbundances).map((Function1)new Serializable(maxIntens){
            public static final long serialVersionUID = 0L;
            private final double maxIntens$1;

            public final double apply(double x) {
                return this.apply$mcDD$sp(x);
            }

            public double apply$mcDD$sp(double x) {
                return x / this.maxIntens$1;
            }
            {
                this.maxIntens$1 = maxIntens$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
        Tuple2 tuple22 = tuple2 = theoAbundances.length < normAbundances.length ? new Tuple2((Object)theoAbundances, (Object)normAbundances) : new Tuple2((Object)normAbundances, (Object)theoAbundances);
        if (tuple2 != null) {
            Tuple2 tuple23;
            double[] shortest = (double[])tuple2._1();
            double[] longest = (double[])tuple2._2();
            Tuple2 tuple24 = tuple23 = new Tuple2((Object)shortest, (Object)longest);
            double[] shortest2 = (double[])tuple24._1();
            double[] longest2 = (double[])tuple24._2();
            return (float)VectorSimilarity$.MODULE$.rmsd(shortest2, (double[])Predef$.MODULE$.doubleArrayOps(longest2).take(shortest2.length));
        }
        throw new MatchError((Object)tuple2);
    }

    public float calcSignalFluctuationByBasicPeakelFinder(Feature f, LongMap<ILcContext> lcContextBySpectrumId) {
        FloatRef shape = FloatRef.create((float)0.0f);
        Predef$.MODULE$.refArrayOps((Object[])f.indexedPeakels()).foreach((Function1)new Serializable(lcContextBySpectrumId, shape){
            public static final long serialVersionUID = 0L;
            private final LongMap lcContextBySpectrumId$1;
            private final FloatRef shape$1;

            public final void apply(Tuple2<Peakel, Object> x0$3) {
                Tuple2<Peakel, Object> tuple2 = x0$3;
                if (tuple2 != null) {
                    Peakel p = (Peakel)tuple2._1();
                    this.shape$1.elem += (float)FeatureScorer$.MODULE$.basicPeakelFinder().findPeakelsIndices((Seq<Peak>)Predef$.MODULE$.wrapRefArray((Object[])p.toPeaks((LongMap<? extends ILcContext>)this.lcContextBySpectrumId$1))).length;
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                this.lcContextBySpectrumId$1 = lcContextBySpectrumId$1;
                this.shape$1 = shape$1;
            }
        });
        return shape.elem / (float)f.getPeakelsCount();
    }

    public float calcSignalFluctuationByWaveletBasedPeakelFinder(Feature f, LongMap<ILcContext> lcContextBySpectrumId) {
        FloatRef shape = FloatRef.create((float)0.0f);
        Predef$.MODULE$.refArrayOps((Object[])f.indexedPeakels()).foreach((Function1)new Serializable(lcContextBySpectrumId, shape){
            public static final long serialVersionUID = 0L;
            private final LongMap lcContextBySpectrumId$2;
            private final FloatRef shape$2;

            public final void apply(Tuple2<Peakel, Object> x0$4) {
                Tuple2<Peakel, Object> tuple2 = x0$4;
                if (tuple2 != null) {
                    Peakel p = (Peakel)tuple2._1();
                    this.shape$2.elem += (float)new WaveletDetectorDuMethod((Seq<Peak>)Predef$.MODULE$.wrapRefArray((Object[])p.toPeaks((LongMap<? extends ILcContext>)this.lcContextBySpectrumId$2))).findCwtPeakels().length;
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                this.lcContextBySpectrumId$2 = lcContextBySpectrumId$2;
                this.shape$2 = shape$2;
            }
        });
        return shape.elem / (float)f.getPeakelsCount();
    }

    public float calcStdDevPeakelsMzPrecision(Feature f) {
        ArrayBuffer peakelsMzPrecision = new ArrayBuffer();
        Predef$.MODULE$.refArrayOps((Object[])f.indexedPeakels()).foreach((Function1)new Serializable(peakelsMzPrecision){
            public static final long serialVersionUID = 0L;
            private final ArrayBuffer peakelsMzPrecision$1;

            public final ArrayBuffer<Object> apply(Tuple2<Peakel, Object> x0$5) {
                Tuple2<Peakel, Object> tuple2 = x0$5;
                if (tuple2 != null) {
                    Peakel peakel = (Peakel)tuple2._1();
                    double stdDev = new StandardDeviation().evaluate(peakel.mzValues());
                    ArrayBuffer arrayBuffer = this.peakelsMzPrecision$1.$plus$eq((Object)BoxesRunTime.boxToDouble((double)(stdDev * (double)peakel.getArea())));
                    return arrayBuffer;
                }
                throw new MatchError(tuple2);
            }
            {
                this.peakelsMzPrecision$1 = peakelsMzPrecision$1;
            }
        });
        return peakelsMzPrecision.isEmpty() ? Float.NaN : (float)(BoxesRunTime.unboxToDouble((Object)peakelsMzPrecision.sum((Numeric)Numeric.DoubleIsFractional$.MODULE$)) / (f.getMz() * (double)BoxesRunTime.unboxToFloat((Object)Predef$.MODULE$.floatArrayOps((float[])Predef$.MODULE$.refArrayOps((Object[])f.indexedPeakels()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final float apply(Tuple2<Peakel, Object> x$8) {
                return ((Peakel)x$8._1()).getArea();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Float()))).sum((Numeric)Numeric.FloatIsFractional$.MODULE$))));
    }

    public float calcPeakelsAmplitude(Feature f) {
        if (Predef$.MODULE$.refArrayOps((Object[])f.indexedPeakels()).isEmpty()) {
            return Float.NaN;
        }
        FloatRef weightedAmplitudeSum = FloatRef.create((float)0.0f);
        FloatRef areaSum = FloatRef.create((float)0.0f);
        Predef$.MODULE$.refArrayOps((Object[])f.indexedPeakels()).withFilter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<Peakel, Object> check$ifrefutable$1) {
                Tuple2<Peakel, Object> tuple2 = check$ifrefutable$1;
                boolean bl = tuple2 != null;
                return bl;
            }
        }).foreach((Function1)new Serializable(weightedAmplitudeSum, areaSum){
            public static final long serialVersionUID = 0L;
            private final FloatRef weightedAmplitudeSum$1;
            private final FloatRef areaSum$1;

            public final void apply(Tuple2<Peakel, Object> x$9) {
                Tuple2<Peakel, Object> tuple2 = x$9;
                if (tuple2 != null) {
                    Peakel peakel = (Peakel)tuple2._1();
                    float[] intensityValues = peakel.intensityValues();
                    float area = peakel.getArea();
                    this.weightedAmplitudeSum$1.elem += BoxesRunTime.unboxToFloat((Object)Predef$.MODULE$.floatArrayOps(intensityValues).max((Ordering)Ordering.Float$.MODULE$)) / BoxesRunTime.unboxToFloat((Object)Predef$.MODULE$.floatArrayOps(intensityValues).min((Ordering)Ordering.Float$.MODULE$)) * area;
                    this.areaSum$1.elem += area;
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                this.weightedAmplitudeSum$1 = weightedAmplitudeSum$1;
                this.areaSum$1 = areaSum$1;
            }
        });
        return weightedAmplitudeSum.elem / areaSum.elem;
    }

    public float fr$profi$mzdb$algo$feature$scoring$FeatureScorer$$getDistanceBetweenTwoPoints(float x1, float y1, float x2, float y2) {
        return (float)package$.MODULE$.sqrt(package$.MODULE$.pow((double)(x2 - x1), 2.0) + package$.MODULE$.pow((double)(y2 - y1), 2.0));
    }

    public float fr$profi$mzdb$algo$feature$scoring$FeatureScorer$$getDistanceSum(Peakel peakel) {
        FloatRef sum = FloatRef.create((float)0.0f);
        Predef$.MODULE$.longArrayOps(peakel.spectrumIds()).indices().sliding(2).withFilter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(IndexedSeq<Object> x$10) {
                return x$10.size() == 2;
            }
        }).foreach((Function1)new Serializable(peakel, sum){
            public static final long serialVersionUID = 0L;
            private final Peakel peakel$2;
            private final FloatRef sum$1;

            public final void apply(IndexedSeq<Object> indexPair) {
                Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(BoxesRunTime.unboxToInt((Object)indexPair.apply(0)), BoxesRunTime.unboxToInt((Object)indexPair.apply(1)));
                if (sp2 != null) {
                    Tuple2.mcII.sp sp3;
                    int idx1 = sp2._1$mcI$sp();
                    int idx2 = sp2._2$mcI$sp();
                    Tuple2.mcII.sp sp4 = sp3 = new Tuple2.mcII.sp(idx1, idx2);
                    int idx12 = sp4._1$mcI$sp();
                    int idx22 = sp4._2$mcI$sp();
                    float t1 = this.peakel$2.elutionTimes()[idx12];
                    float t2 = this.peakel$2.elutionTimes()[idx22];
                    float i1 = this.peakel$2.intensityValues()[idx12];
                    float i2 = this.peakel$2.intensityValues()[idx22];
                    this.sum$1.elem += FeatureScorer$.MODULE$.fr$profi$mzdb$algo$feature$scoring$FeatureScorer$$getDistanceBetweenTwoPoints(t1, i1, t2, i2);
                    return;
                }
                throw new MatchError((Object)sp2);
            }
            {
                this.peakel$2 = peakel$2;
                this.sum$1 = sum$1;
            }
        });
        return sum.elem;
    }

    public float calcDistanceOverArea(Feature f) {
        FloatRef m = FloatRef.create((float)0.0f);
        Predef$.MODULE$.refArrayOps((Object[])f.indexedPeakels()).foreach((Function1)new Serializable(m){
            public static final long serialVersionUID = 0L;
            private final FloatRef m$2;

            public final void apply(Tuple2<Peakel, Object> x0$6) {
                Tuple2<Peakel, Object> tuple2 = x0$6;
                if (tuple2 != null) {
                    Peakel p = (Peakel)tuple2._1();
                    this.m$2.elem += FeatureScorer$.MODULE$.fr$profi$mzdb$algo$feature$scoring$FeatureScorer$$getDistanceSum(p) * p.area();
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                this.m$2 = m$2;
            }
        });
        return m.elem / (float)package$.MODULE$.pow((double)BoxesRunTime.unboxToFloat((Object)Predef$.MODULE$.floatArrayOps((float[])Predef$.MODULE$.refArrayOps((Object[])f.indexedPeakels()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final float apply(Tuple2<Peakel, Object> x$12) {
                return ((Peakel)x$12._1()).intensitySum();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Float()))).sum((Numeric)Numeric.FloatIsFractional$.MODULE$)), 2.0);
    }

    public float calcMeanPeakelsApexDeviation(Peakel[] peakels) {
        FloatRef m = FloatRef.create((float)0.0f);
        IntRef count = IntRef.create((int)0);
        Predef$.MODULE$.refArrayOps((Object[])peakels).sliding(2).withFilter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Peakel[] x$13) {
                return x$13.length == 2;
            }
        }).foreach((Function1)new Serializable(m, count){
            public static final long serialVersionUID = 0L;
            private final FloatRef m$3;
            private final IntRef count$1;

            public final void apply(Peakel[] x) {
                this.m$3.elem += (float)package$.MODULE$.abs(x[0].apexIndex() - x[1].apexIndex());
                ++this.count$1.elem;
            }
            {
                this.m$3 = m$3;
                this.count$1 = count$1;
            }
        });
        return m.elem / (float)count.elem;
    }

    private FeatureScorer$() {
        MODULE$ = this;
        this.basicPeakelFinder = new BasicPeakelFinder(BasicPeakelFinder$.MODULE$.$lessinit$greater$default$1(), BasicPeakelFinder$.MODULE$.$lessinit$greater$default$2());
    }
}

