/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.mzdb.util.math.pdf;

import fr.profi.mzdb.util.math.pdf.GaussianModel;
import fr.profi.mzdb.util.math.pdf.IProbabilityFunction;
import scala.Predef$;
import scala.math.package$;

public final class GaussianFunction$
implements IProbabilityFunction {
    public static final GaussianFunction$ MODULE$;
    private final double sigmaToFwhmFactor;

    static {
        new GaussianFunction$();
    }

    public GaussianModel apply(double xZero, double yMax, double sigma) {
        return new GaussianModel(xZero, yMax, sigma);
    }

    public double sigmaToFwhmFactor() {
        return this.sigmaToFwhmFactor;
    }

    public double yMax(double xZero, double sigmaSquared, double x, double y) {
        Predef$.MODULE$.require(sigmaSquared > 0.0);
        double nx = x - xZero;
        return y / package$.MODULE$.exp(-(nx * nx) / ((double)2 * sigmaSquared));
    }

    public double y(double xZero, double sigmaSquared, double yMax, double x) {
        Predef$.MODULE$.require(sigmaSquared > 0.0);
        double nx = x - xZero;
        return yMax * package$.MODULE$.exp(-(nx * nx) / ((double)2 * sigmaSquared));
    }

    public double sigma(double width, double relativeHeight) {
        Predef$.MODULE$.require(width > 0.0);
        Predef$.MODULE$.require(relativeHeight > 0.0 && relativeHeight <= 1.0);
        return width / ((double)2 * package$.MODULE$.sqrt((double)-2 * package$.MODULE$.log(relativeHeight)));
    }

    public double width(double sigma, double relativeHeight) {
        Predef$.MODULE$.require(sigma > 0.0);
        Predef$.MODULE$.require(relativeHeight <= 1.0);
        return sigma * ((double)2 * package$.MODULE$.sqrt((double)-2 * package$.MODULE$.log(relativeHeight)));
    }

    public double fwhm(double sigma) {
        return sigma * this.sigmaToFwhmFactor();
    }

    private GaussianFunction$() {
        MODULE$ = this;
        this.sigmaToFwhmFactor = (double)2 * package$.MODULE$.sqrt((double)2 * package$.MODULE$.log(2.0));
    }
}

