/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.mzdb.util.math.wavelet;

import edu.emory.mathcs.jtransforms.fft.FloatFFT_1D;
import fr.profi.mzdb.util.math.wavelet.MexicanHat;
import fr.profi.mzdb.util.math.wavelet.MexicanHat$;
import fr.profi.mzdb.util.math.wavelet.MotherWavelet;
import fr.profi.mzdb.util.math.wavelet.WaveletUtils$;
import fr.profi.mzdb.util.math.wavelet.WaveletUtils$$anonfun$cwt$1$;
import org.apache.commons.math3.complex.Complex;
import org.apache.commons.math3.transform.DftNormalization;
import org.apache.commons.math3.transform.FastFourierTransformer;
import org.apache.commons.math3.transform.TransformType;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.HashMap;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.util.control.Breaks$;

public final class WaveletUtils$ {
    public static final WaveletUtils$ MODULE$;
    private final FastFourierTransformer transformer;

    static {
        new WaveletUtils$();
    }

    public FastFourierTransformer transformer() {
        return this.transformer;
    }

    public Integer nextPowerOf2(Integer a) {
        int b;
        for (b = 1; b < Predef$.MODULE$.Integer2int(a); b <<= 1) {
        }
        if (b == 1 || b == 2) {
            b = 4;
        }
        return Predef$.MODULE$.int2Integer(b);
    }

    public boolean checkIfItsPowerOf2(Integer n) {
        if (BoxesRunTime.equalsNumObject((Number)n, (Object)BoxesRunTime.boxToInteger((int)0)) || BoxesRunTime.equalsNumObject((Number)n, (Object)BoxesRunTime.boxToInteger((int)1)) || BoxesRunTime.equalsNumObject((Number)n, (Object)BoxesRunTime.boxToInteger((int)2))) {
            return false;
        }
        return BoxesRunTime.equals((Object)BoxesRunTime.boxToInteger((int)(Predef$.MODULE$.Integer2int(n) & -Predef$.MODULE$.Integer2int(n))), (Object)n);
    }

    public double[] makePowerOf2(double[] ydata) {
        double[] dArray;
        if (this.checkIfItsPowerOf2(Predef$.MODULE$.int2Integer(ydata.length))) {
            dArray = ydata;
        } else {
            int diff = Predef$.MODULE$.Integer2int(this.nextPowerOf2(Predef$.MODULE$.int2Integer(ydata.length))) - ydata.length;
            ArrayBuffer ydatabuff = new ArrayBuffer();
            Predef$.MODULE$.doubleArrayOps(ydata).copyToBuffer((Buffer)ydatabuff);
            RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), diff - 1).foreach((Function1)new Serializable(ydatabuff){
                public static final long serialVersionUID = 0L;
                private final ArrayBuffer ydatabuff$1;

                public final ArrayBuffer<Object> apply(int i) {
                    return this.ydatabuff$1.$plus$eq((Object)BoxesRunTime.boxToDouble((double)0.0));
                }
                {
                    this.ydatabuff$1 = ydatabuff$1;
                }
            });
            dArray = (double[])ydatabuff.toArray(ClassTag$.MODULE$.Double());
        }
        return dArray;
    }

    public Complex[] makePowerOf2(Complex[] ydata) {
        Complex[] complexArray;
        if (this.checkIfItsPowerOf2(Predef$.MODULE$.int2Integer(ydata.length))) {
            complexArray = ydata;
        } else {
            int diff = Predef$.MODULE$.Integer2int(this.nextPowerOf2(Predef$.MODULE$.int2Integer(ydata.length))) - ydata.length;
            ArrayBuffer ydatabuff = new ArrayBuffer();
            Predef$.MODULE$.refArrayOps((Object[])ydata).copyToBuffer((Buffer)ydatabuff);
            RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), diff - 1).foreach((Function1)new Serializable(ydatabuff){
                public static final long serialVersionUID = 0L;
                private final ArrayBuffer ydatabuff$2;

                public final ArrayBuffer<Complex> apply(int i) {
                    return this.ydatabuff$2.$plus$eq((Object)new Complex(0.0, 0.0));
                }
                {
                    this.ydatabuff$2 = ydatabuff$2;
                }
            });
            complexArray = (Complex[])ydatabuff.toArray(ClassTag$.MODULE$.apply(Complex.class));
        }
        return complexArray;
    }

    public float[] periodicExtend(Buffer<Object> sig, int a) {
        int len = sig.length();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), a).foreach((Function1)new Serializable(sig){
            public static final long serialVersionUID = 0L;
            private final Buffer sig$1;

            public final Buffer<Object> apply(int i) {
                float temp1 = BoxesRunTime.unboxToFloat((Object)this.sig$1.apply(2 * i));
                float temp2 = BoxesRunTime.unboxToFloat((Object)this.sig$1.last());
                this.sig$1.$plus$eq$colon((Object)BoxesRunTime.boxToFloat((float)temp2));
                return this.sig$1.$plus$eq((Object)BoxesRunTime.boxToFloat((float)temp1));
            }
            {
                this.sig$1 = sig$1;
            }
        });
        return (float[])sig.toArray(ClassTag$.MODULE$.Float());
    }

    public double[] convolveUsingFft(double[] y, double[] wavelet, boolean useConjugate) {
        int initLength = y.length;
        double[] ypower2 = this.makePowerOf2(y);
        Complex[] yfft = this.transformer().transform(ypower2, TransformType.FORWARD);
        double[] waveletsized = (double[])Predef$.MODULE$.doubleArrayOps(wavelet).$plus$plus((GenTraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), ypower2.length - wavelet.length).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply(int i) {
                return this.apply$mcDI$sp(i);
            }

            public double apply$mcDI$sp(int i) {
                return 0.0;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
        Predef$.MODULE$.require(waveletsized.length == ypower2.length, (Function0)new Serializable(ypower2, waveletsized){
            public static final long serialVersionUID = 0L;
            private final double[] ypower2$1;
            private final double[] waveletsized$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ydata length: ", ", wavelet size: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.ypower2$1.length), BoxesRunTime.boxToInteger((int)this.waveletsized$1.length)}));
            }
            {
                this.ypower2$1 = ypower2$1;
                this.waveletsized$1 = waveletsized$1;
            }
        });
        Complex[] waveletfft = (Complex[])Predef$.MODULE$.refArrayOps((Object[])this.transformer().transform(waveletsized, TransformType.FORWARD)).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Complex apply(Complex x$1) {
                return x$1.conjugate();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Complex.class)));
        Complex[] x = (Complex[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])yfft).zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])waveletfft), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Complex apply(Tuple2<Complex, Complex> x0$1) {
                Tuple2<Complex, Complex> tuple2 = x0$1;
                if (tuple2 != null) {
                    Complex a = (Complex)tuple2._1();
                    Complex b = (Complex)tuple2._2();
                    Complex complex = a.multiply(b);
                    return complex;
                }
                throw new MatchError(tuple2);
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Complex.class)));
        return (double[])Predef$.MODULE$.doubleArrayOps((double[])Predef$.MODULE$.refArrayOps((Object[])this.transformer().transform(x, TransformType.INVERSE)).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply(Complex x$2) {
                return x$2.getReal();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()))).take(initLength);
    }

    public boolean convolveUsingFft$default$3() {
        return true;
    }

    public float[] convolveUsingJtransform(float[] y, float[] wavelet, boolean useConjugate) {
        int N = y.length;
        FloatFFT_1D fft2 = new FloatFFT_1D(N);
        float[] yfft = (float[])Array$.MODULE$.fill(N * 2, (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final float apply() {
                return this.apply$mcF$sp();
            }

            public float apply$mcF$sp() {
                return 0.0f;
            }
        }, ClassTag$.MODULE$.Float());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), N).foreach$mVc$sp((Function1)new Serializable(y, yfft){
            public static final long serialVersionUID = 0L;
            private final float[] y$1;
            private final float[] yfft$1;

            public final void apply(int j) {
                this.apply$mcVI$sp(j);
            }

            public void apply$mcVI$sp(int j) {
                this.yfft$1[2 * j] = this.y$1[j];
            }
            {
                this.y$1 = y$1;
                this.yfft$1 = yfft$1;
            }
        });
        fft2.complexForward(yfft);
        float[] wavepadded = (float[])Array$.MODULE$.fill(N * 2, (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final float apply() {
                return this.apply$mcF$sp();
            }

            public float apply$mcF$sp() {
                return 0.0f;
            }
        }, ClassTag$.MODULE$.Float());
        int r = package$.MODULE$.min(wavelet.length, N);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), r).foreach$mVc$sp((Function1)new Serializable(wavelet, wavepadded){
            public static final long serialVersionUID = 0L;
            private final float[] wavelet$1;
            private final float[] wavepadded$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                this.wavepadded$1[2 * i] = this.wavelet$1[i];
            }
            {
                this.wavelet$1 = wavelet$1;
                this.wavepadded$1 = wavepadded$1;
            }
        });
        fft2.complexForward(wavepadded);
        float[] x = (float[])Array$.MODULE$.fill(2 * N, (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final float apply() {
                return this.apply$mcF$sp();
            }

            public float apply$mcF$sp() {
                return 0.0f;
            }
        }, ClassTag$.MODULE$.Float());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), N).foreach$mVc$sp((Function1)new Serializable(useConjugate, yfft, wavepadded, x){
            public static final long serialVersionUID = 0L;
            private final boolean useConjugate$1;
            private final float[] yfft$1;
            private final float[] wavepadded$1;
            private final float[] x$5;

            public final void apply(int j) {
                this.apply$mcVI$sp(j);
            }

            public void apply$mcVI$sp(int j) {
                float value2 = this.useConjugate$1 ? -this.wavepadded$1[2 * j + 1] : this.wavepadded$1[2 * j + 1];
                this.x$5[2 * j] = this.yfft$1[2 * j] * this.wavepadded$1[2 * j] - this.yfft$1[2 * j + 1] * value2;
                this.x$5[2 * j + 1] = this.yfft$1[2 * j] * value2 + this.wavepadded$1[2 * j] * this.yfft$1[2 * j + 1];
            }
            {
                this.useConjugate$1 = useConjugate$1;
                this.yfft$1 = yfft$1;
                this.wavepadded$1 = wavepadded$1;
                this.x$5 = x$5;
            }
        });
        fft2.complexInverse(x, true);
        return (float[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.floatArrayOps(x).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).collect((PartialFunction)new Serializable(){
            public static final long serialVersionUID = 0L;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends Tuple2<Object, Object>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 != null) {
                    float value2 = BoxesRunTime.unboxToFloat((Object)A1._1());
                    int idx = A1._2$mcI$sp();
                    if (idx % 2 == 0) {
                        object = BoxesRunTime.boxToFloat((float)value2);
                        return (B1)object;
                    }
                }
                object = function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(Tuple2<Object, Object> x1) {
                int idx;
                Tuple2<Object, Object> tuple2 = x1;
                boolean bl = tuple2 != null && (idx = tuple2._2$mcI$sp()) % 2 == 0;
                return bl;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Float()));
    }

    public boolean convolveUsingJtransform$default$3() {
        return true;
    }

    public HashMap<Object, float[]> cwt(float[] ydata, MotherWavelet wavelet, float[] scales) {
        int extendLength = wavelet.nbPoints() / 3;
        float[] ydataExtended = this.periodicExtend((Buffer<Object>)Predef$.MODULE$.floatArrayOps(ydata).toBuffer(), extendLength);
        ObjectRef coeffs = ObjectRef.create((Object)new HashMap());
        float[] waveletValues = (float[])wavelet.values();
        float[] psiXval = wavelet.getPsiXval();
        float dxval = psiXval[1];
        float xmax = BoxesRunTime.unboxToFloat((Object)Predef$.MODULE$.floatArrayOps(psiXval).last());
        IntRef prevExiting = IntRef.create((int)scales.length);
        Breaks$.MODULE$.breakable((Function0)new Serializable(ydata, scales, extendLength, ydataExtended, coeffs, waveletValues, dxval, xmax, prevExiting){
            public static final long serialVersionUID = 0L;
            public final float[] ydata$1;
            public final float[] scales$1;
            public final int extendLength$1;
            public final float[] ydataExtended$1;
            public final ObjectRef coeffs$1;
            public final float[] waveletValues$1;
            public final float dxval$1;
            public final float xmax$1;
            public final IntRef prevExiting$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.scales$1.length).foreach$mVc$sp((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.cwt.1 $outer;

                    public final void apply(int scaleIndex) {
                        this.apply$mcVI$sp(scaleIndex);
                    }

                    public void apply$mcVI$sp(int scaleIndex) {
                        float scale = this.$outer.scales$1[scaleIndex];
                        ObjectRef f = ObjectRef.create((Object)((float[])((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.$outer.ydataExtended$1.length).map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final float apply(int i) {
                                return this.apply$mcFI$sp(i);
                            }

                            public float apply$mcFI$sp(int i) {
                                return 0.0f;
                            }
                        }, IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Float())));
                        int maxStuff = (int)(scale * this.$outer.xmax$1);
                        int[] indexes = (int[])Predef$.MODULE$.intArrayOps((int[])RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), maxStuff).by(1).toArray(ClassTag$.MODULE$.Int())).map((Function1)new Serializable(this, scale){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ anonfun$cwt$1$$anonfun$apply$mcV$sp$1 $outer;
                            private final float scale$1;

                            public final int apply(int x) {
                                return this.apply$mcII$sp(x);
                            }

                            public int apply$mcII$sp(int x) {
                                return (int)package$.MODULE$.floor((double)((float)x / (this.scale$1 * this.$outer.fr$profi$mzdb$util$math$wavelet$WaveletUtils$$anonfun$$anonfun$$$outer().dxval$1)));
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.scale$1 = scale$1;
                            }
                        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()));
                        int lenWave = indexes.length;
                        float[] waveletCoeffs = (float[])Predef$.MODULE$.intArrayOps(indexes).map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ anonfun$cwt$1$$anonfun$apply$mcV$sp$1 $outer;

                            public final float apply(int x$3) {
                                return this.apply$mcFI$sp(x$3);
                            }

                            public float apply$mcFI$sp(int x$3) {
                                return this.$outer.fr$profi$mzdb$util$math$wavelet$WaveletUtils$$anonfun$$anonfun$$$outer().waveletValues$1[x$3];
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Float()));
                        float mean = BoxesRunTime.unboxToFloat((Object)Predef$.MODULE$.floatArrayOps(waveletCoeffs).sum((Numeric)Numeric.FloatIsFractional$.MODULE$)) / (float)waveletCoeffs.length;
                        float[] v = (float[])Predef$.MODULE$.floatArrayOps((float[])Predef$.MODULE$.floatArrayOps(waveletCoeffs).reverse()).map((Function1)new Serializable(this, mean){
                            public static final long serialVersionUID = 0L;
                            private final float mean$1;

                            public final float apply(float x$4) {
                                return this.apply$mcFF$sp(x$4);
                            }

                            public float apply$mcFF$sp(float x$4) {
                                return x$4 - this.mean$1;
                            }
                            {
                                this.mean$1 = mean$1;
                            }
                        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Float()));
                        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), package$.MODULE$.min(((float[])f.elem).length, lenWave)).foreach$mVc$sp((Function1)new Serializable(this, f, v){
                            public static final long serialVersionUID = 0L;
                            private final ObjectRef f$1;
                            private final float[] v$1;

                            public final void apply(int i) {
                                this.apply$mcVI$sp(i);
                            }

                            public void apply$mcVI$sp(int i) {
                                ((float[])this.f$1.elem)[i] = this.v$1[i];
                            }
                            {
                                this.f$1 = f$1;
                                this.v$1 = v$1;
                            }
                        });
                        if (((float[])f.elem).length > this.$outer.ydataExtended$1.length) {
                            this.$outer.prevExiting$1.elem = scaleIndex;
                            throw Breaks$.MODULE$.break();
                        }
                        float[] convolvingResult = WaveletUtils$.MODULE$.convolveUsingJtransform(this.$outer.ydataExtended$1, (float[])f.elem, true);
                        float[] scaleogram = (float[])Predef$.MODULE$.floatArrayOps(convolvingResult).map((Function1)new Serializable(this, scale){
                            public static final long serialVersionUID = 0L;
                            private final float scale$1;

                            public final float apply(float x) {
                                return this.apply$mcFF$sp(x);
                            }

                            public float apply$mcFF$sp(float x) {
                                return (float)((double)x * (1.0 / package$.MODULE$.sqrt((double)this.scale$1)));
                            }
                            {
                                this.scale$1 = scale$1;
                            }
                        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Float()));
                        int p = this.$outer.ydataExtended$1.length - (int)package$.MODULE$.floor((double)((float)lenWave / 2.0f));
                        ((HashMap)this.$outer.coeffs$1.elem).update((Object)BoxesRunTime.boxToFloat((float)scale), Predef$.MODULE$.floatArrayOps((float[])Predef$.MODULE$.floatArrayOps((float[])Predef$.MODULE$.floatArrayOps(scaleogram).slice(p, this.$outer.ydataExtended$1.length)).$plus$plus((GenTraversableOnce)Predef$.MODULE$.floatArrayOps((float[])Predef$.MODULE$.floatArrayOps(scaleogram).slice(0, p)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Float()))).slice(this.$outer.extendLength$1, this.$outer.ydata$1.length + this.$outer.extendLength$1));
                    }

                    public /* synthetic */ anonfun.cwt.1 fr$profi$mzdb$util$math$wavelet$WaveletUtils$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.ydata$1 = ydata$1;
                this.scales$1 = scales$1;
                this.extendLength$1 = extendLength$1;
                this.ydataExtended$1 = ydataExtended$1;
                this.coeffs$1 = coeffs$1;
                this.waveletValues$1 = waveletValues$1;
                this.dxval$1 = dxval$1;
                this.xmax$1 = xmax$1;
                this.prevExiting$1 = prevExiting$1;
            }
        });
        if (prevExiting.elem == scales.length) {
            return (HashMap)coeffs.elem;
        }
        return (HashMap)((HashMap)coeffs.elem).slice(0, prevExiting.elem);
    }

    public MotherWavelet cwt$default$2() {
        return new MexicanHat(MexicanHat$.MODULE$.apply$default$1(), MexicanHat$.MODULE$.apply$default$2(), MexicanHat$.MODULE$.apply$default$3());
    }

    public void denoiseCoeffs(double[][] coeffs, float percent) {
        Predef$.MODULE$.refArrayOps((Object[])coeffs).foreach((Function1)new Serializable(percent){
            public static final long serialVersionUID = 0L;
            private final float percent$1;

            public final void apply(double[] coeff) {
                double[] value2 = (double[])Predef$.MODULE$.doubleArrayOps(coeff).sortBy((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final double apply(double x) {
                        return this.apply$mcDD$sp(x);
                    }

                    public double apply$mcDD$sp(double x) {
                        return x;
                    }
                }, (Ordering)Ordering.Double$.MODULE$);
                DoubleRef thresh = DoubleRef.create((double)value2[(int)(this.percent$1 * (float)coeff.length)]);
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), coeff.length).foreach$mVc$sp((Function1)new Serializable(this, thresh, coeff){
                    public static final long serialVersionUID = 0L;
                    private final DoubleRef thresh$1;
                    private final double[] coeff$1;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        if (this.coeff$1[i] < this.thresh$1.elem) {
                            this.coeff$1[i] = 0.0;
                        }
                    }
                    {
                        this.thresh$1 = thresh$1;
                        this.coeff$1 = coeff$1;
                    }
                });
            }
            {
                this.percent$1 = percent$1;
            }
        });
    }

    public float denoiseCoeffs$default$2() {
        return 0.25f;
    }

    private WaveletUtils$() {
        MODULE$ = this;
        this.transformer = new FastFourierTransformer(DftNormalization.STANDARD);
    }
}

