/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.mzscope.map;

import com.almworks.sqlite4java.SQLiteException;
import fr.profi.mzdb.MzDbReader;
import fr.profi.mzdb.util.concurrent.Callback;
import fr.proline.mzscope.map.LcMsMap;
import fr.proline.mzscope.map.LcMsMapChunk;
import fr.proline.mzscope.map.LcMsViewerEvent;
import fr.proline.mzscope.map.LcMsViewerListener;
import fr.proline.mzscope.map.LcMsViewport;
import fr.proline.mzscope.map.color.IntensityPainter;
import fr.proline.mzscope.map.math.Function1D;
import java.io.FileNotFoundException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ScheduledThreadPoolExecutor;

public class LcMsViewer {
    private LcMsMap map = null;
    private LcMsViewport mapViewport = null;
    private ScheduledThreadPoolExecutor threadPool = new ScheduledThreadPoolExecutor(3);
    private Set<LcMsViewerListener> viewerListeners = new HashSet<LcMsViewerListener>();

    public LcMsViewer(LcMsMap map) {
        this.setMap(map);
    }

    public LcMsMap getMap() {
        return this.map;
    }

    private void initMapViewport() {
        if (this.map == null) {
            return;
        }
        try {
            MzDbReader mzDb = this.map.createReader();
            if (mzDb == null) {
                return;
            }
            try {
                double runDuration = mzDb.getLastTime();
                int[] mzRange = mzDb.getMzRange(1);
                int minMzRun = mzRange[0];
                int maxMzRun = mzRange[1];
                this.mapViewport = new LcMsViewport(minMzRun, maxMzRun, 0.0, runDuration);
            }
            catch (SQLiteException e) {
                e.printStackTrace();
            }
        }
        catch (SQLiteException | FileNotFoundException | ClassNotFoundException e1) {
            e1.printStackTrace();
        }
    }

    public LcMsViewport getMapViewport() {
        return this.mapViewport;
    }

    public final void setMap(LcMsMap map) {
        this.map = map;
        this.initMapViewport();
        this.fireLcMsViewerEvent(new LcMsViewerEvent(this, LcMsViewerEvent.LcMsViewerEventType.MAP_CHANGED));
    }

    public LcMsMapChunk extractChunk(double minMz, double maxMz, double minRt, double maxRt) {
        LcMsMapChunk chunk = this.extractChunk(new LcMsViewport(minMz, maxMz, minRt, maxRt));
        return chunk;
    }

    public LcMsMapChunk extractChunk(LcMsViewport viewport) {
        LcMsMapChunk chunk = new LcMsMapChunk(this.getMap(), viewport);
        return chunk;
    }

    public void removeLcMsViewerListener(LcMsViewerListener listener) {
        this.viewerListeners.remove(listener);
    }

    public void addLcMsViewerListener(LcMsViewerListener listener) {
        this.viewerListeners.remove(listener);
    }

    public void fireLcMsViewerEvent(LcMsViewerEvent e) {
        for (LcMsViewerListener listener : this.viewerListeners) {
            listener.onLcMsViewerEvent(e);
        }
    }

    public void fireLcMsViewerEvent(LcMsViewerEvent.LcMsViewerEventType type) {
        LcMsViewerEvent e = new LcMsViewerEvent(this, type);
        for (LcMsViewerListener listener : this.viewerListeners) {
            listener.onLcMsViewerEvent(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestNewImage(int width, int height, Function1D intensity, LcMsViewport viewport, Callback<LcMsMapChunk> callback, IntensityPainter painter) {
        LcMsMapChunk chunk = this.extractChunk(viewport);
        ScheduledThreadPoolExecutor scheduledThreadPoolExecutor = this.threadPool;
        synchronized (scheduledThreadPoolExecutor) {
            Iterator runnableIterator = this.threadPool.getQueue().iterator();
            while (runnableIterator.hasNext()) {
                this.threadPool.remove((Runnable)runnableIterator.next());
            }
            if (this.threadPool.submit(chunk.getImageProcess(width, height, intensity, callback, painter)) != null) {
                this.fireLcMsViewerEvent(LcMsViewerEvent.LcMsViewerEventType.IMAGE_PROCESS_ADDED);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestUpdateImageColor(int width, int height, Function1D intensity, LcMsViewport viewport, Callback<LcMsMapChunk> callback, IntensityPainter painter) {
        LcMsMapChunk chunk = this.extractChunk(viewport);
        for (double v = 0.0; v <= 1.0; v += 0.2) {
            System.out.println(v + " => " + intensity.eval(v));
        }
        ScheduledThreadPoolExecutor scheduledThreadPoolExecutor = this.threadPool;
        synchronized (scheduledThreadPoolExecutor) {
            Iterator runnableIterator = this.threadPool.getQueue().iterator();
            while (runnableIterator.hasNext()) {
                this.threadPool.remove((Runnable)runnableIterator.next());
            }
            if (this.threadPool.submit(chunk.getImageProcess(width, height, intensity, callback, painter)) != null) {
                this.fireLcMsViewerEvent(LcMsViewerEvent.LcMsViewerEventType.IMAGE_PROCESS_ADDED);
            }
        }
    }

    public int getRunningTaskCount() {
        return this.threadPool.getActiveCount();
    }
}

