/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.mzscope.map;

import java.awt.geom.Point2D;

public class LcMsViewport {
    public double minMz = 0.0;
    public double maxMz = 0.0;
    public double minRt = 0.0;
    public double maxRt = 0.0;

    public LcMsViewport() {
        this.minMz = 0.0;
        this.maxMz = 0.0;
        this.minRt = 0.0;
        this.maxRt = 0.0;
    }

    public LcMsViewport(LcMsViewport viewport) {
        if (viewport != null) {
            this.minMz = viewport.minMz;
            this.maxMz = viewport.maxMz;
            this.minRt = viewport.minRt;
            this.maxRt = viewport.maxRt;
        }
    }

    public LcMsViewport(double minMzDisp, double maxMzDisp, double minRtDisp, double maxRtDisp) {
        this.minMz = minMzDisp;
        this.maxMz = maxMzDisp;
        this.minRt = minRtDisp;
        this.maxRt = maxRtDisp;
    }

    public Point2D value2pixel(double mz, double rt, int imageWidth, int imageHeight) {
        double x = (rt - this.minRt) / (this.maxRt - this.minRt) * (double)imageWidth;
        double y = (mz - this.minMz) / (this.maxMz - this.minMz) * (double)imageHeight;
        return new Point2D.Double(x, y);
    }

    public Point2D pixel2value(double x, double y, int imageWidth, int imageHeight) {
        double rt = (this.maxRt - this.minRt) * x / (double)imageWidth + this.minRt;
        double mz = (this.maxMz - this.minMz) * y / (double)imageHeight + this.minMz;
        return new Point2D.Double(mz, rt);
    }

    public LcMsViewport translate(double tMz, double tRt) {
        return new LcMsViewport(this.minMz + tMz, this.maxMz + tMz, this.minRt + tRt, this.maxRt + tRt);
    }

    public LcMsViewport centerScale(double cMz, double cRt, double scaleMz, double scaleRt) {
        return new LcMsViewport((this.minMz - cMz) * scaleMz + cMz, (this.maxMz - cMz) * scaleMz + cMz, (this.minRt - cRt) * scaleRt + cRt, (this.maxRt - cRt) * scaleRt + cRt);
    }

    public String toString() {
        return "MassViewport [minMzDisp=" + this.minMz + ", maxMzDisp=" + this.maxMz + ", minRtDisp=" + this.minRt + ", maxRtDisp=" + this.maxRt + "]";
    }
}

