/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.mzscope.map.control;

import fr.proline.mzscope.map.LcMsViewer;
import fr.proline.mzscope.map.LcMsViewport;
import fr.proline.mzscope.map.control.LcMsViewerManipulator;
import fr.proline.mzscope.map.control.LcMsViewerSelectionManipulator;
import fr.proline.mzscope.map.ui.LcMsViewerUI;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.Point2D;

public class LcMsViewerController
implements MouseMotionListener,
MouseListener,
MouseWheelListener {
    private LcMsViewer viewer = null;
    private LcMsViewerUI ui = null;
    private LcMsViewerManipulator manipulator = null;

    public LcMsViewerController() {
        this.setManipulator(new LcMsViewerSelectionManipulator(this));
    }

    public LcMsViewer getViewer() {
        return this.viewer;
    }

    public void setViewer(LcMsViewer viewer) {
        this.viewer = viewer;
    }

    public LcMsViewerUI getUI() {
        return this.ui;
    }

    public void setUI(LcMsViewerUI ui) {
        this.ui = ui;
    }

    public LcMsViewerManipulator getManipulator() {
        return this.manipulator;
    }

    public void setManipulator(LcMsViewerManipulator manipulator) {
        this.manipulator = manipulator;
    }

    public Point2D pixel2values(double x, double y) {
        return this.getUI().getDisplayViewport().pixel2value(x, y, this.getUI().getCanvas().getWidth(), this.getUI().getCanvas().getHeight());
    }

    public Point2D values2pixel(double mz, double rt) {
        return this.getUI().getDisplayViewport().value2pixel(mz, rt, this.getUI().getCanvas().getWidth(), this.getUI().getCanvas().getHeight());
    }

    public void changeViewport(double minMz, double maxMz, double minRt, double maxRt) {
        this.changeViewport(new LcMsViewport(minMz, maxMz, minRt, maxRt));
    }

    public void reinitViewport() {
        this.changeViewport(this.getViewer().getMapViewport());
    }

    public void updateViewport() {
        this.changeViewport(this.getUI().getDisplayViewport());
    }

    public void changeViewport(LcMsViewport viewport) {
        this.getViewer().requestNewImage(this.getUI().getCanvas().getWidth(), this.getUI().getCanvas().getHeight(), this.getUI().getLuminosityFunction(), viewport, this.getUI(), this.getUI().getPainter());
        this.getUI().setDisplayViewport(viewport);
    }

    public void updateImageColor(LcMsViewport viewport) {
        this.getViewer().requestUpdateImageColor(this.getUI().getCanvas().getWidth(), this.getUI().getCanvas().getHeight(), this.getUI().getLuminosityFunction(), viewport, this.getUI(), this.getUI().getPainter());
        this.getUI().setDisplayViewport(viewport);
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        if (this.manipulator != null) {
            this.manipulator.mouseWheelMoved(e);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (this.manipulator != null) {
            this.manipulator.mouseClicked(e);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.manipulator != null) {
            this.manipulator.mousePressed(e);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.manipulator != null) {
            this.manipulator.mouseReleased(e);
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        if (this.manipulator != null) {
            this.manipulator.mouseEntered(e);
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (this.manipulator != null) {
            this.manipulator.mouseExited(e);
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.manipulator != null) {
            this.manipulator.mouseDragged(e);
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (this.manipulator != null) {
            this.manipulator.mouseMoved(e);
        }
    }
}

