/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.mzscope.model;

import fr.proline.mzscope.model.MsnExtractionRequest;

public class FeaturesExtractionRequest
extends MsnExtractionRequest {
    public static final boolean REMOVE_BASELINE = false;
    public static final boolean USE_SMOOTHING = true;
    public static final int MIN_PEAKS_COUNT = 5;
    public static final int MIN_MAX_DISTANCE = 3;
    public static final float MIN_MAX_RATIO = 0.75f;
    public static final float INTENSITY_PERCENTILE = 0.9f;
    public static final int MAX_CONSECUTIVE_GAPS = 3;
    private ExtractionMethod extractionMethod;
    private boolean removeBaseline;
    private boolean useSmoothing;
    private int minPeaksCount;
    private int minmaxDistanceThreshold;
    private float maxIntensityRelativeThreshold;
    private float intensityPercentile;
    private int maxConsecutiveGaps;

    public static Builder<?> builder() {
        return new Builder();
    }

    protected FeaturesExtractionRequest(Builder builder) {
        super(builder);
        this.extractionMethod = builder.extractionMethod;
        this.removeBaseline = builder.removeBaseline;
        this.useSmoothing = builder.useSmoothing;
        this.minPeaksCount = builder.minPeaksCount;
        this.minmaxDistanceThreshold = builder.minmaxDistanceThreshold;
        this.maxIntensityRelativeThreshold = builder.maxIntensityRelativeThreshold;
        this.intensityPercentile = builder.intensityPercentile;
        this.maxConsecutiveGaps = builder.maxConsecutiveGaps;
    }

    public ExtractionMethod getExtractionMethod() {
        return this.extractionMethod;
    }

    public boolean isRemoveBaseline() {
        return this.removeBaseline;
    }

    public boolean isUseSmoothing() {
        return this.useSmoothing;
    }

    public int getMinPeaksCount() {
        return this.minPeaksCount;
    }

    public int getMinmaxDistanceThreshold() {
        return this.minmaxDistanceThreshold;
    }

    public float getMaxIntensityRelativeThreshold() {
        return this.maxIntensityRelativeThreshold;
    }

    public float getIntensityPercentile() {
        return this.intensityPercentile;
    }

    public int getMaxConsecutiveGaps() {
        return this.maxConsecutiveGaps;
    }

    public String getExtractionParamsString() {
        StringBuilder sb = new StringBuilder();
        String em = "";
        switch (this.getExtractionMethod()) {
            case EXTRACT_MS2_FEATURES: {
                em = "Extract MS2 Features";
                break;
            }
            case DETECT_PEAKELS: {
                em = "Detect Peakels";
                break;
            }
            case DETECT_FEATURES: {
                em = "Detect Features";
            }
        }
        sb.append("<html>");
        sb.append(em);
        sb.append(": <br/>");
        sb.append("m/z tolerance (ppm): ");
        sb.append(Float.toString(this.getMzTolPPM()));
        sb.append("<br/>");
        if (this.isRemoveBaseline()) {
            sb.append("Use Peakels baseline remover <br/>");
        }
        if (Double.compare(this.getMinMz(), this.getMaxMz()) == 0 && Double.compare(this.getMinMz(), 0.0) == 0) {
            sb.append("no m/z bounds");
        } else if (Double.compare(this.getMz(), 0.0) != 0) {
            sb.append("at m/z: ");
            sb.append(this.getMz());
        } else {
            sb.append("m/z bounds: ");
            sb.append(this.getMinMz());
            sb.append(" - ");
            sb.append(this.getMaxMz());
        }
        sb.append("</html>");
        return sb.toString();
    }

    public static class Builder<T extends Builder<T>>
    extends MsnExtractionRequest.Builder<T> {
        ExtractionMethod extractionMethod;
        boolean removeBaseline = false;
        boolean useSmoothing = true;
        int minPeaksCount = 5;
        int minmaxDistanceThreshold = 3;
        int maxConsecutiveGaps = 3;
        float maxIntensityRelativeThreshold = 0.75f;
        float intensityPercentile = 0.9f;

        @Override
        public T setMzTolPPM(float mzTolPPM) {
            this.mzTolPPM = mzTolPPM;
            return (T)((Builder)this.self());
        }

        @Override
        public T setMz(double mz) {
            this.mz = mz;
            this.maxMz = mz + mz * (double)this.mzTolPPM / 1000000.0;
            this.minMz = mz - mz * (double)this.mzTolPPM / 1000000.0;
            return (T)((Builder)this.self());
        }

        @Override
        public T setMaxMz(double maxMz) {
            this.maxMz = maxMz;
            return (T)((Builder)this.self());
        }

        @Override
        public T setMinMz(double minMz) {
            this.minMz = minMz;
            return (T)((Builder)this.self());
        }

        public T setExtractionMethod(ExtractionMethod extractionMethod) {
            this.extractionMethod = extractionMethod;
            return (T)((Builder)this.self());
        }

        public T setRemoveBaseline(boolean removeBaseline) {
            this.removeBaseline = removeBaseline;
            return (T)((Builder)this.self());
        }

        public T setUseSmoothing(boolean useSmoothing) {
            this.useSmoothing = useSmoothing;
            return (T)((Builder)this.self());
        }

        public T setMinPeaksCount(int minPeaksCount) {
            this.minPeaksCount = minPeaksCount;
            return (T)((Builder)this.self());
        }

        public T setMinmaxDistanceThreshold(int minmaxDistanceThreshold) {
            this.minmaxDistanceThreshold = minmaxDistanceThreshold;
            return (T)((Builder)this.self());
        }

        public T setIntensityPercentile(float intensityPercentile) {
            this.intensityPercentile = intensityPercentile;
            return (T)((Builder)this.self());
        }

        public T setMaxIntensityRelativeThreshold(float maxIntensityRelativeThreshold) {
            this.maxIntensityRelativeThreshold = maxIntensityRelativeThreshold;
            return (T)((Builder)this.self());
        }

        public T setMaxConsecutiveGaps(int maxConsecutiveGaps) {
            this.maxConsecutiveGaps = maxConsecutiveGaps;
            return (T)((Builder)this.self());
        }

        @Override
        public FeaturesExtractionRequest build() {
            return new FeaturesExtractionRequest(this);
        }
    }

    public static enum ExtractionMethod {
        EXTRACT_MS2_FEATURES,
        DETECT_PEAKELS,
        DETECT_FEATURES;

    }
}

