/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.mzscope.mzml;

import fr.proline.mzscope.model.IChromatogram;
import fr.proline.mzscope.mzml.Scan;
import fr.proline.mzscope.mzml.XICExtractor;
import fr.proline.mzscope.mzml.mzMLReader;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.util.List;
import javax.swing.JFrame;

public class Main {
    public static String MS_LEVEL_CV_PARAM = "MS:1000511";

    public static void main(String[] args) {
        String filepath = args[0];
        long start = System.currentTimeMillis();
        List<Scan> scans = mzMLReader.read(filepath);
        System.out.println(scans.size() + " scans read in :: " + (System.currentTimeMillis() - start) + " ms");
        start = System.currentTimeMillis();
        IChromatogram chromato = null;
        int maxIter = 100;
        for (int k = 0; k < maxIter; ++k) {
            float v = (float)Math.random() * 1200.0f + 400.0f;
            float delta = v * 10.0f / 1000000.0f;
            chromato = XICExtractor.extract(scans, v - delta, v + delta);
        }
        chromato = XICExtractor.extract(scans, 435.71f, 435.85f);
        System.out.println(maxIter + " ions chromatogram extracted in :: " + (System.currentTimeMillis() - start) + " ms");
        System.out.println("mzML IChromatogram length " + chromato.getIntensities().length);
        JFrame frame = new JFrame("mzML IChromatogram Viewer");
        frame.setSize(800, 600);
        frame.setDefaultCloseOperation(3);
        try {
            BufferedWriter output = new BufferedWriter(new FileWriter("extracted_xic.tab"));
            output.write("index, rt, intensity \n");
            for (int count = 0; count < chromato.getIntensities().length; ++count) {
                output.write(count + "," + chromato.getTime()[count] + "," + chromato.getIntensities()[count] + "\n");
            }
            output.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

