/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.mzscope.mzml;

import fr.proline.mzscope.model.FeaturesExtractionRequest;
import fr.proline.mzscope.model.IChromatogram;
import fr.proline.mzscope.model.IExportParameters;
import fr.proline.mzscope.model.IFeature;
import fr.proline.mzscope.model.IPeakel;
import fr.proline.mzscope.model.IRawFile;
import fr.proline.mzscope.model.MsnExtractionRequest;
import fr.proline.mzscope.model.QCMetrics;
import fr.proline.mzscope.model.Spectrum;
import fr.proline.mzscope.mzml.Scan;
import fr.proline.mzscope.mzml.XICExtractor;
import fr.proline.mzscope.mzml.mzMLReader;
import java.io.File;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MzMLRawFile
implements IRawFile {
    private static final Logger LOG = LoggerFactory.getLogger(MzMLRawFile.class);
    private final File mzMLFile;
    private List<Scan> scans;

    public MzMLRawFile(File file) {
        this.mzMLFile = file;
        this.init();
    }

    private void init() {
        try {
            long start = System.currentTimeMillis();
            LOG.info("Start reading mzMLRawFile " + this.mzMLFile.getAbsolutePath());
            this.scans = mzMLReader.read(this.mzMLFile.getAbsolutePath());
            LOG.info("File mzML read in :: " + (System.currentTimeMillis() - start) + " ms");
        }
        catch (Exception e) {
            LOG.error("cannot read file " + this.mzMLFile.getAbsolutePath(), (Throwable)e);
        }
    }

    @Override
    public String getName() {
        return this.mzMLFile.getName();
    }

    @Override
    public File getFile() {
        return this.mzMLFile;
    }

    @Override
    public IChromatogram getTIC(int msLevel) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public IChromatogram getBPI() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public IChromatogram getXIC(MsnExtractionRequest params) {
        IChromatogram chromatogram = XICExtractor.extract(this.scans, (float)params.getMinMz(), (float)params.getMaxMz());
        return chromatogram;
    }

    @Override
    public Spectrum getSpectrum(int spectrumIndex) {
        return this.toModelSpectrum(this.scans.get(spectrumIndex));
    }

    @Override
    public int getSpectrumId(double retentionTime) {
        for (Scan s : this.scans) {
            if (!(Math.abs((double)s.getRetentionTime() - retentionTime) < 0.001)) continue;
            return s.getIndex();
        }
        return 0;
    }

    @Override
    public double[] getElutionTimes(int msLevel) {
        return this.scans.stream().mapToDouble(s -> (double)s.getRetentionTime() / 60.0).toArray();
    }

    @Override
    public double getSpectrumElutionTime(int spectrumIndex) {
        return this.scans.get(spectrumIndex).getRetentionTime();
    }

    @Override
    public int getNextSpectrumId(int spectrumIndex, int msLevel) {
        return Math.min(spectrumIndex + 1, this.scans.size());
    }

    @Override
    public int getPreviousSpectrumId(int spectrumIndex, int msLevel) {
        return Math.max(spectrumIndex - 1, 0);
    }

    private Spectrum toModelSpectrum(Scan mzmlScan) {
        double[] masses = new double[mzmlScan.getMasses().length];
        for (int k = 0; k < masses.length; ++k) {
            masses[k] = mzmlScan.getMasses()[k];
        }
        return new Spectrum(mzmlScan.getIndex(), mzmlScan.getRetentionTime(), masses, mzmlScan.getIntensities(), 1);
    }

    @Override
    public List<IFeature> extractFeatures(FeaturesExtractionRequest params) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public List<IPeakel> extractPeakels(FeaturesExtractionRequest params) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public List<Float> getMsMsEvent(double minMz, double maxMz) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int getSpectrumCount() {
        return this.scans.size();
    }

    @Override
    public boolean exportRawFile(String mgfFileName, IExportParameters exportParams) {
        return true;
    }

    @Override
    public boolean isDIAFile() {
        return false;
    }

    @Override
    public Map<String, Object> getFileProperties() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public QCMetrics getFileMetrics() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public void closeIRawFile() {
    }
}

