/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.mzscope.processing;

import com.almworks.sqlite4java.SQLiteException;
import com.github.davidmoten.rtree.Entry;
import com.github.davidmoten.rtree.RTree;
import com.github.davidmoten.rtree.geometry.Geometries;
import com.github.davidmoten.rtree.geometry.Geometry;
import com.github.davidmoten.rtree.geometry.Point;
import fr.profi.ms.model.TheoreticalIsotopePattern;
import fr.profi.mzdb.MzDbReader;
import fr.profi.mzdb.model.Feature;
import fr.profi.mzdb.model.Peakel;
import fr.profi.mzdb.model.PeakelCursor;
import fr.profi.mzdb.model.SpectrumData;
import fr.proline.mzscope.processing.IsotopicPatternUtils;
import fr.proline.mzscope.processing.SpectrumUtils;
import java.io.StreamCorruptedException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.math3.stat.descriptive.DescriptiveStatistics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Tuple2;
import scala.collection.JavaConverters;
import scala.collection.mutable.Buffer;

public class PeakelsHelper {
    private static final Logger logger = LoggerFactory.getLogger(PeakelsHelper.class);
    private static int HALF_MZ_WINDOW = 5;
    private static float RT_TOLERANCE = 40.0f;
    private static float INTENSITY_PERCENTILE = 0.99f;
    private List<Peakel> peakels;
    private RTree<Peakel, Point> rTree;

    public PeakelsHelper(Peakel[] peakels) {
        this(Arrays.asList(peakels));
    }

    public PeakelsHelper(List<Peakel> peakels) {
        logger.info("creates PeakelsHelper with {} peakels", (Object)peakels.size());
        this.peakels = peakels;
        this.rTree = RTree.create();
        for (Peakel p : peakels) {
            this.rTree = this.rTree.add((Object)p, (Geometry)Geometries.point((double)p.getMz(), (double)p.getApexElutionTime()));
        }
        logger.info("built RTree contains {} peakels", (Object)this.rTree.size());
    }

    public List<Peakel> findCoelutigPeakels(double minMz, double maxMz, float minRt, float maxRt) {
        ArrayList<Peakel> coelutingPeakels = new ArrayList<Peakel>(1000);
        Iterator peakelIterator = this.rTree.search(Geometries.rectangle((double)minMz, (double)minRt, (double)maxMz, (double)maxRt)).toBlocking().toIterable().iterator();
        while (peakelIterator.hasNext()) {
            coelutingPeakels.add((Peakel)((Entry)peakelIterator.next()).value());
        }
        return coelutingPeakels;
    }

    public List<Peakel> findCoelutigPeakels(double minMz, double maxMz, float minRt, float maxRt, Map<Integer, Peakel> assigned) {
        ArrayList<Peakel> coelutingPeakels = new ArrayList<Peakel>(1000);
        Iterator peakelIterator = this.rTree.search(Geometries.rectangle((double)minMz, (double)minRt, (double)maxMz, (double)maxRt)).toBlocking().toIterable().iterator();
        while (peakelIterator.hasNext()) {
            Peakel p = (Peakel)((Entry)peakelIterator.next()).value();
            if (assigned.containsKey(p.getId())) continue;
            coelutingPeakels.add(p);
        }
        return coelutingPeakels;
    }

    public List<Feature> deisotopePeakels(MzDbReader reader, float mzTolPPM) throws StreamCorruptedException, SQLiteException {
        long start = System.currentTimeMillis();
        DescriptiveStatistics[] stats = new DescriptiveStatistics[]{new DescriptiveStatistics(), new DescriptiveStatistics(), new DescriptiveStatistics()};
        ArrayList<Feature> features = new ArrayList<Feature>();
        ArrayList<Feature> monoPeakelFeatures = new ArrayList<Feature>();
        HashMap<Integer, Peakel> assigned = new HashMap<Integer, Peakel>();
        this.peakels.sort(new Comparator<Peakel>(){

            @Override
            public int compare(Peakel o1, Peakel o2) {
                return Double.compare(o2.getApexIntensity(), o1.getApexIntensity());
            }
        });
        double REFMZ = 724.71024;
        double REFRT = 133.866;
        float intensityThreshold = this.peakels.get(Math.min(this.peakels.size() - 1, (int)((float)this.peakels.size() * INTENSITY_PERCENTILE))).getApexIntensity();
        for (int k = 0; k < this.peakels.size(); ++k) {
            if (k % 10000 == 0) {
                logger.info("processing peakel " + k);
            }
            if (assigned.containsKey(this.peakels.get(k).getId())) continue;
            SpectrumData data = this.buildSpectrumDataFromPeakels(k, assigned);
            Tuple2<Object, TheoreticalIsotopePattern>[] putativePatterns = IsotopicPatternUtils.calcIsotopicPatternHypotheses(data, this.peakels.get(k).getMz(), mzTolPPM);
            TheoreticalIsotopePattern bestPattern = (TheoreticalIsotopePattern)putativePatterns[0]._2;
            ArrayList<Peakel> l = new ArrayList<Peakel>(bestPattern.isotopeCount() + 1);
            int gapRank = 0;
            int indexOfMatching = 0;
            for (Tuple2 t : bestPattern.mzAbundancePairs()) {
                if (1000000.0 * (Math.abs(this.peakels.get(k).getMz() - (Double)t._1) / this.peakels.get(k).getMz()) < (double)mzTolPPM) break;
                ++indexOfMatching;
            }
            double scaling = this.peakels.get(k).getApexIntensity() / ((Float)bestPattern.mzAbundancePairs()[indexOfMatching]._2).floatValue();
            for (Tuple2 t : bestPattern.mzAbundancePairs()) {
                double patternMz = (Double)t._1;
                float patternNormAbundance = ((Float)t._2).floatValue();
                List<Peakel> isotopes = this.findCoelutigPeakels(patternMz - patternMz * (double)mzTolPPM / 1000000.0, patternMz + patternMz * (double)mzTolPPM / 1000000.0, this.peakels.get(k).getFirstElutionTime(), this.peakels.get(k).getLastElutionTime(), assigned);
                Peakel bestMatching = null;
                double maxCorr = Double.MIN_VALUE;
                for (Peakel p : isotopes) {
                    double corr = SpectrumUtils.correlation(this.peakels.get(k), p);
                    if (!(corr > 0.5) || !(corr > maxCorr) || !((double)p.getApexIntensity() < 2.5 * (double)patternNormAbundance * scaling)) continue;
                    maxCorr = corr;
                    bestMatching = p;
                }
                if (bestMatching != null) {
                    if (!assigned.containsKey(bestMatching.getId())) {
                        gapRank = 0;
                        assigned.put(bestMatching.getId(), bestMatching);
                        l.add(bestMatching);
                    } else {
                        logger.trace("best isotope match found but already assigned");
                    }
                } else {
                    ++gapRank;
                }
                if (gapRank >= 3) break;
            }
            if (l.isEmpty()) {
                logger.trace("Strange situation: peakel {}, {} not found from pattern at mono {}, {}+ (gap: {})", new Object[]{this.peakels.get(k).getMz(), (double)this.peakels.get(k).getApexElutionTime() / 60.0, bestPattern.monoMz(), bestPattern.charge(), gapRank});
                l.add(this.peakels.get(k));
            }
            Feature feature = new Feature(((Peakel)l.get(0)).getMz(), bestPattern.charge(), (Buffer)JavaConverters.asScalaBufferConverter(l).asScala(), true);
            if (l.size() > 1) {
                features.add(feature);
                stats[0].addValue((double)feature.getBasePeakel().getApexIntensity());
                stats[1].addValue((double)feature.calcDuration());
                stats[2].addValue((double)feature.getMs1Count());
                continue;
            }
            monoPeakelFeatures.add(feature);
        }
        double minIntensity = stats[0].getPercentile(10.0);
        double maxDuration = stats[1].getMax();
        double minMs1Count = stats[2].getPercentile(10.0);
        logger.info("Filter dubious features: Thresholds are minIntensity={}, maxDuration={}, minMs1Count{}", new Object[]{minIntensity, maxDuration, minMs1Count});
        for (Feature f : monoPeakelFeatures) {
            if ((double)f.getBasePeakel().getApexIntensity() >= minIntensity && (double)f.calcDuration() <= maxDuration && (double)f.getMs1Count() >= minMs1Count) {
                features.add(f);
                continue;
            }
            features.add(f);
        }
        logger.info("Features detected : {} in {} ms", (Object)features.size(), (Object)(System.currentTimeMillis() - start));
        return features;
    }

    public List<Feature> deisotopePeakelsFromMzdb(MzDbReader reader, float mzTolPPM) throws StreamCorruptedException, SQLiteException {
        long start = System.currentTimeMillis();
        ArrayList<Feature> result = new ArrayList<Feature>();
        HashMap<Integer, Peakel> assigned = new HashMap<Integer, Peakel>();
        this.peakels.sort(new Comparator<Peakel>(){

            @Override
            public int compare(Peakel o1, Peakel o2) {
                return Double.compare(o2.getApexIntensity(), o1.getApexIntensity());
            }
        });
        for (int k = 0; k < this.peakels.size(); ++k) {
            if (k % 10000 == 0) {
                logger.info("processing peakel " + k);
            }
            if (assigned.containsKey(this.peakels.get(k).getId())) continue;
            SpectrumData data = reader.getSpectrumData(this.peakels.get(k).getApexSpectrumId());
            Tuple2<Object, TheoreticalIsotopePattern>[] putativePatterns = IsotopicPatternUtils.calcIsotopicPatternHypotheses(data, this.peakels.get(k).getMz(), mzTolPPM);
            TheoreticalIsotopePattern bestPattern = (TheoreticalIsotopePattern)putativePatterns[0]._2;
            ArrayList<Peakel> l = new ArrayList<Peakel>(bestPattern.isotopeCount() + 1);
            for (Tuple2 t : bestPattern.mzAbundancePairs()) {
                double mz = (Double)t._1;
                List<Peakel> isotopes = this.findCoelutigPeakels(mz - mz * (double)mzTolPPM / 1000000.0, mz + mz * (double)mzTolPPM / 1000000.0, this.peakels.get(k).getFirstElutionTime(), this.peakels.get(k).getLastElutionTime());
                Peakel bestMatching = null;
                double maxCorr = Double.MIN_VALUE;
                for (Peakel p : isotopes) {
                    double corr = SpectrumUtils.correlation(this.peakels.get(k), p);
                    if (!(corr > 0.5) || !(corr > maxCorr)) continue;
                    maxCorr = corr;
                    bestMatching = p;
                }
                if (bestMatching == null || assigned.containsKey(bestMatching.getId())) continue;
                assigned.put(bestMatching.getId(), bestMatching);
                l.add(bestMatching);
            }
            if (l.isEmpty()) {
                logger.trace("Strange situation : peakel not found within isotopic pattern .... " + this.peakels.get(k).getMz());
                l.add(this.peakels.get(k));
            }
            Feature feature = new Feature(((Peakel)l.get(0)).getMz(), bestPattern.charge(), (Buffer)JavaConverters.asScalaBufferConverter(l).asScala(), true);
            result.add(feature);
        }
        logger.info("Features detected : {} in {} ms", (Object)result.size(), (Object)(System.currentTimeMillis() - start));
        return result;
    }

    private SpectrumData buildSpectrumDataFromPeakels(int k, Map<Integer, Peakel> assigned) {
        Peakel peakel = this.peakels.get(k);
        List<Peakel> coelutingPeakels = this.findCoelutigPeakels(peakel.getApexMz() - (double)HALF_MZ_WINDOW, peakel.getApexMz() + (double)HALF_MZ_WINDOW, peakel.getFirstElutionTime(), peakel.getLastElutionTime(), assigned);
        return this.buildSpectrumDataFromPeakels(peakel, coelutingPeakels);
    }

    public SpectrumData buildSpectrumDataFromPeakels(Peakel peakel, List<Peakel> coelutingPeakels) {
        Tuple2<double[], float[]> values = this.slicePeakels(coelutingPeakels, peakel);
        SpectrumData data = new SpectrumData((double[])values._1, (float[])values._2);
        return data;
    }

    private Tuple2<double[], float[]> slicePeakels(List<Peakel> coelutingPeakels, Peakel matchingPeakel) {
        Long matchingSpectrumId = matchingPeakel.getApexSpectrumId();
        ArrayList mzList = new ArrayList(coelutingPeakels.size());
        ArrayList intensityList = new ArrayList(coelutingPeakels.size());
        coelutingPeakels.sort(new Comparator<Peakel>(){

            @Override
            public int compare(Peakel o1, Peakel o2) {
                return Double.compare(o1.getApexMz(), o2.getApexMz());
            }
        });
        int SPAN = 3;
        coelutingPeakels.stream().forEach(peakel -> {
            PeakelCursor peakelCursor = peakel.getNewCursor();
            boolean foundPeak = false;
            float sum = 0.0f;
            int count = 0;
            while (peakelCursor.next() && !foundPeak) {
                if (peakelCursor.getSpectrumId() != matchingSpectrumId.longValue()) continue;
                mzList.add(peakelCursor.getMz());
                foundPeak = true;
            }
            if (foundPeak) {
                int index = peakelCursor.cursorIndex();
                int minBound = Math.max(0, index - 3);
                int maxBound = Math.min(index + 3, peakel.getPeaksCount() - 1);
                for (int i = minBound; i <= maxBound; ++i) {
                    sum += peakel.intensityValues()[i];
                    ++count;
                }
                intensityList.add(Float.valueOf(sum / (float)count));
            }
        });
        int idx = 0;
        double[] mz = new double[mzList.size()];
        for (Double d : mzList) {
            mz[idx++] = d;
        }
        idx = 0;
        float[] intensities = new float[intensityList.size()];
        for (Float f : intensityList) {
            intensities[idx++] = f.floatValue();
        }
        return new Tuple2((Object)mz, (Object)intensities);
    }
}

